/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.registers;

import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViews;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModelStateListener;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.registers.IRegistersViewContributor;
import ro.amiq.dvt.ui.views.registers.DVTXRegistersLabelProvider;
import ro.amiq.dvt.ui.views.registers.IRegistersViewModel;
import ro.amiq.dvt.ui.views.registers.IXRegistersContributor;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class RegistersViewCommon
extends DVTLazyView
implements IInterpreterViews,
IDVTModelStateListener {
    public static final String ID = "ro.amiq.dvt.ui.views.RegistersView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.PROJECT_INFORMATION, ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS, ViewKind.CAN_HANDLE_GUI_FILTERS);
    protected IRegistersViewContributor currentContributor = DVTViewContributors.getInstance().getViewContributor(LanguageKind.VLOG, IRegistersViewContributor.class);
    protected ViewDataContainer dataContainer;
    protected boolean dirty;
    protected IRegistersViewModel registersViewModel;
    protected DVTXRegistersLabelProvider labelProvider = new DVTXRegistersLabelProvider();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    public IRegistersViewContributor getCurrentContributor() {
        return this.currentContributor;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    @Override
    public boolean supportsDecorations() {
        return false;
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.dataContainer;
    }

    public void setCurrentContributor(IRegistersViewContributor currentContributor) {
        this.currentContributor = currentContributor;
    }

    public String getLabelInfoText() {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return "[no DVT Project or file selected]";
        }
        boolean isSearchMode = false;
        StringMatcher[] searchSegments = this.getTreeSearchSegments();
        if (searchSegments != null && searchSegments.length != 0) {
            isSearchMode = true;
        }
        String labelText = "";
        if (this.getHistoryItem() == null || !(this.currentContributor instanceof IXRegistersContributor)) {
            labelText = "[" + project.getName() + "]";
            if (!isSearchMode) {
                labelText = String.valueOf(labelText) + " " + this.getNumOfRegistersForLabel();
            }
            return labelText;
        }
        labelText = this.currentContributor.getTreeLabelText(this.getHistoryItem());
        if (labelText == null || labelText.isEmpty()) {
            labelText = "[" + project.getName() + "]";
        }
        if (!isSearchMode) {
            labelText = String.valueOf(labelText) + " " + this.getNumOfRegistersForLabel();
        }
        return labelText;
    }

    public String getNumOfRegistersForLabel() {
        if (this.registersViewModel == null) {
            return "";
        }
        long numOfRegisters = this.currentContributor.getTotalRegisterCount();
        return "[" + numOfRegisters + (numOfRegisters == 1L ? " register]" : " registers]");
    }

    protected abstract HistoryItem getHistoryItem();
}

