/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.registers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViewsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.registers.IRegistersViewContributor;
import ro.amiq.dvt.ui.views.registers.IRegistersViewModel;
import ro.amiq.dvt.ui.views.registers.RegistersDisplayKind;
import ro.amiq.dvt.ui.views.registers.RegistersSortKind;
import ro.amiq.dvt.ui.views.registers.RegistersView;
import ro.amiq.dvt.ui.views.registers.XRegistersViewUtils;

public class RegistersViewModel
implements IRegistersViewModel {
    private IProject project;
    private DVTBaseLabelProvider labelProvider;
    private IRegistersViewContributor currentContributor;
    private RegistersView registersView;

    public RegistersViewModel(IProject project, DVTBaseLabelProvider labelProvider, RegistersView registersView, boolean isPreInterpreterMode) {
        this.project = project;
        this.labelProvider = labelProvider;
        this.registersView = registersView;
        this.currentContributor = XRegistersViewUtils.getViewContributor(isPreInterpreterMode || IInterpreterViewsCommon.isInterpreterMode());
        if (this.currentContributor != null && (isPreInterpreterMode || this.currentContributor.isStatic())) {
            this.currentContributor.resetState();
            this.currentContributor.addListener(registersView);
        }
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (this.project == null || treePath == null) {
            return Collections.emptyList();
        }
        if (this.currentContributor == null || this.currentContributor.hasInterpreterFailed()) {
            return Collections.emptyList();
        }
        List<TreePath> result = new ArrayList<TreePath>();
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            boolean displayHierarhical;
            boolean bl = displayHierarhical = this.registersView.getDisplayKind() == RegistersDisplayKind.Tree;
            if (displayHierarhical) {
                List<TreePath> children = this.currentContributor.createRootTreePath(monitor, this.project);
                if (children != null) {
                    return children;
                }
                result.add(AbstractTreeIterator.getDummyOperatioNode(null));
                return result;
            }
            result = this.currentContributor.createFlatTreePath(monitor, this.project, this.registersView.getSortKind() == RegistersSortKind.NAME || this.currentContributor.isStatic());
            if (result != null) {
                return result;
            }
            result = new ArrayList();
            if (result.isEmpty()) {
                result.add(AbstractTreeIterator.getDummyOperatioNode(null));
            }
            return result;
        }
        Object element = treePath.getElement();
        if (element instanceof DummyElement) {
            return result;
        }
        List<Object> children = this.currentContributor.getChildrenForElement(element, this.registersView.getSortKind() == RegistersSortKind.NAME, this.project, monitor);
        if (children == null) {
            return result;
        }
        int i = childStartIndex;
        while (i < Math.min(childEndIndex, children.size())) {
            TreePath prevChild;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Object dvtElementWrapper = children.get(i);
            String text = this.labelProvider.getText(dvtElementWrapper);
            TreePath child = TreePath.child(treePath, text, i);
            child.setElement(dvtElementWrapper);
            TreePath treePath2 = prevChild = result.isEmpty() ? null : result.get(result.size() - 1);
            if (child.equals(prevChild, true)) {
                child.append("@(" + i + ")@");
            }
            result.add(child);
            ++i;
        }
        return result;
    }

    @Override
    public Boolean hasChildren(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return treePath;
        }
        currentPath = treePath;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl11
        return currentPath;
lbl-1000:
        // 1 sources

        {
            if (monitor.isCanceled()) {
                return currentPath;
            }
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl11:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl12:
        // 1 sources

        return currentPath;
    }

    @Override
    public void clearModelCaches() {
        this.currentContributor.cleanRegisterRoots();
    }

    @Override
    public boolean hasInterpreterFailed() {
        if (this.currentContributor == null) {
            throw new IllegalStateException("Contributor cannot be null!");
        }
        return this.currentContributor.hasInterpreterFailed();
    }

    @Override
    public void setHasInterpreterFailed(boolean isInterpreterProcessFailed) {
        if (this.currentContributor == null) {
            throw new IllegalStateException("Contributor cannot be null!");
        }
        this.currentContributor.setHasInterpreterFailed(isInterpreterProcessFailed);
    }

    @Override
    public List<Object> getTreeElementsForRoot(Object root) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.registersView == null) {
            return children;
        }
        List<TreePath> rootTreePaths = this.getChildren(TreePath.TOP_DUMMY_TREE_PATH, 0, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        for (TreePath rootTreePath : rootTreePaths) {
            DVTTreeElementWrapper rootWrapper = new DVTTreeElementWrapper(rootTreePath);
            this.computeChildrenForElement(rootWrapper);
            children.add(rootWrapper);
        }
        return children;
    }

    private void computeChildrenForElement(DVTTreeElementWrapper element) {
        List<TreePath> elementChildren = this.getChildren((TreePath)element.getRfElement(), 0, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        if (elementChildren == null || elementChildren.isEmpty()) {
            return;
        }
        for (TreePath child : elementChildren) {
            DVTTreeElementWrapper elementWrapper = new DVTTreeElementWrapper(child);
            this.computeChildrenForElement(elementWrapper);
            element.addChild(elementWrapper);
        }
    }
}

