/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.semantic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.PlainElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.semantic.HHLabelProvider;
import ro.amiq.dvt.ui.views.semantic.HHViewInput;
import ro.amiq.dvt.ui.views.semantic.HHViewInputConfigurator;
import ro.amiq.dvt.ui.views.semantic.HHViewUtils;
import ro.amiq.dvt.ui.views.semantic.HHWrapper;
import ro.amiq.dvt.ui.views.semantic.HidHolderView;
import ro.amiq.dvt.ui.views.semantic.IHHViewContributor;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class AbstractHHViewContributor
implements IHHViewContributor {
    protected DVTBaseLabelProvider fLabelProvider = new HHLabelProvider();

    @Override
    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    @Override
    public boolean adaptsTo(Object adapted) {
        return adapted instanceof PlainElementWrapper;
    }

    @Override
    public String getComment(Object wrapper) {
        return null;
    }

    @Override
    public void gotoElement(IProject project, Object wrapper) {
    }

    protected int countUniqueOperators(List<IDVTElementWrapper> elements) {
        if (elements == null) {
            return 0;
        }
        int count = 0;
        for (IDVTElementWrapper element : elements) {
            Object obj = element.getRfElement();
            if (!(obj instanceof HHWrapper)) {
                return 0;
            }
            if (((HHWrapper)obj).getHidObject().getHidKind() != IHidObject.HidKind.OPERATOR) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        if (!this.adaptsTo(wrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        if (rfElement == null) {
            return false;
        }
        return !ViewsUtils.matchCamelCaseOrRegex(matcher, this.fLabelProvider.getText(wrapper));
    }

    protected int filterTree(IDVTElementWrapper root, HHViewInputConfigurator viewConfigurator) {
        if (root == null || viewConfigurator == null) {
            return 0;
        }
        ComplexFilter filter = new ComplexFilter(viewConfigurator.getView(), false);
        ViewsUtils.filterElementComplex(root, filter);
        return filter.matchCount;
    }

    @Override
    public HHViewInput getInput(HHViewInputConfigurator inputConfig) {
        if (inputConfig == null) {
            return null;
        }
        List<Object> elements = new ArrayList();
        Object source = inputConfig.getSource();
        int matchedCount = 0;
        int totalCount = 0;
        int uniqueOperatorsCount = 0;
        if (ViewsUtils.isCanceled(inputConfig.getUpdateJob())) {
            return null;
        }
        boolean showHids = inputConfig.getView().isShowActionEnabled(HidHolderView.ShowActionKind.SHOW_HIDS);
        boolean showOperators = inputConfig.getView().isShowActionEnabled(HidHolderView.ShowActionKind.SHOW_OPERATORS);
        boolean showPredefined = inputConfig.getView().isShowActionEnabled(HidHolderView.ShowActionKind.SHOW_PREDEFINED);
        boolean showOnlyComplete = inputConfig.getView().isShowActionEnabled(HidHolderView.ShowActionKind.SHOW_ONLY_COMPLETE);
        if (!showHids && !showOperators) {
            return null;
        }
        if (source instanceof HHHistoryItem) {
            HHHistoryItem hhItem = (HHHistoryItem)source;
            if (!DVTPlugin.getDefault().collect().c(hhItem.getProject(), this.getFeature())) {
                return null;
            }
            IHidHolder holder = hhItem.getHidHolder();
            if (holder != null) {
                elements = HHViewUtils.getData(holder, showHids, showOperators, showOnlyComplete, showPredefined);
            } else {
                source = hhItem.getProject();
            }
        }
        if (source instanceof IProject) {
            IRfSingleLangProject rfProject;
            block17: {
                String nature_ID;
                IProject project;
                block16: {
                    block15: {
                        project = (IProject)source;
                        if (DVTPlugin.getDefault().collect().c(project, this.getFeature())) break block15;
                        return null;
                    }
                    nature_ID = this.getLanguageKind().NATURE_ID;
                    if (project.isAccessible() && project.hasNature(nature_ID)) break block16;
                    return null;
                }
                rfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(project, nature_ID, false);
                if (rfProject instanceof IHidHolder) break block17;
                return null;
            }
            try {
                elements = HHViewUtils.getData((IHidHolder)((Object)rfProject), showHids, showOperators, showOnlyComplete, showPredefined);
            }
            catch (CoreException ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        }
        if (ViewsUtils.isCanceled(inputConfig.getUpdateJob())) {
            return null;
        }
        PlainElementWrapper root = PlainElementWrapper.of(null);
        ((IDVTElementWrapper)root).addChildren(elements);
        ViewsUtils.addAdditionaInfoInTree(root, inputConfig.getView().enabledShowActions, "*");
        totalCount = ViewsUtils.countAllWrappersInTree(root);
        matchedCount = this.filterTree(root, inputConfig);
        elements = ((IDVTElementWrapper)root).getChildren();
        if (showOperators) {
            uniqueOperatorsCount = this.countUniqueOperators(elements);
        }
        return new HHViewInput(elements, matchedCount, totalCount, uniqueOperatorsCount);
    }

    private String getFeature() {
        LanguageKind languageKind = this.getLanguageKind();
        if (languageKind == LanguageKind.VLOG) {
            return "F7376";
        }
        if (languageKind == LanguageKind.VHDL) {
            return "F7668646C";
        }
        if (languageKind == LanguageKind.E) {
            return "F65";
        }
        if (languageKind == LanguageKind.SLN) {
            return "F736C6E";
        }
        return null;
    }

    public static abstract class HHHistoryItem<T>
    extends HistoryItem {
        protected T qName;
        protected IProject project;

        public HHHistoryItem(T path, IProject project) {
            super(path.toString());
            this.qName = path;
            this.project = project;
        }

        @Override
        public IProject getProject() {
            return this.project;
        }

        public T getQName() {
            return this.qName;
        }

        public abstract IHidHolder getHidHolder();

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            result = 31 * result + (this.qName == null ? 0 : this.qName.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof HHHistoryItem)) {
                return false;
            }
            HHHistoryItem other = (HHHistoryItem)obj;
            if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
                return false;
            }
            return !(this.qName == null ? other.qName != null : !this.qName.equals(other.qName));
        }
    }
}

