/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.semantic;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.semantic.HHViewUtils;
import ro.amiq.dvt.ui.views.semantic.HHWrapper;
import ro.amiq.dvt.ui.views.semantic.HidHolderView;

public class HHLabelProvider
extends DVTBaseLabelProvider {
    @Override
    public Image getImage(Object element) {
        if (!(element instanceof IDVTElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Object obj = ((IDVTElementWrapper)element).getRfElement();
        if (obj instanceof LanguageKind) {
            LanguageKind languageKind = (LanguageKind)((Object)obj);
            switch (languageKind) {
                case E: {
                    return DVTImages.imageCache.getImage(DVTImages.E_LANGUAGE);
                }
                case SLN: {
                    return DVTImages.imageCache.getImage(DVTImages.SLN_LANGUAGE);
                }
                case VHDL: {
                    return DVTImages.imageCache.getImage(DVTImages.VHDL_LANGUAGE);
                }
                case VLOG: {
                    return DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
                }
            }
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (obj instanceof HHWrapper) {
            return HHLabelProvider.toImage(((HHWrapper)obj).getHidObject());
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    @Override
    public String getText(Object element) {
        IRfNamedElement ss;
        IRfScopeElement scope;
        if (!(element instanceof IDVTElementWrapper)) {
            return "";
        }
        IDVTElementWrapper wrapper = (IDVTElementWrapper)element;
        Object obj = wrapper.getRfElement();
        if (!(obj instanceof HHWrapper)) {
            if (obj instanceof LanguageKind) {
                return ((LanguageKind)((Object)obj)).VIEW_NAME;
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            return "";
        }
        if (wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            this.setBoldFont(wrapper);
        }
        boolean showQualifiers = wrapper.getAdditionalInfo((Object)HidHolderView.ShowActionKind.SHOW_QUALIFIERS) != null;
        boolean showCompletePath = wrapper.getAdditionalInfo((Object)HidHolderView.ShowActionKind.SHOW_COMPLETE_PATH) != null;
        boolean showIsResolved = wrapper.getAdditionalInfo((Object)HidHolderView.ShowActionKind.SHOW_UNRESOLVED) != null;
        boolean showScope = wrapper.getAdditionalInfo((Object)HidHolderView.ShowActionKind.SHOW_SCOPE) != null;
        boolean showSecondaryScope = wrapper.getAdditionalInfo((Object)HidHolderView.ShowActionKind.SHOW_SECONDARY_SCOPE) != null;
        IHidObject hidObject = ((HHWrapper)obj).getHidObject();
        StringBuilder sb = new StringBuilder(HidUtils.toString(hidObject, showCompletePath, false));
        IHidObject.HidKind hidKind = hidObject.getHidKind();
        if (showQualifiers) {
            String qualfiers = null;
            switch (hidKind) {
                case HID: {
                    if (((Hid)hidObject).isMethodCall(false)) {
                        sb.append("()");
                    }
                    if ((qualfiers = HHViewUtils.serializeQualifiers(HidUtils.toHidQualifiers(((Hid)hidObject).getQualifiers()))).isEmpty()) break;
                    sb.append(" [").append(qualfiers).append("]");
                    break;
                }
                case ACCESS: {
                    String accessKindName = HHViewUtils.serializeAccessKind(((HidAccess)hidObject).getAccessKind());
                    if (accessKindName.isEmpty()) break;
                    sb.append(" [[").append(accessKindName).append("]]");
                    break;
                }
                case OPERATOR: {
                    String customType;
                    qualfiers = HHViewUtils.serializeQualifiers(HidUtils.toOperatorQualifiers(((HidOperator)hidObject).getQualifiers()));
                    if (!qualfiers.isEmpty()) {
                        sb.append(" [").append(qualfiers).append("]");
                    }
                    if ((customType = HHViewUtils.serializeCustomOperatorType(((HidOperator)hidObject).getOperatorType())) == null) break;
                    sb.append(" [[").append(customType).append("]]");
                    break;
                }
            }
        }
        if (showIsResolved && !HidUtils.isResolved(hidObject)) {
            sb.append("   [not resolved]");
        } else if (showIsResolved) {
            IRfNamedElement resolvedElement = HidUtils.getResolvedElement(hidObject);
            if (resolvedElement == null) {
                sb.append("   [resolved to: NULL]");
            } else {
                sb.append("   [resolved to: " + resolvedElement.getSignature() + " ]");
            }
        }
        if (showScope && (hidKind == IHidObject.HidKind.HID || hidKind == IHidObject.HidKind.OPERATOR) && (scope = ((HHWrapper)obj).getScope()) != null) {
            sb.append("  *").append(scope.getName()).append("*");
        }
        if (showSecondaryScope && hidKind == IHidObject.HidKind.HID && (ss = ((Hid)hidObject).getSecondaryScope()) != null) {
            sb.append("  **").append(ss.getName()).append("**");
        }
        return sb.toString().replaceAll("\n", " ");
    }

    @NotNull
    private static Image toImage(IHidObject value) {
        if (value == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        switch (value.getHidKind()) {
            case HID: {
                return DVTImages.imageCache.getImage(DVTImages.ASSUME);
            }
            case ACCESS: {
                return DVTImages.imageCache.getImage(DVTImages.ARROW_LEFT_RIGHT_IMG);
            }
            case IMPLICIT: {
                return DVTImages.imageCache.getImage(DVTImages.SHOW_PREDEFINED);
            }
            case OPERATOR: {
                return DVTImages.imageCache.getImage(DVTImages.CHECK);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }
}

