/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.semantic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.PlainElementWrapper;
import ro.amiq.dvt.ui.views.semantic.HHWrapper;
import ro.amiq.dvt.ui.views.semantic.HidHolderView;

public interface HHViewUtils {
    public static List<IDVTElementWrapper> getData(IHidHolder element, boolean showHids, boolean showOperators, boolean showOnlyComplete, boolean showPredefined) {
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList<IDVTElementWrapper> wrappers = new ArrayList<IDVTElementWrapper>();
        int[] nofCollects = new int[1];
        if (showHids) {
            element.visitHidObject(null, new MakeWrapperVisitor(true, false, showOnlyComplete, showPredefined, wrappers, nofCollects));
        }
        if (showOperators) {
            element.visitHidObject(null, new MakeWrapperVisitor(false, true, showOnlyComplete, showPredefined, wrappers, nofCollects));
        }
        return wrappers;
    }

    @NotNull
    public static String serializeQualifiers(IHidObject hidObject) {
        if (hidObject instanceof HidAccess) {
            return HHViewUtils.serializeAccessKind(((HidAccess)hidObject).getAccessKind());
        }
        if (hidObject instanceof IHidOccurrenceHolder) {
            HidOccurrence occurrence = ((IHidOccurrenceHolder)((Object)hidObject)).getOccurrence();
            if (occurrence == null) {
                return "";
            }
            StringJoiner outer = new StringJoiner("; ");
            String sqs = HHViewUtils.serializeQualifiers(occurrence, HidUtils.isHid(hidObject) ? HidQualifier.class : HidOperatorQualifier.class);
            if (sqs != null && !sqs.isEmpty()) {
                outer.add(sqs);
            }
            return outer.toString();
        }
        return "";
    }

    @NotNull
    public static <T extends Enum<T>> String serializeQualifiers(HidOccurrence hidOccurrence, Class clazz) {
        if (HidQualifier.class.equals((Object)clazz)) {
            return HHViewUtils.serializeQualifiers(HidUtils.toHidQualifiers(hidOccurrence.getQualifiers()));
        }
        if (HidOperatorQualifier.class.equals((Object)clazz)) {
            return HHViewUtils.serializeQualifiers(HidUtils.toOperatorQualifiers(hidOccurrence.getQualifiers()));
        }
        return null;
    }

    @NotNull
    public static String serializeQualifiers(List qualifiers) {
        if (qualifiers == null || qualifiers.isEmpty()) {
            return "";
        }
        StringJoiner inner = new StringJoiner(", ");
        for (Object hidOccurrenceQualifier : qualifiers) {
            inner.add(hidOccurrenceQualifier.toString());
        }
        return inner.toString();
    }

    public static String serializeCustomOperatorType(int type) {
        if (type >= 0) {
            return null;
        }
        return IHidOperatorConstants.OperatorType.nameOf(type);
    }

    @NotNull
    public static String serializeAccessKind(int accessKind) {
        switch (accessKind) {
            case -2147483648: {
                return "NO_ACCESS";
            }
            case 0: {
                return "DOT_ACCESS";
            }
            case 1: {
                return "COLON_ACCESS";
            }
            case 4: {
                return "ARGUMENT_ACCESS";
            }
            case 2: {
                return "COLON_COLON_ACCESS";
            }
            case 3: {
                return "RANDOMIZE_ACCESS";
            }
            case 5: {
                return "ATTRIBUTE_ACCESS";
            }
        }
        return "";
    }

    public static class MakeWrapperVisitor
    implements IHidVisitor<IHidObject> {
        private final boolean showHids;
        private final boolean showOperators;
        private final boolean showPredefined;
        private final boolean showOnlyComplete;
        private final List<IDVTElementWrapper> wrappers;
        private ParserPath parserPath;
        private IRfScopeElement scope;
        private PlainElementWrapper currentRoot;
        private int[] nofCollects;

        public MakeWrapperVisitor(boolean showHids, boolean showOperators, boolean showOnlyComplete, boolean showPredefined, List<IDVTElementWrapper> wrappers, int[] nofCollects) {
            this.showHids = showHids;
            this.showOperators = showOperators;
            this.wrappers = wrappers;
            this.nofCollects = nofCollects;
            this.showOnlyComplete = showOnlyComplete;
            this.showPredefined = showPredefined;
        }

        public MakeWrapperVisitor(boolean showHids, boolean showOperators, List<IDVTElementWrapper> wrappers, boolean showOnlyComplete, boolean showPredefined, int[] nofCollects, IRfScopeElement scope, ParserPath parserPath) {
            this(showHids, showOperators, showOnlyComplete, showPredefined, wrappers, nofCollects);
            this.scope = scope;
            this.parserPath = parserPath;
        }

        @Override
        public boolean enterBindInstances() {
            return true;
        }

        @Override
        public boolean enterDataTypes() {
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.scope = ((HidHolder)holder).getScope();
            }
        }

        @Override
        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        @Override
        public boolean visit(IHidObject hidObject) {
            if (!this.showPredefined && this.scope instanceof IRfNamedElement && ((IRfNamedElement)this.scope).getLanguageKind() == LanguageKind.VHDL && ((IRfNamedElement)this.scope).isPredefined()) {
                return true;
            }
            PlainElementWrapper wrapper = PlainElementWrapper.of(new HHWrapper(hidObject, this.parserPath, this.scope));
            switch (hidObject.getHidKind()) {
                case HID: {
                    if (!this.showHids) break;
                    Hid hid = (Hid)hidObject;
                    HidAccess parentAccess = hid.getParentAccess();
                    if (parentAccess == null) {
                        int n = this.nofCollects[0];
                        this.nofCollects[0] = n + 1;
                        if (n > HidHolderView.MAX_NOF_HID_OBJECTS_SHOWN) {
                            return false;
                        }
                        this.wrappers.add(wrapper);
                    } else {
                        IDVTElementWrapper findWrapperAncestor = MakeWrapperVisitor.findWrapperAncestor(this.currentRoot, parentAccess);
                        if (findWrapperAncestor != null) {
                            findWrapperAncestor.addChild(wrapper);
                        }
                    }
                    this.currentRoot = wrapper;
                    break;
                }
                case ACCESS: {
                    IDataType dataType;
                    if (!this.showHids) break;
                    IDVTElementWrapper findWrapperAncestor = MakeWrapperVisitor.findWrapperAncestor(this.currentRoot, ((HidAccess)hidObject).getParentHid());
                    if (findWrapperAncestor != null) {
                        findWrapperAncestor.addChild(wrapper);
                    }
                    if ((dataType = ((HidAccess)hidObject).getDataType()) != null && dataType.getParamValuesHolder() != null) {
                        IHidHolder hidHolder = dataType.getParamValuesHolder();
                        hidHolder.visitHidObject(null, new MakeWrapperVisitor(true, true, this.showOnlyComplete, this.showPredefined, this.wrappers, this.nofCollects));
                    }
                    this.currentRoot = wrapper;
                    break;
                }
                case IMPLICIT: {
                    this.currentRoot.addChild(wrapper);
                    break;
                }
                case OPERATOR: {
                    PlainElementWrapper childWrapper;
                    IHidObject lhValue;
                    if (!this.showOperators) break;
                    int n = this.nofCollects[0];
                    this.nofCollects[0] = n + 1;
                    if (n > HidHolderView.MAX_NOF_HID_OBJECTS_SHOWN) {
                        return false;
                    }
                    HidOperator operator = (HidOperator)hidObject;
                    this.currentRoot = wrapper;
                    if (!this.showOnlyComplete || operator.isComplete()) {
                        this.wrappers.add(this.currentRoot);
                    }
                    if ((lhValue = operator.getLHValue()) == null) break;
                    if (lhValue.getHidKind() == IHidObject.HidKind.OPERATOR) {
                        MakeWrapperVisitor visitor = new MakeWrapperVisitor(true, this.showOperators, new ArrayList<IDVTElementWrapper>(), false, this.showPredefined, this.nofCollects, this.scope, this.parserPath);
                        ((HidOperator)lhValue).visitHidObject((IRfSingleLangProject)null, (IHidVisitor)visitor);
                        this.currentRoot.addChildren(visitor.getWrappers());
                    } else if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                        childWrapper = PlainElementWrapper.of(new HHWrapper(lhValue, this.parserPath, this.scope));
                        this.currentRoot.addChild(childWrapper);
                    }
                    ListContainer<IHidObject> rhValues = operator.getRHValues();
                    if (rhValues == null || rhValues.isEmpty()) break;
                    for (IHidObject rhValue : rhValues) {
                        if (rhValue == null) continue;
                        if (rhValue.getHidKind() == IHidObject.HidKind.OPERATOR) {
                            MakeWrapperVisitor visitor = new MakeWrapperVisitor(true, this.showOperators, new ArrayList<IDVTElementWrapper>(), false, this.showPredefined, this.nofCollects, this.scope, this.parserPath);
                            ((HidOperator)rhValue).visitHidObject((IRfSingleLangProject)null, (IHidVisitor)visitor);
                            this.currentRoot.addChildren(visitor.getWrappers());
                            continue;
                        }
                        childWrapper = PlainElementWrapper.of(new HHWrapper(rhValue, this.parserPath, this.scope));
                        this.currentRoot.addChild(childWrapper);
                    }
                    break;
                }
            }
            return true;
        }

        public List<IDVTElementWrapper> getWrappers() {
            return this.wrappers;
        }

        public static IDVTElementWrapper findWrapperAncestor(IDVTElementWrapper root, IHidObject object) {
            if (root == null || object == null) {
                return root;
            }
            do {
                if (((HHWrapper)root.getRfElement()).getHidObject() != object) continue;
                return root;
            } while ((root = root.getParent()) != null);
            return root;
        }

        @Override
        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

