/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.semantic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.PlainElementWrapper;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.semantic.AbstractHHViewContributor;
import ro.amiq.dvt.ui.views.semantic.HHViewInput;
import ro.amiq.dvt.ui.views.semantic.HHViewInputConfigurator;
import ro.amiq.dvt.ui.views.semantic.HHViewUtils;
import ro.amiq.dvt.ui.views.semantic.HHWrapper;
import ro.amiq.dvt.ui.views.semantic.HidHolderViewCommon;
import ro.amiq.dvt.ui.views.semantic.IHHViewContributor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class HidHolderView
extends HidHolderViewCommon
implements IUpdateJobImpl,
IRfFilterableTreeAccessor {
    private static final List<IHHViewContributor> allHHContributors = DVTViewContributors.getInstance().getAllInstanceOf(IHHViewContributor.class);
    public static final int MAX_NOF_MENU_ENTRIES = 15;
    public static int MAX_NOF_HID_OBJECTS_SHOWN = 50000;
    private TreeViewContentProvider lazyContentProvider;
    private Tree tree;
    private int matchCount;
    private int totalCount;
    private int uniqueOperatorsCount;
    private int viewLimitReached = 0;
    private final UpdateJob updateJob = new UpdateJob("Update Hid Holder View", this);
    private SashForm mainSashForm;
    private Label treeLabel;
    private SashForm upperSashForm;
    private Composite sashChildTree;
    private List<IDVTElementWrapper> elements;
    private final DVTLabelProviderProxy<IHHViewContributor> treeLabelProvider = new DVTLabelProviderProxy<IHHViewContributor>(IHHViewContributor.class, "default-tree");
    private final Action[] showActions = new ShowAction[ShowActionKind.values().length];
    Set<ShowActionKind> enabledShowActions = EnumSet.of(ShowActionKind.SHOW_HIDS, ShowActionKind.SHOW_UNRESOLVED, ShowActionKind.SHOW_OPERATORS);
    private final Action selectTopAction = new Action("Show All", DVTImages.VERIFICATION_HIERARCHY_TOP){

        public void run() {
            HidHolderView.this.setInput(new ViewDataContainer(HidHolderView.this.getProject(), null));
            HidHolderView.this.update(null);
        }
    };
    private static GridLayout layout = new GridLayout(1, true);
    private static GridLayout twoPartLayout;

    static {
        HidHolderView.layout.marginWidth = 0;
        HidHolderView.layout.marginHeight = 0;
        HidHolderView.layout.verticalSpacing = 0;
        twoPartLayout = new GridLayout(2, false);
        HidHolderView.twoPartLayout.marginWidth = 0;
        HidHolderView.twoPartLayout.marginHeight = 0;
        HidHolderView.twoPartLayout.verticalSpacing = 0;
    }

    private static List<IDVTElementWrapper> getHelpMsg() {
        return new ArrayList<IDVTElementWrapper>(INPUT_VERIFICATION_HIERARCHY_VIEW);
    }

    public boolean isShowActionEnabled(ShowActionKind action) {
        return action != null && this.enabledShowActions.contains((Object)action);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)layout);
        this.mainSashForm = new SashForm(parent, 512);
        this.mainSashForm.setLayout((Layout)layout);
        this.mainSashForm.setFont(parent.getFont());
        this.mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)this.mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)layout);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        this.treeLabel = new Label(fUpperSashFormComposite, 16384);
        this.treeLabel.setFont(this.mainSashForm.getFont());
        this.treeLabel.setLayoutData((Object)new GridData(768));
        this.upperSashForm = new SashForm(fUpperSashFormComposite, 256);
        this.upperSashForm.setLayout((Layout)twoPartLayout);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.createViewToolbar();
        this.createTreeViewPart();
        this.createTreeContextMenu();
    }

    private void createTreeViewPart() {
        this.sashChildTree = new Composite((Composite)this.upperSashForm, 0);
        this.sashChildTree.setLayout((Layout)layout);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        this.createTextFilter("default-filter", this.sashChildTree, "default-tree", true);
        this.setTextFilterFont("default-filter", this.mainSashForm.getFont());
        this.setTextFilterMessage("default-filter", "Filter by: hierarchical name .port");
        Composite treeComposite = new Composite(this.sashChildTree, 0);
        treeComposite.setLayoutData((Object)new GridData(1808));
        treeComposite.setLayout((Layout)new FillLayout(256));
        this.tree = new Tree(treeComposite, 268436228);
        this.lazyContentProvider = new TreeViewContentProvider(this.tree, this.treeLabelProvider);
        this.fExpandLevel = -1;
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                HidHolderView.this.gotoSelectedElement("default-tree");
            }
        });
    }

    private void createViewToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.selectTopAction);
        this.createShowActions();
        Action[] actionArray = this.showActions;
        int n = this.showActions.length;
        int n2 = 0;
        while (n2 < n) {
            Action showAction = actionArray[n2];
            toolbarManager.add((IAction)showAction);
            ++n2;
        }
        toolbarManager.update(true);
    }

    private void createShowActions() {
        ShowActionKind[] showActionKindArray = ShowActionKind.values();
        int n = showActionKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShowActionKind actionType = showActionKindArray[n2];
            this.showActions[actionType.ordinal()] = new ShowAction(actionType);
            ++n2;
        }
    }

    private void createTreeContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                HidHolderView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager mgr) {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper("default-tree");
        this.fillContextMenu(selectedWrapper, mgr, this.isShowActionEnabled(ShowActionKind.SHOW_QUALIFIERS));
    }

    private void fillContextMenu(IDVTElementWrapper selectedWrapper, IMenuManager mgr, boolean showQualifiers) {
        if (mgr == null) {
            return;
        }
        List<GoToOffsetAction> actions = this.getGoToActions(selectedWrapper, showQualifiers);
        if (actions == null || actions.isEmpty()) {
            return;
        }
        for (GoToOffsetAction goToOffsetAction : actions) {
            mgr.add((IAction)goToOffsetAction);
        }
    }

    private static void goToOffsetAndPath(int offset, ParserPath parserPath, String text) {
        if (parserPath == null || offset < 0) {
            return;
        }
        DVTFileUtils.getInstance().openEditorWithOffset(new File(parserPath.path), offset, text != null ? text.length() : 1, true, "org.eclipse.ui.DefaultTextEditor");
    }

    private List<GoToOffsetAction> getGoToActions(IDVTElementWrapper selectedWrapper, boolean showQualifiers) {
        Object obj = selectedWrapper.getRfElement();
        if (!(obj instanceof HHWrapper)) {
            return Collections.emptyList();
        }
        IHidObject element = ((HHWrapper)obj).getHidObject();
        if (element == null) {
            return Collections.emptyList();
        }
        ParserPath parserPath = ((HHWrapper)obj).getParserPath();
        Hid hid = null;
        String text = HidUtils.toString(element, true, false);
        block0 : switch (element.getHidKind()) {
            case HID: {
                return this.getGoToActions(text, parserPath, ((IHidOccurrenceHolder)((Object)element)).getOccurrence(), HidQualifier.class, null, showQualifiers);
            }
            case OPERATOR: {
                return this.getGoToActions(text, parserPath, ((IHidOccurrenceHolder)((Object)element)).getOccurrence(), HidOperatorQualifier.class, null, showQualifiers);
            }
            case ACCESS: {
                List<? extends IHidObject> argValues;
                HidAccess access = (HidAccess)element;
                if (access.isSelect()) {
                    IHidObject select = access.getSelects().get(0);
                    switch (select.getHidKind()) {
                        case HID: {
                            return this.getGoToActions(text, parserPath, ((IHidOccurrenceHolder)((Object)select)).getOccurrence(), HidQualifier.class, access.getAccessKind(), showQualifiers);
                        }
                        case OPERATOR: {
                            return this.getGoToActions(text, parserPath, ((IHidOccurrenceHolder)((Object)select)).getOccurrence(), HidOperatorQualifier.class, access.getAccessKind(), showQualifiers);
                        }
                        case ACCESS: {
                            hid = ((HidAccess)select).getParentHid();
                            if (hid == null) break block0;
                            return this.getGoToActions(text, parserPath, hid.getOccurrence(), HidQualifier.class, access.getAccessKind(), showQualifiers);
                        }
                        case IMPLICIT: {
                            hid = access.getParentHid();
                            if (hid == null) break block0;
                            return this.getGoToActions(text, parserPath, hid.getOccurrence(), HidQualifier.class, access.getAccessKind(), showQualifiers);
                        }
                    }
                    break;
                }
                if (access instanceof IHidAccessArgs && (argValues = ((IHidAccessArgs)((Object)access)).getArgumentValues()) != null && !argValues.isEmpty()) {
                    IHidObject argumentValue = argValues.get(0);
                    Class clazzQualifier = HidUtils.isHid(argumentValue) ? HidQualifier.class : HidOperatorQualifier.class;
                    return this.getGoToActions(text, parserPath, ((IHidOccurrenceHolder)((Object)argumentValue)).getOccurrence(), clazzQualifier, access.getAccessKind(), showQualifiers);
                }
                hid = ((HidAccess)element).getParentHid();
                if (hid == null) break;
                return this.getGoToActions(text, parserPath, hid.getOccurrence(), HidQualifier.class, access.getAccessKind(), showQualifiers);
            }
        }
        return Collections.emptyList();
    }

    private List<GoToOffsetAction> getGoToActions(String text, ParserPath parserPath, HidOccurrence hidOccurrence, Class clazzQualifier, Integer accessKind, boolean showQualifiers) {
        if (hidOccurrence == null) {
            return Collections.emptyList();
        }
        ArrayList<GoToOffsetAction> actions = new ArrayList<GoToOffsetAction>();
        StringBuilder qualifiers = new StringBuilder();
        if (showQualifiers) {
            if (accessKind != null) {
                qualifiers.append(HHViewUtils.serializeAccessKind(accessKind)).append(", ");
            }
            qualifiers.append(HHViewUtils.serializeQualifiers(hidOccurrence, clazzQualifier));
        }
        actions.add(new GoToOffsetAction(hidOccurrence.getLine(), hidOccurrence.getOffset(), qualifiers.toString(), parserPath, text));
        return actions;
    }

    protected Control getControl() {
        return this.tree;
    }

    @Override
    public void clean() {
        this.updateJob.cancel();
        this.cleanNonGui();
        this.cleanGui();
    }

    private void cleanNonGui() {
        if (this.elements != null) {
            this.elements.clear();
        }
        this.totalCount = 0;
        this.matchCount = 0;
        this.uniqueOperatorsCount = 0;
        this.viewLimitReached = 0;
    }

    private void cleanGui() {
        boolean incorrectProject;
        if (this.lazyContentProvider == null || this.tree == null || this.tree.isDisposed()) {
            return;
        }
        if (this.treeLabel == null || this.treeLabel.isDisposed()) {
            return;
        }
        IProject project = this.getProject();
        List<IDVTElementWrapper> treeInput = null;
        boolean bl = incorrectProject = project == null || !project.isAccessible() || !Utils.hasDvtNature(project);
        if (incorrectProject) {
            this.treeLabel.setText("[no DVT Project or file selected]");
            ProjectColorUtils.setFgBg(this, null);
        } else {
            this.treeLabel.setText(this.getTreeLabelText());
            ProjectColorUtils.setFgBg(this, this.getProject().getName());
        }
        treeInput = incorrectProject ? HidHolderView.getHelpMsg() : new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE);
        this.lazyContentProvider.setInput(treeInput, -1);
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper wrapper = this.getSelectedWrapper(treeId);
        if (wrapper == null) {
            return;
        }
        List<GoToOffsetAction> actions = this.getGoToActions(wrapper, false);
        if (actions == null || actions.isEmpty()) {
            return;
        }
        actions.get(0).run();
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.tree.setRedraw(false);
            this.update(null);
            this.tree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public Tree getTree(String treeId) {
        return this.tree;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        Tree tree = this.getTree(treeId);
        if (tree != null) {
            return tree.getData();
        }
        return null;
    }

    private String getTreeLabelText() {
        if (this.getProject() == null) {
            return "";
        }
        HistoryItem hhItem = this.getHistoryItem();
        String scopeName = hhItem != null && ((AbstractHHViewContributor.HHHistoryItem)hhItem).getHidHolder() != null ? ((AbstractHHViewContributor.HHHistoryItem)hhItem).getHidHolder().toString() : this.getProject().getName();
        StringBuilder labelBuilder = new StringBuilder("[").append(scopeName).append("]");
        if (this.viewLimitReached != 0) {
            labelBuilder.append("[! Only the first " + this.viewLimitReached * MAX_NOF_HID_OBJECTS_SHOWN + " hid objects are shown]");
        }
        if (this.getStringMatcher("default-filter") == null) {
            if (this.totalCount > 0) {
                labelBuilder.append("[").append(this.totalCount).append(this.totalCount == 1 ? " hid object]" : " hid objects]");
            }
        } else {
            labelBuilder.append("[").append(this.matchCount).append("/").append(this.totalCount).append(" hid objects]");
        }
        if (this.uniqueOperatorsCount > 0) {
            labelBuilder.append("[").append(this.uniqueOperatorsCount).append(" unique ").append(this.uniqueOperatorsCount == 1 ? "operator]" : "operators]");
        }
        return labelBuilder.toString();
    }

    @Override
    public AbstractHHViewContributor.HHHistoryItem<?> getHistoryItem() {
        return (AbstractHHViewContributor.HHHistoryItem)super.getHistoryItem();
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            if (this.tree == null) {
                return;
            }
            IProject project = this.getProject();
            if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            this.treeLabel.setText("");
            ProjectColorUtils.setFgBg(this, null);
            this.lazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            this.updateJob.cancel();
            this.updateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setFocus() {
        if (this.tree != null && !this.tree.isDisposed()) {
            this.tree.setFocus();
        }
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        this.elements = new ArrayList<IDVTElementWrapper>();
        this.totalCount = 0;
        this.matchCount = 0;
        this.uniqueOperatorsCount = 0;
        this.viewLimitReached = 0;
        if (ViewsUtils.isCanceled(updateJob)) {
            return;
        }
        HistoryItem hhItem = this.getHistoryItem();
        if (hhItem != null) {
            Optional<IHHViewContributor> findFirst = allHHContributors.stream().filter(provider -> provider.getLanguageKind() == hhItem.getLanguage()).findFirst();
            if (!findFirst.isPresent()) {
                return;
            }
            IHHViewContributor contributor = findFirst.get();
            HHViewInput input = contributor.getInput(new HHViewInputConfigurator(hhItem, this));
            if (input == null) {
                return;
            }
            this.handleMaxNofElements(input.getElements(), elem -> {
                boolean bl = this.elements.add((IDVTElementWrapper)elem);
            });
            this.totalCount += input.getTotalCount();
            this.matchCount += input.getMatchCount();
            this.uniqueOperatorsCount += input.getUniqueOperatorsCount();
        } else {
            IProject project = this.getProject();
            ArrayList<PlainElementWrapper> languageHeaders = new ArrayList<PlainElementWrapper>(3);
            for (IHHViewContributor contributor : allHHContributors) {
                if (ViewsUtils.isCanceled(updateJob)) {
                    return;
                }
                HHViewInput input = contributor.getInput(new HHViewInputConfigurator(project, this));
                if (input == null) continue;
                PlainElementWrapper languageHeader = PlainElementWrapper.of((Object)contributor.getLanguageKind());
                this.handleMaxNofElements(input.getElements(), elem -> languageHeader.addChild((IDVTElementWrapper)elem));
                if (languageHeader.hasChildren()) {
                    languageHeaders.add(languageHeader);
                }
                this.totalCount += input.getTotalCount();
                this.matchCount += input.getMatchCount();
                this.uniqueOperatorsCount += input.getUniqueOperatorsCount();
            }
            if (languageHeaders.size() > 1) {
                this.elements.addAll(languageHeaders);
            } else if (languageHeaders.size() == 1) {
                this.elements.addAll(((PlainElementWrapper)languageHeaders.get(0)).getChildren());
            }
        }
    }

    private void handleMaxNofElements(List<IDVTElementWrapper> source, Consumer<IDVTElementWrapper> handler) {
        if (source == null || source.isEmpty() || handler == null) {
            return;
        }
        int inputSize = source.size();
        int i = 0;
        while (i < inputSize) {
            if (i > MAX_NOF_HID_OBJECTS_SHOWN) {
                ++this.viewLimitReached;
                break;
            }
            handler.accept(source.get(i));
            ++i;
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        if (this.lazyContentProvider == null || this.tree == null || this.tree.isDisposed()) {
            return;
        }
        if (this.treeLabel == null || this.treeLabel.isDisposed()) {
            return;
        }
        this.fExpandLevel = -1;
        List<IDVTElementWrapper> treeInput = null;
        this.treeLabel.setText(this.getTreeLabelText());
        if (this.getProject() == null) {
            ProjectColorUtils.setFgBg(this, null);
        } else {
            ProjectColorUtils.setFgBg(this, this.getProject().getName());
        }
        treeInput = this.elements != null && !this.elements.isEmpty() ? this.elements : new ArrayList<IDVTElementWrapper>(AbstractFilteredView.NO_DATA_MESSAGE);
        this.lazyContentProvider.setInput(treeInput, this.fExpandLevel);
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.treeLabelProvider;
    }

    @Override
    public void dispose() {
        this.updateJob.cancel();
        if (this.tree != null && !this.tree.isDisposed()) {
            this.tree.dispose();
        }
        this.tree = null;
        if (this.treeLabel != null && !this.treeLabel.isDisposed()) {
            this.treeLabel.dispose();
        }
        this.treeLabel = null;
        this.lazyContentProvider = null;
        this.elements = null;
        super.dispose();
    }

    @Override
    public UpdateJob getUpdateJob() {
        return this.updateJob;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        return this.getSearchSegments("default-filter");
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        return this.getSearchStrictness("default-filter");
    }

    @Override
    public String getTreeSearchPort() {
        return this.getSearchPort("default-filter");
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    public Object getRoots() {
        return this.elements;
    }

    public void testSetShowHids(boolean value) {
        if (value ^ this.isShowActionEnabled(ShowActionKind.SHOW_HIDS)) {
            this.showActions[ShowActionKind.SHOW_HIDS.ordinal()].run();
            ObjectionManager.getInstance().waitFor(Objection.HIDHOLDER);
        }
    }

    public void testSetShowOperators(boolean value) {
        if (value ^ this.isShowActionEnabled(ShowActionKind.SHOW_OPERATORS)) {
            this.showActions[ShowActionKind.SHOW_OPERATORS.ordinal()].run();
            ObjectionManager.getInstance().waitFor(Objection.HIDHOLDER);
        }
    }

    public void testSetShowPredefined(boolean value) {
        if (value ^ this.isShowActionEnabled(ShowActionKind.SHOW_PREDEFINED)) {
            this.showActions[ShowActionKind.SHOW_PREDEFINED.ordinal()].run();
            ObjectionManager.getInstance().waitFor(Objection.HIDHOLDER);
        }
    }

    public int testGetHidObjectsInHierarchyCount() {
        return this.totalCount;
    }

    public int testGetUniqueOperatorsCount() {
        return this.uniqueOperatorsCount;
    }

    public void testCollectHidHoldersForProject(IProject project, boolean showHids, boolean showPredefined) {
        this.elements = new ArrayList<IDVTElementWrapper>();
        this.createShowActions();
        if (!showHids) {
            this.enabledShowActions.remove((Object)ShowActionKind.SHOW_HIDS);
        }
        if (!showPredefined) {
            this.enabledShowActions.remove((Object)ShowActionKind.SHOW_PREDEFINED);
        }
        MAX_NOF_HID_OBJECTS_SHOWN = Integer.MAX_VALUE;
        ArrayList<PlainElementWrapper> languageHeaders = new ArrayList<PlainElementWrapper>(3);
        for (IHHViewContributor contributor : allHHContributors) {
            HHViewInput input = contributor.getInput(new HHViewInputConfigurator(project, this));
            if (input == null) continue;
            PlainElementWrapper languageHeader = PlainElementWrapper.of((Object)contributor.getLanguageKind());
            this.handleMaxNofElements(input.getElements(), elem -> languageHeader.addChild((IDVTElementWrapper)elem));
            if (languageHeader.hasChildren()) {
                languageHeaders.add(languageHeader);
            }
            this.totalCount += input.getTotalCount();
            this.matchCount += input.getMatchCount();
            this.uniqueOperatorsCount += input.getUniqueOperatorsCount();
        }
        MAX_NOF_HID_OBJECTS_SHOWN = 50000;
        if (languageHeaders.size() > 1) {
            this.elements.addAll(languageHeaders);
        } else if (languageHeaders.size() == 1) {
            this.elements.addAll(((PlainElementWrapper)languageHeaders.get(0)).getChildren());
        }
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return this.lazyContentProvider;
    }

    @Override
    public Control getControlToColorBg() {
        return this.treeLabel;
    }

    @Override
    public Control getControlToColorFg() {
        return this.treeLabel;
    }

    static class GoToOffsetAction
    extends Action {
        int offset;
        int line;
        ParserPath path;
        String text;

        private GoToOffsetAction(int line, int offset, String qualifiers, ParserPath path, String text) {
            super("Go to offset (" + line + " , " + offset + ")" + (qualifiers != null && !qualifiers.isEmpty() ? " [" + qualifiers + "]" : ""));
            this.text = text;
            this.path = path;
            this.offset = offset;
            this.line = line;
        }

        public void run() {
            HidHolderView.goToOffsetAndPath(this.offset, this.path, this.text);
        }
    }

    private class ShowAction
    extends Action {
        ShowActionKind action;

        ShowAction(ShowActionKind action) {
            super(action.text, 2);
            this.setImageDescriptor(action.imageDescriptor);
            this.setToolTipText(action.text);
            this.setChecked(HidHolderView.this.isShowActionEnabled(action));
            this.action = action;
        }

        public void run() {
            if (HidHolderView.this.isShowActionEnabled(this.action)) {
                HidHolderView.this.enabledShowActions.remove((Object)this.action);
            } else {
                HidHolderView.this.enabledShowActions.add(this.action);
            }
            HidHolderView.this.update(null);
        }
    }

    public static enum ShowActionKind {
        SHOW_COMPLETE_PATH("Show Complete Path", DVTImages.PREPEND_PACKAGE),
        SHOW_QUALIFIERS("Show Qualifiers", DVTImages.SHOW_PREDEFINED),
        SHOW_UNRESOLVED("Show Unresolved", DVTImages.SHOW_BUILD_REPORT),
        SHOW_SCOPE("Show Scope", DVTImages.SHOW_BUILD_LOG_FILE),
        SHOW_SECONDARY_SCOPE("Show Secondary Scope", DVTImages.PREPROC_IFNDEF),
        SHOW_HIDS("Show Hids", DVTImages.ALL_CO),
        SHOW_OPERATORS("Show Operators", DVTImages.DESC_ADD_CORRECTION),
        SHOW_ONLY_COMPLETE("Show Only Complete", DVTImages.SCRIPT_REFACTOR),
        SHOW_PREDEFINED("Show Predefined", DVTImages.SHOW_PREDEFINED);

        String text;
        ImageDescriptor imageDescriptor;

        private ShowActionKind(String text, ImageDescriptor img) {
            this.text = text;
            this.imageDescriptor = img;
        }
    }
}

