/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.templates;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.templates.CodeTemplatesViewCommon;
import ro.amiq.dvt.ui.views.templates.CustomTemplate;
import ro.amiq.dvt.ui.views.templates.EditTemplateDialog;
import ro.amiq.dvt.ui.views.templates.TemplateHierarchy;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;

public class CodeTemplatesView
extends CodeTemplatesViewCommon {
    private static Set<String> fLastProjectNames = new HashSet<String>();
    private Tree fTree;
    private TreeViewer fTreeViewer;
    private CustomTemplate fLastTemplateDragged;
    private DVTPreviewSourceViewer fSourceViewer;
    private Combo fFilterOptionsCombo;
    private InsertTemplate fInsertTemplateItem;
    private Refresh fRefreshItem;
    private NewTemplate fNewTemplateItem;
    private RemoveTemplate fRemoveTemplateItem;
    private EditTemplate fEditTemplateItem;
    private Menu fOptionsMenu;
    private SashForm fSashForm;
    private MenuItem fInsertMenuItem;
    private MenuItem fNewMenuItem;
    private MenuItem fEditMenuItem;
    private MenuItem fRemoveMenuItem;
    private MenuItem fShowPrefsPageMenuItem;
    private IPartListener2 fPartListener;
    private static Comparator<TemplateHierarchy> fTemplateHierarchyComparator = (proposal0, proposal1) -> {
        if (proposal0.getType().equals("template") && proposal1.getType().equals("template")) {
            return proposal0.getCustomTemplate().getName().compareTo(proposal1.getCustomTemplate().getName());
        }
        return proposal0.getNiceName().compareTo(proposal1.getNiceName());
    };

    @Override
    public void gotoSelectedElement(String treeId) {
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), () -> {
            this.fTreeViewer.resetFilters();
            this.fTreeViewer.addFilter((ViewerFilter)new CustomViewFilter(this.getTextFilterText("default-filter"), this.fFilterOptionsCombo.getText()));
            this.fTreeViewer.expandAll();
        });
    }

    @Override
    public Tree getTree(String treeId) {
        return this.fTree;
    }

    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fTree != null) {
            this.fTree.dispose();
        }
        if (this.fSashForm != null) {
            this.fSashForm.dispose();
        }
        if (this.fInsertMenuItem != null) {
            this.fInsertMenuItem.dispose();
        }
        if (this.fNewMenuItem != null) {
            this.fNewMenuItem.dispose();
        }
        if (this.fEditMenuItem != null) {
            this.fEditMenuItem.dispose();
        }
        if (this.fRemoveMenuItem != null) {
            this.fRemoveMenuItem.dispose();
        }
        if (this.fShowPrefsPageMenuItem != null) {
            this.fShowPrefsPageMenuItem.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        Label filterLabel = new Label(composite, 0);
        filterLabel.setFont(composite.getFont());
        GridData layoutFData = new GridData(4, 0x1000000, false, false);
        filterLabel.setLayoutData((Object)layoutFData);
        filterLabel.setText("Filter by:");
        this.fFilterOptionsCombo = new Combo(composite, 4);
        GridData layoutCData = new GridData(16384, 0, false, false);
        layoutCData.widthHint = 100;
        this.fFilterOptionsCombo.setLayoutData((Object)layoutCData);
        this.fFilterOptionsCombo.add("Nature", 0);
        this.fFilterOptionsCombo.add("Context", 1);
        this.fFilterOptionsCombo.add("Name", 2);
        this.fFilterOptionsCombo.add("Project", 3);
        this.fFilterOptionsCombo.add("Description", 4);
        this.fFilterOptionsCombo.setText("Name");
        this.fFilterOptionsCombo.addModifyListener(e -> {
            this.setTextFilterMessage("default-filter", "Filter by: Template's " + this.fFilterOptionsCombo.getText());
            this.stringMatcherUpdated("default-filter");
        });
        this.createTextFilter("default-filter", composite, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: name");
        this.getTextFilter("default-filter").setLayoutData((Object)new GridData(4, 4, true, false));
        this.fSashForm = new SashForm(composite, 2560);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.fTree = new Tree((Composite)this.fSashForm, 268438276);
        this.fTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTree.setHeaderVisible(true);
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fTreeViewer.setInput((Object)TemplatesViewUtils.createTemplatesHierarchy());
        DragSource dragSource = new DragSource((Control)this.fTree, 3);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        dragSource.setTransfer(types);
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ITreeSelection selection = (ITreeSelection)CodeTemplatesView.this.fTreeViewer.getSelection();
                if (selection == null) {
                    return;
                }
                TemplateHierarchy th = (TemplateHierarchy)selection.getFirstElement();
                if (th == null || !th.getType().equals("template")) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                ITreeSelection selection = (ITreeSelection)CodeTemplatesView.this.fTreeViewer.getSelection();
                if (selection == null) {
                    return;
                }
                TemplateHierarchy th = (TemplateHierarchy)selection.getFirstElement();
                if (th == null) {
                    return;
                }
                if (th.getType().equals("template")) {
                    event.data = " ";
                }
                CodeTemplatesView.this.fLastTemplateDragged = th.getCustomTemplate();
            }

            public void dragFinished(DragSourceEvent event) {
                TemplatesViewUtils.showTemplateProposalInEditor(CodeTemplatesView.this.fLastTemplateDragged);
            }
        });
        TreeColumn nameColumn = new TreeColumn(this.fTree, 16384);
        nameColumn.setText("Name");
        nameColumn.setWidth(200);
        TreeColumn projectColumn = new TreeColumn(this.fTree, 16384);
        projectColumn.setText("Project");
        projectColumn.setWidth(100);
        TreeColumn descrColumn = new TreeColumn(this.fTree, 16384);
        descrColumn.setText("Description");
        descrColumn.setWidth(100);
        this.fTree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CodeTemplatesView.this.fSourceViewer.setDocument((IDocument)new Document());
                ITreeSelection selection = (ITreeSelection)CodeTemplatesView.this.fTreeViewer.getSelection();
                if (selection == null) {
                    return;
                }
                TemplateHierarchy th = (TemplateHierarchy)selection.getFirstElement();
                if (th == null || !th.getType().equals("template")) {
                    return;
                }
                CustomTemplate template = th.getCustomTemplate();
                String natureId = TemplatesViewUtilsCommon.getNatureFromContextId(template.getContextTypeId());
                Document document = new Document();
                CodeTemplatesView.this.fSourceViewer.unconfigure();
                SourceViewerConfiguration sourceViewerConfiguration = TemplatesViewUtils.getSourceViewerConfiguration(natureId);
                if (sourceViewerConfiguration == null) {
                    return;
                }
                CodeTemplatesView.this.fSourceViewer.configure(sourceViewerConfiguration);
                IDocumentPartitioner documentPartitioner = TemplatesViewUtils.getDocumentPartitioner(natureId);
                if (documentPartitioner == null) {
                    return;
                }
                documentPartitioner.connect((IDocument)document);
                if (document instanceof IDocumentExtension3) {
                    ((IDocumentExtension3)document).setDocumentPartitioner(TemplatesViewUtils.getDocumentPartitioning(natureId), documentPartitioner);
                } else {
                    document.setDocumentPartitioner(documentPartitioner);
                }
                document.set(template.getPattern());
                CodeTemplatesView.this.fSourceViewer.setDocument((IDocument)document);
                CodeTemplatesView.this.fSourceViewer.refresh();
            }

            public void mouseDoubleClick(MouseEvent e) {
                CodeTemplatesView.this.insertTemplateAction();
            }
        });
        this.fOptionsMenu = new Menu((Control)this.fTree);
        this.fTree.setMenu(this.fOptionsMenu);
        this.fOptionsMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                CodeTemplatesView.this.fTree.getMenu().setVisible(false);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.fTree.addMenuDetectListener(e -> {
            ITreeSelection selection = (ITreeSelection)this.fTreeViewer.getSelection();
            if (selection == null) {
                e.doit = false;
                return;
            }
            TemplateHierarchy th = (TemplateHierarchy)selection.getFirstElement();
            if (th == null || !th.getType().equals("template")) {
                e.doit = false;
                return;
            }
            e.doit = true;
        });
        this.fInsertMenuItem = new MenuItem(this.fOptionsMenu, 0);
        this.fInsertMenuItem.setText("Insert");
        this.fInsertMenuItem.setImage(DVTImages.imageCache.getImage(DVTImages.INSERT_TEMPLATE));
        this.fInsertMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CodeTemplatesView.this.insertTemplateAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new MenuItem(this.fOptionsMenu, 2);
        this.fNewMenuItem = new MenuItem(this.fOptionsMenu, 0);
        this.fNewMenuItem.setText("New...");
        this.fNewMenuItem.setImage(DVTImages.imageCache.getImage(DVTImages.NEW_TEMPLATE));
        this.fNewMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CodeTemplatesView.this.createNewTemplateAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fEditMenuItem = new MenuItem(this.fOptionsMenu, 0);
        this.fEditMenuItem.setText("Edit...");
        this.fEditMenuItem.setImage(DVTImages.imageCache.getImage(DVTImages.EDIT_TEMPLATE));
        this.fEditMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CodeTemplatesView.this.editTemplateAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fRemoveMenuItem = new MenuItem(this.fOptionsMenu, 0);
        this.fRemoveMenuItem.setText("Remove");
        this.fRemoveMenuItem.setImage(DVTImages.imageCache.getImage(DVTImages.DELETE_TEMPLATE));
        this.fRemoveMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CodeTemplatesView.this.removeTemplateAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new MenuItem(this.fOptionsMenu, 2);
        this.fShowPrefsPageMenuItem = new MenuItem(this.fOptionsMenu, 0);
        this.fShowPrefsPageMenuItem.setText("Open Preference Page...");
        this.fShowPrefsPageMenuItem.setImage(DVTImages.imageCache.getImage(DVTImages.TEMPLATES));
        this.fShowPrefsPageMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection selection = (ITreeSelection)CodeTemplatesView.this.fTreeViewer.getSelection();
                if (selection == null) {
                    return;
                }
                TemplateHierarchy th = (TemplateHierarchy)selection.getFirstElement();
                if (th == null || !th.getType().equals("template")) {
                    return;
                }
                CustomTemplate template = th.getCustomTemplate();
                String projectName = template.getProjectName();
                PreferenceDialog pref = null;
                if (projectName.equals("[global]")) {
                    pref = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"ro.amiq.dvt.ui.codetemplates.TemplatesPreferencePage", null, null);
                } else {
                    template = th.getCustomTemplate();
                    IProject project = template.getProject();
                    if (project == null) {
                        return;
                    }
                    pref = PreferencesUtil.createPropertyDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IAdaptable)project, (String)"ro.amiq.dvt.ui.codetemplates.CodeTemplatesPropertyPage", null, null, (int)0);
                }
                if (pref != null) {
                    pref.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group group = new Group((Composite)this.fSashForm, 0);
        group.setLayout((Layout)new GridLayout());
        Label label = new Label((Composite)group, 0);
        label.setText("Preview:");
        GridData data = new GridData(4, 4, false, false);
        label.setLayoutData((Object)data);
        this.fSourceViewer = new DVTPreviewSourceViewer((Composite)group, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration();
        this.fSourceViewer.configure(configuration);
        this.fSourceViewer.setPreferenceStore(DVTPlugin.getDefault().getCombinedPreferenceStore());
        Document document = new Document();
        this.fSourceViewer.setDocument((IDocument)document);
        this.fSourceViewer.setEditable(false);
        Cursor arrowCursor = this.fSourceViewer.getTextWidget().getDisplay().getSystemCursor(0);
        this.fSourceViewer.getTextWidget().setCursor(arrowCursor);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fSourceViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fSashForm.setWeights(new int[]{20, 10});
        this.createToolbar(parent);
        this.fPartListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                Set<String> allProjectsNamesFromWorkspace = TemplatesViewUtils.getAllProjectsNamesFromWorkspace();
                if (partRef.getId().equals("ro.amiq.dvt.ui.views.templates.CodeTemplatesView") && !allProjectsNamesFromWorkspace.equals(fLastProjectNames)) {
                    fLastProjectNames = allProjectsNamesFromWorkspace;
                    CodeTemplatesView.this.update(null);
                }
            }
        };
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        fLastProjectNames = TemplatesViewUtils.getAllProjectsNamesFromWorkspace();
    }

    protected IEditorPart getActiveEditor() {
        try {
            return this.getSite().getPage().getActiveEditor();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void createToolbar(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        this.fInsertTemplateItem = new InsertTemplate();
        this.fRefreshItem = new Refresh();
        this.fNewTemplateItem = new NewTemplate();
        this.fRemoveTemplateItem = new RemoveTemplate();
        this.fEditTemplateItem = new EditTemplate();
        CollapseAllAction collapseAllAction = new CollapseAllAction();
        ExpandAllAction expandAllAction = new ExpandAllAction();
        tbm.add((IAction)this.fInsertTemplateItem);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fNewTemplateItem);
        tbm.add((IAction)this.fEditTemplateItem);
        tbm.add((IAction)this.fRemoveTemplateItem);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fRefreshItem);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)collapseAllAction);
        tbm.add((IAction)expandAllAction);
    }

    @Override
    public void update(BuildEvents updateEvent) {
        TemplateHierarchy createTemplatesHierarchy = TemplatesViewUtils.createTemplatesHierarchy();
        boolean hasTemplates = createTemplatesHierarchy.hasChildren();
        this.fInsertTemplateItem.setEnabled(hasTemplates);
        this.fRefreshItem.setEnabled(hasTemplates);
        this.fNewTemplateItem.setEnabled(hasTemplates);
        this.fRemoveTemplateItem.setEnabled(hasTemplates);
        this.fEditTemplateItem.setEnabled(hasTemplates);
        if (!hasTemplates) {
            this.fSourceViewer.setDocument((IDocument)new Document());
        }
        this.fTreeViewer.setInput((Object)createTemplatesHierarchy);
        this.fTreeViewer.resetFilters();
        String textFilterText = this.getTextFilterText("default-filter");
        if (!textFilterText.isEmpty()) {
            this.fTreeViewer.addFilter((ViewerFilter)new CustomViewFilter(textFilterText, this.fFilterOptionsCombo.getText()));
        }
        this.fTreeViewer.expandAll();
        this.fTreeViewer.refresh(true);
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.fTreeViewer.refresh(true));
    }

    public void insertTemplateAction() {
        ITreeSelection treeSelection = (ITreeSelection)this.fTreeViewer.getSelection();
        if (treeSelection == null) {
            return;
        }
        TemplateHierarchy th = (TemplateHierarchy)treeSelection.getFirstElement();
        if (th == null || !th.getType().equals("template")) {
            return;
        }
        TemplatesViewUtils.showTemplateProposalInEditor(th.getCustomTemplate());
    }

    public void createNewTemplateAction() {
        EditTemplateDialog editTemplateDialog = new EditTemplateDialog(null);
        CustomTemplate customTemplateEdited = editTemplateDialog.openCustom();
        if (customTemplateEdited == null) {
            return;
        }
        TemplatesViewUtils.addTemplate(customTemplateEdited);
        this.update(null);
    }

    public void editTemplateAction() {
        ITreeSelection selection = (ITreeSelection)this.fTreeViewer.getSelection();
        if (selection == null) {
            return;
        }
        TemplateHierarchy th = (TemplateHierarchy)selection.getFirstElement();
        if (th == null || !th.getType().equals("template")) {
            return;
        }
        CustomTemplate customTemplate = th.getCustomTemplate();
        EditTemplateDialog editTemplateDialog = new EditTemplateDialog(customTemplate);
        CustomTemplate customTemplateEdited = editTemplateDialog.openCustom();
        if (customTemplateEdited == null) {
            return;
        }
        if (customTemplate.equals((Object)customTemplateEdited)) {
            return;
        }
        if (!customTemplate.getName().equals(customTemplateEdited.getName())) {
            MessageDialog md = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "", null, "The name of the template has been changed. Click 'Create new' to create an additionaltemplate with the new name or 'Rename' to rename the existing one.", 0, new String[]{"Rename", "Create new"}, 0);
            int answer = md.open();
            if (answer == 0) {
                TemplatesViewUtils.deleteTemplate(customTemplate);
            }
        } else {
            TemplatesViewUtils.deleteTemplate(customTemplate);
        }
        TemplatesViewUtils.addTemplate(customTemplateEdited);
        this.update(null);
    }

    public void removeTemplateAction() {
        ITreeSelection selection = (ITreeSelection)this.fTreeViewer.getSelection();
        if (selection == null) {
            return;
        }
        TemplateHierarchy th = (TemplateHierarchy)selection.getFirstElement();
        if (th == null || !th.getType().equals("template")) {
            return;
        }
        CustomTemplate customTemplate = th.getCustomTemplate();
        TemplatesViewUtils.deleteTemplate(customTemplate);
        this.update(null);
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return null;
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void clean() {
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public Control getControlToColorBg() {
        return null;
    }

    @Override
    public Control getControlToColorFg() {
        return null;
    }

    class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            super("Collapse All", 1);
            this.setDescription("Collapse All");
            this.setToolTipText("Collapse All");
            this.setImageDescriptor(DVTImages.COLLAPSE_TREE);
        }

        public void run() {
            CodeTemplatesView.this.fTreeViewer.collapseAll();
        }
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            TemplateHierarchy root = (TemplateHierarchy)inputElement;
            if (root.getType().equals("root")) {
                List<TemplateHierarchy> children = root.getChildren();
                Collections.sort(children, fTemplateHierarchyComparator);
                return children.toArray(new TemplateHierarchy[0]);
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            TemplateHierarchy th = (TemplateHierarchy)parentElement;
            List<TemplateHierarchy> children = th.getChildren();
            Collections.sort(children, fTemplateHierarchyComparator);
            return children.toArray(new Object[0]);
        }

        public Object getParent(Object element) {
            TemplateHierarchy th = (TemplateHierarchy)element;
            return th.getParent();
        }

        public boolean hasChildren(Object element) {
            TemplateHierarchy th = (TemplateHierarchy)element;
            return th.hasChildren();
        }
    }

    private class CustomViewFilter
    extends ViewerFilter {
        private StringMatcher fMatcher;
        private String fFilterBy = "name";
        private Set<TemplateHierarchy> fKeep = new HashSet<TemplateHierarchy>();
        private boolean fNoMatch = false;

        public CustomViewFilter(String pattern, String filterBy) {
            this.fMatcher = new StringMatcher("*" + pattern + "*", true, false);
            this.fFilterBy = filterBy.toLowerCase();
            TemplateHierarchy th = (TemplateHierarchy)CodeTemplatesView.this.fTreeViewer.getInput();
            if (th == null) {
                return;
            }
            if (this.fFilterBy.equals("nature")) {
                List<TemplateHierarchy> natures = th.getChildren();
                for (TemplateHierarchy nature : natures) {
                    if (!this.fMatcher.match(nature.getNiceName())) continue;
                    this.fKeep.add(nature);
                    List<TemplateHierarchy> contexts = nature.getChildren();
                    this.fKeep.addAll(contexts);
                    for (TemplateHierarchy context : contexts) {
                        this.fKeep.addAll(context.getChildren());
                    }
                }
            } else if (this.fFilterBy.equals("context")) {
                List<TemplateHierarchy> natures = th.getChildren();
                for (TemplateHierarchy nature : natures) {
                    List<TemplateHierarchy> contexts = nature.getChildren();
                    for (TemplateHierarchy context : contexts) {
                        if (!this.fMatcher.match(context.getNiceName())) continue;
                        this.fKeep.add(nature);
                        this.fKeep.add(context);
                        this.fKeep.addAll(context.getChildren());
                    }
                }
            } else if (this.fFilterBy.equals("name") || this.fFilterBy.equals("description") || this.fFilterBy.equals("project")) {
                List<TemplateHierarchy> natures = th.getChildren();
                for (TemplateHierarchy nature : natures) {
                    List<TemplateHierarchy> contexts = nature.getChildren();
                    for (TemplateHierarchy context : contexts) {
                        List<TemplateHierarchy> templates = context.getChildren();
                        for (TemplateHierarchy template : templates) {
                            if (!(this.fFilterBy.equals("name") && this.fMatcher.match(template.getCustomTemplate().getName()) || this.fFilterBy.equals("description") && this.fMatcher.match(template.getCustomTemplate().getDescription())) && (!this.fFilterBy.equals("project") || !this.fMatcher.match(template.getCustomTemplate().getProjectName()))) continue;
                            this.fKeep.add(template);
                            this.fKeep.add(context);
                            this.fKeep.add(nature);
                        }
                    }
                }
            }
            if (this.fKeep.isEmpty()) {
                this.fNoMatch = true;
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fMatcher == null) {
                return false;
            }
            if (this.fNoMatch) {
                return false;
            }
            return this.fKeep.contains(element);
        }
    }

    class EditTemplate
    extends Action {
        public EditTemplate() {
            super("Edit the Template", 1);
            this.setDescription("Edit the Template");
            this.setToolTipText("Edit the Template");
            this.setImageDescriptor(DVTImages.EDIT_TEMPLATE);
        }

        public void run() {
            CodeTemplatesView.this.editTemplateAction();
        }
    }

    class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            super("Expand All", 1);
            this.setDescription("Expand All");
            this.setToolTipText("Expand All");
            this.setImageDescriptor(DVTImages.EXPAND_TREE);
        }

        public void run() {
            CodeTemplatesView.this.fTreeViewer.expandAll();
        }
    }

    class InsertTemplate
    extends Action {
        public InsertTemplate() {
            super("Insert into Editor", 1);
            this.setDescription("Insert into Editor");
            this.setToolTipText("Insert into Editor");
            this.setImageDescriptor(DVTImages.INSERT_TEMPLATE);
        }

        public void run() {
            CodeTemplatesView.this.insertTemplateAction();
        }
    }

    private static class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                TemplateHierarchy th = (TemplateHierarchy)element;
                if (th.getType().equals("template")) {
                    return DVTImages.imageCache.getImage(DVTImages.TEMPLATE);
                }
                if (th.getType().equals("nature") && th.getName().equals("ro.amiq.edt.enature")) {
                    return DVTImages.imageCache.getImage(DVTImages.E_PERSPECTIVE);
                }
                if (th.getType().equals("nature") && th.getName().equals("ro.amiq.slndt.slnnature")) {
                    return DVTImages.imageCache.getImage(DVTImages.SLN_PERSPECTIVE);
                }
                if (th.getType().equals("nature") && th.getName().equals("ro.amiq.msdldt.msdlnature")) {
                    return DVTImages.imageCache.getImage(DVTImages.SDL_PERSPECTIVE);
                }
                if (th.getType().equals("nature") && th.getName().equals("ro.amiq.pssdt.pssnature")) {
                    return DVTImages.imageCache.getImage(DVTImages.PSS_PERSPECTIVE);
                }
                if (th.getType().equals("nature") && th.getName().equals("ro.amiq.vlogdt.VlogNature")) {
                    return DVTImages.imageCache.getImage(DVTImages.VLOG_PERSPECTIVE);
                }
                if (th.getType().equals("nature") && th.getName().equals("ro.amiq.vhdldt.VhdlNature")) {
                    return DVTImages.imageCache.getImage(DVTImages.VLOG_PERSPECTIVE);
                }
                return DVTImages.imageCache.getImage(DVTImages.TEMPLATE_CATEGORY);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TemplateHierarchy th = (TemplateHierarchy)element;
            if (columnIndex == 0) {
                return th.getNiceName();
            }
            if (columnIndex == 1 && th.getType().equals("template")) {
                return th.getCustomTemplate().getProjectName();
            }
            if (columnIndex == 2 && th.getType().equals("template")) {
                return th.getCustomTemplate().getDescription();
            }
            return "";
        }
    }

    class NewTemplate
    extends Action {
        public NewTemplate() {
            super("Create a New Template", 1);
            this.setDescription("Create a New Template");
            this.setToolTipText("Create a New Template");
            this.setImageDescriptor(DVTImages.NEW_TEMPLATE);
        }

        public void run() {
            CodeTemplatesView.this.createNewTemplateAction();
        }
    }

    class Refresh
    extends Action {
        public Refresh() {
            super("Refresh", 1);
            this.setDescription("Refresh");
            this.setToolTipText("Refresh");
            this.setImageDescriptor(DVTImages.REFRESH);
        }

        public void run() {
            CodeTemplatesView.this.update(null);
        }
    }

    class RemoveTemplate
    extends Action {
        public RemoveTemplate() {
            super("Remove the Template", 1);
            this.setDescription("Remove the Template");
            this.setToolTipText("Remove the Template");
            this.setImageDescriptor(DVTImages.DELETE_TEMPLATE);
        }

        public void run() {
            CodeTemplatesView.this.removeTemplateAction();
        }
    }
}

