/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.templates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.views.templates.CustomTemplate;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtilsCommon;

public class EditTemplateDialog
extends StatusDialog {
    private CustomTemplate fCustomTemplate;
    private Text fNameText;
    private Combo fContextCombo;
    private Button fAutoInsert;
    private Text fDescriptionText;
    private Combo fLocationCombo;
    private DVTPreviewSourceViewer fSourceViewer;
    private Combo fNatureCombo;
    private String fName;
    private String fNiceContextId;
    private boolean fAutoIns;
    private String fDescription;
    private String fLocation;
    private String fSource;
    private String fNature;

    public EditTemplateDialog(CustomTemplate template) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.fCustomTemplate = template;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)new GridLayout(6, false));
        GridData layoutData = new GridData(4, 4, true, true, 6, 1);
        layoutData.widthHint = 800;
        layoutData.heightHint = 600;
        comp.setLayoutData((Object)layoutData);
        Label nameLabel = new Label(comp, 0);
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        nameLabel.setText("Name:");
        this.fNameText = new Text(comp, 2048);
        this.fNameText.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        if (this.fCustomTemplate != null) {
            this.fNameText.setText(this.fCustomTemplate.getName());
        }
        this.fNameText.addModifyListener(e -> {
            boolean bl = this.validate();
        });
        this.fAutoInsert = new Button(comp, 32);
        this.fAutoInsert.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.fAutoInsert.setText("Automatically Insert");
        if (this.fCustomTemplate != null) {
            this.fAutoInsert.setSelection(this.fCustomTemplate.isAutoInsertable());
        }
        Label locationLabel = new Label(comp, 0);
        locationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        locationLabel.setText("Project:");
        this.fLocationCombo = new Combo(comp, 12);
        this.fLocationCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        ArrayList<String> projNames = new ArrayList<String>(TemplatesViewUtils.getAllProjectsNamesFromWorkspace());
        projNames.add(0, "[global]");
        this.fLocationCombo.setItems(projNames.toArray(new String[0]));
        this.fLocationCombo.addModifyListener(e -> {
            if (this.fNatureCombo == null) {
                return;
            }
            String projectName = this.fLocationCombo.getText();
            if (projectName.equals("[global]")) {
                String[] items = new String[]{TemplatesViewUtils.getNatureNiceName("ro.amiq.edt.enature"), TemplatesViewUtils.getNatureNiceName("ro.amiq.slndt.slnnature"), TemplatesViewUtils.getNatureNiceName("ro.amiq.msdldt.msdlnature"), TemplatesViewUtils.getNatureNiceName("ro.amiq.pssdt.pssnature"), TemplatesViewUtils.getNatureNiceName("ro.amiq.vhdldt.VhdlNature"), TemplatesViewUtils.getNatureNiceName("ro.amiq.vlogdt.VlogNature")};
                this.fNatureCombo.setItems(items);
                this.fNatureCombo.setEnabled(true);
                this.fNatureCombo.setText(this.fNatureCombo.getItem(0));
                return;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return;
            }
            List<String> natures = TemplatesViewUtils.getProjectNatures(project);
            ArrayList<String> naturesNames = new ArrayList<String>();
            for (String string : natures) {
                naturesNames.add(TemplatesViewUtils.getNatureNiceName(string));
            }
            this.fNatureCombo.setItems(naturesNames.toArray(new String[0]));
            if (!naturesNames.isEmpty()) {
                this.fNatureCombo.setText(this.fNatureCombo.getItem(0));
            }
            this.fNatureCombo.setEnabled(true);
            this.validate();
        });
        if (this.fCustomTemplate != null) {
            this.fLocationCombo.setText(this.fCustomTemplate.getProjectName());
            this.fLocationCombo.setEnabled(false);
        }
        Label natureLabel = new Label(comp, 0);
        natureLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        natureLabel.setText("Nature:");
        this.fNatureCombo = new Combo(comp, 12);
        this.fNatureCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.fCustomTemplate != null) {
            String niceNatureId = TemplatesViewUtils.getNatureNiceName(TemplatesViewUtilsCommon.getNatureFromContextId(this.fCustomTemplate.getContextTypeId()));
            this.fNatureCombo.add(niceNatureId, 0);
            this.fNatureCombo.setItems(new String[]{niceNatureId});
            this.fNatureCombo.setText(niceNatureId);
            this.fNatureCombo.setEnabled(false);
        }
        this.fNatureCombo.addModifyListener(e -> {
            if (this.fNatureCombo.getText().isEmpty()) {
                return;
            }
            String fullNatureId = TemplatesViewUtils.getNatureFullNameFromNiceName(this.fNatureCombo.getText());
            if (fullNatureId == null || fullNatureId.isEmpty()) {
                return;
            }
            ContextTypeRegistry contextReg = TemplatesViewUtils.getContextTypeRegistry(fullNatureId);
            LinkedList<String> contexts = new LinkedList<String>();
            Iterator contextTypes = contextReg.contextTypes();
            while (contextTypes.hasNext()) {
                TemplateContextType tct = (TemplateContextType)contextTypes.next();
                String str = tct.getId();
                String niceStr = TemplatesViewUtils.getNiceContextId(str);
                contexts.add(niceStr);
            }
            this.fContextCombo.setItems(contexts.toArray(new String[0]));
            this.fContextCombo.setText(this.fContextCombo.getItem(0));
            if (this.fSourceViewer == null) {
                return;
            }
            String natureId = this.fNatureCombo.getText();
            natureId = TemplatesViewUtils.getNatureFullNameFromNiceName(natureId);
            IDocument document = this.fSourceViewer.getDocument();
            this.fSourceViewer.unconfigure();
            SourceViewerConfiguration sourceViewerConfiguration = TemplatesViewUtils.getSourceViewerConfiguration(natureId);
            if (sourceViewerConfiguration == null) {
                return;
            }
            this.fSourceViewer.configure(sourceViewerConfiguration);
            IDocumentPartitioner documentPartitioner = TemplatesViewUtils.getDocumentPartitioner(natureId);
            if (documentPartitioner == null) {
                return;
            }
            documentPartitioner.connect(document);
            document.setDocumentPartitioner(documentPartitioner);
            this.fSourceViewer.setDocument(document);
            this.fSourceViewer.refresh();
            this.validate();
        });
        Label contextLabel = new Label(comp, 0);
        contextLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        contextLabel.setText("Context:");
        this.fContextCombo = new Combo(comp, 12);
        this.fContextCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.fCustomTemplate != null) {
            String natureId = TemplatesViewUtilsCommon.getNatureFromContextId(this.fCustomTemplate.getContextTypeId());
            ContextTypeRegistry contextReg = TemplatesViewUtils.getContextTypeRegistry(natureId);
            LinkedList<String> contexts = new LinkedList<String>();
            Iterator contextTypes = contextReg.contextTypes();
            while (contextTypes.hasNext()) {
                TemplateContextType tct = (TemplateContextType)contextTypes.next();
                String str = tct.getId();
                String niceStr = TemplatesViewUtils.getNiceContextId(str);
                contexts.add(niceStr);
            }
            this.fContextCombo.setItems(contexts.toArray(new String[0]));
            this.fContextCombo.setText(TemplatesViewUtils.getNiceContextId(this.fCustomTemplate.getContextTypeId()));
        }
        Label descLabel = new Label(comp, 0);
        descLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        descLabel.setText("Description:");
        this.fDescriptionText = new Text(comp, 2048);
        this.fDescriptionText.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        if (this.fCustomTemplate != null) {
            this.fDescriptionText.setText(this.fCustomTemplate.getDescription());
        }
        Label patternLabel = new Label(comp, 0);
        patternLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        patternLabel.setText("Pattern:");
        this.fSourceViewer = new DVTPreviewSourceViewer(comp, 2818);
        this.fSourceViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.fSourceViewer.setPreferenceStore(DVTPlugin.getDefault().getCombinedPreferenceStore());
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fSourceViewer.setEditable(true);
        this.fSourceViewer.addTextListener(event -> {
            boolean bl = this.validate();
        });
        if (this.fCustomTemplate == null) {
            SourceViewerConfiguration configuration = new SourceViewerConfiguration();
            this.fSourceViewer.configure(configuration);
            document = new Document();
            this.fSourceViewer.setDocument((IDocument)document);
        } else {
            String natureId = TemplatesViewUtilsCommon.getNatureFromContextId(this.fCustomTemplate.getContextTypeId());
            document = new Document();
            this.fSourceViewer.unconfigure();
            this.fSourceViewer.configure(TemplatesViewUtils.getSourceViewerConfiguration(natureId));
            IDocumentPartitioner documentPartitioner = TemplatesViewUtils.getDocumentPartitioner(natureId);
            documentPartitioner.connect((IDocument)document);
            if (document instanceof IDocumentExtension3) {
                ((IDocumentExtension3)document).setDocumentPartitioner(TemplatesViewUtils.getDocumentPartitioning(natureId), documentPartitioner);
            } else {
                document.setDocumentPartitioner(documentPartitioner);
            }
            document.set(this.fCustomTemplate.getPattern());
            this.fSourceViewer.setDocument((IDocument)document);
            this.fSourceViewer.refresh();
        }
        new Label(comp, 0);
        Button insertVarsButton = new Button(comp, 0);
        insertVarsButton.setLayoutData((Object)new GridData(16384, 4, false, false, 4, 1));
        insertVarsButton.setText("Insert Variables");
        insertVarsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinkedList<String> vars = new LinkedList<String>();
                vars.add("cursor - The cursor position after editing template variables");
                vars.add("date - Current date");
                vars.add("dollar - The dollar symbol");
                vars.add("file_name - File name");
                vars.add("line_selection - The selected lines");
                vars.add("project_name - Project name");
                vars.add("time - Current time");
                vars.add("user - User name");
                vars.add("word_selection - The selected word");
                vars.add("year - Current year");
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(EditTemplateDialog.this.getShell(), (ILabelProvider)new LabelProvider());
                dialog.setTitle("Variable Selection");
                dialog.setMessage("Select a Variable (* = any string, ? = any char):");
                dialog.setElements((Object[])vars.toArray(new String[0]));
                dialog.open();
                String selection = (String)dialog.getFirstResult();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                selection = (selection = selection.split("\\s\\-\\s")[0].trim()).equals("dollar") ? "$$" : "${" + selection + "}";
                StyledText text = EditTemplateDialog.this.fSourceViewer.getTextWidget();
                text.setFocus();
                int offset = text.getCaretOffset();
                IDocument doc = EditTemplateDialog.this.fSourceViewer.getDocument();
                String cont = doc.get();
                String s1 = cont.substring(0, offset);
                String s2 = cont.substring(offset);
                text.setText(String.valueOf(s1) + selection + s2);
                text.setCaretOffset(offset + selection.length());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.fCustomTemplate == null) {
            this.setTitle("New Template");
        } else {
            this.setTitle("Edit Template");
        }
        return comp;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        if (this.validate()) {
            this.fName = this.fNameText.getText();
            this.fAutoIns = this.fAutoInsert.getSelection();
            this.fLocation = this.fLocationCombo.getText();
            this.fNature = this.fNatureCombo.getText();
            this.fNiceContextId = this.fContextCombo.getText();
            this.fDescription = this.fDescriptionText.getText();
            this.fSource = this.fSourceViewer.getDocument().get();
        }
        super.okPressed();
    }

    public CustomTemplate openCustom() {
        super.open();
        if (this.fName == null || this.fName.isEmpty() || this.fLocation.isEmpty() || this.fNature.isEmpty() || this.fNiceContextId.isEmpty()) {
            return null;
        }
        String fullNatureName = TemplatesViewUtils.getNatureFullNameFromNiceName(this.fNature);
        String fullContextId = TemplatesViewUtilsCommon.getFullContextId(fullNatureName, this.fNiceContextId);
        Template template = new Template(this.fName, this.fDescription, fullContextId, this.fSource, this.fAutoIns);
        String location = this.fLocation;
        IProject project = null;
        if (!location.equals("[global]")) {
            project = TemplatesViewUtils.getProject(location);
        }
        if (this.fNameText != null) {
            this.fNameText.dispose();
        }
        if (this.fAutoInsert != null) {
            this.fAutoInsert.dispose();
        }
        if (this.fLocationCombo != null) {
            this.fLocationCombo.dispose();
        }
        if (this.fNatureCombo != null) {
            this.fNatureCombo.dispose();
        }
        if (this.fContextCombo != null) {
            this.fContextCombo.dispose();
        }
        if (this.fDescriptionText != null) {
            this.fDescriptionText.dispose();
        }
        return new CustomTemplate(template, project);
    }

    private boolean validate() {
        block7: {
            if (this.fNameText != null && !this.fNameText.isDisposed() && this.fNameText.getText().isEmpty()) {
                this.updateStatus((IStatus)new Status(4, "DVT", "Template's name must not be empty!"));
                return false;
            }
            if (this.fLocationCombo != null && !this.fLocationCombo.isDisposed() && this.fLocationCombo.getText().isEmpty()) {
                this.updateStatus((IStatus)new Status(4, "DVT", "You must select a project for this template!"));
                return false;
            }
            if (this.fNatureCombo != null && !this.fNatureCombo.isDisposed() && this.fNatureCombo.getText().isEmpty()) {
                this.updateStatus((IStatus)new Status(4, "DVT", "Template's nature must not be empty!"));
                return false;
            }
            if (this.fContextCombo != null && !this.fContextCombo.isDisposed() && this.fContextCombo.getText().isEmpty()) {
                this.updateStatus((IStatus)new Status(4, "DVT", "Template's context must not be empty!"));
                return false;
            }
            TemplateTranslator templateTranslator = new TemplateTranslator();
            try {
                String text = this.fSourceViewer.getTextWidget().getText();
                if (text != null && !text.isEmpty()) {
                    templateTranslator.translate(text);
                }
            }
            catch (TemplateException templateException) {
                if (templateTranslator.getErrorMessage() == null) break block7;
                this.updateStatus((IStatus)new Status(4, "DVT", templateTranslator.getErrorMessage()));
                return false;
            }
        }
        this.updateStatus((IStatus)new Status(0, "DVT", ""));
        return true;
    }
}

