/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.templates;

import java.util.LinkedList;
import java.util.List;
import ro.amiq.dvt.ui.views.templates.CustomTemplate;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;

public class TemplateHierarchy
implements Comparable<Object> {
    public static final String NATURE_TYPE = "nature";
    public static final String CONTEXT_TYPE = "context";
    public static final String TEMPLATE_TYPE = "template";
    public static final String ROOT_TYPE = "root";
    Object fData = null;
    String fType = "";
    TemplateHierarchy fParent = null;
    List<TemplateHierarchy> fChildren = new LinkedList<TemplateHierarchy>();

    public TemplateHierarchy(Object data, String type, TemplateHierarchy parent) {
        this.fData = data;
        this.fType = type;
        this.fParent = parent;
    }

    public List<TemplateHierarchy> getChildren() {
        return this.fChildren;
    }

    public Object getData() {
        return this.fData;
    }

    public String getType() {
        return this.fType;
    }

    public TemplateHierarchy getParent() {
        return this.fParent;
    }

    public String getName() {
        if (this.fType.equals(NATURE_TYPE) || this.fType.equals(CONTEXT_TYPE)) {
            return (String)this.fData;
        }
        return ((CustomTemplate)((Object)this.fData)).getName();
    }

    public String getNiceName() {
        if (this.fType.equals(NATURE_TYPE)) {
            return TemplatesViewUtils.getNatureNiceName((String)this.fData);
        }
        if (this.fType.equals(CONTEXT_TYPE)) {
            return TemplatesViewUtils.getNiceContextId((String)this.fData);
        }
        return ((CustomTemplate)((Object)this.fData)).getName();
    }

    public CustomTemplate getCustomTemplate() {
        if (this.fData instanceof CustomTemplate) {
            return (CustomTemplate)((Object)this.fData);
        }
        return null;
    }

    public void addChild(TemplateHierarchy child) {
        this.fChildren.add(child);
    }

    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateHierarchy)) {
            return false;
        }
        TemplateHierarchy th = (TemplateHierarchy)obj;
        if (th.getType().equals(ROOT_TYPE)) {
            return this.getType().equals(ROOT_TYPE);
        }
        if (th.getType().equals(this.getType()) && th.getName().equals(this.getName())) {
            if (th.getType().equals(NATURE_TYPE)) {
                return true;
            }
            if (th.getType().equals(CONTEXT_TYPE)) {
                return th.getParent().equals(this.getParent());
            }
            CustomTemplate thTemplate = th.getCustomTemplate();
            CustomTemplate template = this.getCustomTemplate();
            return thTemplate.getProjectName().equals(template.getProjectName()) && thTemplate.equals((Object)template);
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
        if (ROOT_TYPE.equals(this.fType)) {
            return result;
        }
        String name = this.getName();
        result = 31 * result + (name == null ? 0 : name.hashCode());
        if (NATURE_TYPE.equals(this.fType)) {
            return result;
        }
        if (CONTEXT_TYPE.equals(this.fType)) {
            result = 31 * result + (this.fParent == null ? 0 : this.fParent.hashCode());
            return result;
        }
        CustomTemplate template = this.getCustomTemplate();
        result = 31 * result + (template == null ? 0 : template.hashCode());
        return result;
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof TemplateHierarchy)) {
            return -1;
        }
        TemplateHierarchy th = (TemplateHierarchy)o;
        if (th.getType().equals(this.getType()) && th.getName().equals(this.getName())) {
            return 0;
        }
        return -1;
    }
}

