/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.templates;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.views.templates.CodeTemplatesView;
import ro.amiq.dvt.ui.views.templates.CustomTemplate;
import ro.amiq.dvt.ui.views.templates.TemplateHierarchy;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtilsCommon;

public class TemplatesViewUtils
extends TemplatesViewUtilsCommon {
    public static final String VLOG_TEMPLATE_CONTEXT_TYPE_ANY = "ro.amiq.vlogdt.templates.contextType.unknown";
    public static final String VLOG_TEMPLATE_CONTEXT_TYPE_STATEMENT = "ro.amiq.vlogdt.templates.contextType.statement";
    public static final String VLOG_TEMPLATE_CONTEXT_TYPE_MEMBER = "ro.amiq.vlogdt.templates.contextType.member";
    public static final String VLOG_TEMPLATE_CONTEXT_TYPE_ACTION = "ro.amiq.vlogdt.templates.contextType.action";
    public static final String VLOG_TEMPLATE_CONTEXT_TYPE_OTHER = "ro.amiq.vlogdt.templates.contextType.other";
    public static final String VLOG_TEMPLATE_CONTEXT_FILE_CONTENT = "ro.amiq.vlogdt.templates.contextType.file_content";
    public static final String VLOG_TEMPLATE_CONTEXT_JAVADOC_COMMENT = "ro.amiq.vlogdt.templates.contextType.javadoc_comment";
    public static final String E_TEMPLATE_CONTEXT_TYPE_ANY = "ro.amiq.edt.templates.contextType.unknown";
    public static final String E_TEMPLATE_CONTEXT_TYPE_STATEMENT = "ro.amiq.edt.templates.contextType.statement";
    public static final String E_TEMPLATE_CONTEXT_TYPE_STRUCT_MEMBER = "ro.amiq.edt.templates.contextType.struct_member";
    public static final String E_TEMPLATE_CONTEXT_TYPE_ACTION = "ro.amiq.edt.templates.contextType.action";
    public static final String E_TEMPLATE_CONTEXT_FILE_CONTENT = "ro.amiq.edt.templates.contextType.file_content";
    public static final String VHDL_TEMPLATE_CONTEXT_TYPE_ANY = "ro.amiq.vhdldt.templates.contextType.unknown";
    public static final String VHDL_TEMPLATE_CONTEXT_TYPE_UNIT = "ro.amiq.vhdldt.templates.contextType.unit";
    public static final String VHDL_TEMPLATE_CONTEXT_TYPE_FILE_CONTENT = "ro.amiq.vhdldt.templates.contextType.file_content";
    public static final String VHDL_TEMPLATE_CONTEXT_TYPE_MEMBER = "ro.amiq.vhdldt.templates.contextType.member";
    public static final String VHDL_TEMPLATE_CONTEXT_TYPE_ACTION = "ro.amiq.vhdldt.templates.contextType.action";
    public static final String PSS_TEMPLATE_CONTEXT_TYPE_ANY = "ro.amiq.pssdt.templates.contextType.unknown";
    public static final String PSS_TEMPLATE_CONTEXT_TYPE_STATEMENT = "ro.amiq.pssdt.templates.contextType.statement";
    public static final String PSS_TEMPLATE_CONTEXT_TYPE_STRUCT_MEMBER = "ro.amiq.pssdt.templates.contextType.struct_member";
    public static final String PSS_TEMPLATE_CONTEXT_TYPE_ACTION = "ro.amiq.pssdt.templates.contextType.action";
    public static final String PSS_TEMPLATE_CONTEXT_FILE_CONTENT = "ro.amiq.pssdt.templates.contextType.file_content";
    public static final String MSDL_TEMPLATE_CONTEXT_TYPE_ANY = "ro.amiq.msdldt.templates.contextType.unknown";
    public static final String MSDL_TEMPLATE_CONTEXT_TYPE_STATEMENT = "ro.amiq.msdldt.templates.contextType.statement";
    public static final String MSDL_TEMPLATE_CONTEXT_TYPE_STRUCT_MEMBER = "ro.amiq.msdldt.templates.contextType.struct_member";
    public static final String MSDL_TEMPLATE_CONTEXT_TYPE_ACTION = "ro.amiq.msdldt.templates.contextType.action";
    public static final String MSDL_TEMPLATE_CONTEXT_FILE_CONTENT = "ro.amiq.msdldt.templates.contextType.file_content";
    public static final Map<String, String> fNaturesFullToNiceNameMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ro.amiq.edt.enature", "e Language");
            this.put("ro.amiq.vlogdt.VlogNature", "SystemVerilog");
            this.put("ro.amiq.vhdldt.VhdlNature", "VHDL");
            this.put("ro.amiq.slndt.slnnature", "SLN");
            this.put("ro.amiq.msdldt.msdlnature", "M-SDL");
            this.put("ro.amiq.pssdt.pssnature", "PSS");
        }
    };
    public static final Map<String, String> fNaturesShortToFullNameMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("edt", "ro.amiq.edt.enature");
            this.put("vlogdt", "ro.amiq.vlogdt.VlogNature");
            this.put("vhdldt", "ro.amiq.vhdldt.VhdlNature");
            this.put("slndt", "ro.amiq.slndt.slnnature");
            this.put("msdldt", "ro.amiq.msdldt.msdlnature");
            this.put("slndt", "ro.amiq.pssdt.pssnature");
        }
    };
    public static final Map<String, String> fNaturesNiceToFullNameMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("e Language", "ro.amiq.edt.enature");
            this.put("SystemVerilog", "ro.amiq.vlogdt.VlogNature");
            this.put("VHDL", "ro.amiq.vhdldt.VhdlNature");
            this.put("SLN", "ro.amiq.slndt.slnnature");
            this.put("M-SDL", "ro.amiq.msdldt.msdlnature");
            this.put("PSS", "ro.amiq.pssdt.pssnature");
        }
    };
    public static final Map<String, String> fNaturesMapShort2Full = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("e Language", "ro.amiq.edt.enature");
            this.put("SystemVerilog", "ro.amiq.vlogdt.VlogNature");
            this.put("VHDL", "ro.amiq.vhdldt.VhdlNature");
            this.put("SLN", "ro.amiq.slndt.slnnature");
            this.put("M-SDL", "ro.amiq.msdldt.msdlnature");
            this.put("PSS", "ro.amiq.pssdt.pssnature");
        }
    };
    private static final Map<String, String> fGlobalTemplatesHandlersMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ro.amiq.edt.enature", "ro.amiq.edt.global.templates");
            this.put("ro.amiq.slndt.slnnature", "ro.amiq.slndt.global.templates");
            this.put("ro.amiq.msdldt.msdlnature", "ro.amiq.msdldt.global.templates");
            this.put("ro.amiq.pssdt.pssnature", "ro.amiq.pssdt.global.templates");
            this.put("ro.amiq.vlogdt.VlogNature", "ro.amiq.vlogdt.global.templates");
            this.put("ro.amiq.vhdldt.VhdlNature", "ro.amiq.vhdldt.global.templates");
        }
    };

    public static TemplateHierarchy createTemplatesHierarchy() {
        Map contexts;
        LinkedList<CustomTemplate> allTemplates = new LinkedList<CustomTemplate>();
        LinkedList<Template> globalTemplates = new LinkedList<Template>();
        List<IProject> allProjects = TemplatesViewUtils.getAllProjectsFromWorkspace();
        HashSet<String> workspaceNatures = new HashSet<String>();
        for (IProject iProject : allProjects) {
            LinkedList projectTemplates = new LinkedList();
            List<String> natures = TemplatesViewUtils.getProjectNatures(iProject);
            workspaceNatures.addAll(natures);
            for (String nature : natures) {
                projectTemplates.addAll(TemplatesViewUtils.getProjectTemplates(iProject, nature));
            }
            Iterator<String> iterator = projectTemplates.iterator();
            while (iterator.hasNext()) {
                Template template = (Template)iterator.next();
                allTemplates.add(new CustomTemplate(template, iProject));
            }
        }
        for (String nature : workspaceNatures) {
            globalTemplates.addAll(TemplatesViewUtils.getGlobalTemplates(nature));
        }
        for (Template template : globalTemplates) {
            allTemplates.add(new CustomTemplate(template, null));
        }
        LinkedHashMap model = new LinkedHashMap();
        for (CustomTemplate customTemplate : allTemplates) {
            String contextId = customTemplate.getContextTypeId();
            String natureId = TemplatesViewUtils.getNatureFromContextId(contextId);
            contexts = null;
            contexts = !model.containsKey(natureId) ? new LinkedHashMap() : (Map)model.get(natureId);
            List templates = null;
            templates = !contexts.containsKey(contextId) ? new ArrayList() : (List)contexts.get(contextId);
            templates.add(customTemplate);
            contexts.put(contextId, templates);
            model.put(natureId, contexts);
        }
        TemplateHierarchy root = new TemplateHierarchy("", "root", null);
        for (Map.Entry entry : model.entrySet()) {
            TemplateHierarchy th = new TemplateHierarchy(entry.getKey(), "nature", root);
            contexts = (Map)entry.getValue();
            for (Map.Entry entry2 : contexts.entrySet()) {
                TemplateHierarchy th2 = new TemplateHierarchy(entry2.getKey(), "context", th);
                List templates = (List)entry2.getValue();
                for (CustomTemplate customTemplate : templates) {
                    TemplateHierarchy th3 = new TemplateHierarchy((Object)customTemplate, "template", th2);
                    th2.addChild(th3);
                }
                th.addChild(th2);
            }
            root.addChild(th);
        }
        return root;
    }

    public static List<String> getProjectNatures(IProject project) {
        ArrayList<String> natures = new ArrayList<String>();
        try {
            if (project.hasNature("ro.amiq.edt.enature")) {
                natures.add("ro.amiq.edt.enature");
            }
            if (project.hasNature("ro.amiq.slndt.slnnature")) {
                natures.add("ro.amiq.slndt.slnnature");
            }
            if (project.hasNature("ro.amiq.msdldt.msdlnature")) {
                natures.add("ro.amiq.msdldt.msdlnature");
            }
            if (project.hasNature("ro.amiq.pssdt.pssnature")) {
                natures.add("ro.amiq.pssdt.pssnature");
            }
            if (project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                natures.add("ro.amiq.vlogdt.VlogNature");
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                natures.add("ro.amiq.vhdldt.VhdlNature");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return natures;
    }

    public static String getNatureNiceName(String fullName) {
        if (fullName.equals("ro.amiq.edt.enature") || fullName.equals("ro.amiq.slndt.slnnature") || fullName.equals("ro.amiq.msdldt.msdlnature") || fullName.equals("ro.amiq.pssdt.pssnature") || fullName.equals("ro.amiq.vlogdt.VlogNature") || fullName.equals("ro.amiq.vhdldt.VhdlNature")) {
            return fNaturesFullToNiceNameMap.get(fullName);
        }
        return "";
    }

    public static String getNatureFullNameFromNiceName(String niceName) {
        if (fNaturesNiceToFullNameMap.containsKey(niceName)) {
            return fNaturesNiceToFullNameMap.get(niceName);
        }
        return "";
    }

    public static String getNatureFullNameFromShortName(String shortName) {
        if (fNaturesShortToFullNameMap.containsKey(shortName)) {
            return fNaturesShortToFullNameMap.get(shortName);
        }
        return "";
    }

    public static List<Template> getGlobalTemplates(String nature) {
        if (!fGlobalTemplatesHandlersMap.containsKey(nature)) {
            return new ArrayList<Template>();
        }
        Template[] templates = new Template[]{};
        TemplateStore templateStore = TemplatesViewUtils.getTemplateStore(null, nature, true);
        if (templateStore == null) {
            return Arrays.asList(templates);
        }
        templates = templateStore.getTemplates();
        return Arrays.asList(templates);
    }

    public static Template getGlobalTemplate(String nature, String templateName) {
        List<Template> templates = TemplatesViewUtils.getGlobalTemplates(nature);
        if (templates == null || templates.isEmpty()) {
            return null;
        }
        for (Template t : templates) {
            if (!t.getName().equals(templateName)) continue;
            return t;
        }
        return null;
    }

    public static TemplateStore getTemplateStore(IProject project, String natureId, boolean isGlobal) {
        if (!fGlobalTemplatesHandlersMap.containsKey(natureId)) {
            return null;
        }
        if (isGlobal) {
            String commandId = fGlobalTemplatesHandlersMap.get(natureId);
            IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null) {
                Object result;
                block6: {
                    IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
                    result = handlerService.executeCommand(commandId, null);
                    if (result instanceof List) break block6;
                    return null;
                }
                try {
                    List list = (List)result;
                    return (TemplateStore)list.get(0);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        return null;
    }

    public static IDocumentPartitioner getDocumentPartitioner(String natureId) {
        if (!fGlobalTemplatesHandlersMap.containsKey(natureId)) {
            return null;
        }
        String commandId = fGlobalTemplatesHandlersMap.get(natureId);
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            Object result;
            block5: {
                IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
                result = handlerService.executeCommand(commandId, null);
                if (result instanceof List) break block5;
                return null;
            }
            try {
                List list = (List)result;
                return (IDocumentPartitioner)list.get(1);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return null;
    }

    public static String getDocumentPartitioning(String natureId) {
        if (natureId.equals("ro.amiq.vlogdt.VlogNature")) {
            return "__vlog_partitioning";
        }
        if (natureId.equals("ro.amiq.edt.enature")) {
            return "__e_partitioning";
        }
        if (natureId.equals("ro.amiq.slndt.slnnature")) {
            return "__e_partitioning";
        }
        if (natureId.equals("ro.amiq.pssdt.pssnature")) {
            return "__pss_partitioning";
        }
        if (natureId.equals("ro.amiq.msdldt.msdlnature")) {
            return "__msdl_partitioning";
        }
        if (natureId.equals("ro.amiq.vhdldt.VhdlNature")) {
            return "__vhdl_partitioning";
        }
        return "";
    }

    public static SourceViewerConfiguration getSourceViewerConfiguration(String natureId) {
        if (!fGlobalTemplatesHandlersMap.containsKey(natureId)) {
            return null;
        }
        String commandId = fGlobalTemplatesHandlersMap.get(natureId);
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            Object result;
            block5: {
                IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
                result = handlerService.executeCommand(commandId, null);
                if (result instanceof List) break block5;
                return null;
            }
            try {
                List list = (List)result;
                return (SourceViewerConfiguration)list.get(2);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return null;
    }

    public static TemplateStore getTemplateStore(CustomTemplate customTemplate) {
        String natureId = TemplatesViewUtils.getNatureFromContextId(customTemplate.getContextTypeId());
        return TemplatesViewUtils.getTemplateStore(customTemplate.getProject(), natureId, customTemplate.isGlobal());
    }

    public static ContextTypeRegistry getContextTypeRegistry(String natureId) {
        ContributionContextTypeRegistry fRegistry = new ContributionContextTypeRegistry();
        if (natureId.equals("ro.amiq.vlogdt.VlogNature")) {
            fRegistry.addContextType(VLOG_TEMPLATE_CONTEXT_TYPE_ANY);
            fRegistry.addContextType(VLOG_TEMPLATE_CONTEXT_TYPE_STATEMENT);
            fRegistry.addContextType(VLOG_TEMPLATE_CONTEXT_TYPE_MEMBER);
            fRegistry.addContextType(VLOG_TEMPLATE_CONTEXT_TYPE_ACTION);
            fRegistry.addContextType(VLOG_TEMPLATE_CONTEXT_TYPE_OTHER);
            fRegistry.addContextType(VLOG_TEMPLATE_CONTEXT_FILE_CONTENT);
            fRegistry.addContextType(VLOG_TEMPLATE_CONTEXT_JAVADOC_COMMENT);
        } else if (natureId.equals("ro.amiq.edt.enature")) {
            fRegistry = new ContributionContextTypeRegistry();
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_TYPE_ANY);
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_TYPE_STATEMENT);
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_TYPE_STRUCT_MEMBER);
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_TYPE_ACTION);
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_FILE_CONTENT);
        } else if (natureId.equals("ro.amiq.slndt.slnnature")) {
            fRegistry = new ContributionContextTypeRegistry();
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_TYPE_ANY);
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_TYPE_STATEMENT);
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_TYPE_STRUCT_MEMBER);
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_TYPE_ACTION);
            fRegistry.addContextType(E_TEMPLATE_CONTEXT_FILE_CONTENT);
        } else if (natureId.equals("ro.amiq.pssdt.pssnature")) {
            fRegistry = new ContributionContextTypeRegistry();
            fRegistry.addContextType(PSS_TEMPLATE_CONTEXT_TYPE_ANY);
            fRegistry.addContextType(PSS_TEMPLATE_CONTEXT_TYPE_STATEMENT);
            fRegistry.addContextType(PSS_TEMPLATE_CONTEXT_TYPE_STRUCT_MEMBER);
            fRegistry.addContextType(PSS_TEMPLATE_CONTEXT_TYPE_ACTION);
            fRegistry.addContextType(PSS_TEMPLATE_CONTEXT_FILE_CONTENT);
        } else if (natureId.equals("ro.amiq.msdldt.msdlnature")) {
            fRegistry = new ContributionContextTypeRegistry();
            fRegistry.addContextType(MSDL_TEMPLATE_CONTEXT_TYPE_ANY);
            fRegistry.addContextType(MSDL_TEMPLATE_CONTEXT_TYPE_STATEMENT);
            fRegistry.addContextType(MSDL_TEMPLATE_CONTEXT_TYPE_STRUCT_MEMBER);
            fRegistry.addContextType(MSDL_TEMPLATE_CONTEXT_TYPE_ACTION);
            fRegistry.addContextType(MSDL_TEMPLATE_CONTEXT_FILE_CONTENT);
        } else if (natureId.equals("ro.amiq.vhdldt.VhdlNature")) {
            fRegistry = new ContributionContextTypeRegistry();
            fRegistry.addContextType(VHDL_TEMPLATE_CONTEXT_TYPE_ANY);
            fRegistry.addContextType(VHDL_TEMPLATE_CONTEXT_TYPE_ACTION);
            fRegistry.addContextType(VHDL_TEMPLATE_CONTEXT_TYPE_MEMBER);
            fRegistry.addContextType(VHDL_TEMPLATE_CONTEXT_TYPE_UNIT);
            fRegistry.addContextType(VHDL_TEMPLATE_CONTEXT_TYPE_FILE_CONTENT);
        }
        return fRegistry;
    }

    public static String getNiceContextId(String contextId) {
        if (!fFullContextIdToNiceContextIdMap.containsKey(contextId)) {
            return "";
        }
        return (String)fFullContextIdToNiceContextIdMap.get(contextId);
    }

    public static List<IProject> getAllProjectsFromWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> openProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isAccessible()) {
                openProjects.add(iProject);
            }
            ++n2;
        }
        return openProjects;
    }

    public static Set<String> getAllProjectsNamesFromWorkspace() {
        List<IProject> projects = TemplatesViewUtils.getAllProjectsFromWorkspace();
        HashSet<String> names = new HashSet<String>();
        for (IProject iProject : projects) {
            if (!iProject.isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(iProject) || !new File(iProject.getLocation().toFile(), ".dvt").exists()) continue;
            names.add(iProject.getName());
        }
        return names;
    }

    public static IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static void addTemplateToStore(CustomTemplate customTemplate) {
        try {
            TemplateStore templateStore = TemplatesViewUtils.getTemplateStore(customTemplate);
            if (templateStore == null) {
                return;
            }
            templateStore.add(new TemplatePersistenceData((Template)customTemplate, true));
            templateStore.save();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void deleteTemplateFromStore(CustomTemplate customTemplate) {
        try {
            TemplateStore templateStore = TemplatesViewUtils.getTemplateStore(customTemplate);
            if (templateStore == null) {
                return;
            }
            TemplatePersistenceData[] tdps = templateStore.getTemplateData(false);
            TemplatePersistenceData tpd = null;
            TemplatePersistenceData[] templatePersistenceDataArray = tdps;
            int n = tdps.length;
            int n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n2];
                if (templatePersistenceData.getTemplate().equals((Object)customTemplate)) {
                    tpd = templatePersistenceData;
                }
                ++n2;
            }
            if (tpd == null) {
                return;
            }
            templateStore.delete(tpd);
            templateStore.save();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static boolean matchingTemplates(Template template1, Template template2) {
        return template1.equals((Object)template2);
    }

    public static void updateTemplatesView() {
        TemplatesViewUtils.updateTemplatesView(0L);
    }

    public static void updateTemplatesView(long delayMillis) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            IViewReference[] refs;
            IViewReference[] iViewReferenceArray = refs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                if (viewReference.getId().equals("ro.amiq.dvt.ui.views.templates.CodeTemplatesView")) {
                    CodeTemplatesView view = (CodeTemplatesView)viewReference.getView(true);
                    try {
                        Thread.sleep(delayMillis);
                    }
                    catch (Exception exception) {}
                    view.update(null);
                }
                ++n2;
            }
        });
    }

    public static boolean showTemplateProposalInEditor(CustomTemplate customTemplate) {
        CustomTemplate customTemplate1;
        DocumentTemplateContext context;
        IDocument document;
        int offset;
        IEditorPart editor;
        block26: {
            IDocumentProvider documentProvider;
            if (customTemplate == null) {
                return false;
            }
            editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor instanceof MultiPageEditorPart) {
                Object selectedPage = ((MultiPageEditorPart)editor).getSelectedPage();
                if (!(selectedPage instanceof AbstractTextEditor)) {
                    return false;
                }
                editor = (AbstractTextEditor)selectedPage;
            }
            if (!(editor instanceof AbstractTextEditor)) {
                return false;
            }
            AbstractTextEditor textEditor = (AbstractTextEditor)editor;
            DVTEditor dvtEditor = textEditor instanceof DVTEditor ? (DVTEditor)editor : null;
            ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
            if (selectionProvider == null) {
                return false;
            }
            ISelection selection = selectionProvider.getSelection();
            if (!(selection instanceof ITextSelection)) {
                return false;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            offset = textSelection.getOffset();
            if (offset == -1) {
                offset = 0;
            }
            if ((documentProvider = textEditor.getDocumentProvider()) == null) {
                return false;
            }
            IEditorInput editorInput = textEditor.getEditorInput();
            if (editorInput == null) {
                return false;
            }
            document = documentProvider.getDocument((Object)editorInput);
            if (document == null) {
                return false;
            }
            try {
                String natureId = TemplatesViewUtilsCommon.getNatureFromContextId(customTemplate.getContextTypeId());
                TemplateContextType contextType = null;
                if (natureId.equals("ro.amiq.vlogdt.VlogNature")) {
                    contextType = TemplatesViewUtils.getContextTypeRegistry(natureId).getContextType(VLOG_TEMPLATE_CONTEXT_FILE_CONTENT);
                } else if (natureId.equals("ro.amiq.edt.enature")) {
                    contextType = TemplatesViewUtils.getContextTypeRegistry(natureId).getContextType(E_TEMPLATE_CONTEXT_FILE_CONTENT);
                } else if (natureId.equals("ro.amiq.slndt.slnnature")) {
                    contextType = TemplatesViewUtils.getContextTypeRegistry(natureId).getContextType(E_TEMPLATE_CONTEXT_FILE_CONTENT);
                } else if (natureId.equals("ro.amiq.msdldt.msdlnature")) {
                    contextType = TemplatesViewUtils.getContextTypeRegistry(natureId).getContextType(MSDL_TEMPLATE_CONTEXT_FILE_CONTENT);
                } else if (natureId.equals("ro.amiq.pssdt.pssnature")) {
                    contextType = TemplatesViewUtils.getContextTypeRegistry(natureId).getContextType(PSS_TEMPLATE_CONTEXT_FILE_CONTENT);
                } else if (natureId.equals("ro.amiq.vhdldt.VhdlNature")) {
                    contextType = TemplatesViewUtils.getContextTypeRegistry(natureId).getContextType(VHDL_TEMPLATE_CONTEXT_TYPE_FILE_CONTENT);
                }
                if (contextType == null) {
                    contextType = new TemplateContextType();
                }
                context = new DocumentTemplateContext(contextType, document, (Position)new DVTPosition(offset));
                String text = document.get(document.getLineOffset(textSelection.getStartLine()), offset - document.getLineOffset(textSelection.getStartLine()));
                String indentText = TemplatesViewUtils.determineOffsetIndent(text);
                customTemplate1 = new CustomTemplate(new Template(customTemplate.getName(), customTemplate.getDescription(), customTemplate.getContextTypeId(), TemplatesViewUtils.indentCodeTemplate(customTemplate.getPattern(), indentText), customTemplate.isAutoInsertable()), customTemplate.getProject());
                if (dvtEditor != null) {
                    String formattedPattern = TemplatesViewUtils.formatReplacementString(() -> dvtEditor.makeSourceViewerConfiguration(), customTemplate1, dvtEditor, offset);
                    customTemplate1.setPattern(formattedPattern);
                }
                if (!customTemplate1.getPattern().isEmpty()) break block26;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        TemplateProposal templateProposal = new TemplateProposal((Template)customTemplate1, (TemplateContext)context, (IRegion)new Region(offset, document.getLength()), null, 0);
        templateProposal.apply(TemplatesViewUtils.getViewer(editor), '\u0000', 0, offset);
        editor.setFocus();
        return true;
    }

    private static ITextViewer getViewer(IEditorPart editor) {
        Object result;
        block5: {
            if (editor instanceof DVTEditor) {
                return ((DVTEditor)editor).getTextViewer();
            }
            if (!(editor instanceof AbstractTextEditor)) {
                return null;
            }
            try {
                Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                getSourceViewerMethod.setAccessible(true);
                result = getSourceViewerMethod.invoke((Object)editor, new Object[0]);
                if (result instanceof ITextViewer) break block5;
                return null;
            }
            catch (Throwable t) {
                DVTLogger.INSTANCE.logError(t);
                return null;
            }
        }
        return (ITextViewer)result;
    }

    private static String indentCodeTemplate(String codeTemplate, String indentText) {
        codeTemplate = codeTemplate.replaceAll("(\r\n|\r|\n)(.)", "$1" + indentText + "$2");
        return codeTemplate;
    }

    public static String determineOffsetIndent(String text) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == '\t') {
                sb.append(ch);
            } else {
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public static String determineOffsetIndentExclusive(String text) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch != '\t' && ch != ' ') break;
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }
}

