/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.templates;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.views.templates.CustomTemplate;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public abstract class TemplatesViewUtilsCommon {
    public static final String GLOBAL_CONTEXT = "[global]";
    public static final Map<String, String> fNaturesFullToShortNameMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ro.amiq.edt.enature", "edt");
            this.put("ro.amiq.vlogdt.VlogNature", "vlogdt");
            this.put("ro.amiq.vhdldt.VhdlNature", "vhdldt");
            this.put("ro.amiq.slndt.slnnature", "slndt");
            this.put("ro.amiq.msdldt.msdlnature", "msdldt");
            this.put("ro.amiq.pssdt.pssnature", "pssdt");
        }
    };
    public static final Map<String, String> fFullContextIdToNiceContextIdMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ro.amiq.vlogdt.templates.contextType.unknown", "Any Context");
            this.put("ro.amiq.vlogdt.templates.contextType.statement", "Statement");
            this.put("ro.amiq.vlogdt.templates.contextType.member", "Class, Module, Program, Interface");
            this.put("ro.amiq.vlogdt.templates.contextType.action", "Action");
            this.put("ro.amiq.vlogdt.templates.contextType.other", "Others");
            this.put("ro.amiq.vlogdt.templates.contextType.file_content", "File Content");
            this.put("ro.amiq.vlogdt.templates.contextType.javadoc_comment", "JavaDoc Comment");
            this.put("ro.amiq.vlogdt.templates.preferencePage.name", "Code Templates");
            this.put("ro.amiq.vhdldt.templates.contextType.unknown", "Any Context");
            this.put("ro.amiq.vhdldt.templates.contextType.unit", "Unit");
            this.put("ro.amiq.vhdldt.templates.contextType.member", "Member");
            this.put("ro.amiq.vhdldt.templates.contextType.action", "Action");
            this.put("ro.amiq.vhdldt.templates.contextType.file_content", "File Content");
            this.put("ro.amiq.edt.templates.contextType.unknown", "Any Context");
            this.put("ro.amiq.edt.templates.contextType.statement", "Statement");
            this.put("ro.amiq.edt.templates.contextType.struct_member", "Struct Member");
            this.put("ro.amiq.edt.templates.contextType.action", "Action");
            this.put("ro.amiq.edt.templates.contextType.file_content", "File Content");
            this.put("ro.amiq.edt.templates.preferencePage.name", "Code Templates");
            this.put("ro.amiq.slndt.templates.contextType.unknown", "Any Context");
            this.put("ro.amiq.slndt.templates.contextType.statement", "Statement");
            this.put("ro.amiq.slndt.templates.contextType.struct_member", "Struct Member");
            this.put("ro.amiq.slndt.templates.contextType.action", "Action");
            this.put("ro.amiq.slndt.templates.contextType.file_content", "File Content");
            this.put("ro.amiq.slndt.templates.preferencePage.name", "Code Templates");
            this.put("ro.amiq.msdldt.templates.contextType.unknown", "Any Context");
            this.put("ro.amiq.msdldt.templates.contextType.statement", "Statement");
            this.put("ro.amiq.msdldt.templates.contextType.struct_member", "Struct Member");
            this.put("ro.amiq.msdldt.templates.contextType.action", "Action");
            this.put("ro.amiq.msdldt.templates.contextType.file_content", "File Content");
            this.put("ro.amiq.msdldt.templates.preferencePage.name", "Code Templates");
            this.put("ro.amiq.pssdt.templates.contextType.unknown", "Any Context");
            this.put("ro.amiq.pssdt.templates.contextType.statement", "Statement");
            this.put("ro.amiq.pssdt.templates.contextType.struct_member", "Struct Member");
            this.put("ro.amiq.pssdt.templates.contextType.action", "Action");
            this.put("ro.amiq.pssdt.templates.contextType.file_content", "File Content");
            this.put("ro.amiq.pssdt.templates.preferencePage.name", "Code Templates");
        }
    };
    public static final Map<String, String> fProjectTemplatesFilesMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ro.amiq.edt.enature", "edt_code_templates.xml");
            this.put("ro.amiq.slndt.slnnature", "slndt_code_templates.xml");
            this.put("ro.amiq.msdldt.msdlnature", "msdldt_code_templates.xml");
            this.put("ro.amiq.pssdt.pssnature", "pssdt_code_templates.xml");
            this.put("ro.amiq.vlogdt.VlogNature", "vlog_code_templates.xml");
            this.put("ro.amiq.vhdldt.VhdlNature", "vhdl_code_templates.xml");
        }
    };

    public static String formatReplacementString(Supplier<DVTSourceViewerConfiguration> createConfig, Template template, DVTEditor viewer, int offset) {
        String pattern = template.getPattern();
        try {
            String replacementString;
            String result;
            IDocument d = viewer.getDocument();
            int line = d.getLineOfOffset(offset);
            String indent = DVTDocumentCommon.getIndentOfLine(d, line, offset);
            if (indent == null) {
                indent = "";
            }
            if ((result = Utils.formatString(createConfig, replacementString = pattern.trim(), d, indent, true)) == null || result.isEmpty()) {
                result = replacementString;
            }
            result = result.trim();
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return pattern;
        }
    }

    public static String getNatureFromLanguageKind(LanguageKind lang) {
        switch (lang) {
            case VHDL: {
                return "ro.amiq.vhdldt.VhdlNature";
            }
            case VLOG: {
                return "ro.amiq.vlogdt.VlogNature";
            }
            case E: {
                return "ro.amiq.edt.enature";
            }
            case SLN: {
                return "ro.amiq.slndt.slnnature";
            }
            case MSDL: {
                return "ro.amiq.msdldt.msdlnature";
            }
            case PSS: {
                return "ro.amiq.pssdt.pssnature";
            }
        }
        return "";
    }

    public static String getFullContextId(String fullNatureId, String niceContextId) {
        String shortName = TemplatesViewUtilsCommon.getNatureShortName(fullNatureId);
        if (shortName.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, String> entry : fFullContextIdToNiceContextIdMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("ro.amiq." + shortName) || !entry.getValue().equals(niceContextId)) continue;
            return key;
        }
        return "";
    }

    public static String getNatureShortName(String fullName) {
        if (fullName.equals("ro.amiq.edt.enature") || fullName.equals("ro.amiq.slndt.slnnature") || fullName.equals("ro.amiq.msdldt.msdlnature") || fullName.equals("ro.amiq.pssdt.pssnature") || fullName.equals("ro.amiq.vlogdt.VlogNature") || fullName.equals("ro.amiq.vhdldt.VhdlNature")) {
            return fNaturesFullToShortNameMap.get(fullName);
        }
        return "";
    }

    public static String getNatureFromContextId(String contextId) {
        if (contextId.startsWith("ro.amiq.edt.templates.contextType")) {
            return "ro.amiq.edt.enature";
        }
        if (contextId.startsWith("ro.amiq.slndt.templates.contextType")) {
            return "ro.amiq.slndt.slnnature";
        }
        if (contextId.startsWith("ro.amiq.msdldt.templates.contextType")) {
            return "ro.amiq.msdldt.msdlnature";
        }
        if (contextId.startsWith("ro.amiq.pssdt.templates.contextType")) {
            return "ro.amiq.pssdt.pssnature";
        }
        if (contextId.startsWith("ro.amiq.vhdldt.templates.contextType")) {
            return "ro.amiq.vhdldt.VhdlNature";
        }
        if (contextId.startsWith("ro.amiq.vlogdt.templates.contextType")) {
            return "ro.amiq.vlogdt.VlogNature";
        }
        return "";
    }

    public static void addTemplate(CustomTemplate customTemplate) {
        IProject project = customTemplate.getProject();
        if (project == null) {
            TemplatesViewUtils.addTemplateToStore(customTemplate);
        } else {
            String natureId = TemplatesViewUtilsCommon.getNatureFromContextId(customTemplate.getContextTypeId());
            List<Template> templates = TemplatesViewUtilsCommon.getProjectTemplates(project, natureId);
            LinkedList<Template> newTemplates = new LinkedList<Template>();
            newTemplates.addAll(templates);
            newTemplates.add(customTemplate);
            String templatesFileShortName = fProjectTemplatesFilesMap.get(natureId);
            ro.amiq.dvt.utils.Utils.setProjectTemplates(project, templatesFileShortName, newTemplates.toArray(new Template[0]));
        }
    }

    public static void deleteTemplate(CustomTemplate customTemplate) {
        IProject project = customTemplate.getProject();
        if (project == null) {
            TemplatesViewUtils.deleteTemplateFromStore(customTemplate);
        } else {
            String natureId = TemplatesViewUtilsCommon.getNatureFromContextId(customTemplate.getContextTypeId());
            List<Template> templates = TemplatesViewUtilsCommon.getProjectTemplates(project, natureId);
            LinkedList<Template> tmp = new LinkedList<Template>();
            for (Template template : templates) {
                if (TemplatesViewUtils.matchingTemplates(template, customTemplate)) continue;
                tmp.add(template);
            }
            ro.amiq.dvt.utils.Utils.setProjectTemplates(project, fProjectTemplatesFilesMap.get(natureId), tmp.toArray(new Template[0]));
        }
    }

    public static List<Template> getProjectTemplates(IProject project, String nature) {
        Template[] projectTemplates = ro.amiq.dvt.utils.Utils.getProjectTemplates(project, fProjectTemplatesFilesMap.get(nature));
        return Arrays.asList(projectTemplates);
    }
}

