/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.trace.connections;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class AbstractTraceConnectionsView
extends AbstractFilteredView {
    protected void setTraceDataForBreadcrumb(Object pathFromNode, IRfNamedElement destination) {
        try {
            if (pathFromNode == null) {
                return;
            }
            this.inhibitNewElabBCUpdate(pathFromNode, destination);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void inhibitNewElabBCUpdate(Object pathFromNode, IRfNamedElement destination) throws CoreException {
        if (!(pathFromNode instanceof ElementPath)) {
            return;
        }
        if (destination == null) {
            return;
        }
        IRfDefElement declaration = destination.getDeclaration();
        if (declaration == null) {
            return;
        }
        IRfFileDef defFile = declaration.getDefFile();
        if (defFile == null) {
            return;
        }
        IFile file = (IFile)defFile.getAdapter(IResource.class);
        if (file == null) {
            return;
        }
        file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
    }

    protected void updatePathManager(Object pathFromNode) {
        if (!(pathFromNode instanceof ElementPath)) {
            return;
        }
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return;
        }
        DesignPathManager.getInstance().updateFor((DVTEditor)activeEditor, (ElementPath)pathFromNode);
    }
}

