/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.trace.connections;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsBatch;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.designhierarchy.DHPortsLabelProvider;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsView;

public class TCPortsLabelProvider
extends DHPortsLabelProvider {
    private TraceConnectionsView view;

    public TCPortsLabelProvider(TraceConnectionsView treeView) {
        if (treeView == null) {
            throw new IllegalArgumentException(String.valueOf(TCPortsLabelProvider.class.getName()) + " requires a " + TraceConnectionsView.class.getName());
        }
        this.view = treeView;
    }

    @Override
    public Color getForeground(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        Object elem = ((IDVTElementWrapper)wrapper).getRfElement();
        if (!(elem instanceof IRfNamedElement)) {
            return null;
        }
        IRfNamedElement hotItem = (IRfNamedElement)elem;
        Display d = Display.getCurrent();
        if (this.view != null && hotItem == this.view.getPortsViewWhyPort() && d != null) {
            return d.getSystemColor(3);
        }
        return null;
    }

    @Override
    public Image getImage(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Image image = super.getImage(wrapper);
        TCNode selectedNode = this.view.getSelectedNode();
        if (selectedNode == null) {
            selectedNode = this.view.getSelectedWhyNode();
        }
        if (selectedNode == null) {
            return image;
        }
        Object element = ((IDVTElementWrapper)wrapper).getRfElement();
        if (!(element instanceof IRfNamedElement)) {
            return image;
        }
        TCViewUtilsBatch.TCEndPointKind endKind = this.view.isEndSignalPoint(TCPathPoint.of(selectedNode, (IRfNamedElement)element, null));
        return TCViewUtils.getEndKindDecoratedImage(image, endKind);
    }

    @Override
    public Color getBackground(Object element) {
        return null;
    }

    @Override
    public Font getFont(Object wrapper, int columnIndex) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        Object element = ((IDVTElementWrapper)wrapper).getRfElement();
        if (!(element instanceof IRfNamedElement)) {
            return null;
        }
        IRfNamedElement hotItem = (IRfNamedElement)element;
        if (this.view != null && hotItem == this.view.getPortsViewWhyPort()) {
            FontRegistry fontRegistry = JFaceResources.getFontRegistry();
            Display current = Display.getCurrent();
            if (fontRegistry != null && current != null) {
                return fontRegistry.getBold(current.getSystemFont().getFontData()[0].getName());
            }
        }
        return super.getFont(wrapper, columnIndex);
    }
}

