/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.trace.connections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTMembersViewContentProvider;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtilsCommon;
import ro.amiq.dvt.ui.views.trace.connections.ITraceConnectionsContributor;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsPortsViewCommon;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsView;
import ro.amiq.dvt.utils.StringMatcher;

public class TraceConnectionsPortsView
extends TraceConnectionsPortsViewCommon {
    private static final String DEFAULT_FILTER_HELPER_TEXT = "Filter by: name";
    private TableViewer table;
    private TCNode selectedNodeElement;
    private final Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap = new IdentityHashMap<IRfInstanceElement, Set<DummyPort>>();
    private StringMatcher portToPromote;
    private IMembersLabelProvider labelProvider;
    private TraceConnectionsView treeView;
    private IRfNamedElement whyPort;
    private AtomicBoolean updateFromFilter = new AtomicBoolean(true);

    private static List<IDVTElementWrapper> getHelpMsg() {
        return new ArrayList<IDVTElementWrapper>(INPUT_TRACE_CONNECTIONS_PORTS_VIEW);
    }

    public TraceConnectionsPortsView(TraceConnectionsView treeView) {
        this.treeView = treeView;
        if (treeView == null) {
            throw new IllegalArgumentException("The signals sub-view should have a non-null tree view");
        }
    }

    public void initAndShow(Composite parent) {
        this.setSite(this.treeView.getSite());
        this.setSelectionChangedListeners(this.treeView.getSelectionChangedListeners());
        this.createPartControl(parent);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", DEFAULT_FILTER_HELPER_TEXT);
        Composite tableComposite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        tableComposite.setLayoutData((Object)compositeGridData);
        tableComposite.setLayout((Layout)new FillLayout(256));
        this.table = new TableViewer(tableComposite, 268436228);
        this.table.setContentProvider((IContentProvider)new DVTMembersViewContentProvider());
        this.labelProvider = this.getViewContributor().getTCPortsLabelProvider(this.treeView);
        this.table.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof Table) {
                    TraceConnectionsPortsView.this.setFocus();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                TraceConnectionsPortsView.this.gotoSelectedElement("default-tree");
            }
        });
        this.getControl().addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.createContextMenu();
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    private void createContextMenu() {
        MenuManager menuMgr = this.installContextMenuAndSelectionListener(this.getControl());
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.activateContext("ro.amiq.dvt.ui.trace.connections.actions.context");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TraceConnectionsPortsView.this.fillContextMenu(manager);
            }
        });
    }

    private void fillContextMenu(IMenuManager mgr) {
        final IRfNamedElement hotItem = this.getSelectedSignal();
        if (hotItem == null) {
            return;
        }
        IContributionItem[] existingActions = mgr.getItems();
        mgr.removeAll();
        mgr.add((IAction)new Action("Show Path", DVTImages.TRACE_SHOW_PATH){

            public void run() {
                TraceConnectionsPortsView.this.treeView.updateWhyView(TraceConnectionsPortsView.this.selectedNodeElement, hotItem);
                TraceConnectionsPortsView.this.whyPort = hotItem;
            }
        });
        IContributionItem[] iContributionItemArray = existingActions;
        int n = existingActions.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem existingAction = iContributionItemArray[n2];
            mgr.add(existingAction);
            ++n2;
        }
    }

    private List<IRfNamedElement> getOrderedPorts() {
        if (this.selectedNodeElement.type != TCNode.TCNodeType.DESIGN && this.selectedNodeElement.type != TCNode.TCNodeType.BLOCK && this.selectedNodeElement.type != TCNode.TCNodeType.INSTANCE) {
            return null;
        }
        List<IRfNamedElement> signals = this.selectedNodeElement.getHotSignals();
        if (signals.isEmpty()) {
            return null;
        }
        Collections.sort(signals, new DHViewUtilsCommon.SignalViewComparator(this.portToPromote, true));
        return signals;
    }

    public void updatePorts(TCNode nodeElement, String portToPromote) {
        this.portToPromote = portToPromote == null ? null : ViewsUtils.createCamelCaseOrRegexMatcher(portToPromote, true, false);
        this.labelProvider.setBoldMatcher(this.portToPromote);
        this.selectedNodeElement = nodeElement;
        this.dummyPortMap.clear();
        this.showFilteredPorts();
    }

    private void showFilteredPorts() {
        boolean noMatchesFound;
        if (this.selectedNodeElement == null) {
            this.cleanView(true);
            return;
        }
        List<IRfNamedElement> elements = this.getOrderedPorts();
        if (elements == null || elements.isEmpty()) {
            this.cleanView(false);
            ObjectionManager.getInstance().clearForMembers(this);
            return;
        }
        StringMatcher stringMatcher = this.getStringMatcher("default-filter");
        List<BasicElementWrapper> shownPorts = new ArrayList();
        for (IRfNamedElement p : elements) {
            BasicElementWrapper bw = new BasicElementWrapper(p);
            if (!ViewsUtils.matchCamelCaseOrRegex(stringMatcher, this.labelProvider.getText(bw))) continue;
            shownPorts.add(bw);
        }
        boolean bl = noMatchesFound = this.isFiltered() && shownPorts.isEmpty();
        if (noMatchesFound) {
            shownPorts = NO_MATCHES_FOUND;
        }
        this.table.setInput(shownPorts);
        this.table.setSelection(null);
        ObjectionManager.getInstance().clearForMembers(this);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IRfNamedElement instanceElement = this.selectedNodeElement == null ? null : this.selectedNodeElement.namedElement;
        Object pathFromNode = IDesignPathProvider.getPathFromTCNode(this.selectedNodeElement);
        IRfNamedElement selectedSignal = this.getSelectedSignal();
        IRfNamedElement destination = selectedSignal instanceof IRfPortElement ? instanceElement : selectedSignal;
        this.setTraceDataForBreadcrumb(pathFromNode, destination);
        DVTRfUtils.goToPortConnectionOrDeclaration(selectedSignal, this.selectedNodeElement, true);
        if (!DesignUtils.isBlock(instanceElement) && selectedSignal instanceof IRfPortElement) {
            pathFromNode = ((ElementPath)pathFromNode).removeLastSegment();
        }
        this.updatePathManager(pathFromNode);
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        if (!this.updateFromFilter.get()) {
            this.updateFromFilter.set(true);
            return;
        }
        this.showFilteredPorts();
        this.table.setSelection(null);
    }

    public Control getControl() {
        return this.table.getControl();
    }

    public void cleanFilter() {
        Text textFilter = this.getTextFilter("default-filter");
        if (this.isFiltered()) {
            this.updateFromFilter.set(false);
            textFilter.setText("");
            textFilter.setMessage(DEFAULT_FILTER_HELPER_TEXT);
            Display d = Display.getCurrent();
            if (d != null) {
                DVTColorUtil.INSTANCE.setBackground((Control)textFilter, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
            }
            this.setFocus();
        }
    }

    public void cleanView(boolean showEmptyMessage) {
        this.selectedNodeElement = null;
        this.whyPort = null;
        this.portToPromote = null;
        this.labelProvider.setBoldMatcher(this.portToPromote);
        this.dummyPortMap.clear();
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return;
        }
        boolean noMatchesFound = this.isFiltered();
        List elements = TraceConnectionsPortsView.getHelpMsg();
        if (!showEmptyMessage) {
            elements = new ArrayList<IDVTElementWrapper>();
        }
        if (noMatchesFound) {
            elements = NO_MATCHES_FOUND;
        }
        this.table.setInput((Object)elements);
        this.table.setSelection(null);
    }

    @Override
    public void dispose() {
        this.cleanView(false);
        super.dispose();
    }

    @Override
    public Tree getTree(String treeId) {
        return null;
    }

    public IRfNamedElement getWhyPort() {
        return this.whyPort;
    }

    public void setWhyPort(IRfNamedElement port) {
        this.whyPort = port;
    }

    @Override
    public IProject getProject() {
        return null;
    }

    private ITraceConnectionsContributor getViewContributor() {
        return DVTViewContributors.getInstance().getViewContributor(LanguageKind.VLOG, ITraceConnectionsContributor.class);
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return null;
    }

    private IRfNamedElement getSelectedSignal() {
        IDVTElementWrapper obj = this.getSelectedWrapper(null);
        if (obj == null) {
            return null;
        }
        Object elem = obj.getRfElement();
        if (!(elem instanceof IRfNamedElement)) {
            return null;
        }
        return (IRfNamedElement)elem;
    }

    @Override
    public IDVTElementWrapper getSelectedWrapper(String treeId) {
        StructuredSelection sel = (StructuredSelection)this.getSelection(treeId);
        if (sel == null || sel.size() != 1) {
            return null;
        }
        Object elem = sel.getFirstElement();
        if (!(elem instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)elem;
    }

    @Override
    public ISelection getSelection(String treeId) {
        return this.getSelection();
    }

    @Override
    public ISelection getSelection() {
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return null;
        }
        return this.table.getSelection();
    }

    @Override
    public void update(BuildEvents updateEvent) {
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void clean() {
    }

    public boolean isFocused() {
        if (this.getControl() == null) {
            return false;
        }
        return this.getControl().isFocusControl();
    }

    public void doTraceOperationAction(TCOperation operation) {
        if (operation == null) {
            return;
        }
        IRfNamedElement hotItem = this.getSelectedSignal();
        if (hotItem == null) {
            return;
        }
        this.whyPort = null;
        this.treeView.internalDoTraceOperationAction(operation, this.selectedNodeElement, hotItem);
    }

    public void testHelpSelectPortInTable(TableItem item) {
        if (this.table == null || this.table.getInput() == null) {
            return;
        }
        Table t = this.table.getTable();
        t.setSelection(item);
        t.showSelection();
        t.notifyListeners(13, (Event)new DVTSyntheticEvent());
    }

    public void testSelectPortInTableByName(String portName) {
        Table t;
        if (this.table == null || this.table.getInput() == null) {
            return;
        }
        List portList = (List)this.table.getInput();
        if (portList.isEmpty()) {
            return;
        }
        Object firstWrapper = portList.get(0);
        if (!(firstWrapper instanceof IDVTElementWrapper)) {
            return;
        }
        Object first = ((IDVTElementWrapper)firstWrapper).getRfElement();
        int i = 0;
        int foundPortIndex = -1;
        if (first instanceof String) {
            i = 0;
            while (i < portList.size()) {
                if (((String)portList.get(i)).equals(portName)) {
                    foundPortIndex = i;
                }
                ++i;
            }
        }
        if (first instanceof IRfPortElement) {
            i = 0;
            while (i < portList.size()) {
                if (((IRfPortElement)portList.get(i)).getName().equals(portName)) {
                    foundPortIndex = i;
                }
                ++i;
            }
        }
        if (foundPortIndex != -1 && (t = this.table.getTable()) != null && !t.isDisposed()) {
            t.setSelection(foundPortIndex);
        }
    }

    public void testHelpSelectPortByName(String portName) {
        this.testSelectPortInTableByName(portName);
    }

    public void testHelpWhyOperationForSelectedPort() {
        IRfNamedElement hotItem;
        this.whyPort = hotItem = this.getSelectedSignal();
        this.treeView.updateWhyView(this.selectedNodeElement, hotItem);
    }

    public boolean testHelpWhySelectionColoring() {
        if (this.table == null || this.table.getInput() == null) {
            return false;
        }
        List portList = (List)this.table.getInput();
        if (portList.isEmpty()) {
            return false;
        }
        Object firstWrapper = portList.get(0);
        if (!(firstWrapper instanceof IDVTElementWrapper)) {
            return false;
        }
        Object first = ((IDVTElementWrapper)firstWrapper).getRfElement();
        if (first instanceof String) {
            return false;
        }
        if (this.whyPort == null) {
            return false;
        }
        Display d = Display.getCurrent();
        return d == null || this.labelProvider.getForeground(new BasicElementWrapper(this.whyPort)).equals((Object)d.getSystemColor(3));
    }

    public boolean testHelpSamePorts() {
        if (this.treeView.testHelpGetSelectedNode() != this.selectedNodeElement) {
            return false;
        }
        String portsRepresentation = "";
        List portList = (List)this.table.getInput();
        int i = 0;
        while (i < portList.size()) {
            Object portWrapper = portList.get(i);
            if (!(portWrapper instanceof IDVTElementWrapper)) {
                return false;
            }
            portsRepresentation = String.valueOf(portsRepresentation) + ((IDVTElementWrapper)portWrapper).getRfElement().toString();
            if (i < portList.size() - 1) {
                portsRepresentation = String.valueOf(portsRepresentation) + ",";
            }
            ++i;
        }
        return this.treeView.testHelpGetPortsForSelectedNode().equals(portsRepresentation);
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public Control getControlToColorBg() {
        return null;
    }

    @Override
    public Control getControlToColorFg() {
        return null;
    }

    @Override
    public IDVTView getParentView() {
        return this.treeView;
    }
}

