/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.trace.connections;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.DVTSelectionChangedEvent;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.CanceledTraceException;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.trace.connections.TCTreeDecorator;
import ro.amiq.dvt.ui.trace.connections.TCViewMessages;
import ro.amiq.dvt.ui.trace.connections.WhyViewElement;
import ro.amiq.dvt.ui.trace.connections.model.TCEndSet;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCNodeSignalPair;
import ro.amiq.dvt.ui.trace.connections.model.TCPathChain;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.model.TCPathRedundance;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;
import ro.amiq.dvt.ui.trace.connections.utils.TCCache;
import ro.amiq.dvt.ui.trace.connections.utils.TCConfiguration;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsBatch;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.PlainElementWrapper;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.trace.connections.ITraceConnectionsContributor;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsPortsView;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsViewCommon;
import ro.amiq.dvt.utils.ElementListSelectionDialog;
import ro.amiq.dvt.utils.FilteredList;
import ro.amiq.dvt.utils.StringMatcher;

public class TraceConnectionsView
extends TraceConnectionsViewCommon
implements IRfFilterableTreeAccessor,
IUpdateJobImpl {
    public static final String WHY_MENU_LABEL = "Show Path";
    public static final String GO_TO_MENU_LABEL = "Go To";
    public static final String TRACE_MENU_LABEL = "Trace";
    public static final String MAIN_TREE_ID = "default-tree";
    public static final String WHY_TREE_ID = "why-tree";
    public static final String WRITERS_HEADER_LABEL = "Writers";
    public static final String READERS_HEADER_LABEL = "Readers";
    private SashForm mainSashForm;
    private SashForm upperSashForm;
    private Composite sashChildTree;
    private Composite sashChildWhy;
    private Composite sashChildPorts;
    private Tree mainTree;
    private Tree whyTree;
    private TreeViewContentProvider mainContentProvider;
    private TreeViewContentProvider whyContentProvider;
    private Action traceShowFullHierarchyAction;
    private Action traceDriveAndLoadAction;
    private Action traceDriveAction;
    private Action traceLoadAction;
    private Action showRootAction;
    private Action showPortsViewAction;
    private Action showDiagramAllAction;
    private Action showDiagramPathAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action reverseOrderAction;
    private Action nextHitAction;
    private Action prevHitAction;
    private Action toggleMainViewContentAction;
    public static final TCOperation[] TOOLBAR_BUTTONS = new TCOperation[]{TCOperation.DRIVE, TCOperation.LOAD, TCOperation.DRIVE_AND_LOAD};
    private ITraceConnectionsContributor currentContributor = this.getViewContributor();
    private TCNode startNode;
    private IRfNamedElement startConn;
    private TCNode startWhyNode;
    private IRfNamedElement startWhyConn;
    private IDVTElementWrapper selectedWhyNodeWrapper;
    private IDVTElementWrapper startWhyNodeWrapper;
    private TCPathChain driveCausedBy = new TCPathChain();
    private TCPathChain loadCausedBy = new TCPathChain();
    private TCPathRedundance driveRedundance = new TCPathRedundance();
    private TCPathRedundance loadRedundance = new TCPathRedundance();
    private IDVTElementWrapper mainElements;
    private List<IDVTElementWrapper> mainElementsAsList;
    private List<IDVTElementWrapper> whyElements;
    private TCEndSet sources;
    private TCEndSet destinations;
    private Label mainLabel;
    private CLabel whyLabel;
    private IMembersLabelProvider cachePortsLabelProvider;
    private ToolBarManager whyToolBarManager;
    private IDVTElementWrapper selectedTreeElement;
    private TraceConnectionsPortsView portsView;
    private AtomicBoolean updateFromFilter = new AtomicBoolean(true);
    private AtomicBoolean forceShowDiagramAll = new AtomicBoolean(false);
    private AtomicBoolean forceDiagramInNewEditor = new AtomicBoolean(false);
    private Set<TCConfiguration> traceConfigs;
    private static final GridLayout ONE_PART_LAYOUT = new GridLayout(1, true);
    private static final GridLayout TWO_PART_LAYOUT;
    private boolean showPortsViewBelow;
    private boolean showPortsView = true;
    private boolean showContentAsList;
    private int[] sashWeights = new int[]{2, 1};
    private UpdateJob mainTreeUpdateJob = new UpdateJob("Update Trace Connections Main Tree", this);
    private int matchCount;
    private boolean shouldCollapseAll;
    private WhyViewImpl whyView = new WhyViewImpl();
    private UpdateJob whyTreeUpdateJob = new UpdateJob("Update Trace Connections Show Path tree", this.whyView);
    private TCOperation whyEndType;

    static {
        TraceConnectionsView.ONE_PART_LAYOUT.marginWidth = 0;
        TraceConnectionsView.ONE_PART_LAYOUT.marginHeight = 0;
        TraceConnectionsView.ONE_PART_LAYOUT.verticalSpacing = 0;
        TWO_PART_LAYOUT = new GridLayout(2, false);
        TraceConnectionsView.TWO_PART_LAYOUT.marginWidth = 0;
        TraceConnectionsView.TWO_PART_LAYOUT.marginHeight = 0;
        TraceConnectionsView.TWO_PART_LAYOUT.verticalSpacing = 0;
    }

    private static List<IDVTElementWrapper> getMainTreeHelpMsg() {
        return new ArrayList<IDVTElementWrapper>(INPUT_TRACE_CONNECTIONS_VIEW);
    }

    private static List<IDVTElementWrapper> getWhyTreeHelpMsg() {
        return new ArrayList<IDVTElementWrapper>(INPUT_TRACE_CONNECTIONS_WHY_VIEW);
    }

    private static List<IDVTElementWrapper> getUpdateMsg() {
        return new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT);
    }

    public Set<TCConfiguration> getTraceConfigs() {
        EnumSet<TCConfiguration> configs = EnumSet.noneOf(TCConfiguration.class);
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("traceconnections.ignoreAlwaysBlocks")) {
            configs.add(TCConfiguration.IGNORE_COMBINATIONAL_ALWAYS_BLOCKS);
        }
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("traceconnections.ignoreNonBlockingAssignments")) {
            configs.add(TCConfiguration.IGNORE_NONBLOCKING_ASSIGNMENTS);
        }
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("traceconnections.ignoreConcurrentAssignments")) {
            configs.add(TCConfiguration.IGNORE_CONTINUOUS_ASSIGNS);
        }
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("traceconnections.ignoreProcesses")) {
            configs.add(TCConfiguration.IGNORE_PROCESSES);
        }
        return configs;
    }

    protected Control getControl() {
        return this.mainTree;
    }

    public void setFocus() {
        if (this.mainTree != null && !this.mainTree.isDisposed()) {
            this.mainTree.setFocus();
        }
    }

    public void setShowPortsViewBelow(boolean showPortsViewBelow) {
        this.showPortsViewBelow = showPortsViewBelow;
        PrefConst.setTCViewShowPortsBelow(showPortsViewBelow);
    }

    public void setShowPortsView(boolean showPortsView) {
        this.showPortsView = showPortsView;
        PrefConst.setTCViewShowPorts(showPortsView);
    }

    public void setShowContentAsList(boolean value) {
        this.showContentAsList = value;
        PrefConst.setTCViewShowContentAsList(value);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        this.showPortsView = PrefConst.getTCViewShowPorts();
        this.showPortsViewBelow = PrefConst.getTCViewShowPortsBelow();
        this.showContentAsList = PrefConst.getTCViewShowContentAsList();
        this.createMainToolbar();
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        parent.setLayout((Layout)ONE_PART_LAYOUT);
        this.mainSashForm = new SashForm(parent, 512);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)this.mainSashForm);
        this.mainSashForm.setLayout((Layout)ONE_PART_LAYOUT);
        this.mainSashForm.setFont(parent.getFont());
        this.mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)this.mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)ONE_PART_LAYOUT);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        this.mainLabel = new Label(fUpperSashFormComposite, 16384);
        this.mainLabel.setFont(this.mainSashForm.getFont());
        this.mainLabel.setLayoutData((Object)new GridData(768));
        this.upperSashForm = new SashForm(fUpperSashFormComposite, this.showPortsViewBelow ? 512 : 256);
        this.upperSashForm.setLayout((Layout)TWO_PART_LAYOUT);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree = new Composite((Composite)this.upperSashForm, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.sashChildTree.setLayout((Layout)layout);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        if (this.showPortsView) {
            this.showPortsView(this.showPortsViewBelow);
        }
        this.createMainTreePart();
        this.createWhyTreePart();
        this.cleanViews();
    }

    private void createMainTreePart() {
        this.createTextFilter("default-filter", this.sashChildTree, MAIN_TREE_ID, true);
        this.setTextFilterFont("default-filter", this.mainSashForm.getFont());
        this.setTextFilterMessage("default-filter", "Filter by: hierarchical name .port");
        Composite traceViewComposite = new Composite(this.sashChildTree, 0);
        traceViewComposite.setLayoutData((Object)new GridData(1808));
        traceViewComposite.setLayout((Layout)new FillLayout(256));
        this.mainTree = new Tree(traceViewComposite, 268436228);
        DVTBaseLabelProvider mainLabelProvider = this.currentContributor.getCustomLabelProvider(this, "trace-connections-label-provider");
        this.mainContentProvider = new TreeViewContentProvider(this.mainTree, mainLabelProvider);
        this.mainTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TraceConnectionsView.this.gotoSelectedElement(TraceConnectionsView.MAIN_TREE_ID);
            }
        });
        this.mainTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", MAIN_TREE_ID));
        this.mainTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TraceConnectionsView.this.mainContentProvider != null && TraceConnectionsView.this.mainTree != null && !TraceConnectionsView.this.mainTree.isDisposed()) {
                    TraceConnectionsView.this.mainContentProvider.setInput(TraceConnectionsView.getMainTreeHelpMsg(), -1);
                }
            }
        });
        this.mainTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TraceConnectionsView.this.hasPortsView()) {
                    IDVTElementWrapper treeElement = TraceConnectionsView.this.getSelectedTreeElement(TraceConnectionsView.this.mainTree);
                    if (treeElement == null) {
                        TraceConnectionsView.this.portsView.cleanView(true);
                        return;
                    }
                    TCNode nodeElement = TraceConnectionsView.this.getSelectedNode();
                    if (nodeElement == null) {
                        return;
                    }
                    TraceConnectionsView.this.portsView.updatePorts(nodeElement, TraceConnectionsView.this.getSearchPort("default-filter"));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mainTree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (TraceConnectionsView.this.mainTree == null || TraceConnectionsView.this.mainTree.isDisposed()) {
                    return;
                }
                if (TraceConnectionsView.this.upperSashForm == null || TraceConnectionsView.this.upperSashForm.isDisposed()) {
                    return;
                }
                TraceConnectionsView.this.mainContentProvider.updateAllLabels(EnumSet.of(TreeViewContentProvider.LabelUpdateKind.TEXT));
            }
        });
        this.createMainTreeMenu();
    }

    private void hidePortsView() {
        this.setShowPortsView(false);
        int[] oldWeights = this.upperSashForm.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.sashWeights = oldWeights;
        }
        if (this.sashChildPorts != null && !this.sashChildPorts.isDisposed()) {
            this.sashChildPorts.dispose();
        }
        this.sashChildPorts = null;
        if (this.hasPortsView()) {
            this.portsView.dispose();
        }
        this.portsView = null;
        this.upperSashForm.setWeights(new int[]{1});
        this.upperSashForm.layout();
    }

    private void showPortsView(boolean below) {
        WhyViewElement selectedWhyElement;
        this.setShowPortsView(true);
        this.setShowPortsViewBelow(below);
        Composite parent = this.upperSashForm.getParent();
        SashForm oldSash = this.upperSashForm;
        int[] oldWeights = oldSash.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.sashWeights = oldWeights;
        }
        this.upperSashForm = new SashForm(parent, this.showPortsViewBelow ? 512 : 256);
        this.upperSashForm.setLayout((Layout)TWO_PART_LAYOUT);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree.setParent((Composite)this.upperSashForm);
        if (this.sashChildPorts == null) {
            this.sashChildPorts = new Composite((Composite)this.upperSashForm, 0);
            this.sashChildPorts.setLayout((Layout)ONE_PART_LAYOUT);
            this.sashChildPorts.setFont(this.mainSashForm.getFont());
            this.sashChildPorts.setLayoutData((Object)new GridData(1808));
            this.portsView = new TraceConnectionsPortsView(this);
            this.portsView.initAndShow(this.sashChildPorts);
            this.sashChildPorts.layout();
            this.upperSashForm.setWeights(this.sashWeights);
        } else {
            this.sashChildPorts.setParent((Composite)this.upperSashForm);
        }
        oldSash.dispose();
        parent.layout();
        TCNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            selectedNode = this.getSelectedWhyNode();
        }
        if (this.whyElements != null && (selectedWhyElement = this.getSelectedWhyElement()) != null) {
            this.portsView.setWhyPort(selectedWhyElement.point.signal);
        }
        this.portsView.updatePorts(selectedNode, this.getSearchPort("default-filter"));
    }

    public Control getUpperSash() {
        return this.upperSashForm != null ? this.upperSashForm : null;
    }

    private void createWhyTreePart() {
        this.sashChildWhy = new Composite((Composite)this.mainSashForm, 0);
        this.sashChildWhy.setLayout((Layout)ONE_PART_LAYOUT);
        this.sashChildWhy.setLayoutData((Object)new GridData(1808));
        this.createWhyToolbar();
        Composite tableComposite = new Composite(this.sashChildWhy, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        tableComposite.setLayout((Layout)new FillLayout(256));
        this.whyTree = new Tree(tableComposite, 268436228);
        this.whyContentProvider = new TreeViewContentProvider(this.whyTree, this.currentContributor.getCustomLabelProvider(null, "why-view-label-provider"));
        this.whyTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TraceConnectionsView.this.goToSelectedWhyItem(true);
            }
        });
        this.whyTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TraceConnectionsView.this.goToSelectedWhyItem(true);
                } else if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 46) {
                    TraceConnectionsView.this.nextHitAction.run();
                } else if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 44) {
                    TraceConnectionsView.this.prevHitAction.run();
                } else if (e.keyCode == 0x1000002) {
                    TraceConnectionsView.this.nextWhyTreeHit(1);
                } else if (e.keyCode == 0x1000001) {
                    TraceConnectionsView.this.nextWhyTreeHit(-1);
                }
                e.doit = false;
            }
        });
        this.whyTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TraceConnectionsView.this.whyContentProvider != null && TraceConnectionsView.this.whyTree != null && !TraceConnectionsView.this.whyTree.isDisposed()) {
                    TraceConnectionsView.this.whyContentProvider.setInput(TraceConnectionsView.getWhyTreeHelpMsg(), -1);
                }
            }
        });
        this.whyTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TraceConnectionsView.this.showContentAsList) {
                    return;
                }
                WhyViewElement element = TraceConnectionsView.this.getSelectedWhyElement();
                if (element == null) {
                    return;
                }
                TraceConnectionsView.this.markSelectedWhyNodeInMainTree(null);
                if (TraceConnectionsView.this.mainElements != null) {
                    TraceConnectionsView.this.markSelectedWhyNodeInMainTree(element.point.node);
                }
                if (TraceConnectionsView.this.selectedTreeElement != null) {
                    TraceConnectionsView.this.selectedTreeElement.setSelectedElement(null);
                }
                TraceConnectionsView.this.clearTreeSelection(TraceConnectionsView.this.mainTree);
                if (TraceConnectionsView.this.hasPortsView()) {
                    if (TraceConnectionsView.this.selectedWhyNodeWrapper != null) {
                        TraceConnectionsView.this.portsView.setWhyPort(element.point.signal);
                        TraceConnectionsView.this.portsView.updatePorts(element.point.node, TraceConnectionsView.this.getSearchPort("default-filter"));
                    } else {
                        TraceConnectionsView.this.portsView.cleanView(true);
                    }
                }
                TraceConnectionsView.this.fireSelectionChanged(new DVTSelectionChangedEvent(TraceConnectionsView.this, (ISelection)new StructuredSelection((Object)TraceConnectionsView.this.getSelectedTreeElement(TraceConnectionsView.this.whyTree)), null));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createMainTreeMenu() {
        MenuManager menuMgr = this.installContextMenuAndSelectionListener((Control)this.mainTree);
        if (this.showContentAsList) {
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            contextService.activateContext("ro.amiq.dvt.ui.trace.connections.actions.context");
        }
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (TraceConnectionsView.this.showContentAsList) {
                    TraceConnectionsView.this.fillMainListMenu(manager);
                }
            }
        });
    }

    public void updateWhyView(TCNode node, IRfNamedElement hotItem) {
        this.startWhyNode = node;
        this.startWhyConn = hotItem;
        this.whyElements = null;
        this.cleanWhyView(this.startWhyNode != null && this.startWhyConn != null);
        this.whyTreeUpdateJob.cancel();
        this.whyTreeUpdateJob.schedule();
    }

    private void cleanWhyView(final boolean showUpdateMsg) {
        Utils.safeRunSynchInUIThread(new Runnable(){

            @Override
            public void run() {
                TraceConnectionsView.this.nextHitAction.setEnabled(false);
                TraceConnectionsView.this.prevHitAction.setEnabled(false);
                TraceConnectionsView.this.showDiagramPathAction.setEnabled(false);
                TraceConnectionsView.this.reverseOrderAction.setEnabled(false);
                TraceConnectionsView.this.reverseOrderAction.setChecked(false);
                if (TraceConnectionsView.this.whyLabel != null && !TraceConnectionsView.this.whyLabel.isDisposed()) {
                    TraceConnectionsView.this.whyLabel.setText("");
                }
                if (TraceConnectionsView.this.whyContentProvider != null && TraceConnectionsView.this.whyTree != null && !TraceConnectionsView.this.whyTree.isDisposed()) {
                    TraceConnectionsView.this.whyContentProvider.setInput(showUpdateMsg ? TraceConnectionsView.getUpdateMsg() : TraceConnectionsView.getWhyTreeHelpMsg(), -1);
                }
                if (TraceConnectionsView.this.startWhyNodeWrapper != null && TraceConnectionsView.this.selectedWhyNodeWrapper != null) {
                    TraceConnectionsView.this.markSelectedWhyNodeInMainTree(null);
                    TraceConnectionsView.this.markStartWhyNodeInMainTree(null);
                    TraceConnectionsView.this.mainTree.update();
                }
                if (TraceConnectionsView.this.hasPortsView()) {
                    TraceConnectionsView.this.portsView.setWhyPort(null);
                }
            }
        });
    }

    public boolean addSignalsToContextMenu(Set<IRfPortElement> hotPorts, Set<IRfNamedElement> hotFields, final TCNode selectedNode, final TCOperation toolbarBtn, MenuManager subMenu, final ContextMenuType menuType) {
        int nrSignals;
        if (hotPorts == null || selectedNode == null) {
            return false;
        }
        int nrPorts = hotPorts.size();
        int n = nrSignals = hotFields == null ? 0 : hotFields.size();
        if (nrPorts + nrSignals <= 20) {
            IRfSingleLangProject rfProject = selectedNode.namedElement.getRfProject();
            if (rfProject == null) {
                return false;
            }
            ArrayList<IRfPortElement> sortedPorts = new ArrayList<IRfPortElement>(hotPorts);
            IMembersLabelProvider plp = this.internalGetPortsLabelProvider();
            Collections.sort(sortedPorts, DesignUtils.SIGNAL_COMPARATOR);
            for (final IRfNamedElement iRfNamedElement : sortedPorts) {
                BasicElementWrapper bw = new BasicElementWrapper(iRfNamedElement);
                subMenu.add((IAction)new Action(plp.getText(bw), ImageDescriptor.createFromImage((Image)plp.getImage(bw))){

                    public void run() {
                        switch (menuType) {
                            case WHY_MENU: {
                                TraceConnectionsView.this.updateWhyView(selectedNode, iRfNamedElement);
                                break;
                            }
                            case GO_TO_MENU: {
                                DVTRfUtils.goToPortConnectionOrDeclaration(iRfNamedElement, selectedNode, true);
                                break;
                            }
                            case TRACE_MENU: {
                                TraceConnectionsView.this.startNode = selectedNode;
                                TraceConnectionsView.this.startConn = iRfNamedElement;
                                TraceConnectionsView.this.clickToolbarBtn(toolbarBtn);
                                break;
                            }
                        }
                    }
                });
            }
            if (subMenu.getItems().length > 0 && selectedNode.hasHotFields()) {
                subMenu.add((IContributionItem)new Separator());
            }
            ArrayList<IRfNamedElement> arrayList = new ArrayList<IRfNamedElement>(hotFields);
            Collections.sort(arrayList, DesignUtils.SIGNAL_COMPARATOR);
            for (final IRfNamedElement field : arrayList) {
                BasicElementWrapper bw = new BasicElementWrapper(field);
                subMenu.add((IAction)new Action(plp.getText(bw), ImageDescriptor.createFromImage((Image)plp.getImage(bw))){

                    public void run() {
                        switch (menuType) {
                            case WHY_MENU: {
                                TraceConnectionsView.this.updateWhyView(selectedNode, field);
                                break;
                            }
                            case GO_TO_MENU: {
                                DVTRfUtils.goToDeclaration(field, true);
                                break;
                            }
                            case TRACE_MENU: {
                                TraceConnectionsView.this.startNode = selectedNode;
                                TraceConnectionsView.this.startConn = field;
                                TraceConnectionsView.this.clickToolbarBtn(toolbarBtn);
                            }
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private void showContextMenuDialog(List<IRfNamedElement> signals, TCNode selectedNode, TCOperation toolbarBtn, ContextMenuType menuType) {
        if (signals == null) {
            return;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.internalGetPortsLabelProvider()){

            @Override
            protected FilteredList createFilteredList(Composite parent2) {
                FilteredList list = super.createFilteredList(parent2);
                list.setFilterMatcher(new FilteredList.FilterMatcher(){
                    private StringMatcher fLocalMatcher;

                    @Override
                    public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                        this.fLocalMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(pattern, ignoreCase, ignoreWildCards);
                    }

                    @Override
                    public boolean match(Object element) {
                        return ViewsUtils.matchCamelCaseOrRegex(this.fLocalMatcher, fFilteredList.getLabelProvider().getText(element));
                    }
                });
                return list;
            }
        };
        String title = "Select Signal";
        String message = "Select signal:";
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setMultipleSelection(false);
        dialog.setHelpAvailable(false);
        Collections.sort(signals, DesignUtils.SIGNAL_COMPARATOR);
        ArrayList<PlainElementWrapper> wrappers = new ArrayList<PlainElementWrapper>(signals.size());
        for (IRfNamedElement item : signals) {
            wrappers.add(PlainElementWrapper.of(item));
        }
        dialog.setElements(wrappers.toArray());
        if (dialog.open() == 0) {
            Object firstObj = dialog.getFirstResult();
            if (!(firstObj instanceof IDVTElementWrapper)) {
                return;
            }
            if (!(((IDVTElementWrapper)firstObj).getRfElement() instanceof IRfNamedElement)) {
                return;
            }
            IRfSingleLangProject rfProject = selectedNode.namedElement.getRfProject();
            if (rfProject == null) {
                return;
            }
            IRfNamedElement signal = (IRfNamedElement)((IDVTElementWrapper)firstObj).getRfElement();
            switch (menuType) {
                case WHY_MENU: {
                    this.updateWhyView(selectedNode, signal);
                    break;
                }
                case GO_TO_MENU: {
                    DVTRfUtils.goToPortConnectionOrDeclaration(signal, selectedNode, true);
                    break;
                }
                case TRACE_MENU: {
                    this.startNode = selectedNode;
                    this.startConn = signal;
                    this.clickToolbarBtn(toolbarBtn);
                    break;
                }
            }
        }
    }

    private void markWhyPathDecorations(List<IDVTElementWrapper> whyElements) {
        if (this.showContentAsList) {
            return;
        }
        HashSet<TCNode> whyViewNodes = null;
        if (whyElements != null) {
            whyViewNodes = new HashSet<TCNode>();
            for (IDVTElementWrapper element : whyElements) {
                WhyViewElement whyElement = TCViewUtils.getWhyViewElementFromWrapper(element);
                if (whyElement == null || whyViewNodes.contains(whyElement.point.node)) continue;
                whyViewNodes.add(whyElement.point.node);
            }
        }
        final ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        this.visitAndMarkWhyDecorations(this.mainElements, elements, whyViewNodes);
        Utils.safeRunAsynchInUIThread(new Runnable(){

            @Override
            public void run() {
                TCTreeDecorator.refresh(elements.toArray());
            }
        });
    }

    private void fillMainListMenu(IMenuManager mgr) {
        final TCNodeSignalPair nodeSignalPair = this.getSelectedNodeSignalPair();
        if (nodeSignalPair == null) {
            return;
        }
        IContributionItem[] existingActions = mgr.getItems();
        mgr.removeAll();
        mgr.add((IAction)new Action(WHY_MENU_LABEL, DVTImages.TRACE_SHOW_PATH){

            public void run() {
                TraceConnectionsView.this.updateWhyView(nodeSignalPair.node, nodeSignalPair.hotSignal);
            }
        });
        IContributionItem[] iContributionItemArray = existingActions;
        int n = existingActions.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem existingAction = iContributionItemArray[n2];
            mgr.add(existingAction);
            ++n2;
        }
    }

    @Deprecated
    private void fillMainTreeMenu(IMenuManager mgr) {
        final TCNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (!node.hasHotSignals()) {
            return;
        }
        String whyMenuLabel = WHY_MENU_LABEL;
        String goToMenuLabel = GO_TO_MENU_LABEL;
        String traceMenulabel = TRACE_MENU_LABEL;
        if (node.type == TCNode.TCNodeType.DESIGN || node.type == TCNode.TCNodeType.INSTANCE || node.type == TCNode.TCNodeType.BLOCK) {
            MenuManager subMenuGoTo;
            MenuManager subMenuWhy;
            final List<IRfNamedElement> hotSignals = node.getHotSignals();
            int hotItemCount = hotSignals.size();
            Set<IRfPortElement> hotPorts = node.getHotPorts();
            Set<IRfNamedElement> hotFields = node.getHotFields();
            if (hotItemCount > 20) {
                whyMenuLabel = String.valueOf(whyMenuLabel) + "...";
                mgr.add((IAction)new Action(whyMenuLabel, DVTImages.TRACE_SHOW_PATH){

                    public void run() {
                        TraceConnectionsView.this.showContextMenuDialog(hotSignals, node, null, ContextMenuType.WHY_MENU);
                    }
                });
            } else if (hotItemCount > 0 && this.addSignalsToContextMenu(hotPorts, hotFields, node, null, subMenuWhy = new MenuManager(whyMenuLabel, DVTImages.TRACE_SHOW_PATH, null), ContextMenuType.WHY_MENU)) {
                mgr.add((IContributionItem)subMenuWhy);
            }
            if (hotItemCount > 20) {
                goToMenuLabel = String.valueOf(goToMenuLabel) + "...";
                mgr.add((IAction)new Action(goToMenuLabel){

                    public void run() {
                        TraceConnectionsView.this.showContextMenuDialog(hotSignals, node, null, ContextMenuType.GO_TO_MENU);
                    }
                });
            } else if (hotItemCount > 0 && this.addSignalsToContextMenu(hotPorts, hotFields, node, null, subMenuGoTo = new MenuManager(goToMenuLabel), ContextMenuType.GO_TO_MENU)) {
                mgr.add((IContributionItem)subMenuGoTo);
            }
            MenuManager subMenuTrace = new MenuManager(traceMenulabel);
            mgr.add((IContributionItem)subMenuTrace);
            this.addTraceSubMenuToSignal(node, hotSignals, hotItemCount, hotPorts, hotFields, subMenuTrace, TCOperation.DRIVE);
            this.addTraceSubMenuToSignal(node, hotSignals, hotItemCount, hotPorts, hotFields, subMenuTrace, TCOperation.LOAD);
            this.addTraceSubMenuToSignal(node, hotSignals, hotItemCount, hotPorts, hotFields, subMenuTrace, TCOperation.DRIVE_AND_LOAD);
        }
    }

    private void addTraceSubMenuToSignal(final TCNode node, final List<IRfNamedElement> hotSignals, int hotItemCount, Set<IRfPortElement> hotPorts, Set<IRfNamedElement> hotFields, MenuManager subMenuTrace, final TCOperation toolbarBtn) {
        MenuManager subSubMenuTrace;
        String traceOperationLabel = TCViewUtils.getTraceTextFromOperation(toolbarBtn);
        if (hotItemCount > 20) {
            traceOperationLabel = String.valueOf(traceOperationLabel) + " ...";
            subMenuTrace.add((IAction)new Action(traceOperationLabel, TCViewUtils.getImageForTraceOperation(toolbarBtn)){

                public void run() {
                    TraceConnectionsView.this.showContextMenuDialog(hotSignals, node, toolbarBtn, ContextMenuType.TRACE_MENU);
                }
            });
        } else if (hotItemCount > 0 && this.addSignalsToContextMenu(hotPorts, hotFields, node, toolbarBtn, subSubMenuTrace = new MenuManager(TCViewUtils.getTraceTextFromOperation(toolbarBtn), TCViewUtils.getImageForTraceOperation(toolbarBtn), null), ContextMenuType.TRACE_MENU)) {
            subMenuTrace.add((IContributionItem)subSubMenuTrace);
        }
    }

    protected void selectWhyPathElement(int index, boolean excludeWritersOrReaders) {
        if (this.whyElements == null || this.whyTree == null || this.whyTree.isDisposed()) {
            return;
        }
        Utils.safeRunAsynchInUIThread(new Runnable(){

            @Override
            public void run() {
                TraceConnectionsView.this.whyTree.setFocus();
            }
        });
        List<IDVTElementWrapper> flatten = this.flattenOneLevelWhyElements();
        for (IDVTElementWrapper wrapper : flatten) {
            WhyViewElement element = TCViewUtils.getWhyViewElementFromWrapper(wrapper);
            if (element == null || excludeWritersOrReaders && (element.kind == TCStatement.TCStatementKind.WRITER || element.kind == TCStatement.TCStatementKind.READER) || index-- != 0) continue;
            wrapper.setSelectedElement(wrapper);
            if (wrapper.getItem() instanceof TreeItem) {
                this.whyTree.setSelection((TreeItem)wrapper.getItem());
                this.whyTree.showSelection();
                this.whyTree.notifyListeners(13, (Event)new DVTSyntheticEvent());
            }
            return;
        }
    }

    private List<IDVTElementWrapper> flattenOneLevelWhyElements() {
        if (this.whyElements == null) {
            return null;
        }
        ArrayList<IDVTElementWrapper> flatten = new ArrayList<IDVTElementWrapper>(this.whyElements.size());
        for (IDVTElementWrapper wrapper : this.whyElements) {
            List children;
            if (wrapper == null) continue;
            flatten.add(wrapper);
            if (!this.isWhyTreeWriterOrReaderHeader(wrapper) || (children = wrapper.getChildren()) == null || children.isEmpty()) continue;
            flatten.addAll(children);
        }
        return flatten;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        if (treeId.equals(WHY_TREE_ID)) {
            return this.whyElements;
        }
        return this.mainElements;
    }

    private void startTraceJobForAction(final ActionType type) {
        if (!TCViewUtils.shouldContinueWithTraceOperation(TCViewUtils.TraceMessageDialogType.INFORMATION)) {
            return;
        }
        if (this.startNode == null) {
            ObjectionManager.getInstance().clear(Objection.TRACE_VIEW);
            return;
        }
        WorkspaceJob job = new WorkspaceJob(TCViewMessages.fJobText){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", -1);
                try {
                    switch (type) {
                        case TRACE_SHOW_FULL_HIERARCHY: 
                        case SHOW_ROOT: 
                        case SHOW_CONTENT_AS_LIST: 
                        case EXPAND_ALL: {
                            Utils.safeRunSynchInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    (this).TraceConnectionsView.this.updateFromFilter.set(true);
                                    TraceConnectionsView.this.stringMatcherUpdated("default-filter");
                                }
                            });
                            break;
                        }
                        case COLLAPSE_ALL: {
                            Utils.safeRunSynchInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    (this).TraceConnectionsView.this.updateFromFilter.set(true);
                                    (this).TraceConnectionsView.this.shouldCollapseAll = true;
                                    TraceConnectionsView.this.stringMatcherUpdated("default-filter");
                                }
                            });
                            break;
                        }
                        case TRACE_DRIVE_AND_LOAD: 
                        case TRACE_DRIVE: 
                        case TRACE_LOAD: {
                            TraceConnectionsView.this.forceShowDiagramAll.set(DVTPlugin.getDefault().getPreferenceStore().getBoolean("traceconnections.linkWithTraceDiagram"));
                            TraceConnectionsView.this.forceDiagramInNewEditor.set(false);
                            TraceConnectionsView.this.updateTraceView(monitor);
                            break;
                        }
                    }
                }
                catch (CanceledTraceException canceledTraceException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)this.getProject());
        job.schedule(0L);
    }

    private void createMainToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.showRootAction = new Action(TCViewMessages.fTraceShowRootText, 2){

            public void run() {
                TraceConnectionsView.this.startTraceJobForAction(ActionType.SHOW_ROOT);
            }
        };
        this.showRootAction.setImageDescriptor(DVTImages.TRACE_SHOW_ROOT);
        this.showRootAction.setEnabled(!this.showContentAsList);
        this.showRootAction.setChecked(true);
        this.traceShowFullHierarchyAction = new Action(TCViewMessages.fTraceShowFullHierarchyText, 2){

            public void run() {
                TraceConnectionsView.this.showRootAction.setEnabled(!TraceConnectionsView.this.showRootAction.isEnabled());
                TraceConnectionsView.this.startTraceJobForAction(ActionType.TRACE_SHOW_FULL_HIERARCHY);
            }
        };
        this.traceShowFullHierarchyAction.setImageDescriptor(DVTImages.TRACE_IN_FULL_HIERARCHY);
        this.traceShowFullHierarchyAction.setEnabled(!this.showContentAsList);
        this.traceDriveAndLoadAction = new Action(TCViewMessages.fTraceDriveAndLoadText, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TraceConnectionsView.this.startTraceJobForAction(ActionType.TRACE_DRIVE_AND_LOAD);
            }
        };
        this.traceDriveAndLoadAction.setImageDescriptor(DVTImages.TRACE_DRIVE_AND_LOAD);
        this.traceDriveAndLoadAction.setChecked(true);
        this.traceDriveAction = new Action(TCViewMessages.fTraceDriveText, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TraceConnectionsView.this.startTraceJobForAction(ActionType.TRACE_DRIVE);
            }
        };
        this.traceDriveAction.setImageDescriptor(DVTImages.TRACE_DRIVE);
        this.traceLoadAction = new Action(TCViewMessages.fTraceLoadText, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TraceConnectionsView.this.startTraceJobForAction(ActionType.TRACE_LOAD);
            }
        };
        this.traceLoadAction.setImageDescriptor(DVTImages.TRACE_LOAD);
        this.expandAllAction = new Action(TCViewMessages.fTraceExpandAllText, 1){

            public void run() {
                TraceConnectionsView.this.startTraceJobForAction(ActionType.EXPAND_ALL);
            }
        };
        this.expandAllAction.setImageDescriptor(DVTImages.EXPAND_ALL_ACTION);
        this.expandAllAction.setEnabled(!this.showContentAsList);
        this.collapseAllAction = new Action(TCViewMessages.fTraceCollapseAllText, 1){

            public void run() {
                TraceConnectionsView.this.startTraceJobForAction(ActionType.COLLAPSE_ALL);
            }
        };
        this.collapseAllAction.setImageDescriptor(DVTImages.COLLAPSE_ALL_ACTION);
        this.collapseAllAction.setEnabled(!this.showContentAsList);
        this.showDiagramAllAction = new Action(TCViewMessages.fTraceShowDiagramAll, 1){

            public void run() {
                if (TraceConnectionsView.this.startNode == null) {
                    return;
                }
                TCNode start = TraceConnectionsView.this.startNode.getFarthestHotAncestor();
                if (start == null || start.namedElement == null) {
                    return;
                }
                IRfSingleLangProject rfProject = start.namedElement.getRfProject();
                if (rfProject == null) {
                    return;
                }
                DDesignEditorFactory newTraceAllDiagram = DDesignEditorFactory.getInstance().newTraceAllDiagram(TraceConnectionsView.this.getMainLabelText(), start, TCPathPoint.of(TraceConnectionsView.this.startNode, TraceConnectionsView.this.startConn, null), TraceConnectionsView.this.sources, TraceConnectionsView.this.driveCausedBy, TraceConnectionsView.this.driveRedundance, TraceConnectionsView.this.destinations, TraceConnectionsView.this.loadCausedBy, TraceConnectionsView.this.loadRedundance, TraceConnectionsView.this.getActiveOperation(), null);
                if (TraceConnectionsView.this.forceDiagramInNewEditor.get()) {
                    newTraceAllDiagram.openNewEditor();
                } else {
                    newTraceAllDiagram.openEditor();
                }
                TraceConnectionsView.this.forceDiagramInNewEditor.set(false);
            }
        };
        this.showDiagramAllAction.setImageDescriptor(DVTImages.DIAGRAMS);
        this.showDiagramAllAction.setEnabled(false);
        this.showPortsViewAction = new PortsViewAction();
        this.showPortsViewAction.setEnabled(!this.showContentAsList);
        this.toggleMainViewContentAction = new Action(TCViewMessages.fTraceShowContentAsList, 2){

            public void run() {
                TraceConnectionsView.this.setShowContentAsList(TraceConnectionsView.this.toggleMainViewContentAction.isChecked());
                if (TraceConnectionsView.this.showContentAsList) {
                    TraceConnectionsView.this.hidePortsView();
                    TraceConnectionsView.this.showPortsViewAction.setEnabled(false);
                    TraceConnectionsView.this.showRootAction.setEnabled(false);
                    TraceConnectionsView.this.traceShowFullHierarchyAction.setEnabled(false);
                    TraceConnectionsView.this.expandAllAction.setEnabled(false);
                    TraceConnectionsView.this.collapseAllAction.setEnabled(false);
                } else {
                    TraceConnectionsView.this.showPortsView(TraceConnectionsView.this.showPortsViewBelow);
                    TraceConnectionsView.this.showPortsViewAction.setEnabled(true);
                    TraceConnectionsView.this.showRootAction.setEnabled(true);
                    TraceConnectionsView.this.traceShowFullHierarchyAction.setEnabled(true);
                    TraceConnectionsView.this.expandAllAction.setEnabled(true);
                    TraceConnectionsView.this.collapseAllAction.setEnabled(true);
                }
                TraceConnectionsView.this.startTraceJobForAction(ActionType.SHOW_CONTENT_AS_LIST);
            }
        };
        this.toggleMainViewContentAction.setImageDescriptor(DVTImages.TRACE_SHOW_CONTENT_AS_LIST);
        this.toggleMainViewContentAction.setEnabled(true);
        this.toggleMainViewContentAction.setChecked(this.showContentAsList);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.toggleMainViewContentAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.showRootAction);
        toolbarManager.add((IAction)this.traceShowFullHierarchyAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.traceDriveAndLoadAction);
        toolbarManager.add((IAction)this.traceDriveAction);
        toolbarManager.add((IAction)this.traceLoadAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.showPortsViewAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.showDiagramAllAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.expandAllAction);
        toolbarManager.add((IAction)this.collapseAllAction);
    }

    private void createWhyToolbar() {
        Composite toolBarComposite = new Composite(this.sashChildWhy, 2048);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        toolBarComposite.setLayout((Layout)layout);
        toolBarComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.whyLabel = new CLabel(toolBarComposite, 0x800000);
        this.whyLabel.setFont(this.sashChildWhy.getFont());
        this.whyLabel.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.whyLabel.setText("");
        ToolBar membersToolBar = new ToolBar(toolBarComposite, 0x820000);
        membersToolBar.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.whyToolBarManager = new ToolBarManager(membersToolBar);
        this.reverseOrderAction = new Action("Reverse Order", 2){

            public void run() {
                TraceConnectionsView.this.reverseOrderAction();
            }
        };
        this.reverseOrderAction.setImageDescriptor(DVTImages.REVERSE_ORDER);
        this.reverseOrderAction.setChecked(false);
        this.reverseOrderAction.setEnabled(false);
        this.nextHitAction = new Action("Show Next Hit (Ctrl+.)", 1){

            public void run() {
                TraceConnectionsView.this.nextWhyTreeHit(1);
                TraceConnectionsView.this.goToSelectedWhyItem(false);
            }
        };
        this.nextHitAction.setImageDescriptor(DVTImages.SEARCH_NEXT_A);
        this.nextHitAction.setEnabled(false);
        this.prevHitAction = new Action("Show Prev Hit (Ctrl+,)", 1){

            public void run() {
                TraceConnectionsView.this.nextWhyTreeHit(-1);
                TraceConnectionsView.this.goToSelectedWhyItem(false);
            }
        };
        this.prevHitAction.setImageDescriptor(DVTImages.SEARCH_PREV_A);
        this.prevHitAction.setEnabled(false);
        this.showDiagramPathAction = new Action(TCViewMessages.fTraceShowDiagramPath, 1){

            public void run() {
                if (TraceConnectionsView.this.startWhyNode == null) {
                    return;
                }
                TCPathPoint whyPoint = TCPathPoint.of(TraceConnectionsView.this.startWhyNode, TraceConnectionsView.this.startWhyConn, null);
                TCPathPoint startPoint = TCPathPoint.of(TraceConnectionsView.this.startNode, TraceConnectionsView.this.startConn, null);
                DDesignEditorFactory.getInstance().newTracePathDiagram(TraceConnectionsView.this.getWhyLabelText(TraceConnectionsView.this.whyEndType), TraceConnectionsView.this.startWhyNode.getFarthestHotAncestor(), whyPoint, TraceConnectionsView.this.sources, TraceConnectionsView.this.driveCausedBy, TraceConnectionsView.this.destinations, TraceConnectionsView.this.loadCausedBy, startPoint, TraceConnectionsView.this.whyEndType, null).openEditor();
            }
        };
        this.showDiagramPathAction.setImageDescriptor(DVTImages.DIAGRAMS);
        this.showDiagramPathAction.setEnabled(false);
        this.whyToolBarManager.add((IAction)this.nextHitAction);
        this.whyToolBarManager.add((IAction)this.prevHitAction);
        this.whyToolBarManager.add((IContributionItem)new Separator());
        this.whyToolBarManager.add((IAction)this.showDiagramPathAction);
        this.whyToolBarManager.update(true);
    }

    public void clickToolbarBtn(TCOperation operation) {
        this.checkToolbarBtn(operation);
        Action target = this.getToolbarBtn(operation);
        if (target != null) {
            target.run();
        }
    }

    private void checkToolbarBtn(TCOperation operation) {
        Action[] actions;
        Action target = this.getToolbarBtn(operation);
        if (target == null) {
            return;
        }
        Action[] actionArray = actions = new Action[]{this.traceShowFullHierarchyAction, this.traceDriveAndLoadAction, this.traceDriveAction, this.traceLoadAction};
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action a = actionArray[n2];
            a.setChecked(false);
            ++n2;
        }
        target.setChecked(true);
    }

    private Action getToolbarBtn(TCOperation operation) {
        if (operation == null) {
            return null;
        }
        switch (operation) {
            case DRIVE_AND_LOAD: {
                return this.traceDriveAndLoadAction;
            }
            case DRIVE: {
                return this.traceDriveAction;
            }
            case LOAD: {
                return this.traceLoadAction;
            }
        }
        return null;
    }

    private TCOperation getActiveOperation() {
        if (this.traceShowFullHierarchyAction.isChecked() || this.traceDriveAndLoadAction.isChecked()) {
            return TCOperation.DRIVE_AND_LOAD;
        }
        if (this.traceDriveAction.isChecked()) {
            return TCOperation.DRIVE;
        }
        if (this.traceLoadAction.isChecked()) {
            return TCOperation.LOAD;
        }
        return null;
    }

    public void updateTrace(TCOperation traceOperation, IRfNamedElement signal, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap, boolean showDiagramAll, IProgressMonitor monitor, ElementPath dhTopElementPath, ElementPath selectedInstanceElementPath) throws CanceledTraceException {
        if (ViewsUtils.isCanceled(monitor)) {
            throw new CanceledTraceException();
        }
        TCNode designHierarchyModel = null;
        TestHelper.fTracePortsTime = System.currentTimeMillis();
        if (signal == null || dhTopElementPath == null) {
            return;
        }
        monitor.subTask(TCViewMessages.fJobTaskConstructingModelText);
        designHierarchyModel = TCUtils.makeDesignHierarchyElabMode(signal.getRfProject(), dhTopElementPath, dummyPortMap);
        this.startNode = this.findWrapperInTreeNodes(selectedInstanceElementPath, designHierarchyModel);
        if (this.startNode == null) {
            return;
        }
        this.startConn = signal;
        this.setInput(new ViewDataContainer(this.getCurrentProject(), null));
        this.checkToolbarBtn(traceOperation);
        this.forceShowDiagramAll.set(showDiagramAll || DVTPlugin.getDefault().getPreferenceStore().getBoolean("traceconnections.linkWithTraceDiagram"));
        this.forceDiagramInNewEditor.set(showDiagramAll);
        this.updateTraceView(monitor);
        TestHelper.fTracePortsTime = (double)System.currentTimeMillis() - TestHelper.fTracePortsTime;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return this.mainTreeUpdateJob;
    }

    private void internalDeepCleanTree(IDVTElementWrapper root, TCNode node) {
        if (root == null) {
            TCNode rootNode = TCUtils.getNodeRoot(node);
            if (rootNode != null) {
                rootNode.deepClean();
            }
            return;
        }
        TCNode rootNode = TCViewUtils.getTraceNode(root);
        if (rootNode != null) {
            rootNode.deepClean();
        }
        root.deepClean();
    }

    public void deepCleanTree() {
        final TCNode node = this.startNode;
        if (Display.getCurrent() == null) {
            this.internalDeepCleanTree(this.mainElements, node);
        } else {
            WorkspaceJob job = new WorkspaceJob(TCViewMessages.fJobText){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    TraceConnectionsView.this.internalDeepCleanTree(TraceConnectionsView.this.mainElements, node);
                    return Status.OK_STATUS;
                }
            };
            job.setUser(false);
            job.setSystem(true);
            IProject project = this.getProject();
            if (this.fDataContainer != null && project != null) {
                job.setRule((ISchedulingRule)project);
            }
            job.schedule();
        }
    }

    private void cleanViews() {
        this.cleanGui();
        this.cleanViewFilters();
        this.cleanNonGui();
    }

    private void cleanNonGui() {
        this.deepCleanTree();
        this.startNode = null;
        this.startConn = null;
        this.startWhyNode = null;
        this.startWhyConn = null;
        this.selectedWhyNodeWrapper = null;
        this.selectedTreeElement = null;
        this.driveCausedBy = null;
        this.loadCausedBy = null;
        this.driveRedundance = null;
        this.loadRedundance = null;
        this.sources = null;
        this.destinations = null;
        this.whyElements = null;
        this.mainElements = null;
        this.mainElementsAsList = null;
        this.fDataContainer = null;
        this.matchCount = 0;
        this.shouldCollapseAll = false;
        this.forceShowDiagramAll.set(false);
        this.forceDiagramInNewEditor.set(false);
    }

    private void cleanGui() {
        Utils.safeRunSynchInUIThread(new Runnable(){

            @Override
            public void run() {
                DDesignEditorFactory.getInstance().closeDiagramTraceEditors();
                if (TraceConnectionsView.this.mainContentProvider == null || TraceConnectionsView.this.mainTree == null || TraceConnectionsView.this.mainTree.isDisposed()) {
                    return;
                }
                if (TraceConnectionsView.this.whyContentProvider == null || TraceConnectionsView.this.whyTree == null || TraceConnectionsView.this.whyTree.isDisposed()) {
                    return;
                }
                if (TraceConnectionsView.this.mainLabel == null || TraceConnectionsView.this.mainLabel.isDisposed()) {
                    return;
                }
                if (TraceConnectionsView.this.whyLabel == null || TraceConnectionsView.this.whyLabel.isDisposed()) {
                    return;
                }
                List<IDVTElementWrapper> treeInput = null;
                boolean noMatchesFound = TraceConnectionsView.this.isFiltered();
                TraceConnectionsView.this.mainLabel.setText("");
                TraceConnectionsView.this.whyLabel.setText("");
                treeInput = TraceConnectionsView.getMainTreeHelpMsg();
                if (noMatchesFound) {
                    treeInput = new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND);
                }
                TraceConnectionsView.this.mainContentProvider.setInput(treeInput, -1);
                TraceConnectionsView.this.whyContentProvider.setInput(TraceConnectionsView.getWhyTreeHelpMsg(), -1);
                TraceConnectionsView.this.showDiagramAllAction.setEnabled(false);
                if (TraceConnectionsView.this.hasPortsView()) {
                    TraceConnectionsView.this.portsView.cleanView(!TraceConnectionsView.this.isFiltered());
                }
            }
        });
    }

    private void cleanViewFilters() {
        Utils.safeRunSynchInUIThread(new Runnable(){

            @Override
            public void run() {
                if (TraceConnectionsView.this.hasPortsView()) {
                    TraceConnectionsView.this.portsView.cleanFilter();
                }
                if (TraceConnectionsView.this.isFiltered()) {
                    TraceConnectionsView.this.updateFromFilter.set(false);
                    TraceConnectionsView.this.setTextFilterText("default-filter", "");
                    TraceConnectionsView.this.setTextFilterMessage("default-filter", "Filter by: hierarchical name .port");
                    Display d = Display.getCurrent();
                    if (d != null) {
                        TraceConnectionsView.this.setTextFilterBackground("default-filter", JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
                    }
                    TraceConnectionsView.this.setFocus();
                }
            }
        });
    }

    private TCNode findWrapperInTreeNodes(ElementPath selectedInstanceElementPath, TCNode rootNode) {
        if (rootNode == null) {
            return null;
        }
        if (selectedInstanceElementPath.equals(rootNode.getElementPath())) {
            return rootNode;
        }
        if (!rootNode.hasChildren()) {
            return null;
        }
        for (TCNode child : rootNode.getChildren()) {
            TCNode found = this.findWrapperInTreeNodes(selectedInstanceElementPath, child);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private IDVTElementWrapper findNodeInTraceTreeWrappers(TCNode node, IDVTElementWrapper rootWrapper) {
        if (rootWrapper == null) {
            return null;
        }
        if (node == rootWrapper.getRfElement()) {
            return rootWrapper;
        }
        if (!rootWrapper.hasChildren()) {
            return null;
        }
        for (IDVTElementWrapper child : rootWrapper.getChildren()) {
            IDVTElementWrapper found = this.findNodeInTraceTreeWrappers(node, child);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void expandTreeToSelectedWhyElement() {
    }

    private void internalTraceSignal(IProgressMonitor monitor) throws CanceledTraceException {
        if (this.startNode == null) {
            return;
        }
        this.sources = null;
        this.destinations = null;
        TCUtils.clearHotData(this.startNode, true);
        this.driveCausedBy = new TCPathChain();
        this.loadCausedBy = new TCPathChain();
        this.driveRedundance = new TCPathRedundance();
        this.loadRedundance = new TCPathRedundance();
        this.traceConfigs = this.getTraceConfigs();
        TCCache.INSTANCE.clean();
        try {
            try {
                if (this.traceDriveAction.isChecked()) {
                    this.sources = new TCEndSet();
                    monitor.subTask(TCViewMessages.fJobTaskTraceDriveText);
                    TCUtils.traceSignalGeneric(TCOperation.DRIVE, this.startNode, this.startConn, this.sources, this.driveCausedBy, this.driveRedundance, this.traceConfigs, monitor);
                    TCUtils.pruneEmptyInterfaceShellLeaves(this.startNode.getFarthestHotAncestor(), this.showRootAction.isChecked(), TCOperation.DRIVE, this.sources, this.driveCausedBy, null, null, monitor);
                } else if (this.traceLoadAction.isChecked()) {
                    this.destinations = new TCEndSet();
                    monitor.subTask(TCViewMessages.fJobTaskTraceLoadText);
                    TCUtils.traceSignalGeneric(TCOperation.LOAD, this.startNode, this.startConn, this.destinations, this.loadCausedBy, this.loadRedundance, this.traceConfigs, monitor);
                    TCUtils.pruneEmptyInterfaceShellLeaves(this.startNode.getFarthestHotAncestor(), this.showRootAction.isChecked(), TCOperation.LOAD, null, null, this.destinations, this.loadCausedBy, monitor);
                } else {
                    this.sources = new TCEndSet();
                    this.destinations = new TCEndSet();
                    TCUtils.traceSignal(this.startNode, this.startConn, this.sources, this.destinations, this.driveCausedBy, this.loadCausedBy, this.driveRedundance, this.loadRedundance, this.traceConfigs, monitor);
                    TCUtils.pruneEmptyInterfaceShellLeaves(this.startNode.getFarthestHotAncestor(), this.showRootAction.isChecked(), TCOperation.DRIVE_AND_LOAD, this.sources, this.driveCausedBy, this.destinations, this.loadCausedBy, monitor);
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof CanceledTraceException)) {
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                }
                this.cleanViews();
                throw new CanceledTraceException();
            }
        }
        finally {
            TCCache.INSTANCE.clean();
        }
    }

    private void updateTraceView(IProgressMonitor monitor) throws CanceledTraceException {
        Utils.safeRunSynchInUIThread(new Runnable(){

            @Override
            public void run() {
                if (TraceConnectionsView.this.mainLabel != null && !TraceConnectionsView.this.mainLabel.isDisposed()) {
                    TraceConnectionsView.this.mainLabel.setText("");
                }
                if (TraceConnectionsView.this.mainContentProvider != null && TraceConnectionsView.this.mainTree != null && !TraceConnectionsView.this.mainTree.isDisposed()) {
                    TraceConnectionsView.this.mainContentProvider.setInput(TraceConnectionsView.this.startNode == null || TraceConnectionsView.this.startConn == null ? TraceConnectionsView.getMainTreeHelpMsg() : TraceConnectionsView.getUpdateMsg(), -1);
                }
                if (TraceConnectionsView.this.isFiltered()) {
                    TraceConnectionsView.this.updateFromFilter.set(false);
                    TraceConnectionsView.this.setTextFilterText("default-filter", "");
                    TraceConnectionsView.this.setTextFilterMessage("default-filter", "Filter by: hierarchical name .port");
                    Display d = Display.getCurrent();
                    if (d != null) {
                        TraceConnectionsView.this.setTextFilterBackground("default-filter", JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
                    }
                    TraceConnectionsView.this.setFocus();
                }
                if (TraceConnectionsView.this.hasPortsView()) {
                    TraceConnectionsView.this.portsView.cleanFilter();
                    TraceConnectionsView.this.portsView.cleanView(false);
                }
            }
        });
        this.whyTreeUpdateJob.cancel();
        this.startWhyNode = null;
        this.startWhyConn = null;
        this.whyElements = null;
        this.cleanWhyView(false);
        this.internalTraceSignal(monitor);
        this.mainTreeUpdateJob.cancel();
        this.mainTreeUpdateJob.schedule();
    }

    private void setExpandLevelViewWrappers(boolean shouldCollapse, UpdateJob updateJob) {
        if (this.mainElements == null) {
            return;
        }
        LinkedList<IDVTElementWrapper> queue = new LinkedList<IDVTElementWrapper>();
        queue.add(this.mainElements);
        while (!queue.isEmpty()) {
            if (ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            IDVTElementWrapper x = (IDVTElementWrapper)queue.remove();
            if (shouldCollapse) {
                x.setExpanded(-2);
            } else {
                x.setExpanded(0);
            }
            if (!x.hasChildren()) continue;
            for (IDVTElementWrapper child : x.getChildren()) {
                queue.add(child);
            }
        }
    }

    private void setSelectedListWrapper(int index, UpdateJob updateJob) {
        if (!this.showContentAsList || this.mainElementsAsList == null || this.mainElementsAsList.isEmpty() || index > this.mainElementsAsList.size() || this.mainElementsAsList.size() < index) {
            return;
        }
        if (ViewsUtils.isCanceled(updateJob)) {
            return;
        }
        this.selectedTreeElement = this.mainElementsAsList.get(index);
        this.selectedTreeElement.setSelectedElement(this.selectedTreeElement);
    }

    private void setSelectedTreeWrapper(UpdateJob updateJob) {
        if (this.selectedTreeElement != null) {
            this.selectedTreeElement.setSelectedElement(null);
        }
        this.selectedTreeElement = null;
        if (!this.isFiltered()) {
            IDVTElementWrapper found = this.findNodeInTraceTreeWrappers(this.startNode, this.mainElements);
            if (found == null) {
                return;
            }
            this.selectedTreeElement = found;
            this.selectedTreeElement.setSelectedElement(found);
            return;
        }
        if (this.mainElements == null) {
            return;
        }
        LinkedList<IDVTElementWrapper> queue = new LinkedList<IDVTElementWrapper>();
        queue.add(this.mainElements);
        while (!queue.isEmpty()) {
            if (ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            IDVTElementWrapper x = (IDVTElementWrapper)queue.remove();
            if ("*".equals(x.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH))) {
                this.selectedTreeElement = x;
                this.selectedTreeElement.setSelectedElement(x);
                break;
            }
            if (!x.hasChildren()) continue;
            for (IDVTElementWrapper child : x.getChildren()) {
                if (child == null || child.getExpanded() == -2) continue;
                queue.add(child);
            }
        }
    }

    private String getMainLabelText() {
        if (this.startNode == null || this.startConn == null) {
            return "";
        }
        String typeStr = DHViewUtils.getLabelText(this.startNode.namedElement, this.startNode.component, this.startNode.designHint, PrefConst.getDHViewPrependLibrary(), false);
        String traceType = this.traceShowFullHierarchyAction.isChecked() ? TCViewMessages.fTraceShowFullHierarchyText : (this.traceDriveAndLoadAction.isChecked() ? TCViewMessages.fTraceDriveAndLoadText : (this.traceDriveAction.isChecked() ? TCViewMessages.fTraceDriveText : (this.traceLoadAction.isChecked() ? TCViewMessages.fTraceLoadText : "")));
        return String.valueOf(traceType) + " " + typeStr + " . " + this.internalGetPortsLabelProvider().getText(PlainElementWrapper.of(this.startConn));
    }

    private String getWhyLabelText(TCOperation btn) {
        if (this.startWhyNode == null || this.startWhyConn == null) {
            return "";
        }
        String typeStr = DHViewUtils.getLabelText(this.startWhyNode.namedElement, this.startWhyNode.component, this.startWhyNode.designHint, PrefConst.getDHViewPrependLibrary(), false);
        return String.valueOf(switch (btn) {
            case TCOperation.DRIVE -> "Drive path from";
            case TCOperation.LOAD -> "Load path to";
            default -> "Path to";
        }) + " " + typeStr + " . " + this.internalGetPortsLabelProvider().getText(PlainElementWrapper.of(this.startWhyConn));
    }

    private IDVTElementWrapper getSelectedTreeElement(Tree tree) {
        if (tree == null || tree.isDisposed()) {
            return null;
        }
        return TCViewUtils.getWrapperFromTreeSelection(tree.getSelection());
    }

    public TCNode getSelectedNode() {
        return TCViewUtils.getTraceNode(this.getSelectedTreeElement(this.mainTree));
    }

    public TCNodeSignalPair getSelectedNodeSignalPair() {
        return TCViewUtils.getTraceNodeSignalPair(this.getSelectedTreeElement(this.mainTree));
    }

    private WhyViewElement getSelectedWhyElement() {
        return TCViewUtils.getWhyViewElementFromWrapper(this.getSelectedTreeElement(this.whyTree));
    }

    @Override
    public ISelection getSelection(String treeId) {
        return this.getSelection();
    }

    @Override
    public ISelection getSelection() {
        if (this.hasPortsView() && this.portsView.isFocused()) {
            return this.portsView.getSelection();
        }
        return super.getSelection();
    }

    private void goToSelectedWhyItem(boolean activateEditor) {
        WhyViewElement whyElement = this.getSelectedWhyElement();
        if (whyElement == null) {
            return;
        }
        TCPathPoint p = whyElement.point;
        TCStatement statement = whyElement.getStatement();
        if (statement != null) {
            IRfSingleLangProject rfProject = p.node.namedElement.getRfProject();
            if (rfProject == null) {
                return;
            }
            statement.goToInfo.open(rfProject.getProject(), activateEditor);
            return;
        }
        DVTRfUtils.goToDeclaration(p.signal, activateEditor);
    }

    public TCNode getStartNode() {
        return this.startNode;
    }

    public TCNode getStartWhyNode() {
        return this.startWhyNode;
    }

    public TCNode getSelectedWhyNode() {
        return TCViewUtils.getTraceNode(this.selectedWhyNodeWrapper);
    }

    private void unmarkBoldFont(final IDVTElementWrapper w) {
        Utils.safeRunAsynchInUIThread(new Runnable(){

            @Override
            public void run() {
                if (w == null) {
                    return;
                }
                if (!(w.getItem() instanceof TreeItem)) {
                    return;
                }
                TreeItem i = (TreeItem)w.getItem();
                if (i.isDisposed()) {
                    return;
                }
                Display d = i.getDisplay();
                Font f2 = i.getFont();
                if (d == null || f2 == null) {
                    return;
                }
                FontData[] fd = f2.getFontData();
                if (fd == null || fd.length == 0) {
                    return;
                }
                TCNode node = TCViewUtils.getTraceNode(w);
                if (node == TraceConnectionsView.this.startNode) {
                    i.setFont(FontFactory.getInstance().getSWTFont(new FontData(fd[0].getName(), fd[0].getHeight(), 1)));
                    i.setForeground(d.getSystemColor(9));
                } else if (node == TraceConnectionsView.this.startWhyNode) {
                    i.setFont(FontFactory.getInstance().getSWTFont(new FontData(fd[0].getName(), fd[0].getHeight(), 1)));
                    i.setForeground(d.getSystemColor(9));
                } else {
                    int style = 0;
                    if (w.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
                        style = 1;
                    }
                    i.setFont(FontFactory.getInstance().getSWTFont(new FontData(fd[0].getName(), fd[0].getHeight(), style)));
                    i.setForeground(d.getSystemColor(21));
                }
            }
        });
    }

    private void markBoldFont(final IDVTElementWrapper w, final int color) {
        Utils.safeRunAsynchInUIThread(new Runnable(){

            @Override
            public void run() {
                if (w == null) {
                    return;
                }
                if (!(w.getItem() instanceof TreeItem)) {
                    return;
                }
                TreeItem i = (TreeItem)w.getItem();
                if (i.isDisposed()) {
                    return;
                }
                Display d = i.getDisplay();
                Font f2 = i.getFont();
                if (d == null || f2 == null) {
                    return;
                }
                FontData[] fd = f2.getFontData();
                if (fd == null || fd.length == 0) {
                    return;
                }
                i.setFont(FontFactory.getInstance().getSWTFont(new FontData(fd[0].getName(), fd[0].getHeight(), 1)));
                i.setForeground(d.getSystemColor(color));
                if (color == 3) {
                    TraceConnectionsView.this.mainTree.showItem(i);
                }
            }
        });
    }

    private void markSelectedWhyNodeInMainTree(TCNode selectedWhyNode) {
        if (this.showContentAsList) {
            return;
        }
        if (selectedWhyNode == null) {
            this.unmarkBoldFont(this.selectedWhyNodeWrapper);
            this.selectedWhyNodeWrapper = null;
            return;
        }
        if (!this.visitAndMarkSelected(this.mainElements, selectedWhyNode)) {
            this.selectedWhyNodeWrapper = null;
        }
    }

    private boolean visitAndMarkSelected(IDVTElementWrapper root, TCNode selectedNode) {
        TCNode node = TCViewUtils.getTraceNode(root);
        if (node != null && node == selectedNode) {
            this.selectedWhyNodeWrapper = root;
            this.markBoldFont(root, 3);
            return true;
        }
        if (!root.hasChildren()) {
            return false;
        }
        for (IDVTElementWrapper child : root.getChildren()) {
            if (!this.visitAndMarkSelected(child, selectedNode)) continue;
            return true;
        }
        return false;
    }

    private void markStartWhyNodeInMainTree(TCNode startWhyNode) {
        if (this.showContentAsList) {
            return;
        }
        if (startWhyNode == null) {
            this.unmarkBoldFont(this.startWhyNodeWrapper);
            this.startWhyNodeWrapper = null;
            return;
        }
        if (!this.visitAndMarkStart(this.mainElements, startWhyNode)) {
            this.startWhyNodeWrapper = null;
        }
    }

    private boolean visitAndMarkStart(IDVTElementWrapper root, TCNode whyNode) {
        TCNode node = TCViewUtils.getTraceNode(root);
        if (node != null && node == whyNode) {
            this.startWhyNodeWrapper = root;
            this.markBoldFont(root, 9);
            return true;
        }
        if (root == null || !root.hasChildren()) {
            return false;
        }
        for (IDVTElementWrapper child : root.getChildren()) {
            if (!this.visitAndMarkStart(child, whyNode)) continue;
            return true;
        }
        return false;
    }

    private void visitAndMarkWhyDecorations(IDVTElementWrapper root, List<IDVTElementWrapper> elements, Set<TCNode> whyViewNodes) {
        if (root == null) {
            return;
        }
        TCNode node = TCViewUtils.getTraceNode(root);
        if (node != null) {
            if (whyViewNodes != null && whyViewNodes.contains(node)) {
                if (elements != null) {
                    elements.add(root);
                }
                root.setAdditionalInfo(IDVTElementWrapper.Attribute.WHYPATHNODE, "*");
                whyViewNodes.remove(node);
            } else {
                if (root.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.WHYPATHNODE) != null && root.getItem() != null && elements != null) {
                    elements.add(root);
                }
                root.removeAdditionalInfo((Object)IDVTElementWrapper.Attribute.WHYPATHNODE);
            }
        }
        if (!root.hasChildren()) {
            return;
        }
        for (IDVTElementWrapper child : root.getChildren()) {
            this.visitAndMarkWhyDecorations(child, elements, whyViewNodes);
        }
    }

    public TCViewUtilsBatch.TCEndPointKind isEndNode(TCNode node) {
        return TCViewUtilsBatch.getEndNodeKind(node, this.sources, this.destinations, this.startNode);
    }

    public TCViewUtilsBatch.TCEndPointKind isEndSignalPoint(TCPathPoint point) {
        return TCViewUtilsBatch.getEndPointKind(point, this.sources, this.destinations, TCPathPoint.of(this.startNode, this.startConn, null));
    }

    @NotNull
    private IMembersLabelProvider internalGetPortsLabelProvider() {
        if (this.cachePortsLabelProvider != null) {
            return this.cachePortsLabelProvider;
        }
        this.cachePortsLabelProvider = this.currentContributor.getTCPortsLabelProvider(this);
        return this.cachePortsLabelProvider;
    }

    public IProject getCurrentProject() {
        if (this.startNode == null || this.startNode.namedElement == null) {
            return null;
        }
        IResource fileAdapter = this.startNode.namedElement.getFileAdapter();
        if (fileAdapter == null) {
            return null;
        }
        return fileAdapter.getProject();
    }

    private void maximize() {
        this.setPartState(1);
    }

    private void restore() {
        this.setPartState(2);
    }

    private void setPartState(int state) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return;
        }
        IWorkbenchPartReference ref = page.getReference((IWorkbenchPart)this);
        if (ref == null) {
            return;
        }
        page.activate((IWorkbenchPart)this);
        page.setPartState(ref, state);
    }

    private void clearTreeSelection(Tree tree) {
        TreeItem[] treeSelection = tree.getSelection();
        if (treeSelection == null) {
            return;
        }
        int i = 0;
        while (i < treeSelection.length) {
            tree.deselect(treeSelection[i]);
            ++i;
        }
        tree.deselectAll();
    }

    private void updateNonGuiWhyPart(UpdateJob updateJob) {
        if (this.startWhyNode == null || this.startWhyConn == null) {
            return;
        }
        TCPathPoint p = TCPathPoint.of(this.startWhyNode, this.startWhyConn, null);
        this.whyEndType = TCOperation.DRIVE_AND_LOAD;
        if (this.driveCausedBy.hasEffect(p) ^ this.loadCausedBy.hasEffect(p)) {
            this.whyEndType = this.driveCausedBy.hasEffect(p) ? TCOperation.DRIVE : TCOperation.LOAD;
            this.whyElements = this.constructWhyTreeView(p, this.whyEndType == TCOperation.DRIVE ? this.driveCausedBy : this.loadCausedBy, this.whyEndType, updateJob);
        } else {
            List<IDVTElementWrapper> l2;
            this.whyElements = new ArrayList<IDVTElementWrapper>();
            List<IDVTElementWrapper> l1 = this.constructWhyTreeView(p, this.driveCausedBy, TCOperation.DRIVE, updateJob);
            if (l1 != null && !l1.isEmpty()) {
                this.whyElements.addAll(l1);
            }
            if ((l2 = this.constructWhyTreeView(p, this.loadCausedBy, TCOperation.LOAD, updateJob)) != null && !l2.isEmpty()) {
                for (IDVTElementWrapper elem : l2) {
                    if (this.whyElements.contains(elem)) continue;
                    this.whyElements.add(elem);
                }
            }
        }
        if (this.whyElements != null && this.whyElements.isEmpty()) {
            this.whyElements = null;
        }
        this.markSelectedWhyNodeInMainTree(null);
        this.markStartWhyNodeInMainTree(null);
        this.markStartWhyNodeInMainTree(this.startWhyNode);
        this.markWhyPathDecorations(this.whyElements);
    }

    private void updateGuiWhyPart(UpdateJob updateJob) {
        if (ViewsUtils.isCanceled(updateJob)) {
            return;
        }
        this.whyContentProvider.setInput((List<IDVTElementWrapper>)(this.whyElements != null ? new ArrayList<IDVTElementWrapper>(this.whyElements) : null), -1);
        this.whyLabel.setText(this.getWhyLabelText(this.whyEndType));
        this.nextHitAction.setEnabled(true);
        this.prevHitAction.setEnabled(true);
        this.showDiagramPathAction.setEnabled(true);
        this.reverseOrderAction.setEnabled(true);
    }

    private void reverseOrderAction() {
        if (this.whyElements == null) {
            return;
        }
        Collections.reverse(this.whyElements);
        this.selectWhyPathElement(0, false);
        this.whyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(this.whyElements), -1);
    }

    private void nextWhyTreeHit(int direction) {
        IDVTElementWrapper nextElement;
        List<IDVTElementWrapper> flatten = this.flattenOneLevelWhyElements();
        if (flatten == null) {
            return;
        }
        int size = flatten.size();
        if (size < 1) {
            return;
        }
        int next = direction > 0 ? 0 : size - 1;
        IDVTElementWrapper selected = this.getSelectedTreeElement(this.whyTree);
        if (selected != null) {
            int i = 0;
            while (i < size) {
                IDVTElementWrapper wrapper = flatten.get(i);
                if (wrapper == selected) {
                    wrapper.setSelectedElement(null);
                    next = i + direction;
                    next = next >= size ? next - size : (next < 0 ? next + size : next);
                    break;
                }
                ++i;
            }
        }
        if ((nextElement = flatten.get(next)) == null) {
            return;
        }
        if (this.isWhyTreeWriterOrReaderHeader(nextElement)) {
            next = (next += direction) >= size ? next - size : (next < 0 ? next + size : next);
            nextElement = flatten.get(next);
        }
        nextElement.setSelectedElement(nextElement);
        if (nextElement.getItem() instanceof TreeItem) {
            this.whyTree.setSelection((TreeItem)nextElement.getItem());
            this.whyTree.showSelection();
            this.whyTree.notifyListeners(13, (Event)new DVTSyntheticEvent());
        }
    }

    private List<IDVTElementWrapper> constructWhyTreeView(TCPathPoint point, TCPathChain causedBy, TCOperation endType, IDVTJob updateJob) {
        int index;
        WhyViewElement whyElement;
        boolean isDrivePath;
        List<IDVTElementWrapper> result = this.constructWhyPath(point, causedBy, updateJob);
        if (result == null || result.isEmpty()) {
            return result;
        }
        boolean bl = isDrivePath = endType == TCOperation.DRIVE;
        if (isDrivePath) {
            Collections.reverse(result);
        }
        if ((whyElement = TCViewUtils.getWhyViewElementFromWrapper(result.get(index = isDrivePath ? 0 : result.size() - 1))) == null) {
            return result;
        }
        IDVTElementWrapper[] wrHeaders = this.constructWhyWritersAndReaders(whyElement.point, updateJob);
        index = result.size();
        if (wrHeaders != null && wrHeaders[0] != null) {
            result.add(index, wrHeaders[0]);
        }
        if (wrHeaders != null && wrHeaders[1] != null) {
            result.add(index, wrHeaders[1]);
        }
        return result;
    }

    private List<IDVTElementWrapper> constructWhyPath(TCPathPoint point, TCPathChain causedBy, IDVTJob updateJob) {
        if (ViewsUtils.isCanceled(updateJob)) {
            return null;
        }
        if (point == null) {
            return null;
        }
        ArrayDeque<WhyViewElement> deque = new ArrayDeque<WhyViewElement>();
        if (causedBy != null && !causedBy.isEmpty()) {
            HashSet<TCPathPoint> visited = new HashSet<TCPathPoint>();
            point = causedBy.getEffectFromEffect(point);
            while (point != null) {
                if (ViewsUtils.isCanceled(updateJob)) {
                    return null;
                }
                if (!visited.contains(point)) {
                    TCStatement statement;
                    visited.add(point);
                    WhyViewElement newFirst = new WhyViewElement(point);
                    WhyViewElement prevFirst = (WhyViewElement)deque.peekFirst();
                    if (prevFirst == null || !prevFirst.equals(newFirst)) {
                        deque.addFirst(newFirst);
                    }
                    if ((statement = point.statement) != null) {
                        deque.addFirst(new WhyViewElement(point, statement.kind));
                    }
                    point = causedBy.getCauseFromEffect(point);
                    continue;
                }
                break;
            }
        } else {
            deque.addFirst(new WhyViewElement(point));
        }
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        for (WhyViewElement whyElement : deque) {
            if (ViewsUtils.isCanceled(updateJob)) {
                return null;
            }
            result.add(PlainElementWrapper.of(whyElement));
        }
        return result;
    }

    private IDVTElementWrapper[] constructWhyWritersAndReaders(TCPathPoint end, IDVTJob updateJob) {
        List<TCPathPoint> readers;
        if (ViewsUtils.isCanceled(updateJob)) {
            return null;
        }
        IDVTElementWrapper[] headers = new PlainElementWrapper[2];
        if (end == null) {
            return headers;
        }
        TCCache.INSTANCE.clean();
        List<TCPathPoint> writers = TCUtils.getSignalWritersOrReaders2(TCOperation.DRIVE, end, end.node, updateJob, false);
        if (!writers.isEmpty()) {
            headers[0] = PlainElementWrapper.of("Writers of " + end.signal.toString());
            for (TCPathPoint writer : writers) {
                if (ViewsUtils.isCanceled(updateJob)) {
                    return null;
                }
                headers[0].addChild(PlainElementWrapper.of(new WhyViewElement(writer, TCStatement.TCStatementKind.WRITER)));
            }
        }
        if (!(readers = TCUtils.getSignalWritersOrReaders2(TCOperation.LOAD, end, end.node, updateJob, false)).isEmpty()) {
            headers[1] = PlainElementWrapper.of("Readers of " + end.signal.toString());
            for (TCPathPoint reader : readers) {
                if (ViewsUtils.isCanceled(updateJob)) {
                    return null;
                }
                headers[1].addChild(PlainElementWrapper.of(new WhyViewElement(reader, TCStatement.TCStatementKind.READER)));
            }
        }
        TCCache.INSTANCE.clean();
        return headers;
    }

    private boolean isWhyTreeWriterOrReaderHeader(IDVTElementWrapper element) {
        Object obj;
        Object object = obj = element != null ? element.getRfElement() : null;
        if (!(obj instanceof String)) {
            return false;
        }
        return ((String)obj).startsWith(WRITERS_HEADER_LABEL) || ((String)obj).startsWith(READERS_HEADER_LABEL);
    }

    @Override
    public void dispose() {
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        if (this.mainTree != null && !this.mainTree.isDisposed()) {
            this.mainTree.dispose();
        }
        if (this.whyTree != null && !this.whyTree.isDisposed()) {
            this.whyTree.dispose();
        }
        if (this.whyToolBarManager != null) {
            this.whyToolBarManager.dispose();
        }
        if (this.mainLabel != null && !this.mainLabel.isDisposed()) {
            this.mainLabel.dispose();
        }
        if (this.whyLabel != null && this.whyLabel.isDisposed()) {
            this.whyLabel.dispose();
        }
        this.cleanViews();
        if (this.hasPortsView()) {
            this.portsView.dispose();
        }
        this.mainTree = null;
        this.whyTree = null;
        this.whyToolBarManager = null;
        this.mainLabel = null;
        this.whyLabel = null;
        super.dispose();
    }

    private void goToSelectedNode() {
        TCNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object pathFromNode = IDesignPathProvider.getPathFromTCNode(node);
        this.setTraceDataForBreadcrumb(pathFromNode, node.namedElement);
        DVTRfUtils.goToDeclaration(node.namedElement, true);
        if (!DesignUtils.isBlock(node.namedElement)) {
            pathFromNode = ((ElementPath)pathFromNode).removeLastSegment();
        }
        this.updatePathManager(pathFromNode);
    }

    private void goToSelectedNodeSignalPair() {
        TCNodeSignalPair nodeSignalPair = this.getSelectedNodeSignalPair();
        if (nodeSignalPair == null) {
            return;
        }
        Object pathFromNode = IDesignPathProvider.getPathFromTCNode(nodeSignalPair.node);
        IRfNamedElement element = nodeSignalPair.node == null ? null : nodeSignalPair.node.namedElement;
        this.setTraceDataForBreadcrumb(pathFromNode, element);
        DVTRfUtils.goToPortConnectionOrDeclaration(nodeSignalPair.hotSignal, nodeSignalPair.node, true);
        if (!DesignUtils.isBlock(element)) {
            pathFromNode = ((ElementPath)pathFromNode).removeLastSegment();
        }
        this.updatePathManager(pathFromNode);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        if (this.showContentAsList) {
            this.goToSelectedNodeSignalPair();
        } else {
            this.goToSelectedNode();
        }
    }

    public boolean hasPortsView() {
        return this.showPortsView && this.portsView != null;
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        if (!this.updateFromFilter.get()) {
            this.updateFromFilter.set(true);
            return;
        }
        if (this.startNode == null) {
            this.cleanGui();
            this.cleanNonGui();
            return;
        }
        this.mainTree.setRedraw(false);
        if (this.whyElements != null && this.whyTree != null && !this.whyTree.isDisposed()) {
            this.clearTreeSelection(this.whyTree);
            this.selectedWhyNodeWrapper = null;
        }
        this.mainContentProvider.setInput(TraceConnectionsView.getUpdateMsg(), -1);
        if (this.hasPortsView()) {
            this.portsView.cleanView(false);
        }
        this.mainTreeUpdateJob.cancel();
        this.mainTreeUpdateJob.schedule();
        this.mainTree.setRedraw(true);
    }

    public IRfNamedElement getPortsViewWhyPort() {
        if (!this.hasPortsView()) {
            return null;
        }
        return this.portsView.getWhyPort();
    }

    @Override
    public Tree getTree(String treeId) {
        if (treeId.equals(WHY_TREE_ID)) {
            return this.whyTree;
        }
        return this.mainTree;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.currentContributor.getCustomLabelProvider(this, "trace-connections-label-provider");
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        return this.getSearchSegments("default-filter");
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        return this.getSearchStrictness("default-filter");
    }

    @Override
    public String getTreeSearchPort() {
        return this.getSearchPort("default-filter");
    }

    public void setStartNode(TCNode node) {
        this.startNode = node;
    }

    public void setStartConn(IRfNamedElement conn) {
        this.startConn = conn;
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        if (this.startNode == null) {
            return;
        }
        if (ViewsUtils.isCanceled(updateJob)) {
            return;
        }
        if (this.mainElements != null) {
            this.mainElements.deepClean();
        }
        this.mainElements = null;
        this.mainElementsAsList = null;
        if (this.showContentAsList) {
            this.mainElementsAsList = this.currentContributor.makeHotViewList(this.startNode.getFarthestHotAncestor(), TCPathPoint.of(this.startNode, this.startConn, null), this.sources, this.destinations, updateJob);
        } else {
            IDVTElementWrapper iDVTElementWrapper = this.mainElements = this.traceShowFullHierarchyAction.isChecked() ? this.currentContributor.makeFullViewTree(this.startNode, updateJob) : this.currentContributor.makeHotViewTree(this.startNode.getFarthestHotAncestor(), this.showRootAction.isChecked(), updateJob);
        }
        if (ViewsUtils.isCanceled(updateJob)) {
            return;
        }
        this.setExpandLevelViewWrappers(this.shouldCollapseAll, updateJob);
        this.shouldCollapseAll = false;
        if (ViewsUtils.isCanceled(updateJob)) {
            return;
        }
        ComplexFilter filter = new ComplexFilter(this, true);
        ViewsUtils.filterElementComplex(this.mainElements, filter);
        this.matchCount = filter.matchCount;
        if (this.showContentAsList) {
            this.setSelectedListWrapper(0, updateJob);
        } else {
            this.setSelectedTreeWrapper(updateJob);
        }
        this.markStartWhyNodeInMainTree(this.startWhyNode);
        this.markSelectedWhyNodeInMainTree(this.getSelectedWhyNode());
        this.markWhyPathDecorations(this.whyElements);
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            ArrayList<IDVTElementWrapper> mainTreeInput;
            if (this.mainContentProvider == null || this.mainTree == null || this.mainTree.isDisposed()) {
                return;
            }
            if (this.mainLabel == null || this.mainLabel.isDisposed()) {
                return;
            }
            boolean noMatchesFound = this.isFiltered() && this.matchCount == 0;
            this.mainLabel.setText(this.getMainLabelText());
            List<IDVTElementWrapper> list = this.showContentAsList ? this.mainElementsAsList : (mainTreeInput = this.mainElements != null ? new ArrayList<IDVTElementWrapper>(Arrays.asList(this.mainElements)) : TraceConnectionsView.getMainTreeHelpMsg());
            if (mainTreeInput == null) {
                mainTreeInput = TraceConnectionsView.getMainTreeHelpMsg();
            }
            if (mainTreeInput.isEmpty()) {
                mainTreeInput = new ArrayList<IDVTElementWrapper>(NO_RESULTS_MESSAGE);
            }
            if (noMatchesFound) {
                mainTreeInput = new ArrayList(NO_MATCHES_FOUND);
            }
            this.mainContentProvider.setInput((List<IDVTElementWrapper>)mainTreeInput, -1);
            this.showDiagramAllAction.setEnabled(!noMatchesFound);
            if (!noMatchesFound && this.forceShowDiagramAll.get()) {
                this.showDiagramAllAction.run();
            }
            if (this.hasPortsView()) {
                if (this.mainElements != null && !noMatchesFound) {
                    this.portsView.cleanView(true);
                } else {
                    this.portsView.cleanView(false);
                }
            }
        }
        finally {
            this.forceShowDiagramAll.set(false);
        }
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        if (node == null) {
            return null;
        }
        Object traceNode = node.getRfElement();
        if (traceNode == null) {
            return null;
        }
        return ((TCNode)traceNode).getHotSignals().stream().map(sig -> sig.getName()).collect(Collectors.toList());
    }

    private ITraceConnectionsContributor getViewContributor() {
        return DVTViewContributors.getInstance().getViewContributor(LanguageKind.VLOG, ITraceConnectionsContributor.class);
    }

    @Override
    public void update(BuildEvents updateEvent) {
        boolean isDirty;
        boolean bl = isDirty = this.startNode == null || this.startNode.namedElement == null || this.startNode.namedElement.hasNoDefs(false) || this.startConn == null || this.startConn.hasNoDefs(false);
        if (isDirty || BuildEvents.FULL_BUILD == updateEvent || BuildEvents.CLEAN_BUILD == updateEvent) {
            this.cleanViews();
        }
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public Control getControlToColorBg() {
        return null;
    }

    @Override
    public Control getControlToColorFg() {
        return null;
    }

    public boolean candDoTraceOperationAction() {
        if (this.showContentAsList) {
            return true;
        }
        return this.hasPortsView() && this.portsView != null;
    }

    public void doTraceOperationAction(TCOperation operation) {
        if (operation == null) {
            return;
        }
        if (this.showContentAsList) {
            TCNodeSignalPair selectedNodeSignalPair = this.getSelectedNodeSignalPair();
            this.internalDoTraceOperationAction(operation, selectedNodeSignalPair.node, selectedNodeSignalPair.hotSignal);
            return;
        }
        if (!this.hasPortsView() || !this.portsView.isFocused()) {
            return;
        }
        this.portsView.doTraceOperationAction(operation);
    }

    public void internalDoTraceOperationAction(TCOperation operation, TCNode selectedNodeElement, IRfNamedElement hotItem) {
        switch (operation) {
            case DRIVE: {
                this.setStartNode(selectedNodeElement);
                this.setStartConn(hotItem);
                this.clickToolbarBtn(TCOperation.DRIVE);
                break;
            }
            case LOAD: {
                this.setStartNode(selectedNodeElement);
                this.setStartConn(hotItem);
                this.clickToolbarBtn(TCOperation.LOAD);
                break;
            }
            case DRIVE_AND_LOAD: {
                this.setStartNode(selectedNodeElement);
                this.setStartConn(hotItem);
                this.clickToolbarBtn(TCOperation.DRIVE_AND_LOAD);
                break;
            }
        }
    }

    @Override
    public void clean() {
        this.mainTreeUpdateJob.cancel();
        this.whyTreeUpdateJob.cancel();
        this.cleanViews();
    }

    public List<IDVTElementWrapper> testHelpGetInput() {
        return this.mainContentProvider.getInput();
    }

    public void testHelpCheckColdTopAction(boolean checked) {
        this.showRootAction.setChecked(checked);
        this.showRootAction.run();
    }

    public String testHelpGetWhyViewsItems() {
        StringBuilder sb = new StringBuilder();
        if (this.whyElements == null) {
            return "";
        }
        int itemSize = this.whyElements.size();
        int i = 0;
        while (i < itemSize) {
            sb.append(this.whyElements.get(i).toString());
            if (i < itemSize - 1) {
                sb = sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public void testHelpSelectPortsViewItem(TableItem item) {
        if (!this.hasPortsView()) {
            return;
        }
        this.portsView.testHelpSelectPortInTable(item);
    }

    public void testHelpWhyOperation(TCNode selectedNode, IRfNamedElement port) {
        this.updateWhyView(selectedNode, port);
    }

    public void testHelpShowWhyViewForSelectedPort() {
        if (!this.hasPortsView()) {
            return;
        }
        this.portsView.testHelpWhyOperationForSelectedPort();
    }

    public boolean testHelpSelectWhyViewElement(int index) {
        this.selectWhyPathElement(index, true);
        return true;
    }

    public boolean testHelpWhySelectionColoring(int index) {
        if (this.whyTree == null || this.whyTree.isDisposed() || this.whyElements == null) {
            return false;
        }
        if (index < 0 || index > this.whyElements.size()) {
            return false;
        }
        WhyViewElement elem = TCViewUtils.getWhyViewElementFromWrapper(this.whyElements.get(index));
        if (elem == null) {
            return false;
        }
        if (this.mainTree == null || this.mainTree.isDisposed()) {
            return false;
        }
        if (this.mainTree.getSelection().length != 0 || this.selectedTreeElement.getSelectedElement() != null) {
            return false;
        }
        TCNode node = this.getSelectedWhyNode();
        if (node == null) {
            return false;
        }
        if (elem.point == null || elem.point.node == null || elem.point.node != node) {
            return false;
        }
        if (this.selectedWhyNodeWrapper == null) {
            return false;
        }
        TreeItem i = (TreeItem)this.selectedWhyNodeWrapper.getItem();
        if (i.isDisposed()) {
            return false;
        }
        if ((i.getFont().getFontData()[0].getStyle() & 1) == 0) {
            return false;
        }
        Display d = i.getDisplay();
        if (d != null && !i.getForeground().equals((Object)d.getSystemColor(3))) {
            return false;
        }
        return !this.hasPortsView() || this.portsView.testHelpWhySelectionColoring();
    }

    public TCNode testHelpGetSelectedNode() {
        return this.getSelectedNode();
    }

    public void testHelpShowPortsView() {
        if (this.hasPortsView()) {
            return;
        }
        this.showPortsView(false);
    }

    public TraceConnectionsPortsView testHelpGetPortsView() {
        this.testHelpShowPortsView();
        return this.portsView;
    }

    public String testHelpGetPortsForSelectedNode() {
        TCNode node = this.getSelectedNode();
        List<IRfNamedElement> elements = node.getHotSignals();
        Collections.sort(elements, DesignUtils.SIGNAL_COMPARATOR);
        StringJoiner sj = new StringJoiner(",");
        int i = 0;
        while (i < elements.size()) {
            sj.add(elements.get(i).getName());
            ++i;
        }
        return sj.toString();
    }

    public boolean testShowDiagramAll() {
        if (!this.showDiagramAllAction.isEnabled()) {
            return false;
        }
        this.showDiagramAllAction.run();
        return true;
    }

    public boolean testShowDiagramPath() {
        if (!this.showDiagramPathAction.isEnabled()) {
            return false;
        }
        this.showDiagramPathAction.run();
        return true;
    }

    public String testGetSelectedNodeName() {
        return TCViewUtils.getTraceNode(this.getSelectedTreeElement(this.mainTree)).toString();
    }

    private static enum ActionType {
        TRACE_SHOW_FULL_HIERARCHY,
        TRACE_DRIVE_AND_LOAD,
        TRACE_DRIVE,
        TRACE_LOAD,
        SHOW_ROOT,
        SHOW_CONTENT_AS_LIST,
        EXPAND_ALL,
        COLLAPSE_ALL;

    }

    private static enum ContextMenuType {
        WHY_MENU,
        GO_TO_MENU,
        TRACE_MENU;

    }

    private class PortsViewAction
    extends Action {
        public PortsViewAction() {
            super("Show/Hide Signals", 5);
            this.setImageDescriptor(DVTImages.SHOW_HIDE_PORTS);
            this.setMenuCreator(new PortsViewMenuCreator());
        }

        public void run() {
            if (TraceConnectionsView.this.hasPortsView()) {
                TraceConnectionsView.this.hidePortsView();
            } else {
                TraceConnectionsView.this.showPortsView(TraceConnectionsView.this.showPortsViewBelow);
            }
            this.setChecked(true);
        }

        public void runWithEvent(Event event) {
            this.setChecked(true);
            super.runWithEvent(event);
            this.setChecked(true);
        }
    }

    private class PortsViewMenuCreator
    implements IMenuCreator {
        private PortsViewMenuCreator() {
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            Menu menu = new Menu(parent);
            Action vertAction = new Action("Show Signals Below", 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    TraceConnectionsView.this.showPortsView(true);
                }
            };
            vertAction.setChecked(TraceConnectionsView.this.sashChildPorts != null && TraceConnectionsView.this.showPortsViewBelow);
            ActionContributionItem vertItem = new ActionContributionItem((IAction)vertAction);
            vertItem.fill(menu, -1);
            Action horizAction = new Action("Show Signals to the Right", 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    TraceConnectionsView.this.showPortsView(false);
                }
            };
            horizAction.setChecked(TraceConnectionsView.this.sashChildPorts != null && !TraceConnectionsView.this.showPortsViewBelow);
            ActionContributionItem horizItem = new ActionContributionItem((IAction)horizAction);
            horizItem.fill(menu, -1);
            Action hideAction = new Action("Hide Signals", 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    TraceConnectionsView.this.hidePortsView();
                }
            };
            hideAction.setChecked(TraceConnectionsView.this.sashChildPorts == null && !TraceConnectionsView.this.showPortsView);
            ActionContributionItem hideItem = new ActionContributionItem((IAction)hideAction);
            hideItem.fill(menu, -1);
            return menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    class WhyViewImpl
    implements IUpdateJobImpl {
        WhyViewImpl() {
        }

        @Override
        public void updateNonGuiPart(UpdateJob updateJob) {
            TraceConnectionsView.this.updateNonGuiWhyPart(updateJob);
        }

        @Override
        public void updateGuiPart(UpdateJob updateJob) {
            TraceConnectionsView.this.updateGuiWhyPart(updateJob);
        }
    }
}

