/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.trace.connections;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.trace.connections.WhyViewElement;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public class WhyViewLabelProvider
extends DVTBaseLabelProvider {
    @Override
    public Image getImage(Object wrapper) {
        IRfNamedElement signal;
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        WhyViewElement element = TCViewUtils.getWhyViewElementFromWrapper((IDVTElementWrapper)wrapper);
        if (element == null) {
            Object obj = ((IDVTElementWrapper)wrapper).getRfElement();
            if (obj instanceof String && ((String)obj).startsWith("Writers")) {
                return DVTImages.imageCache.getImage(DVTImages.TRACE_WHY_WRITERS_HEADER);
            }
            if (obj instanceof String && ((String)obj).startsWith("Readers")) {
                return DVTImages.imageCache.getImage(DVTImages.TRACE_WHY_READERS_HEADER);
            }
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        TCStatement.TCStatementKind statementKind = element.kind;
        if (statementKind != null) {
            switch (statementKind) {
                case ASSIGN: 
                case ALIAS: {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSIGN);
                }
                case CONCURRENT_ALWAYS_BLOCK: 
                case SEQUENTIAL_ALWAYS_BLOCK: {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ALWAYS);
                }
                case PORT_CONNECTION: {
                    return DVTImages.imageCache.getImage(DVTImages.TRACE_WHY_PORT_CONNECTION);
                }
                case PORT_EXPRESSION: {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_NODIR_PORT);
                }
                case READER: {
                    return DVTImages.imageCache.getImage(DVTImages.TRACE_WHY_READER_MATCH);
                }
                case WRITER: {
                    return DVTImages.imageCache.getImage(DVTImages.TRACE_WHY_WRITER_MATCH);
                }
            }
        }
        if ((signal = element.point.signal) instanceof HierarchicalElement) {
            signal = ((HierarchicalElement)signal).getFirstSegment();
        }
        if (signal instanceof IRfPortElement) {
            IRfPortElement port = (IRfPortElement)signal;
            if (port.isInput() || port.isOutput() || port.isInout()) {
                return port.getImage();
            }
            if (port.isModportPort()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODPORT);
            }
            if (port.isInterfacePort()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_PORT);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_NODIR_PORT);
        }
        return signal.getImage();
    }

    @Override
    public String getText(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return "";
        }
        Object rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        if (rfElement instanceof String) {
            return (String)rfElement;
        }
        WhyViewElement element = TCViewUtils.getWhyViewElementFromWrapper((IDVTElementWrapper)wrapper);
        if (element == null) {
            return "";
        }
        return element.toString();
    }
}

