/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.trace.connections.actions;

import java.util.Deque;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.trace.connections.utils.TCInterfaceInterest;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class TCJobEditorStart {
    public Object execute(ExecutionEvent event, TCOperation traceOperation) {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor == null) {
            return null;
        }
        if (!(activeEditor instanceof DVTEditor)) {
            return null;
        }
        DVTEditor dvtEditor = (DVTEditor)activeEditor;
        IRfNamedElementAndScope cursorElement = dvtEditor.getCursorElement();
        IProject project = this.getProject((IEditorPart)dvtEditor);
        IRfNamedElement conn = this.getSignalElement(project, cursorElement);
        if (cursorElement == null) {
            return null;
        }
        IRfScopeElement scope = cursorElement.getScope();
        boolean computePathIfDirty = TestHelper.isTestMode();
        ElementPath fullElementPath = DesignPathManager.getInstance().getPathFor(dvtEditor, dvtEditor.getCursor(), conn, scope, true, computePathIfDirty);
        if (conn instanceof IRfInstanceElement && scope instanceof IRfInstanceElement && fullElementPath != null && fullElementPath != DesignPathManager.FROZEN_MANAGER_EL_PATH && !fullElementPath.isEmpty()) {
            fullElementPath = fullElementPath.removeLastSegment();
        }
        TCViewUtils.startTCEditorJobWithChecks(conn, fullElementPath, fullElementPath != null, false, project, traceOperation);
        return null;
    }

    protected IProject getProject(IEditorPart textEditor) {
        IFile file = this.getFile(textEditor);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    protected IFile getFile(IEditorPart textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    private IRfNamedElement getSignalElement(IProject project, IRfNamedElementAndScope namedElementAndScope) {
        if (project == null) {
            return null;
        }
        DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.VLOG_FAMILY_REPARSE);
        DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.VHDL_FAMILY_REPARSE);
        if (namedElementAndScope == null) {
            return null;
        }
        IRfNamedElement element = namedElementAndScope.getIRfNamedElement();
        if (element == null) {
            return null;
        }
        TCInterfaceInterest interfaceInterest = TCUtils.resolveInterfaceInterest(element);
        switch (interfaceInterest) {
            case MODPORT_OF_INTERFACE: {
                return null;
            }
            case PORT_OF_MODPORT_OR_CLOCKING_BLOCK: {
                if (element instanceof IRfPortElement && element.getEnclosingScope(IRfModportElement.class) != null) {
                    element = ((IRfPortElement)element).getDesignUnitPort();
                }
            }
            case PORT_OF_INTERFACE: 
            case FIELD_OF_INTERFACE: {
                Deque<? extends IRfNamedElementAndScope> stack = namedElementAndScope.getElementAndScopeStack();
                if (stack == null || stack.isEmpty()) break;
                IRfNamedElement particular = null;
                for (IRfNamedElementAndScope iRfNamedElementAndScope : stack) {
                    if (iRfNamedElementAndScope == null) {
                        return null;
                    }
                    IRfNamedElement possParent = iRfNamedElementAndScope.getIRfNamedElement();
                    TCInterfaceInterest possParentInterest = TCUtils.resolveInterfaceInterest(possParent);
                    if (possParentInterest != TCInterfaceInterest.INTERFACE_AS_INSTANCE && possParentInterest != TCInterfaceInterest.INTERFACE_AS_PORT && possParentInterest != TCInterfaceInterest.MODPORT_AS_PORT && possParentInterest != TCInterfaceInterest.VIRTUAL_INTERFACE && possParentInterest != TCInterfaceInterest.VIRTUAL_MODPORT) continue;
                    particular = possParent;
                }
                if (particular == null) break;
                return TCUtils.makeInterfaceSignal(particular, element);
            }
        }
        return DesignUtils.isValidSignalCandidate(element, null) ? element : null;
    }
}

