/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.typehierarchy;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.AbstractTreeInformationControl;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.typehierarchy.GotoDataContainer;
import ro.amiq.dvt.ui.views.typehierarchy.ITHViewContributor;
import ro.amiq.dvt.ui.views.typehierarchy.THViewInput;
import ro.amiq.dvt.ui.views.typehierarchy.THViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;

public class QuickTypeHierarchyView
extends AbstractTreeInformationControl
implements IUpdateJobImpl {
    public static final String ID = "ro.amiq.dvt.ui.views.QuickTypeHierarchyView";
    public static final String TITLE = "Quick Type Hierarchy";
    private static final String DEFAULT_FILTER_HELPER_TEXT = "Filter by: type name";
    private static final List<IDVTElementWrapper> WARNING_MESSAGE_INPUT = new ArrayList<IDVTElementWrapper>(6){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("WARNING!"));
            this.add(new BasicElementWrapper("Functionality for files"));
            this.add(new BasicElementWrapper("outside a project is"));
            this.add(new BasicElementWrapper("limited. Create a project"));
            this.add(new BasicElementWrapper("or use linked resources"));
            this.add(new BasicElementWrapper("to existing project."));
        }
    };
    private static final List<IDVTElementWrapper> UPDATE_JOB_MESSAGE_INPUT = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Updating..."));
        }
    };
    private static final List<ITHViewContributor> fAllHierarchyContributors = DVTViewContributors.getInstance().getAllInstanceOf(ITHViewContributor.class);
    private final Map<LanguageKind, ITHViewContributor> fAllHierarchyContributorsByLanguageKind = new EnumMap<LanguageKind, ITHViewContributor>(LanguageKind.class);
    private final UpdateJob fUpdateJob;
    private boolean fCurrentHierarchyIsFullType = true;
    private boolean fShowSubtypePrefToRestore;
    private boolean fShowSupertypePrefToRestore;
    private boolean fShowTypePrefToRestore;
    private HistoryItem fHistoryItem;
    DVTLabelProviderProxy<ITHViewContributor> fLabelProvider = new DVTLabelProviderProxy<ITHViewContributor>(ITHViewContributor.class, "default-tree");
    private List<IDVTElementWrapper> fElements;

    public QuickTypeHierarchyView(Shell parent, IProject project) {
        super(null, parent, 16, 768, project);
        this.fShowTypePrefToRestore = PrefConst.getTHViewShowType();
        this.fShowSupertypePrefToRestore = PrefConst.getTHViewShowSupertype();
        this.fShowSubtypePrefToRestore = PrefConst.getTHViewShowSubtype();
        PrefConst.setTHViewShowType(this.fCurrentHierarchyIsFullType);
        PrefConst.setTHViewShowSupertype(!this.fCurrentHierarchyIsFullType);
        PrefConst.setTHViewShowSubtype(false);
        this.fUpdateJob = new UpdateJob("Update Quick Layers View", this);
        for (ITHViewContributor contrib : fAllHierarchyContributors) {
            this.fAllHierarchyContributorsByLanguageKind.put(contrib.getLanguageKind(), contrib);
        }
        this.setTextFilterMessage("default-filter", DEFAULT_FILTER_HELPER_TEXT);
    }

    @Override
    protected String getTitle() {
        return TITLE + (this.fProject != null ? " [" + this.fProject.getName() + "]" : "");
    }

    @Override
    protected DVTBaseLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DVTLabelProviderProxy<ITHViewContributor>(ITHViewContributor.class, "default-tree");
        }
        return this.fLabelProvider;
    }

    @Override
    protected String getId() {
        return ID;
    }

    @Override
    protected void fillDialogMenu(IMenuManager viewMenu) {
        super.fillDialogMenu(viewMenu);
    }

    @Override
    public void update() {
        if (this.fProject == null || !this.fProject.isAccessible()) {
            this.setInputWrappers(new ArrayList<IDVTElementWrapper>(WARNING_MESSAGE_INPUT));
            return;
        }
        this.setInputWrappers(new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT));
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.fElements = new ArrayList<IDVTElementWrapper>();
            PrefConst.setTHViewShowType(this.fCurrentHierarchyIsFullType);
            PrefConst.setTHViewShowSupertype(!this.fCurrentHierarchyIsFullType);
            PrefConst.setTHViewShowSubtype(false);
            ITHViewContributor contentProvider = this.getViewContributor(this.fHistoryItem);
            if (contentProvider == null) {
                return;
            }
            if (ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            StringMatcher matcher = this.getStringMatcher("default-filter");
            THViewInput input = contentProvider.getInput(new THViewInputConfigurator(this.fHistoryItem, matcher, matcher, false, false, true, updateJob));
            List<IDVTElementWrapper> hierarchyElems = input.getHierarchyElements();
            if (matcher == null) {
                ViewsUtils.selectElement(contentProvider, null, hierarchyElems, this.fHistoryItem);
            } else {
                ViewsUtils.selectFirstElement(contentProvider, matcher, hierarchyElems);
            }
            this.fElements.addAll(input.getHierarchyElements());
            if (TestHelper.isTestMode()) {
                TestHelper.fQuickHierarchyElements.clear();
            }
            TestHelper.fQuickHierarchyElements.addAll(input.getHierarchyElements());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            if (this.fElements != null) {
                this.setInputWrappers(this.fElements);
            }
            if (this.fCurrentHierarchyIsFullType) {
                this.setInfoText("Search patterns may contain: * = any string, ? = any character.\nPress 'Ctrl+T' to see the supertype hierarchy");
            } else {
                this.setInfoText("Search patterns may contain: * = any string, ? = any character.\nPress 'Ctrl+T' to see the full type hierarchy");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void gotoSelectedElement() {
        Object selectedElement;
        if (this.fProject == null) {
            return;
        }
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper();
        ITHViewContributor contrib = DVTViewContributors.getInstance().getViewContributor(selectedWrapper, ITHViewContributor.class);
        if (contrib != null) {
            contrib.gotoElement(this.fProject, new GotoDataContainer(selectedWrapper, this.fHistoryItem));
        }
        if (!((selectedElement = selectedWrapper.getRfElement()) instanceof DVTLanguageElement) && !(selectedElement instanceof String)) {
            this.close();
        }
    }

    private ITHViewContributor getViewContributor(HistoryItem historyItem) {
        if (historyItem == null) {
            return null;
        }
        return this.fAllHierarchyContributorsByLanguageKind.get((Object)this.fHistoryItem.getLanguage());
    }

    public void setInput(Object information) {
        try {
            if (!DVTPlugin.getDefault().collect().c(this.fProject, "F636F7265")) {
                return;
            }
            if (!(information instanceof UpdateViewEvent)) {
                return;
            }
            this.fHistoryItem = (HistoryItem)information;
            this.setInfoText("Search patterns may contain: * = any string, ? = any character.\nPress 'Ctrl+T' to see the supertype hierarchy");
            this.update();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean close() {
        PrefConst.setTHViewShowSupertype(this.fShowSupertypePrefToRestore);
        PrefConst.setTHViewShowType(this.fShowTypePrefToRestore);
        PrefConst.setTHViewShowSubtype(this.fShowSubtypePrefToRestore);
        return super.close();
    }

    @Override
    public void handleKeyEvent(KeyEvent event) {
        if (event.character == '\u0014') {
            this.fCurrentHierarchyIsFullType = !this.fCurrentHierarchyIsFullType;
            this.update();
            this.updateGuiPart(this.fUpdateJob);
        }
    }

    @Override
    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts) {
        super.createTextFilter(textFilterId, parent, treeId, searchForPorts);
        TextFilterObject createdFilter = this.getTextFilterObject(textFilterId);
        if (createdFilter == null) {
            return;
        }
        createdFilter.getTextFilter().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                QuickTypeHierarchyView.this.handleKeyEvent(e);
            }
        });
    }
}

