/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.typehierarchy;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.guifilters.GUIFiltersHandler;
import ro.amiq.dvt.ui.actions.history.HistoryAction;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.typehierarchy.GotoDataContainer;
import ro.amiq.dvt.ui.views.typehierarchy.ITHViewContributor;
import ro.amiq.dvt.ui.views.typehierarchy.THViewInput;
import ro.amiq.dvt.ui.views.typehierarchy.THViewInputConfigurator;
import ro.amiq.dvt.ui.views.typehierarchy.TypeHierarchyViewCommon;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class TypeHierarchyView
extends TypeHierarchyViewCommon
implements IUpdateJobImpl,
IXvmFactoryInitListener {
    public static final String HIERARCHY_TREE_ID = "htree";
    public static final String MEMBERS_TREE_ID = "mtree";
    public static final String HIERARCHY_FILTER_ID = "hfilter";
    public static final String MEMBERS_FILTER_ID = "mfilter";
    private static final String OVERRIDE_METHODS_ACTION_ID = "ro.amiq.dvt.ui.views.typehierarchy.OverrideAction";
    private static final List<ITHViewContributor> fAllHierarchyContributors = DVTViewContributors.getInstance().getAllInstanceOf(ITHViewContributor.class);
    private final Map<LanguageKind, ITHViewContributor> fAllHierarchyContributorsByLanguageKind = new EnumMap<LanguageKind, ITHViewContributor>(LanguageKind.class);
    private final UpdateJob fUpdateJob;
    private DVTLabelProviderProxy<ITHViewContributor> fLabelProvider = new DVTLabelProviderProxy<ITHViewContributor>(ITHViewContributor.class, "default-tree");
    private Label fGUIFilteredMembersIndication;
    private Label fInfoHierarchy;
    private Tree fHierarchyTree;
    private TreeViewContentProvider fHierarchyTreeContentProvider;
    private List<IDVTElementWrapper> fHierarchyElements;
    private HierarchyHistoryAction fHierarchyHistoryAction = new HierarchyHistoryAction();
    private OverrideMethods fOverrideMethods = new OverrideMethods();
    private ShowTypeAction fShowTypeAction = new ShowTypeAction();
    private ShowSubtypeAction fShowSubtypeAction = new ShowSubtypeAction();
    private ShowSupertypeAction fShowSupertypeAction = new ShowSupertypeAction();
    private PrependPackageAction fPrependPackageAction = new PrependPackageAction();
    private SortByCategory fSortByCategoryAction = new SortByCategory();
    private ShowOnlyPublicAction fShowOnlyPublicAction = new ShowOnlyPublicAction();
    private ShowPredefinedAction fShowPredefinedAction = new ShowPredefinedAction();
    private ShowAllInheritedAction fShowAllInheritedAction = new ShowAllInheritedAction();
    private Tree fMembersTree;
    private TreeViewContentProvider fMembersContentProvider;
    private CLabel fInfoMembers;
    private ToolBarManager fMembersToolBarManager;
    private IDVTElementWrapper fSelectedHierarchyWrapper;
    private IDVTElementWrapper fLastSelectedHierarchyElement = null;
    private boolean fUpdateOnlyMembers = false;
    private boolean fOverrideShowPredefined = false;
    private List<IDVTElementWrapper> fMemberElements;
    private boolean fKeepOldSelection;
    private MenuManager fMembersMenu;
    private boolean fHasGUIFilteredMembers;

    public TypeHierarchyView() {
        this.fUpdateJob = new UpdateJob("Update Hierarchy View", this);
        for (ITHViewContributor viewContributor : fAllHierarchyContributors) {
            this.fAllHierarchyContributorsByLanguageKind.put(viewContributor.getLanguageKind(), viewContributor);
        }
        DVTMixedLangModelManager.getInstance().addXvmFactoryInitListeners(this);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        GridData parentLayoutData = new GridData(4, 4, true, true);
        parent.setLayoutData((Object)parentLayoutData);
        GridLayout hierarchyCompositeLayout = new GridLayout(1, true);
        hierarchyCompositeLayout.marginWidth = 0;
        hierarchyCompositeLayout.marginHeight = 0;
        hierarchyCompositeLayout.verticalSpacing = 0;
        SashForm sashForm = new SashForm(parent, 512);
        Composite hierarchyComposite = new Composite((Composite)sashForm, 0);
        hierarchyComposite.setLayout((Layout)hierarchyCompositeLayout);
        Composite labelComposite = new Composite(hierarchyComposite, 0);
        GridLayout labelLayout = new GridLayout(1, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fInfoHierarchy = new Label(labelComposite, 16384);
        this.fInfoHierarchy.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createTextFilter(HIERARCHY_FILTER_ID, hierarchyComposite, HIERARCHY_TREE_ID, false);
        this.setTextFilterMessage(HIERARCHY_FILTER_ID, "Filter by: name");
        Composite componentTreeComposite = new Composite(hierarchyComposite, 0);
        GridData hierarchyTreeLayoutData = new GridData(4, 4, true, true);
        componentTreeComposite.setLayoutData((Object)hierarchyTreeLayoutData);
        GridLayout hierarchyTreeCompositeLayout = new GridLayout();
        hierarchyTreeCompositeLayout.marginWidth = 0;
        hierarchyTreeCompositeLayout.marginHeight = 0;
        hierarchyTreeCompositeLayout.verticalSpacing = 0;
        componentTreeComposite.setLayout((Layout)hierarchyTreeCompositeLayout);
        this.fHierarchyTree = new Tree(componentTreeComposite, 268436228);
        this.fHierarchyTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.installContextMenuAndSelectionListener((Control)this.fHierarchyTree);
        this.fHierarchyTree.addKeyListener((KeyListener)this.getKeyListener(HIERARCHY_FILTER_ID, HIERARCHY_TREE_ID));
        this.fHierarchyTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TypeHierarchyView.this.gotoSelectedElement(TypeHierarchyView.HIERARCHY_TREE_ID);
                TypeHierarchyView.this.fSelectedHierarchyWrapper = TypeHierarchyView.this.getSelectedWrapper(TypeHierarchyView.HIERARCHY_TREE_ID);
                if (TypeHierarchyView.this.fSelectedHierarchyWrapper == null) {
                    return;
                }
                TypeHierarchyView.this.fLastSelectedHierarchyElement = TypeHierarchyView.this.fSelectedHierarchyWrapper;
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.fHierarchyTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String comment;
                TypeHierarchyView.this.fSelectedHierarchyWrapper = TypeHierarchyView.this.getSelectedWrapper(TypeHierarchyView.HIERARCHY_TREE_ID);
                if (TypeHierarchyView.this.fSelectedHierarchyWrapper == null) {
                    return;
                }
                if (TypeHierarchyView.this.fSelectedHierarchyWrapper.getRfElement() instanceof String) {
                    return;
                }
                if (TypeHierarchyView.this.fLastSelectedHierarchyElement != null && TypeHierarchyView.this.fLastSelectedHierarchyElement == TypeHierarchyView.this.fSelectedHierarchyWrapper) {
                    return;
                }
                TypeHierarchyView.this.fLastSelectedHierarchyElement = TypeHierarchyView.this.fSelectedHierarchyWrapper;
                HistoryItem historyItem = TypeHierarchyView.this.getHistoryItem();
                ITHViewContributor viewContributor = TypeHierarchyView.this.getViewContributor(historyItem);
                if (viewContributor == null) {
                    return;
                }
                LanguageKind languageKind = historyItem.getLanguage();
                if (languageKind == LanguageKind.E || languageKind == LanguageKind.SLN) {
                    if (viewContributor.shouldOverrideShowPredefined(TypeHierarchyView.this.fSelectedHierarchyWrapper)) {
                        TypeHierarchyView.this.fOverrideShowPredefined = true;
                        TypeHierarchyView.this.fShowPredefinedAction.setEnabled(false);
                    } else {
                        TypeHierarchyView.this.fOverrideShowPredefined = false;
                        TypeHierarchyView.this.fShowPredefinedAction.setEnabled(true);
                    }
                }
                if ((comment = viewContributor.getComment(TypeHierarchyView.this.fSelectedHierarchyWrapper)).length() > 150) {
                    comment = String.valueOf(comment.substring(0, 150)) + "...";
                }
                TypeHierarchyView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(comment);
                TypeHierarchyView.this.update(true, false);
            }
        });
        Composite membersComposite = new Composite((Composite)sashForm, 0);
        GridLayout membersCompositeLayout = new GridLayout(1, true);
        membersCompositeLayout.marginWidth = 0;
        membersCompositeLayout.marginHeight = 0;
        membersCompositeLayout.verticalSpacing = 0;
        membersComposite.setLayout((Layout)membersCompositeLayout);
        Composite toolBarComposite = new Composite(membersComposite, 2048);
        GridLayout toolBarCompositeLayout = new GridLayout(4, false);
        toolBarCompositeLayout.marginHeight = 0;
        toolBarCompositeLayout.verticalSpacing = 0;
        toolBarComposite.setLayout((Layout)toolBarCompositeLayout);
        toolBarComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fGUIFilteredMembersIndication = new Label(toolBarComposite, 0);
        this.fGUIFilteredMembersIndication.setImage(DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI));
        this.fGUIFilteredMembersIndication.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        this.fGUIFilteredMembersIndication.setToolTipText("Content Filters matched!");
        this.fGUIFilteredMembersIndication.setEnabled(this.fHasGUIFilteredMembers);
        Label sep = new Label(toolBarComposite, 514);
        GridData sepData = new GridData(32);
        sepData.heightHint = this.fGUIFilteredMembersIndication.computeSize((int)-1, (int)-1).y;
        sep.setLayoutData((Object)sepData);
        this.fInfoMembers = new CLabel(toolBarComposite, 0);
        this.fInfoMembers.setFont(parent.getFont());
        this.fInfoMembers.setLayoutData((Object)new GridData(4, 2, true, true));
        ToolBar membersToolBar = new ToolBar(toolBarComposite, 0x800000);
        membersToolBar.setLayoutData((Object)new GridData(3, 2, false, true));
        this.fMembersToolBarManager = new ToolBarManager(membersToolBar);
        this.createTextFilter(MEMBERS_FILTER_ID, membersComposite, MEMBERS_TREE_ID, false);
        this.setTextFilterMessage(MEMBERS_FILTER_ID, "Filter by: name");
        Composite membersTreeComposite = new Composite(membersComposite, 0);
        GridData membersTreeLayoutData = new GridData(4, 4, true, true);
        membersTreeComposite.setLayoutData((Object)membersTreeLayoutData);
        GridLayout membersTreeCompositeLayout = new GridLayout();
        membersTreeCompositeLayout.marginWidth = 0;
        membersTreeCompositeLayout.marginHeight = 0;
        membersTreeCompositeLayout.verticalSpacing = 0;
        membersTreeComposite.setLayout((Layout)membersTreeCompositeLayout);
        this.fMembersTree = new Tree(membersTreeComposite, 268436228);
        this.fMembersTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fMembersMenu = this.installContextMenuAndSelectionListener((Control)this.fMembersTree);
        this.fMembersTree.addKeyListener((KeyListener)this.getKeyListener(MEMBERS_FILTER_ID, MEMBERS_TREE_ID));
        this.fMembersTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TypeHierarchyView.this.gotoSelectedElement(TypeHierarchyView.MEMBERS_TREE_ID);
            }

            public void mouseDown(MouseEvent e) {
                TypeHierarchyView.this.fMembersTree.setFocus();
                if (TypeHierarchyView.this.isOverrideMethodsActionEnabled()) {
                    ITHViewContributor viewContributor = TypeHierarchyView.this.getViewContributor(TypeHierarchyView.this.getSelectedMemberElement());
                    if (viewContributor != null) {
                        LanguageKind languageKind = viewContributor.getLanguageKind();
                        if (languageKind == LanguageKind.E || languageKind == LanguageKind.SLN) {
                            TypeHierarchyView.this.fOverrideMethods.setAllDescriptionsToText("Override");
                        } else if (languageKind.equals((Object)LanguageKind.VLOG)) {
                            TypeHierarchyView.this.fOverrideMethods.setAllDescriptionsToText("Override");
                        }
                    }
                    TypeHierarchyView.this.fMembersMenu.remove((IContributionItem)new ActionContributionItem((IAction)TypeHierarchyView.this.fOverrideMethods));
                    TypeHierarchyView.this.fMembersMenu.insert(0, (IContributionItem)new ActionContributionItem((IAction)TypeHierarchyView.this.fOverrideMethods));
                    TypeHierarchyView.this.fMembersMenu.insert(1, (IContributionItem)new Separator());
                } else {
                    TypeHierarchyView.this.fMembersMenu.remove((IContributionItem)new ActionContributionItem((IAction)TypeHierarchyView.this.fOverrideMethods));
                }
                TypeHierarchyView.this.fOverrideMethods.setEnabled(TypeHierarchyView.this.isOverrideMethodsActionEnabled());
            }
        });
        this.fMembersTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean overrideMethodsActionEnabled = TypeHierarchyView.this.isOverrideMethodsActionEnabled();
                if (overrideMethodsActionEnabled) {
                    ITHViewContributor viewContributor = TypeHierarchyView.this.getViewContributor(TypeHierarchyView.this.getHistoryItem());
                    if (viewContributor != null) {
                        LanguageKind languageKind = viewContributor.getLanguageKind();
                        if (languageKind == LanguageKind.E || languageKind == LanguageKind.SLN) {
                            TypeHierarchyView.this.fOverrideMethods.setAllDescriptionsToText("Override");
                        } else if (languageKind.equals((Object)LanguageKind.VLOG)) {
                            TypeHierarchyView.this.fOverrideMethods.setAllDescriptionsToText("Override");
                        }
                    }
                    TypeHierarchyView.this.fMembersMenu.remove((IContributionItem)new ActionContributionItem((IAction)TypeHierarchyView.this.fOverrideMethods));
                    TypeHierarchyView.this.fMembersMenu.insert(0, (IContributionItem)new ActionContributionItem((IAction)TypeHierarchyView.this.fOverrideMethods));
                    TypeHierarchyView.this.fMembersMenu.insert(1, (IContributionItem)new Separator());
                } else {
                    TypeHierarchyView.this.fMembersMenu.remove((IContributionItem)new ActionContributionItem((IAction)TypeHierarchyView.this.fOverrideMethods));
                }
                TypeHierarchyView.this.fOverrideMethods.setEnabled(overrideMethodsActionEnabled);
                IDVTElementWrapper selectedMember = TypeHierarchyView.this.getSelectedMemberElement();
                if (selectedMember == null) {
                    return;
                }
                ITHViewContributor viewContributor = TypeHierarchyView.this.getViewContributor(TypeHierarchyView.this.getHistoryItem());
                if (viewContributor == null) {
                    return;
                }
                String comment = viewContributor.getComment(selectedMember);
                if (comment.length() > 150) {
                    comment = String.valueOf(comment.substring(0, 150)) + "...";
                }
                TypeHierarchyView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(comment);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fHierarchyTreeContentProvider = new TreeViewContentProvider(this.fHierarchyTree, this.fLabelProvider);
        this.fMembersContentProvider = new TreeViewContentProvider(this.fMembersTree, this.fLabelProvider);
    }

    private void createToolbar(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager hierarchyToolBarManager = actionBars.getToolBarManager();
        hierarchyToolBarManager.removeAll();
        this.fMembersToolBarManager.removeAll();
        hierarchyToolBarManager.add((IAction)this.fHierarchyHistoryAction);
        hierarchyToolBarManager.add((IContributionItem)new Separator());
        hierarchyToolBarManager.add((IAction)this.fPrependPackageAction);
        hierarchyToolBarManager.add((IContributionItem)new Separator());
        hierarchyToolBarManager.add((IAction)this.fShowTypeAction);
        hierarchyToolBarManager.add((IAction)this.fShowSupertypeAction);
        hierarchyToolBarManager.add((IAction)this.fShowSubtypeAction);
        hierarchyToolBarManager.add((IContributionItem)new Separator());
        hierarchyToolBarManager.add((IAction)new AbstractFilteredView.ExpandAllAction());
        hierarchyToolBarManager.add((IAction)new AbstractFilteredView.CollapseAllAction());
        this.fMembersToolBarManager.add((IAction)new FilterMembersAction(parent));
        this.fMembersToolBarManager.add((IAction)this.fSortByCategoryAction);
        this.fMembersToolBarManager.add((IContributionItem)new Separator());
        this.fMembersToolBarManager.add((IAction)this.fShowOnlyPublicAction);
        this.fMembersToolBarManager.add((IAction)this.fShowPredefinedAction);
        this.fMembersToolBarManager.add((IAction)this.fShowAllInheritedAction);
        this.fMembersToolBarManager.update(true);
        hierarchyToolBarManager.update(true);
    }

    private void addToHistory() {
        HistoryItem historyItem = this.getHistoryItem();
        if (historyItem == null) {
            return;
        }
        this.fHierarchyHistoryAction.addElement(historyItem);
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            UpdateViewEvent ev;
            HistoryItem historyItem = this.getHistoryItem();
            if (historyItem != null && (ev = (UpdateViewEvent)historyItem).getUpdateHistory() == 2) {
                this.addToHistory();
            }
            this.update(false, false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void update(boolean updateOnlyMembers, boolean keepOldSelection) {
        try {
            this.fUpdateOnlyMembers = updateOnlyMembers;
            this.fKeepOldSelection = keepOldSelection;
            if (this.fHierarchyTree == null) {
                return;
            }
            HistoryItem historyItem = this.getHistoryItem();
            if (historyItem == null || !(historyItem instanceof UpdateViewEvent)) {
                this.cleanView();
                return;
            }
            if (this.fUpdateOnlyMembers) {
                this.fMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            } else {
                this.fHierarchyTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            }
            this.fUpdateJob.cancel();
            this.fUpdateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            HistoryItem historyItem = this.getHistoryItem();
            ITHViewContributor viewContributor = this.getViewContributor(historyItem);
            if (viewContributor == null) {
                return;
            }
            if (ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            if (this.fUpdateOnlyMembers) {
                this.fMemberElements = new ArrayList<IDVTElementWrapper>();
                HistoryItem tmpHist = this.getWrapperAsHistoryElement(this.fSelectedHierarchyWrapper, 0);
                if (tmpHist == null) {
                    return;
                }
                THViewInput input = viewContributor.getInput(new THViewInputConfigurator(tmpHist, this.getStringMatcher(HIERARCHY_FILTER_ID), this.getStringMatcher(MEMBERS_FILTER_ID), this.fUpdateOnlyMembers, this.fOverrideShowPredefined, false, updateJob));
                List<IDVTElementWrapper> origElems = input.getMemberElements();
                this.fHasGUIFilteredMembers = input.hasGUIFilteredMembers();
                this.fMemberElements.addAll(origElems);
            } else {
                this.fHierarchyElements = new ArrayList<IDVTElementWrapper>();
                this.fMemberElements = new ArrayList<IDVTElementWrapper>();
                THViewInput input = viewContributor.getInput(new THViewInputConfigurator(historyItem, this.getStringMatcher(HIERARCHY_FILTER_ID), this.getStringMatcher(MEMBERS_FILTER_ID), this.fUpdateOnlyMembers, this.fOverrideShowPredefined, false, updateJob));
                List<IDVTElementWrapper> hierarchyElems = input.getHierarchyElements();
                if (!this.fKeepOldSelection) {
                    ViewsUtils.selectElement(viewContributor, this.getStringMatcher(HIERARCHY_FILTER_ID), hierarchyElems, historyItem);
                    this.setSelectedElement(hierarchyElems);
                    this.fLastSelectedHierarchyElement = this.fSelectedHierarchyWrapper;
                } else {
                    boolean selected = ViewsUtils.selectElement(viewContributor, this.getStringMatcher(HIERARCHY_FILTER_ID), hierarchyElems, this.fLastSelectedHierarchyElement);
                    if (!selected) {
                        ViewsUtils.selectElement(viewContributor, this.getStringMatcher(HIERARCHY_FILTER_ID), hierarchyElems, historyItem);
                        this.setSelectedElement(hierarchyElems);
                        this.fLastSelectedHierarchyElement = this.fSelectedHierarchyWrapper;
                    }
                }
                this.fOverrideShowPredefined = viewContributor.shouldOverrideShowPredefined(this.fSelectedHierarchyWrapper);
                this.fHierarchyElements.addAll(hierarchyElems);
                THViewInput onlyMembersInput = viewContributor.getInput(new THViewInputConfigurator(this.getWrapperAsHistoryElement(this.fSelectedHierarchyWrapper, 0), this.getStringMatcher(HIERARCHY_FILTER_ID), this.getStringMatcher(MEMBERS_FILTER_ID), !this.fUpdateOnlyMembers, this.fOverrideShowPredefined, false, updateJob));
                List<IDVTElementWrapper> memberElems = onlyMembersInput.getMemberElements();
                this.fHasGUIFilteredMembers = onlyMembersInput.hasGUIFilteredMembers();
                this.fMemberElements.addAll(memberElems);
            }
            LanguageKind languageKind = historyItem.getLanguage();
            if (languageKind == LanguageKind.E || languageKind == LanguageKind.SLN) {
                if (viewContributor.shouldOverrideShowPredefined(this.fSelectedHierarchyWrapper)) {
                    this.fOverrideShowPredefined = true;
                    this.fShowPredefinedAction.setEnabled(false);
                } else {
                    this.fOverrideShowPredefined = false;
                    this.fShowPredefinedAction.setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            HistoryItem historyItem = this.getHistoryItem();
            if (historyItem == null) {
                return;
            }
            String cElemInfo = "";
            if (historyItem.getLanguage() == LanguageKind.VLOG) {
                cElemInfo = ((UpdateViewEvent)historyItem).getElementName();
            } else if (historyItem.getLanguage() == LanguageKind.PSS) {
                cElemInfo = ((UpdateViewEvent)historyItem).getElementName();
            } else if (historyItem.getLanguage() == LanguageKind.MSDL) {
                cElemInfo = ((UpdateViewEvent)historyItem).getElementName();
            } else {
                cElemInfo = ((UpdateViewEvent)historyItem).getEdtElementFullName().toString();
                if (cElemInfo.contains(".")) {
                    cElemInfo = cElemInfo.split("\\.")[1];
                }
            }
            if (this.fHierarchyElements.isEmpty() && !this.fUpdateOnlyMembers) {
                this.fExpandLevel = -1;
                StringMatcher stringMatcher = this.getStringMatcher(HIERARCHY_FILTER_ID);
                if (stringMatcher != null && !stringMatcher.getPattern().isEmpty()) {
                    this.fHierarchyTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND), this.fExpandLevel);
                    this.fMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(), this.fExpandLevel);
                } else {
                    this.fHierarchyTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
                    this.fMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(), this.fExpandLevel);
                }
                this.fInfoMembers.setText("");
                this.fInfoMembers.setImage(null);
                this.getTextFilter(MEMBERS_FILTER_ID).setEnabled(false);
                this.createToolbar((Composite)this.getViewSite().getShell());
                return;
            }
            this.getTextFilter(MEMBERS_FILTER_ID).setEnabled(true);
            IProject project = this.getProject();
            if (this.fHierarchyTreeContentProvider != null && this.fMembersContentProvider != null && this.fHierarchyElements != null && this.fInfoHierarchy != null && project != null) {
                if (!this.fUpdateOnlyMembers) {
                    this.fHierarchyTreeContentProvider.setInput(this.fHierarchyElements, this.fExpandLevel);
                }
                StringMatcher stringMatcher = this.getStringMatcher(MEMBERS_FILTER_ID);
                if (this.fMemberElements.isEmpty()) {
                    if (stringMatcher != null && !stringMatcher.getPattern().isEmpty()) {
                        this.fMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND), this.fExpandLevel);
                    } else if (this.fHasGUIFilteredMembers) {
                        this.fMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
                    } else {
                        this.fMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
                    }
                } else {
                    this.fMembersContentProvider.setInput(this.fMemberElements, this.fExpandLevel);
                }
                ITHViewContributor viewContributor = this.getViewContributor(historyItem);
                if (viewContributor == null || this.fSelectedHierarchyWrapper == null || !(historyItem instanceof UpdateViewEvent)) {
                    this.fGUIFilteredMembersIndication.setEnabled(false);
                    this.fInfoHierarchy.setText("[No class selected]");
                    ProjectColorUtils.setFgBg(this, null);
                    this.fInfoMembers.setText("");
                    this.fInfoMembers.setImage(null);
                    return;
                }
                String text = this.fLabelProvider.getText(this.fSelectedHierarchyWrapper);
                this.fInfoMembers.setText(text);
                this.fInfoMembers.setImage(this.fLabelProvider.getImage(this.fSelectedHierarchyWrapper));
                this.fGUIFilteredMembersIndication.setEnabled(this.fHasGUIFilteredMembers);
                this.fInfoHierarchy.setText("[" + project.getName() + "] " + cElemInfo);
                ProjectColorUtils.setFgBg(this, project.getName());
                this.fMembersToolBarManager.update(true);
            }
            this.createToolbar((Composite)this.getViewSite().getShell());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void cleanView() {
        this.fInfoHierarchy.setText("");
        ProjectColorUtils.setFgBg(this, null);
        this.fGUIFilteredMembersIndication.setEnabled(false);
        this.fHierarchyTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_TYPE_HIERARCHY_VIEW), this.fExpandLevel);
        this.fMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(), this.fExpandLevel);
        this.getTextFilter(MEMBERS_FILTER_ID).setEnabled(false);
        this.fInfoMembers.setText("");
        this.fInfoMembers.setImage(null);
        this.fOverrideMethods.setEnabled(false);
        this.createToolbar((Composite)this.getViewSite().getShell());
    }

    private boolean setSelectedElement(List<IDVTElementWrapper> elements) {
        for (IDVTElementWrapper wrapper : elements) {
            if (wrapper.getSelectedElement() != null) {
                this.fSelectedHierarchyWrapper = wrapper;
                return true;
            }
            List<IDVTElementWrapper> children = wrapper.getChildren();
            if (children == null || children.isEmpty() || !this.setSelectedElement(children)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.fHierarchyTree != null && !this.fHierarchyTree.isDisposed()) {
            this.fHierarchyTree.dispose();
        }
        if (this.fInfoHierarchy != null && !this.fInfoHierarchy.isDisposed()) {
            this.fInfoHierarchy.dispose();
        }
        if (this.fGUIFilteredMembersIndication != null && !this.fGUIFilteredMembersIndication.isDisposed()) {
            this.fGUIFilteredMembersIndication.dispose();
        }
        this.fHierarchyTree = null;
        this.fInfoHierarchy = null;
        this.fHierarchyTreeContentProvider = null;
        this.fGUIFilteredMembersIndication = null;
        DVTMixedLangModelManager.getInstance().removeXvmFactoryInitListeners(this);
        super.dispose();
    }

    public void setFocus() {
        this.fHierarchyTree.setFocus();
    }

    private ITHViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, ITHViewContributor.class);
    }

    private ITHViewContributor getViewContributor(HistoryItem historyItem) {
        if (historyItem == null) {
            return null;
        }
        return this.fAllHierarchyContributorsByLanguageKind.get((Object)historyItem.getLanguage());
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper(treeId);
        ITHViewContributor viewContributor = this.getViewContributor(selectedWrapper);
        if (selectedWrapper == null || viewContributor == null) {
            return;
        }
        viewContributor.gotoElement(this.getProject(), new GotoDataContainer(selectedWrapper, this.getHistoryItem()));
    }

    @Override
    public Tree getTree(String treeId) {
        if (treeId.equals(MEMBERS_TREE_ID)) {
            return this.fMembersTree;
        }
        return this.fHierarchyTree;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        if (treeId.equals(MEMBERS_TREE_ID)) {
            return this.fMemberElements;
        }
        return this.fHierarchyElements;
    }

    private boolean isOverrideMethodsActionEnabled() {
        TreeItem[] selMember = this.fMembersTree.getSelection();
        TreeItem[] selHierarchy = this.fHierarchyTree.getSelection();
        if (selMember == null || selMember.length == 0 || !(selMember[0].getData() instanceof IDVTElementWrapper)) {
            return false;
        }
        if (selHierarchy == null || selHierarchy.length == 0 || !(selHierarchy[0].getData() instanceof IDVTElementWrapper)) {
            return false;
        }
        IDVTElementWrapper selMemberWrapper = (IDVTElementWrapper)selMember[0].getData();
        IDVTElementWrapper selHierarchyWrapper = (IDVTElementWrapper)selHierarchy[0].getData();
        if (selHierarchyWrapper == null || selMemberWrapper == null) {
            return false;
        }
        ITHViewContributor viewContributor = this.getViewContributor(this.getHistoryItem());
        if (viewContributor == null) {
            return false;
        }
        return viewContributor.canShowOverrideMethodMenuEntry(selHierarchyWrapper, selMemberWrapper);
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.fHierarchyTree.setRedraw(false);
            this.fMembersTree.setRedraw(false);
            if (textFilterId.equals(MEMBERS_FILTER_ID)) {
                this.update(true, false);
            } else {
                this.update(false, false);
            }
            this.fHierarchyTree.setRedraw(true);
            this.fMembersTree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private HistoryItem getWrapperAsHistoryElement(IDVTElementWrapper selHierarchyWrapper, int updateHistory) {
        if (selHierarchyWrapper == null) {
            return null;
        }
        ITHViewContributor viewContributor = this.getViewContributor(this.getHistoryItem());
        if (viewContributor == null) {
            return null;
        }
        return viewContributor.createHistoryItemForWrapper(selHierarchyWrapper, this.getProject(), updateHistory);
    }

    private IDVTElementWrapper getSelectedMemberElement() {
        TreeItem[] sel = this.fMembersTree.getSelection();
        if (sel == null || sel.length == 0 || sel[0].getData() == null) {
            return null;
        }
        if (!(sel[0].getData() instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)sel[0].getData();
    }

    @Override
    public ISelection getSelection() {
        if (this.fMembersTree.isFocusControl()) {
            return this.getSelection(MEMBERS_TREE_ID);
        }
        return this.getSelection(HIERARCHY_TREE_ID);
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void clean() {
        this.fUpdateJob.cancel();
        this.fHierarchyTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
        this.fMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(), this.fExpandLevel);
        ProjectColorUtils.setFgBg(this, null);
        this.fInfoMembers.setText("");
        this.fInfoMembers.setImage(null);
        this.getTextFilter(MEMBERS_FILTER_ID).setEnabled(false);
    }

    public DVTBaseLabelProvider testGetLabelProvider() {
        return this.fLabelProvider;
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return this.fHierarchyTreeContentProvider;
    }

    @Override
    public Control getControlToColorBg() {
        return this.fInfoHierarchy.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.fInfoHierarchy;
    }

    @Override
    public void postXvmReadyUpdate() {
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    class FilterMembersAction
    extends Action {
        private Composite fParent;

        public FilterMembersAction(Composite parent) {
            super("&Filters...", 1);
            this.setImageDescriptor(DVTImages.FILTER);
            this.fParent = parent;
        }

        public void run() {
            if (TypeHierarchyView.this.getHistoryItem() == null) {
                return;
            }
            StatusDialog dialog = new StatusDialog(this.fParent.getShell()){
                private CheckboxTableViewer fCheckBoxList;

                protected Control createDialogArea(Composite parent) {
                    Composite containerComposite = new Composite(parent, 0);
                    GridLayout containerCompositeLayout = new GridLayout();
                    containerCompositeLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
                    containerCompositeLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                    containerCompositeLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
                    containerCompositeLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                    containerComposite.setLayout((Layout)containerCompositeLayout);
                    containerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                    containerComposite.setFont(parent.getFont());
                    Label info = new Label(containerComposite, 16384);
                    info.setText("S&elect the elements to include on the view:");
                    this.fCheckBoxList = CheckboxTableViewer.newCheckList((Composite)containerComposite, (int)2048);
                    this.fCheckBoxList.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
                    this.fCheckBoxList.setLabelProvider(this.createLabelProvider());
                    this.fCheckBoxList.setContentProvider((IContentProvider)new ArrayContentProvider());
                    Composite buttons = new Composite(containerComposite, 0);
                    GridLayout buttonsLayout = new GridLayout(2, false);
                    buttonsLayout.marginWidth = 0;
                    buttonsLayout.marginHeight = 0;
                    buttons.setLayout((Layout)buttonsLayout);
                    buttons.setLayoutData((Object)new GridData(131072, 1024, true, true, 2, 1));
                    Button selectAll = new Button(buttons, 0);
                    selectAll.setText("Select All");
                    Button deselectAll = new Button(buttons, 0);
                    deselectAll.setText("Deselect All");
                    HistoryItem historyItem = TypeHierarchyView.this.getHistoryItem();
                    LanguageKind languageKind = historyItem.getLanguage();
                    if (languageKind == LanguageKind.VLOG) {
                        this.fCheckBoxList.setInput((Object)new String[]{"Show fields", "Show events", "Show functions", "Show tasks", "Show [declaration class]"});
                        this.fCheckBoxList.setChecked((Object)"Show fields", PrefConst.getTHViewShowFields());
                        this.fCheckBoxList.setChecked((Object)"Show events", PrefConst.getTHViewShowEvents());
                        this.fCheckBoxList.setChecked((Object)"Show functions", PrefConst.getTHViewShowFunctions());
                        this.fCheckBoxList.setChecked((Object)"Show tasks", PrefConst.getTHViewShowTasks());
                        this.fCheckBoxList.setChecked((Object)"Show [declaration class]", PrefConst.getTHViewShowDefinitionLayer());
                        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)"Show fields", true);
                                fCheckBoxList.setChecked((Object)"Show events", true);
                                fCheckBoxList.setChecked((Object)"Show functions", true);
                                fCheckBoxList.setChecked((Object)"Show tasks", true);
                                fCheckBoxList.setChecked((Object)"Show [declaration class]", true);
                            }
                        });
                        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)"Show fields", false);
                                fCheckBoxList.setChecked((Object)"Show events", false);
                                fCheckBoxList.setChecked((Object)"Show functions", false);
                                fCheckBoxList.setChecked((Object)"Show tasks", false);
                                fCheckBoxList.setChecked((Object)"Show [declaration class]", false);
                            }
                        });
                    } else if (languageKind == LanguageKind.E || languageKind == LanguageKind.SLN) {
                        this.fCheckBoxList.setInput((Object)new String[]{"Show fields", "Show events", "Show methods", "Show [declaration class]"});
                        this.fCheckBoxList.setChecked((Object)"Show fields", PrefConst.getTHViewShowFields());
                        this.fCheckBoxList.setChecked((Object)"Show events", PrefConst.getTHViewShowEvents());
                        this.fCheckBoxList.setChecked((Object)"Show methods", PrefConst.getTHViewShowMethods());
                        this.fCheckBoxList.setChecked((Object)"Show [declaration class]", PrefConst.getTHViewShowDefinitionLayer());
                        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)"Show fields", true);
                                fCheckBoxList.setChecked((Object)"Show events", true);
                                fCheckBoxList.setChecked((Object)"Show methods", true);
                                fCheckBoxList.setChecked((Object)"Show [declaration class]", true);
                            }
                        });
                        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)"Show fields", false);
                                fCheckBoxList.setChecked((Object)"Show events", false);
                                fCheckBoxList.setChecked((Object)"Show methods", false);
                                fCheckBoxList.setChecked((Object)"Show [declaration class]", false);
                            }
                        });
                    } else if (languageKind == LanguageKind.PSS) {
                        this.fCheckBoxList.setInput((Object)new String[]{"Show fields", "Show functions", "Show [declaration class]"});
                        this.fCheckBoxList.setChecked((Object)"Show fields", PrefConst.getTHViewShowFields());
                        this.fCheckBoxList.setChecked((Object)"Show functions", PrefConst.getTHViewShowFunctions());
                        this.fCheckBoxList.setChecked((Object)"Show [declaration class]", PrefConst.getTHViewShowDefinitionLayer());
                        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)"Show fields", true);
                                fCheckBoxList.setChecked((Object)"Show functions", true);
                                fCheckBoxList.setChecked((Object)"Show [declaration class]", true);
                            }
                        });
                        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)"Show fields", false);
                                fCheckBoxList.setChecked((Object)"Show functions", false);
                                fCheckBoxList.setChecked((Object)"Show [declaration class]", false);
                            }
                        });
                    }
                    1.applyDialogFont((Control)containerComposite);
                    return containerComposite;
                }

                private IBaseLabelProvider createLabelProvider() {
                    return new LabelProvider(){

                        public Image getImage(Object element) {
                            return null;
                        }

                        public String getText(Object element) {
                            if (element instanceof String) {
                                return (String)element;
                            }
                            return null;
                        }
                    };
                }

                protected void okPressed() {
                    HistoryItem historyItem = TypeHierarchyView.this.getHistoryItem();
                    if (historyItem == null) {
                        return;
                    }
                    LanguageKind languageKind = historyItem.getLanguage();
                    if (languageKind == LanguageKind.VLOG) {
                        PrefConst.setTHViewShowFields(this.fCheckBoxList.getChecked((Object)"Show fields"));
                        PrefConst.setTHViewShowEvents(this.fCheckBoxList.getChecked((Object)"Show events"));
                        PrefConst.setTHViewShowFunctions(this.fCheckBoxList.getChecked((Object)"Show functions"));
                        PrefConst.setTHViewShowTasks(this.fCheckBoxList.getChecked((Object)"Show tasks"));
                        PrefConst.setTHViewShowDefinitionLayer(this.fCheckBoxList.getChecked((Object)"Show [declaration class]"));
                    } else if (languageKind == LanguageKind.E || languageKind == LanguageKind.SLN) {
                        PrefConst.setTHViewShowFields(this.fCheckBoxList.getChecked((Object)"Show fields"));
                        PrefConst.setTHViewShowEvents(this.fCheckBoxList.getChecked((Object)"Show events"));
                        PrefConst.setTHViewShowMethods(this.fCheckBoxList.getChecked((Object)"Show methods"));
                        PrefConst.setTHViewShowDefinitionLayer(this.fCheckBoxList.getChecked((Object)"Show [declaration class]"));
                    } else if (languageKind == LanguageKind.PSS) {
                        PrefConst.setTHViewShowFields(this.fCheckBoxList.getChecked((Object)"Show fields"));
                        PrefConst.setTHViewShowFunctions(this.fCheckBoxList.getChecked((Object)"Show functions"));
                        PrefConst.setTHViewShowDefinitionLayer(this.fCheckBoxList.getChecked((Object)"Show [declaration class]"));
                    }
                    super.okPressed();
                    boolean filtering = GUIFiltersHandler.isFilteringEnabled();
                    DVTViewManager.loadGuiFilters(DVTPlugin.getSelectionManager().getLastSelectedProject(), filtering);
                    TypeHierarchyView.this.update(true, false);
                }
            };
            dialog.setTitle("Type Hierarchy View Member Filters");
            dialog.setHelpAvailable(false);
            dialog.open();
        }
    }

    class HierarchyHistoryAction
    extends HistoryAction {
        HierarchyHistoryAction() {
        }

        @Override
        public void openHistoryItem(HistoryItem item) {
            IProject newProject = Utils.getProject(((UpdateViewEvent)item).getProjectName());
            TypeHierarchyView.this.setInput(new ViewDataContainer(newProject, item));
            TypeHierarchyView.this.update(null);
        }

        @Override
        public boolean checkHistoryItem(HistoryItem item) {
            return true;
        }
    }

    class OverrideMethods
    extends Action {
        OverrideMethods() {
            super("Override");
            this.setDescription("Override");
            this.setToolTipText("Override");
        }

        public String getActionDefinitionId() {
            return super.getActionDefinitionId();
        }

        public String getId() {
            return TypeHierarchyView.OVERRIDE_METHODS_ACTION_ID;
        }

        public void run() {
            TreeItem[] selMember = TypeHierarchyView.this.fMembersTree.getSelection();
            TreeItem[] selHierarchy = TypeHierarchyView.this.fHierarchyTree.getSelection();
            if (selMember == null || selMember.length == 0 || !(selMember[0].getData() instanceof IDVTElementWrapper)) {
                return;
            }
            if (selHierarchy == null || selHierarchy.length == 0 || !(selHierarchy[0].getData() instanceof IDVTElementWrapper)) {
                return;
            }
            IDVTElementWrapper selMemberWrapper = (IDVTElementWrapper)selMember[0].getData();
            IDVTElementWrapper selHierarchyWrapper = (IDVTElementWrapper)selHierarchy[0].getData();
            if (selHierarchyWrapper != null && selMemberWrapper != null) {
                ITHViewContributor viewContributor = TypeHierarchyView.this.getViewContributor(TypeHierarchyView.this.getHistoryItem());
                if (viewContributor == null) {
                    return;
                }
                viewContributor.overrideMethod(selHierarchyWrapper, selMemberWrapper);
            }
        }

        public void setAllDescriptionsToText(String text) {
            this.setText(text);
            this.setDescription(text);
            this.setToolTipText(text);
        }
    }

    class PrependPackageAction
    extends Action {
        public PrependPackageAction() {
            super("Prepend Package Name", 2);
            this.setDescription("Prepend Package Name");
            this.setToolTipText("Prepend Package Name");
            this.setImageDescriptor(DVTImages.PREPEND_PACKAGE);
            this.setChecked(PrefConst.getTHViewPrependPackage());
        }

        public void run() {
            PrefConst.setTHViewPrependPackage(this.isChecked());
            TypeHierarchyView.this.update(false, true);
        }
    }

    class ShowAllInheritedAction
    extends Action {
        ShowAllInheritedAction() {
            super("Show All Inherited Members", 2);
            this.setDescription("Show All Inherited Members");
            this.setToolTipText("Show All Inherited Members");
            this.setImageDescriptor(DVTImages.INHER_CO);
            this.setChecked(PrefConst.getTHViewShowAllInherited());
        }

        public void run() {
            PrefConst.setTHViewShowAllInherited(this.isChecked());
            TypeHierarchyView.this.update(true, false);
        }
    }

    class ShowOnlyPublicAction
    extends Action {
        ShowOnlyPublicAction() {
            super("Show Only Public Members", 2);
            this.setDescription("Show Only Public Members");
            this.setToolTipText("Show Only Public Members");
            this.setImageDescriptor(DVTImages.SHOW_PUBLIC);
            this.setChecked(PrefConst.getTHViewShowOnlyPublic());
        }

        public void run() {
            PrefConst.setTHViewShowOnlyPublic(this.isChecked());
            TypeHierarchyView.this.update(true, false);
        }
    }

    class ShowPredefinedAction
    extends Action {
        ShowPredefinedAction() {
            super("Show All Predefined Members", 2);
            this.setDescription("Show All Predefined Members");
            this.setToolTipText("Show All Predefined Members");
            this.setImageDescriptor(DVTImages.SHOW_PREDEFINED);
            this.setChecked(PrefConst.getTHViewShowPredefined());
        }

        public void run() {
            PrefConst.setTHViewShowPredefined(this.isChecked());
            TypeHierarchyView.this.update(true, false);
        }
    }

    class ShowSubtypeAction
    extends Action {
        ShowSubtypeAction() {
            super("Show Subtype Hierarchy", 8);
            this.setDescription("Show Subtype Hierarchy");
            this.setToolTipText("Show Subtype Hierarchy");
            this.setImageDescriptor(DVTImages.SUB_CO);
            this.setChecked(PrefConst.getTHViewShowSubtype());
        }

        public void run() {
            PrefConst.setTHViewShowSubtype(this.isChecked());
            if (this.isChecked()) {
                TypeHierarchyView.this.update(false, true);
            }
        }
    }

    class ShowSupertypeAction
    extends Action {
        ShowSupertypeAction() {
            super("Show Supertype Hierarchy", 8);
            this.setDescription("Show Supertype Hierarchy");
            this.setToolTipText("Show Supertype Hierarchy");
            this.setImageDescriptor(DVTImages.SUPER_CO);
            this.setChecked(PrefConst.getTHViewShowSupertype());
        }

        public void run() {
            PrefConst.setTHViewShowSupertype(this.isChecked());
            if (this.isChecked()) {
                TypeHierarchyView.this.update(false, true);
            }
        }
    }

    class ShowTypeAction
    extends Action {
        ShowTypeAction() {
            super("Show Full Type Hierarchy", 8);
            this.setDescription("Show Full Type Hierarchy");
            this.setToolTipText("Show Full Type Hierarchy");
            this.setImageDescriptor(DVTImages.HIERARCHY_CO);
            this.setChecked(PrefConst.getTHViewShowType());
        }

        public void run() {
            PrefConst.setTHViewShowType(this.isChecked());
            if (this.isChecked()) {
                TypeHierarchyView.this.update(false, true);
            }
        }
    }

    class SortByCategory
    extends Action {
        SortByCategory() {
            super("Category Sort", 2);
            this.setDescription("Sort by Category");
            this.setToolTipText("Sort Members by Category");
            this.setImageDescriptor(DVTImages.CATEGORY_SORT);
            this.setChecked(PrefConst.getTHViewSortByCategory());
        }

        public void run() {
            PrefConst.setTHViewSortByCategory(this.isChecked());
            TypeHierarchyView.this.update(true, false);
        }
    }
}

