/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.uvm.hierarchy;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.guifilters.GUIFiltersHandler;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.uvm.hierarchy.IXVMBrowserViewContributor;
import ro.amiq.dvt.ui.views.uvm.hierarchy.XVMBrowserViewCommon;
import ro.amiq.dvt.ui.views.uvm.hierarchy.XVMBrowserViewInput;
import ro.amiq.dvt.ui.views.uvm.hierarchy.XVMBrowserViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class XVMBrowserView
extends XVMBrowserViewCommon
implements IUpdateJobImpl,
IPropertyChangeListener,
IRfFilterableTreeAccessor,
IXvmFactoryInitListener {
    public static final String COMPONENTS_TREE_ID = "ctree";
    public static final String MEMBERS_TREE_ID = "mtree";
    public static final String COMPONENTS_FILTER_ID = "cfilter";
    public static final String MEMBERS_FILTER_ID = "mfilter";
    private static final String OVERRIDE_METHODS_ACTION_ID = "ro.amiq.dvt.views.hierarchy.OverrideAction";
    private static final List<IDVTElementWrapper> UPDATE_JOB_MESSAGE_INPUT = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Updating..."));
        }
    };
    private static final String XVM_BROWSER_DIALOG_TITLE = "UVM Browser View Member Filters";
    private static final List<IXVMBrowserViewContributor> fAllXVMBrowserContributors = DVTViewContributors.getInstance().getAllInstanceOf(IXVMBrowserViewContributor.class);
    private final Map<LanguageKind, IXVMBrowserViewContributor> fAllXVMBrowserContributorsByLanguageKind = new EnumMap<LanguageKind, IXVMBrowserViewContributor>(LanguageKind.class);
    private final UpdateJob fUpdateJob;
    private DVTLabelProviderProxy<IXVMBrowserViewContributor> fLabelProvider = new DVTLabelProviderProxy<IXVMBrowserViewContributor>(IXVMBrowserViewContributor.class, "default-tree");
    private Label fMembersContentFiltersLabel;
    private Label fTreeContentFiltersLabel;
    private Label fInfoComponents;
    private Tree fXVMComponentsTree;
    private TreeViewContentProvider fXVMComponentsTreeContentProvider;
    private List<IDVTElementWrapper> fXVMComponentsElements;
    private OverrideMethods fOverrideMethods = new OverrideMethods();
    private GroupByPackageAction fGroupByPackageAction = new GroupByPackageAction();
    private PrependPackageAction fPrependPackageAction = new PrependPackageAction();
    private XVMMembersAction fXVMMembersAction = new XVMMembersAction();
    private FilterMembersAction fFilterMembersAction;
    private SortByCategory fSortByCategoryAction = new SortByCategory();
    private ShowOnlyPublicAction fShowOnlyPublicAction = new ShowOnlyPublicAction();
    private ShowPredefinedAction fShowPredefinedAction = new ShowPredefinedAction();
    private ShowAllInheritedAction fShowAllInheritedAction = new ShowAllInheritedAction();
    private Tree fMembersTree;
    private TreeViewContentProvider fXVMMembersContentProvider;
    private CLabel fInfoMembers;
    private ToolBarManager fMembersToolBarManager;
    private IDVTElementWrapper fSelectedComponentWrapper;
    private IDVTElementWrapper fLastSelectedComponentElement = null;
    private boolean fUpdateOnlyMembers = false;
    private List<IDVTElementWrapper> fMemberElements;
    private boolean fKeepOldSelection;
    private MenuManager fMembersMenu;
    private boolean fHasGUIFilteredMembers;
    private boolean fHasGUIFilteredTree;
    private boolean fHasSearchedElementFiltered;
    private boolean fHasSearchedMemberFiltered;
    private Image fContentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image fContentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);

    public XVMBrowserView() {
        this.fUpdateJob = new UpdateJob("Update UVM Browser View", this);
        for (IXVMBrowserViewContributor viewContributor : fAllXVMBrowserContributors) {
            this.fAllXVMBrowserContributorsByLanguageKind.put(viewContributor.getLanguageKind(), viewContributor);
        }
        DVTMixedLangModelManager.getInstance().addXvmFactoryInitListeners(this);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.vlogdt.help.XVMBrowserView");
        GridData parentLayoutData = new GridData(4, 4, true, true);
        parent.setLayoutData((Object)parentLayoutData);
        GridLayout componentCompositeLayout = new GridLayout(1, true);
        componentCompositeLayout.marginWidth = 0;
        componentCompositeLayout.marginHeight = 0;
        componentCompositeLayout.verticalSpacing = 0;
        SashForm sashForm = new SashForm(parent, 512);
        Composite componentComposite = new Composite((Composite)sashForm, 0);
        componentComposite.setLayout((Layout)componentCompositeLayout);
        Composite labelComposite = new Composite(componentComposite, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fTreeContentFiltersLabel = new Label(labelComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.fTreeContentFiltersLabel.setImage(this.fHasGUIFilteredTree ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
        } else {
            this.fTreeContentFiltersLabel.setImage(this.fContentFiltersEnabledIcon);
        }
        this.fTreeContentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fTreeContentFiltersLabel.setToolTipText("Content Filters matched!");
        this.fTreeContentFiltersLabel.setEnabled(this.fHasGUIFilteredTree);
        this.fInfoComponents = new Label(labelComposite, 16384);
        this.fInfoComponents.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createTextFilter(COMPONENTS_FILTER_ID, componentComposite, COMPONENTS_TREE_ID, false);
        this.setTextFilterMessage(COMPONENTS_FILTER_ID, "Filter by: name");
        Composite componentTreeComposite = new Composite(componentComposite, 0);
        GridData componentTreeLayoutData = new GridData(4, 4, true, true);
        componentTreeComposite.setLayoutData((Object)componentTreeLayoutData);
        GridLayout componentTreeCompositeLayout = new GridLayout();
        componentTreeCompositeLayout.marginWidth = 0;
        componentTreeCompositeLayout.marginHeight = 0;
        componentTreeCompositeLayout.verticalSpacing = 0;
        componentTreeComposite.setLayout((Layout)componentTreeCompositeLayout);
        this.fXVMComponentsTree = new Tree(componentTreeComposite, 268436228);
        this.fXVMComponentsTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.installContextMenuAndSelectionListener((Control)this.fXVMComponentsTree);
        this.fXVMComponentsTree.addKeyListener((KeyListener)this.getKeyListener(COMPONENTS_FILTER_ID, COMPONENTS_TREE_ID));
        this.fXVMComponentsTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                XVMBrowserView.this.gotoSelectedElement(XVMBrowserView.COMPONENTS_TREE_ID);
                XVMBrowserView.this.fSelectedComponentWrapper = XVMBrowserView.this.getSelectedWrapper(XVMBrowserView.COMPONENTS_TREE_ID);
                if (XVMBrowserView.this.fSelectedComponentWrapper == null) {
                    return;
                }
                XVMBrowserView.this.fLastSelectedComponentElement = XVMBrowserView.this.fSelectedComponentWrapper;
                HistoryItem tmpHist = XVMBrowserView.this.getWrapperAsHistoryElement(XVMBrowserView.this.fSelectedComponentWrapper, 0);
                if (tmpHist == null) {
                    return;
                }
            }
        });
        this.fXVMComponentsTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                XVMBrowserView.this.fSelectedComponentWrapper = XVMBrowserView.this.getSelectedWrapper(XVMBrowserView.COMPONENTS_TREE_ID);
                if (XVMBrowserView.this.fSelectedComponentWrapper == null) {
                    return;
                }
                if (XVMBrowserView.this.fLastSelectedComponentElement != null && XVMBrowserView.this.fLastSelectedComponentElement == XVMBrowserView.this.fSelectedComponentWrapper) {
                    return;
                }
                XVMBrowserView.this.fLastSelectedComponentElement = XVMBrowserView.this.fSelectedComponentWrapper;
                IXVMBrowserViewContributor viewContributor = XVMBrowserView.this.getViewContributor(XVMBrowserView.this.fLastSelectedComponentElement);
                if (viewContributor == null) {
                    return;
                }
                String comment = viewContributor.getComment(XVMBrowserView.this.fSelectedComponentWrapper);
                if (comment.length() > 150) {
                    comment = String.valueOf(comment.substring(0, 150)) + "...";
                }
                XVMBrowserView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(comment);
                XVMBrowserView.this.update(true, false);
            }
        });
        Composite membersComposite = new Composite((Composite)sashForm, 0);
        GridLayout membersCompositeLayout = new GridLayout(1, true);
        membersCompositeLayout.marginWidth = 0;
        membersCompositeLayout.marginHeight = 0;
        membersCompositeLayout.verticalSpacing = 0;
        membersComposite.setLayout((Layout)membersCompositeLayout);
        Composite toolBarComposite = new Composite(membersComposite, 2048);
        GridLayout toolBarCompositeLayout = new GridLayout(4, false);
        toolBarCompositeLayout.marginHeight = 0;
        toolBarCompositeLayout.verticalSpacing = 0;
        toolBarComposite.setLayout((Layout)toolBarCompositeLayout);
        toolBarComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fMembersContentFiltersLabel = new Label(toolBarComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.fMembersContentFiltersLabel.setImage(this.fHasGUIFilteredMembers ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
        } else {
            this.fMembersContentFiltersLabel.setImage(this.fContentFiltersEnabledIcon);
        }
        this.fMembersContentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        this.fMembersContentFiltersLabel.setToolTipText("Content Filters matched!");
        this.fMembersContentFiltersLabel.setEnabled(this.fHasGUIFilteredMembers);
        Label sep = new Label(toolBarComposite, 514);
        GridData sepData = new GridData(32);
        sepData.heightHint = this.fMembersContentFiltersLabel.computeSize((int)-1, (int)-1).y;
        sep.setLayoutData((Object)sepData);
        this.fInfoMembers = new CLabel(toolBarComposite, 0);
        this.fInfoMembers.setFont(parent.getFont());
        this.fInfoMembers.setLayoutData((Object)new GridData(4, 2, true, true));
        ToolBar membersToolBar = new ToolBar(toolBarComposite, 0x800000);
        membersToolBar.setLayoutData((Object)new GridData(3, 2, false, true));
        this.fMembersToolBarManager = new ToolBarManager(membersToolBar);
        this.createTextFilter(MEMBERS_FILTER_ID, membersComposite, MEMBERS_TREE_ID, false);
        this.setTextFilterMessage(MEMBERS_FILTER_ID, "Filter by: name");
        Composite membersTreeComposite = new Composite(membersComposite, 0);
        GridData membersTreeLayoutData = new GridData(4, 4, true, true);
        membersTreeComposite.setLayoutData((Object)membersTreeLayoutData);
        GridLayout membersTreeCompositeLayout = new GridLayout();
        membersTreeCompositeLayout.marginWidth = 0;
        membersTreeCompositeLayout.marginHeight = 0;
        membersTreeCompositeLayout.verticalSpacing = 0;
        membersTreeComposite.setLayout((Layout)membersTreeCompositeLayout);
        this.createToolbar((Composite)this.getViewSite().getShell());
        this.fMembersTree = new Tree(membersTreeComposite, 268436228);
        this.fMembersTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fMembersMenu = this.installContextMenuAndSelectionListener((Control)this.fMembersTree);
        this.fMembersTree.addKeyListener((KeyListener)this.getKeyListener(MEMBERS_FILTER_ID, MEMBERS_TREE_ID));
        this.fMembersTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                XVMBrowserView.this.gotoSelectedElement(XVMBrowserView.MEMBERS_TREE_ID);
            }

            public void mouseDown(MouseEvent e) {
                XVMBrowserView.this.fMembersTree.setFocus();
                if (XVMBrowserView.this.isOverrideMethodsActionEnabled()) {
                    IXVMBrowserViewContributor viewContributor = XVMBrowserView.this.getViewContributor(XVMBrowserView.this.getSelectedMemberElement());
                    if (viewContributor != null) {
                        LanguageKind languageKind = viewContributor.getLanguageKind();
                        if (languageKind.equals((Object)LanguageKind.E)) {
                            XVMBrowserView.this.fOverrideMethods.setAllDescriptionsToText("Override");
                        } else if (languageKind.equals((Object)LanguageKind.VLOG)) {
                            XVMBrowserView.this.fOverrideMethods.setAllDescriptionsToText("Override");
                        }
                    }
                    XVMBrowserView.this.fMembersMenu.remove((IContributionItem)new ActionContributionItem((IAction)XVMBrowserView.this.fOverrideMethods));
                    XVMBrowserView.this.fMembersMenu.insert(0, (IContributionItem)new ActionContributionItem((IAction)XVMBrowserView.this.fOverrideMethods));
                    XVMBrowserView.this.fMembersMenu.insert(1, (IContributionItem)new Separator());
                } else {
                    XVMBrowserView.this.fMembersMenu.remove((IContributionItem)new ActionContributionItem((IAction)XVMBrowserView.this.fOverrideMethods));
                }
                XVMBrowserView.this.fOverrideMethods.setEnabled(XVMBrowserView.this.isOverrideMethodsActionEnabled());
            }
        });
        this.fMembersTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (XVMBrowserView.this.isOverrideMethodsActionEnabled()) {
                    IXVMBrowserViewContributor viewContributor = XVMBrowserView.this.getViewContributor(XVMBrowserView.this.getSelectedMemberElement());
                    if (viewContributor != null) {
                        LanguageKind languageKind = viewContributor.getLanguageKind();
                        if (languageKind.equals((Object)LanguageKind.E)) {
                            XVMBrowserView.this.fOverrideMethods.setAllDescriptionsToText("Override");
                        } else if (languageKind.equals((Object)LanguageKind.VLOG)) {
                            XVMBrowserView.this.fOverrideMethods.setAllDescriptionsToText("Override");
                        }
                    }
                    XVMBrowserView.this.fMembersMenu.remove((IContributionItem)new ActionContributionItem((IAction)XVMBrowserView.this.fOverrideMethods));
                    XVMBrowserView.this.fMembersMenu.insert(0, (IContributionItem)new ActionContributionItem((IAction)XVMBrowserView.this.fOverrideMethods));
                    XVMBrowserView.this.fMembersMenu.insert(1, (IContributionItem)new Separator());
                } else {
                    XVMBrowserView.this.fMembersMenu.remove((IContributionItem)new ActionContributionItem((IAction)XVMBrowserView.this.fOverrideMethods));
                }
                XVMBrowserView.this.fOverrideMethods.setEnabled(XVMBrowserView.this.isOverrideMethodsActionEnabled());
                IDVTElementWrapper selectedMember = XVMBrowserView.this.getSelectedMemberElement();
                if (selectedMember == null) {
                    return;
                }
                IXVMBrowserViewContributor viewContributor = XVMBrowserView.this.getViewContributor(selectedMember);
                if (viewContributor == null) {
                    return;
                }
                String comment = viewContributor.getComment(selectedMember);
                if (comment.length() > 150) {
                    comment = String.valueOf(comment.substring(0, 150)) + "...";
                }
                XVMBrowserView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(comment);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fXVMComponentsTreeContentProvider = new TreeViewContentProvider(this.fXVMComponentsTree, this.fLabelProvider);
        this.fXVMMembersContentProvider = new TreeViewContentProvider(this.fMembersTree, this.fLabelProvider);
        this.fExpandLevel = -1;
    }

    private void createToolbar(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager componentsToolBarManager = actionBars.getToolBarManager();
        componentsToolBarManager.removeAll();
        this.fMembersToolBarManager.removeAll();
        componentsToolBarManager.add((IAction)this.fPrependPackageAction);
        componentsToolBarManager.add((IAction)this.fGroupByPackageAction);
        componentsToolBarManager.add((IAction)new AbstractFilteredView.ExpandAllAction());
        componentsToolBarManager.add((IAction)new AbstractFilteredView.CollapseAllAction());
        actionBars.updateActionBars();
        this.fMembersToolBarManager.add((IAction)this.fXVMMembersAction);
        this.fFilterMembersAction = new FilterMembersAction(parent);
        this.fMembersToolBarManager.add((IAction)this.fFilterMembersAction);
        this.fMembersToolBarManager.add((IAction)this.fSortByCategoryAction);
        this.fMembersToolBarManager.add((IContributionItem)new Separator());
        this.fMembersToolBarManager.add((IAction)this.fShowOnlyPublicAction);
        this.fMembersToolBarManager.add((IAction)this.fShowPredefinedAction);
        this.fMembersToolBarManager.add((IAction)this.fShowAllInheritedAction);
        this.fFilterMembersAction.setEnabled(!this.fXVMMembersAction.isChecked());
        this.fSortByCategoryAction.setEnabled(!this.fXVMMembersAction.isChecked());
        this.fShowOnlyPublicAction.setEnabled(!this.fXVMMembersAction.isChecked());
        this.fShowPredefinedAction.setEnabled(!this.fXVMMembersAction.isChecked());
        this.fShowAllInheritedAction.setEnabled(!this.fXVMMembersAction.isChecked());
        this.fMembersToolBarManager.update(true);
        componentsToolBarManager.update(true);
        this.fMembersToolBarManager.getControl().getParent().getParent().layout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("uvmcomponentsview.prefs_changed")) {
            this.update(true, false);
        }
    }

    @Override
    public void update(BuildEvents updateEvent) {
        this.update(false, false);
    }

    private void update(boolean updateOnlyMembers, boolean keepOldSelection) {
        try {
            this.fUpdateOnlyMembers = updateOnlyMembers;
            this.fKeepOldSelection = keepOldSelection;
            if (this.fXVMComponentsTree == null) {
                return;
            }
            IProject project = this.getProject();
            if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (this.fUpdateOnlyMembers) {
                this.fXVMMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), 1);
            } else {
                this.fXVMComponentsTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), 1);
                this.fXVMMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), 1);
            }
            this.fUpdateJob.cancel();
            this.fUpdateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.fHasGUIFilteredMembers = false;
            this.fHasGUIFilteredTree = false;
            this.fHasSearchedElementFiltered = false;
            this.fHasSearchedMemberFiltered = false;
            this.fMemberElements = new ArrayList<IDVTElementWrapper>();
            if (!this.fUpdateOnlyMembers) {
                this.fXVMComponentsElements = new ArrayList<IDVTElementWrapper>();
            }
            for (IXVMBrowserViewContributor viewContributor : fAllXVMBrowserContributors) {
                XVMBrowserViewInput input;
                if (ViewsUtils.isCanceled(updateJob)) {
                    return;
                }
                IProject project = this.getProject();
                boolean isMultipleNatureProject = ViewsUtils.hasMoreThanOneDVTNature(project);
                if (this.fUpdateOnlyMembers) {
                    input = viewContributor.getInput(new XVMBrowserViewInputConfigurator(this, project, this.getStringMatcher(COMPONENTS_FILTER_ID), this.getStringMatcher(MEMBERS_FILTER_ID), this.fSelectedComponentWrapper, this.fUpdateOnlyMembers, updateJob, isMultipleNatureProject));
                    List<IDVTElementWrapper> memberElements = input.getMemberElements();
                    this.fHasGUIFilteredMembers = this.fHasGUIFilteredMembers || input.hasGUIFilteredMembers();
                    boolean bl = this.fHasSearchedMemberFiltered = this.fHasSearchedMemberFiltered || input.hasSearchedMemberFiltered();
                    if (memberElements == null) continue;
                    this.fMemberElements.addAll(memberElements);
                    continue;
                }
                input = viewContributor.getInput(new XVMBrowserViewInputConfigurator(this, project, this.getStringMatcher(COMPONENTS_FILTER_ID), this.getStringMatcher(MEMBERS_FILTER_ID), this.fSelectedComponentWrapper, this.fUpdateOnlyMembers, updateJob, isMultipleNatureProject));
                this.fHasGUIFilteredTree = this.fHasGUIFilteredTree || input.hasGUIFilteredTree();
                this.fHasSearchedElementFiltered = this.fHasSearchedElementFiltered || input.hasSearchedElementFiltered();
                List<IDVTElementWrapper> componentElements = input.getComponentElements();
                if (componentElements == null) {
                    componentElements = new ArrayList<IDVTElementWrapper>();
                }
                if (!this.fKeepOldSelection) {
                    ViewsUtils.selectElement(viewContributor, this.getStringMatcher(COMPONENTS_FILTER_ID), componentElements, null);
                    this.setSelectedElement(componentElements);
                    this.fLastSelectedComponentElement = this.fSelectedComponentWrapper;
                } else {
                    boolean selected = ViewsUtils.selectElement(viewContributor, this.getStringMatcher(COMPONENTS_FILTER_ID), componentElements, this.fLastSelectedComponentElement);
                    if (!selected) {
                        ViewsUtils.selectElement(viewContributor, this.getStringMatcher(COMPONENTS_FILTER_ID), componentElements, null);
                        this.setSelectedElement(componentElements);
                        this.fLastSelectedComponentElement = this.fSelectedComponentWrapper;
                    }
                }
                this.fXVMComponentsElements.addAll(componentElements);
                XVMBrowserViewInput onlyMembersInput = viewContributor.getInput(new XVMBrowserViewInputConfigurator(this, project, this.getStringMatcher(COMPONENTS_FILTER_ID), this.getStringMatcher(MEMBERS_FILTER_ID), this.fSelectedComponentWrapper, !this.fUpdateOnlyMembers, updateJob, isMultipleNatureProject));
                List<IDVTElementWrapper> memberElements = onlyMembersInput.getMemberElements();
                this.fHasGUIFilteredMembers = this.fHasGUIFilteredMembers || input.hasGUIFilteredMembers();
                boolean bl = this.fHasSearchedMemberFiltered = this.fHasSearchedMemberFiltered || input.hasSearchedMemberFiltered();
                if (memberElements == null) continue;
                this.fMemberElements.addAll(memberElements);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            if (this.fMembersContentFiltersLabel == null) {
                return;
            }
            if (EclipseUtils.isAtLeastEclipse419()) {
                this.fMembersContentFiltersLabel.setImage(this.fHasGUIFilteredMembers ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
            }
            this.fMembersContentFiltersLabel.setEnabled(this.fHasGUIFilteredMembers);
            if (EclipseUtils.isAtLeastEclipse419()) {
                this.fTreeContentFiltersLabel.setImage(this.fHasGUIFilteredTree ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
            }
            this.fTreeContentFiltersLabel.setEnabled(this.fHasGUIFilteredTree);
            if (this.fXVMComponentsTreeContentProvider != null && this.fXVMMembersContentProvider != null && this.fXVMComponentsElements != null && this.fInfoComponents != null && this.getProject() != null) {
                if (this.fUpdateOnlyMembers) {
                    this.updateMembers();
                } else {
                    this.fExpandLevel = -1;
                    if (this.fXVMComponentsElements.isEmpty()) {
                        if (this.fHasSearchedElementFiltered) {
                            this.fXVMComponentsTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
                        } else if (this.getStringMatcher(COMPONENTS_FILTER_ID) != null) {
                            this.fXVMComponentsTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND), this.fExpandLevel);
                        } else if (this.fHasGUIFilteredTree) {
                            this.fXVMComponentsTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
                        } else {
                            this.fXVMComponentsTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
                        }
                        this.getTextFilter(MEMBERS_FILTER_ID).setEnabled(false);
                        this.fSelectedComponentWrapper = null;
                        this.fInfoComponents.setText("[" + this.getProject().getName() + "] ");
                        ProjectColorUtils.setFgBg(this, this.getProject().getName());
                        this.fXVMMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(), 1);
                        this.fInfoMembers.setText("");
                        this.fInfoMembers.setImage(null);
                        this.fMembersToolBarManager.update(true);
                        return;
                    }
                    this.fXVMComponentsTreeContentProvider.setInput(this.fXVMComponentsElements, this.fExpandLevel);
                    this.getTextFilter(MEMBERS_FILTER_ID).setEnabled(true);
                    this.updateMembers();
                }
                String text = this.fLabelProvider.getText(this.fSelectedComponentWrapper);
                this.fInfoMembers.setText(text);
                this.fInfoMembers.setImage(this.fLabelProvider.getImage(this.fSelectedComponentWrapper));
                this.fInfoComponents.setText("[" + this.getProject().getName() + "] ");
                ProjectColorUtils.setFgBg(this, this.getProject().getName());
                this.fMembersToolBarManager.update(true);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateMembers() {
        StringMatcher stringMatcher = this.getStringMatcher(MEMBERS_FILTER_ID);
        if (this.fMemberElements.isEmpty()) {
            if (this.fHasSearchedMemberFiltered) {
                this.fXVMMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
            } else if (stringMatcher != null && !stringMatcher.getPattern().isEmpty()) {
                this.fXVMMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND), this.fExpandLevel);
            } else if (this.fHasGUIFilteredMembers) {
                this.fXVMMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
            } else {
                this.fXVMMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
            }
        } else {
            this.fXVMMembersContentProvider.setInput(this.fMemberElements, this.fExpandLevel);
        }
    }

    private void cleanView() {
        this.fInfoMembers.setText("");
        this.fInfoMembers.setImage(null);
        this.fOverrideMethods.setEnabled(false);
        IProject project = this.getProject();
        try {
            if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.fInfoComponents.setText("[no DVT Project or file selected]");
                ProjectColorUtils.setFgBg(this, null);
                this.fTreeContentFiltersLabel.setEnabled(false);
                this.fMembersContentFiltersLabel.setEnabled(false);
                this.fXVMComponentsTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_SELECT_PROJECT_OR_FILE), 1);
                this.getTextFilter(MEMBERS_FILTER_ID).setEnabled(false);
            } else {
                this.fInfoComponents.setText("[" + project.getName() + "] ");
                ProjectColorUtils.setFgBg(this, project.getName());
                this.fMembersContentFiltersLabel.setEnabled(false);
                this.fTreeContentFiltersLabel.setEnabled(false);
                this.fXVMComponentsTreeContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), 1);
                this.getTextFilter(MEMBERS_FILTER_ID).setEnabled(false);
            }
            this.fXVMMembersContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(), 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean setSelectedElement(List<IDVTElementWrapper> elementWrappers) {
        if (elementWrappers == null) {
            return false;
        }
        for (IDVTElementWrapper wrapper : elementWrappers) {
            if (wrapper.getSelectedElement() != null) {
                this.fSelectedComponentWrapper = wrapper;
                return true;
            }
            List<IDVTElementWrapper> children = wrapper.getChildren();
            if (children == null || children.isEmpty() || !this.setSelectedElement(children)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.fXVMComponentsTree != null && !this.fXVMComponentsTree.isDisposed()) {
            this.fXVMComponentsTree.dispose();
        }
        if (this.fInfoComponents != null && !this.fInfoComponents.isDisposed()) {
            this.fInfoComponents.dispose();
        }
        if (this.fMembersContentFiltersLabel != null && !this.fMembersContentFiltersLabel.isDisposed()) {
            this.fMembersContentFiltersLabel.dispose();
        }
        if (this.fTreeContentFiltersLabel != null && !this.fTreeContentFiltersLabel.isDisposed()) {
            this.fTreeContentFiltersLabel.dispose();
        }
        this.fXVMComponentsTree = null;
        this.fXVMComponentsTreeContentProvider = null;
        this.fInfoComponents = null;
        this.fMembersContentFiltersLabel = null;
        this.fTreeContentFiltersLabel = null;
        DVTMixedLangModelManager.getInstance().removeXvmFactoryInitListeners(this);
        super.dispose();
    }

    public void setFocus() {
        this.fXVMComponentsTree.setFocus();
    }

    private IXVMBrowserViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, IXVMBrowserViewContributor.class);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper(treeId);
        IXVMBrowserViewContributor viewContributor = this.getViewContributor(selectedWrapper);
        if (selectedWrapper == null || viewContributor == null) {
            return;
        }
        viewContributor.gotoElement(this.getProject(), selectedWrapper);
    }

    @Override
    public Tree getTree(String treeId) {
        if (treeId.equals(MEMBERS_TREE_ID)) {
            return this.fMembersTree;
        }
        return this.fXVMComponentsTree;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        if (treeId.equals(MEMBERS_TREE_ID)) {
            return this.fMemberElements;
        }
        return this.fXVMComponentsElements;
    }

    private boolean isOverrideMethodsActionEnabled() {
        TreeItem[] selectedComponents = this.fXVMComponentsTree.getSelection();
        TreeItem[] selectedMembers = this.fMembersTree.getSelection();
        if (selectedComponents == null || selectedComponents.length == 0 || !(selectedComponents[0].getData() instanceof IDVTElementWrapper)) {
            return false;
        }
        if (selectedMembers == null || selectedMembers.length == 0 || !(selectedMembers[0].getData() instanceof IDVTElementWrapper)) {
            return false;
        }
        IDVTElementWrapper selectedComponentWrapper = (IDVTElementWrapper)selectedComponents[0].getData();
        IDVTElementWrapper selectedMemberWrapper = (IDVTElementWrapper)selectedMembers[0].getData();
        IXVMBrowserViewContributor viewContributor = this.getViewContributor(selectedMemberWrapper);
        if (viewContributor == null) {
            return false;
        }
        return viewContributor.canShowOverrideMethodMenuEntry(selectedComponentWrapper, selectedMemberWrapper);
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.fXVMComponentsTree.setRedraw(false);
            this.fMembersTree.setRedraw(false);
            if (textFilterId.equals(MEMBERS_FILTER_ID)) {
                this.update(true, false);
            } else {
                this.update(false, false);
            }
            this.fXVMComponentsTree.setRedraw(true);
            this.fMembersTree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private HistoryItem getWrapperAsHistoryElement(IDVTElementWrapper selectedComponentWrapper, int updateHistory) {
        if (selectedComponentWrapper == null) {
            return null;
        }
        IXVMBrowserViewContributor viewContributor = this.getViewContributor(selectedComponentWrapper);
        if (viewContributor == null) {
            return null;
        }
        return viewContributor.createHistoryItemForWrapper(selectedComponentWrapper, this.getProject(), updateHistory);
    }

    private IDVTElementWrapper getSelectedMemberElement() {
        TreeItem[] selectedMembers = this.fMembersTree.getSelection();
        if (selectedMembers == null || selectedMembers.length == 0 || selectedMembers[0].getData() == null) {
            return null;
        }
        if (!(selectedMembers[0].getData() instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)selectedMembers[0].getData();
    }

    @Override
    public ISelection getSelection() {
        if (this.fMembersTree.isFocusControl()) {
            return this.getSelection(MEMBERS_TREE_ID);
        }
        return this.getSelection(COMPONENTS_TREE_ID);
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void clean() {
        this.fUpdateJob.cancel();
        this.cleanView();
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.fLabelProvider;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        return this.getSearchSegments("default-filter");
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        return this.getSearchStrictness("default-filter");
    }

    @Override
    public String getTreeSearchPort() {
        return this.getSearchPort("default-filter");
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return this.fUpdateJob;
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return this.fXVMComponentsTreeContentProvider;
    }

    @Override
    public Control getControlToColorBg() {
        return this.fInfoComponents.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.fInfoComponents;
    }

    @Override
    public void postXvmReadyUpdate() {
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    public void testSetCheckPrependPackageButton(boolean check) {
        this.fPrependPackageAction.setChecked(check);
        this.fPrependPackageAction.run();
    }

    public void testSetCheckGroupByPackageButton(boolean check) {
        this.fGroupByPackageAction.setChecked(check);
        this.fGroupByPackageAction.run();
    }

    class FilterMembersAction
    extends Action {
        private static final String SHOW_DECLARATION_CLASS = "Show [declaration class]";
        private static final String SHOW_DECLARATION_STRUCT = "Show [declaration struct]";
        private static final String SHOW_METHODS = "Show methods";
        private static final String SHOW_TASKS = "Show tasks";
        private static final String SHOW_FUNCTIONS = "Show functions";
        private static final String SHOW_EVENTS = "Show events";
        private static final String SHOW_FIELDS = "Show fields";
        private Composite fParent;

        public FilterMembersAction(Composite parent) {
            super("&Filters...", 1);
            this.setImageDescriptor(DVTImages.FILTER);
            this.fParent = parent;
        }

        public void run() {
            if (XVMBrowserView.this.getWrapperAsHistoryElement(XVMBrowserView.this.fSelectedComponentWrapper, 0) == null) {
                return;
            }
            StatusDialog dialog = new StatusDialog(this.fParent.getShell()){
                private CheckboxTableViewer fCheckBoxList;

                protected Control createDialogArea(Composite parent) {
                    Composite containerComposite = new Composite(parent, 0);
                    GridLayout containerCompositeLayout = new GridLayout();
                    containerCompositeLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
                    containerCompositeLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                    containerCompositeLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
                    containerCompositeLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                    containerComposite.setLayout((Layout)containerCompositeLayout);
                    containerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                    containerComposite.setFont(parent.getFont());
                    Label info = new Label(containerComposite, 16384);
                    info.setText("S&elect the elements to include on the view:");
                    this.fCheckBoxList = CheckboxTableViewer.newCheckList((Composite)containerComposite, (int)2048);
                    this.fCheckBoxList.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
                    this.fCheckBoxList.setLabelProvider(this.createLabelProvider());
                    this.fCheckBoxList.setContentProvider((IContentProvider)new ArrayContentProvider());
                    Composite buttons = new Composite(containerComposite, 0);
                    GridLayout buttonsLayout = new GridLayout(2, false);
                    buttonsLayout.marginWidth = 0;
                    buttonsLayout.marginHeight = 0;
                    buttons.setLayout((Layout)buttonsLayout);
                    buttons.setLayoutData((Object)new GridData(131072, 1024, true, true, 2, 1));
                    Button selectAll = new Button(buttons, 0);
                    selectAll.setText("Select All");
                    Button deselectAll = new Button(buttons, 0);
                    deselectAll.setText("Deselect All");
                    HistoryItem historyItem = XVMBrowserView.this.getWrapperAsHistoryElement(((FilterMembersAction)FilterMembersAction.this).XVMBrowserView.this.fSelectedComponentWrapper, 0);
                    if (historyItem != null && historyItem.getLanguage().equals((Object)LanguageKind.VLOG)) {
                        this.fCheckBoxList.setInput((Object)new String[]{FilterMembersAction.SHOW_FIELDS, FilterMembersAction.SHOW_EVENTS, FilterMembersAction.SHOW_FUNCTIONS, FilterMembersAction.SHOW_TASKS, FilterMembersAction.SHOW_DECLARATION_CLASS});
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FIELDS, PrefConst.getUVMBrowserViewShowFields());
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_EVENTS, PrefConst.getUVMBrowserViewShowEvents());
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FUNCTIONS, PrefConst.getUVMBrowserViewShowFunctions());
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_TASKS, PrefConst.getUVMBrowserViewShowTasks());
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_DECLARATION_CLASS, PrefConst.getUVMBrowserViewShowDefinitionLayer());
                        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FIELDS, true);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_EVENTS, true);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FUNCTIONS, true);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_TASKS, true);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_DECLARATION_CLASS, true);
                            }
                        });
                        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FIELDS, false);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_EVENTS, false);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FUNCTIONS, false);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_TASKS, false);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_DECLARATION_CLASS, false);
                            }
                        });
                    } else if (historyItem != null && historyItem.getLanguage().equals((Object)LanguageKind.E)) {
                        this.fCheckBoxList.setInput((Object)new String[]{FilterMembersAction.SHOW_FIELDS, FilterMembersAction.SHOW_EVENTS, FilterMembersAction.SHOW_METHODS, FilterMembersAction.SHOW_DECLARATION_CLASS});
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FIELDS, PrefConst.getUVMBrowserViewShowFields());
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_EVENTS, PrefConst.getUVMBrowserViewShowEvents());
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_METHODS, PrefConst.getUVMBrowserViewShowMethods());
                        this.fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_DECLARATION_STRUCT, PrefConst.getUVMBrowserViewShowDefinitionLayer());
                        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FIELDS, true);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_EVENTS, true);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_METHODS, true);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_DECLARATION_STRUCT, true);
                            }
                        });
                        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_FIELDS, false);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_EVENTS, false);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_METHODS, false);
                                fCheckBoxList.setChecked((Object)FilterMembersAction.SHOW_DECLARATION_STRUCT, false);
                            }
                        });
                    }
                    1.applyDialogFont((Control)containerComposite);
                    return containerComposite;
                }

                private IBaseLabelProvider createLabelProvider() {
                    return new LabelProvider(){

                        public Image getImage(Object element) {
                            return null;
                        }

                        public String getText(Object element) {
                            if (element instanceof String) {
                                return (String)element;
                            }
                            return null;
                        }
                    };
                }

                protected void okPressed() {
                    HistoryItem historyItem = XVMBrowserView.this.getWrapperAsHistoryElement(((FilterMembersAction)FilterMembersAction.this).XVMBrowserView.this.fSelectedComponentWrapper, 0);
                    if (historyItem == null) {
                        return;
                    }
                    if (historyItem.getLanguage().equals((Object)LanguageKind.VLOG)) {
                        PrefConst.setUVMBrowserViewShowFields(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_FIELDS));
                        PrefConst.setUVMBrowserViewShowEvents(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_EVENTS));
                        PrefConst.setUVMBrowserViewShowFunctions(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_FUNCTIONS));
                        PrefConst.setUVMBrowserViewShowTasks(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_TASKS));
                        PrefConst.setUVMBrowserViewShowDefinitionLayer(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_DECLARATION_CLASS));
                    } else if (historyItem.getLanguage().equals((Object)LanguageKind.E)) {
                        PrefConst.setUVMBrowserViewShowFields(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_FIELDS));
                        PrefConst.setUVMBrowserViewShowEvents(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_EVENTS));
                        PrefConst.setUVMBrowserViewShowMethods(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_METHODS));
                        PrefConst.setUVMBrowserViewShowDefinitionLayer(this.fCheckBoxList.getChecked((Object)FilterMembersAction.SHOW_DECLARATION_STRUCT));
                    }
                    super.okPressed();
                    boolean filtering = GUIFiltersHandler.isFilteringEnabled();
                    DVTViewManager.loadGuiFilters(DVTPlugin.getSelectionManager().getLastSelectedProject(), filtering);
                    XVMBrowserView.this.update(true, false);
                }
            };
            dialog.setTitle(XVMBrowserView.XVM_BROWSER_DIALOG_TITLE);
            dialog.setHelpAvailable(false);
            dialog.open();
        }
    }

    class GroupByPackageAction
    extends Action {
        public GroupByPackageAction() {
            super("Group by Package", 2);
            this.setDescription("Group by Package");
            this.setToolTipText("Group by Package");
            this.setImageDescriptor(DVTImages.OUTLINE_PACKAGE);
            this.setChecked(PrefConst.getUVMBrowserViewGroupByPackage());
        }

        public void run() {
            PrefConst.setUVMBrowserViewGroupByPackage(this.isChecked());
            XVMBrowserView.this.update(false, false);
        }
    }

    class OverrideMethods
    extends Action {
        OverrideMethods() {
            super("Override");
            this.setDescription("Override");
            this.setToolTipText("Override");
        }

        public String getActionDefinitionId() {
            return super.getActionDefinitionId();
        }

        public String getId() {
            return XVMBrowserView.OVERRIDE_METHODS_ACTION_ID;
        }

        public void run() {
            TreeItem[] selectedMembers = XVMBrowserView.this.fMembersTree.getSelection();
            TreeItem[] selectedComponents = XVMBrowserView.this.fXVMComponentsTree.getSelection();
            if (selectedMembers == null || selectedMembers.length == 0 || !(selectedMembers[0].getData() instanceof IDVTElementWrapper)) {
                return;
            }
            if (selectedComponents == null || selectedComponents.length == 0 || !(selectedComponents[0].getData() instanceof IDVTElementWrapper)) {
                return;
            }
            IDVTElementWrapper selectedMemberWrapper = (IDVTElementWrapper)selectedMembers[0].getData();
            IDVTElementWrapper selectedComponentWrapper = (IDVTElementWrapper)selectedComponents[0].getData();
            if (selectedComponentWrapper != null && selectedMemberWrapper != null) {
                IXVMBrowserViewContributor viewContributor = XVMBrowserView.this.getViewContributor(selectedMemberWrapper);
                if (viewContributor == null) {
                    return;
                }
                viewContributor.overrideMethod(selectedComponentWrapper, selectedMemberWrapper);
            }
        }

        public void setAllDescriptionsToText(String text) {
            this.setText(text);
            this.setDescription(text);
            this.setToolTipText(text);
        }
    }

    class PrependPackageAction
    extends Action {
        public PrependPackageAction() {
            super("Prepend Package Name", 2);
            this.setDescription("Prepend Package Name");
            this.setToolTipText("Prepend Package Name");
            this.setImageDescriptor(DVTImages.PREPEND_PACKAGE);
            this.setChecked(PrefConst.getUVMBrowserViewPrependPackage());
        }

        public void run() {
            PrefConst.setUVMBrowserViewPrependPackage(this.isChecked());
            XVMBrowserView.this.update(false, true);
        }
    }

    class ShowAllInheritedAction
    extends Action {
        ShowAllInheritedAction() {
            super("Show All Inherited Members", 2);
            this.setDescription("Show All Inherited Members");
            this.setToolTipText("Show All Inherited Members");
            this.setImageDescriptor(DVTImages.INHER_CO);
            this.setChecked(PrefConst.getUVMBrowserViewShowAllInherited());
        }

        public void run() {
            PrefConst.setUVMBrowserViewShowAllInherited(this.isChecked());
            XVMBrowserView.this.update(true, false);
        }
    }

    class ShowOnlyPublicAction
    extends Action {
        ShowOnlyPublicAction() {
            super("Show Only Public Members", 2);
            this.setDescription("Show Only Public Members");
            this.setToolTipText("Show Only Public Members");
            this.setImageDescriptor(DVTImages.SHOW_PUBLIC);
            this.setChecked(PrefConst.getUVMBrowserViewShowOnlyPublic());
        }

        public void run() {
            PrefConst.setUVMBrowserViewShowOnlyPublic(this.isChecked());
            XVMBrowserView.this.update(true, false);
        }
    }

    class ShowPredefinedAction
    extends Action {
        ShowPredefinedAction() {
            super("Show All Predefined Members", 2);
            this.setDescription("Show All Predefined Members");
            this.setToolTipText("Show All Predefined Members");
            this.setImageDescriptor(DVTImages.SHOW_PREDEFINED);
            this.setChecked(PrefConst.getUVMBrowserViewShowPredefined());
        }

        public void run() {
            PrefConst.setUVMBrowserViewShowPredefined(this.isChecked());
            XVMBrowserView.this.update(true, false);
        }
    }

    class SortByCategory
    extends Action {
        SortByCategory() {
            super("Category Sort", 2);
            this.setDescription("Sort by Category");
            this.setToolTipText("Sort Members by Category");
            this.setImageDescriptor(DVTImages.CATEGORY_SORT);
            this.setChecked(PrefConst.getUVMBrowserViewSortByCategory());
        }

        public void run() {
            PrefConst.setUVMBrowserViewSortByCategory(this.isChecked());
            XVMBrowserView.this.update(true, false);
        }
    }

    class XVMMembersAction
    extends Action {
        public XVMMembersAction() {
            super("UVM Members Mode", 2);
            this.setDescription("UVM Members Mode");
            this.setToolTipText("UVM Members Mode");
            this.setImageDescriptor(DVTImages.UVM);
            this.setChecked(PrefConst.getUVMBrowserViewShowUVMMembers());
        }

        public void run() {
            PrefConst.setUVMBrowserViewShowUVMMembers(this.isChecked());
            boolean filtering = GUIFiltersHandler.isFilteringEnabled();
            DVTViewManager.loadGuiFilters(DVTPlugin.getSelectionManager().getLastSelectedProject(), filtering);
            XVMBrowserView.this.fFilterMembersAction.setEnabled(!this.isChecked());
            XVMBrowserView.this.fSortByCategoryAction.setEnabled(!this.isChecked());
            XVMBrowserView.this.fShowOnlyPublicAction.setEnabled(!this.isChecked());
            XVMBrowserView.this.fShowPredefinedAction.setEnabled(!this.isChecked());
            XVMBrowserView.this.fShowAllInheritedAction.setEnabled(!this.isChecked());
            XVMBrowserView.this.update(true, true);
        }
    }
}

