/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.uvmsequencetree;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.BooleanPropertyAction;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.history.HistoryAction;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.uvmsequencetree.IUVMSequenceTreeViewContributor;
import ro.amiq.dvt.ui.views.uvmsequencetree.UVMSequenceTreeViewCommon;
import ro.amiq.dvt.ui.views.uvmsequencetree.UVMSequenceTreeViewInput;
import ro.amiq.dvt.ui.views.uvmsequencetree.UVMSequenceTreeViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class UVMSequenceTreeView
extends UVMSequenceTreeViewCommon
implements IUpdateJobImpl {
    private static final List<IUVMSequenceTreeViewContributor> fAllUVMSequenceTreeContributors = DVTViewContributors.getInstance().getAllInstanceOf(IUVMSequenceTreeViewContributor.class);
    private final Map<LanguageKind, IUVMSequenceTreeViewContributor> fAllUVMSTContributorsByLanguageKind = new EnumMap<LanguageKind, IUVMSequenceTreeViewContributor>(LanguageKind.class);
    private final UpdateJob fUpdateJob;
    private DVTLabelProviderProxy<IUVMSequenceTreeViewContributor> fLabelProvider = new DVTLabelProviderProxy<IUVMSequenceTreeViewContributor>(IUVMSequenceTreeViewContributor.class, "default-tree");
    private Label fInfo;
    private Label fContentFiltersLabel;
    private String fBulkDataInfo;
    private Tree fTree;
    private TreeViewContentProvider fLazyContentProvider;
    private boolean fHasGUIFilteredRoots;
    private Image fContentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image fContentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);
    private UVMSequenceTreeHistoryAction fUVMSequenceTreeHistoryAction = new UVMSequenceTreeHistoryAction();
    private TreeColumn fNameColumn = null;
    private TreeColumn fCommentColumn = null;
    private List<IDVTElementWrapper> fElements;
    private PrependPackageAction fPrependPackageAction = new PrependPackageAction();
    public static final int COLUMN_SIZE_NAME = 50;
    public static final int COLUMN_SIZE_COMMENT = 50;

    public UVMSequenceTreeView() {
        this.fUpdateJob = new UpdateJob("Update UVM Sequence Tree View", this);
        for (IUVMSequenceTreeViewContributor contributor : fAllUVMSequenceTreeContributors) {
            this.fAllUVMSTContributorsByLanguageKind.put(contributor.getLanguageKind(), contributor);
        }
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite labelComposite = new Composite(parent, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fContentFiltersLabel = new Label(labelComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.fContentFiltersLabel.setImage(this.fHasGUIFilteredRoots ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
        } else {
            this.fContentFiltersLabel.setImage(this.fContentFiltersEnabledIcon);
        }
        this.fContentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        this.fContentFiltersLabel.setToolTipText("Content Filters matched!");
        this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredRoots);
        this.fInfo = new Label(labelComposite, 16384);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        this.fInfo.setLayoutData((Object)layoutData);
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: hierarchical name");
        Composite composite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        composite.setLayoutData((Object)compositeGridData);
        composite.setLayout((Layout)new FillLayout(256));
        this.fTree = new Tree(composite, 268436228);
        this.fTree.setHeaderVisible(true);
        this.fLazyContentProvider = new TreeViewContentProvider(this.fTree, this.fLabelProvider);
        this.fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                UVMSequenceTreeView.this.gotoSelectedElement("default-tree");
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.createToolbar(parent);
        this.installContextMenuAndSelectionListener((Control)this.fTree);
    }

    private void createToolbar(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.removeAll();
        tbm.add((IAction)this.fUVMSequenceTreeHistoryAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fPrependPackageAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new AbstractFilteredView.CollapseAllAction());
        tbm.add((IAction)new AbstractFilteredView.ExpandAllAction());
    }

    private void addToHistory() {
        if (this.getHistoryItem() == null) {
            return;
        }
        this.fUVMSequenceTreeHistoryAction.addElement(this.getHistoryItem());
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            IProject project;
            if (this.fTree == null) {
                return;
            }
            if (this.getHistoryItem() == null) {
                this.fInfo.setText("");
                ProjectColorUtils.setFgBg(this, null);
                this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_SEQUENCE_TREE_VIEW), this.fExpandLevel);
                return;
            }
            UpdateViewEvent ev = (UpdateViewEvent)this.getHistoryItem();
            if (ev.getUpdateHistory() == 5) {
                this.addToHistory();
            }
            if ((project = this.getProject()) == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            this.fHasGUIFilteredRoots = false;
            this.fUpdateJob.cancel();
            this.fUpdateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.fElements = new ArrayList<IDVTElementWrapper>();
            IUVMSequenceTreeViewContributor contentProvider = this.getViewContributor(this.getHistoryItem());
            if (contentProvider == null) {
                return;
            }
            if (ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            IProject project = this.getProject();
            UVMSequenceTreeViewInput input = contentProvider.getInput(new UVMSequenceTreeViewInputConfigurator(this.getHistoryItem(), project, this.getSearchSegments("default-filter"), this.getSearchStrictness("default-filter"), ViewsUtils.hasMoreThanOneDVTNature(project), this.isShowPrependPackage(), updateJob), null);
            List<IDVTElementWrapper> origElems = input.getElements();
            ViewsUtils.selectElement(contentProvider, null, origElems, this.getHistoryItem());
            this.fElements.addAll(origElems);
            this.fHasGUIFilteredRoots = this.fHasGUIFilteredRoots || input.getHasGUIFilteredRoots();
            this.fBulkDataInfo = input.getBulkDataInfo();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            IProject project = this.getProject();
            this.redrawView();
            if (this.fLazyContentProvider != null && this.fElements != null && this.fInfo != null && project != null) {
                this.fExpandLevel = this.isFiltered() ? -1 : 2;
                StringMatcher sm = this.getStringMatcher("default-filter");
                if (this.fElements.isEmpty()) {
                    if (sm != null && !sm.getPattern().isEmpty()) {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND), this.fExpandLevel);
                    } else if (this.fHasGUIFilteredRoots) {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
                    } else {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
                    }
                } else {
                    this.fLazyContentProvider.setInput(this.fElements, this.fExpandLevel);
                }
                if (this.fBulkDataInfo == null) {
                    this.fBulkDataInfo = "";
                }
                StringBuilder infoText = new StringBuilder();
                infoText.append("[").append(project.getName()).append("] ").append(this.fBulkDataInfo.replaceAll("\n", ""));
                this.fInfo.setText(infoText.toString());
                ProjectColorUtils.setFgBg(this, project.getName());
                this.fInfo.setToolTipText(this.fBulkDataInfo);
                if (EclipseUtils.isAtLeastEclipse419()) {
                    this.fContentFiltersLabel.setImage(this.fHasGUIFilteredRoots ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
                }
                this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredRoots);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.dispose();
        }
        if (this.fInfo != null && !this.fInfo.isDisposed()) {
            this.fInfo.dispose();
        }
        if (this.fContentFiltersLabel != null && !this.fContentFiltersLabel.isDisposed()) {
            this.fContentFiltersLabel.dispose();
        }
        if (this.fNameColumn != null) {
            this.fNameColumn.dispose();
        }
        if (this.fCommentColumn != null) {
            this.fCommentColumn.dispose();
        }
        this.fTree = null;
        this.fInfo = null;
        this.fContentFiltersLabel = null;
        this.fLazyContentProvider = null;
        this.fInfo = null;
        super.dispose();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    private void redrawView() {
        this.createToolbar((Composite)this.getViewSite().getShell());
        int n = this.fTree.getSize().x;
        if (n == 0) {
            n = 1000;
        }
        if (this.fNameColumn == null) {
            this.fNameColumn = new TreeColumn(this.fTree, 16384, 0);
            this.fNameColumn.setText("Sequences");
            this.fNameColumn.setMoveable(true);
        }
        this.fNameColumn.setWidth(n * 50 / 100);
        if (this.fCommentColumn == null) {
            this.fCommentColumn = new TreeColumn(this.fTree, 16384);
            this.fCommentColumn.setText("Comment");
            this.fCommentColumn.setMoveable(true);
        }
        this.fCommentColumn.setWidth(n * 50 / 100);
    }

    private IUVMSequenceTreeViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, IUVMSequenceTreeViewContributor.class);
    }

    private IUVMSequenceTreeViewContributor getViewContributor(HistoryItem historyItem) {
        if (historyItem == null) {
            return null;
        }
        return this.fAllUVMSTContributorsByLanguageKind.get((Object)this.getHistoryItem().getLanguage());
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper(treeId);
        if (selectedWrapper == null || this.getViewContributor(selectedWrapper) == null) {
            return;
        }
        this.getViewContributor(selectedWrapper).gotoElement(this.getProject(), selectedWrapper);
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.fTree.setRedraw(false);
            this.update(null);
            this.fTree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public Tree getTree(String treeId) {
        return this.fTree;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return this.fTree.getData();
    }

    public DVTLabelProviderProxy<IUVMSequenceTreeViewContributor> getLabelProvider() {
        return this.fLabelProvider;
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void clean() {
        this.fUpdateJob.cancel();
        IProject project = this.getProject();
        if (project == null || project != null && !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.fInfo.setText("[no DVT Project or file selected]");
            ProjectColorUtils.setFgBg(this, null);
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_SELECT_PROJECT_OR_FILE), this.fExpandLevel);
            this.fContentFiltersLabel.setEnabled(false);
        } else {
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
            this.fContentFiltersLabel.setEnabled(false);
            if (this.fBulkDataInfo != null) {
                this.fInfo.setText("[" + project.getName() + "] " + this.fBulkDataInfo.replaceAll("\n", ""));
                ProjectColorUtils.setFgBg(this, project.getName());
                this.fInfo.setToolTipText(this.fBulkDataInfo);
            }
        }
    }

    public boolean isShowPrependPackage() {
        if (this.fPrependPackageAction != null) {
            return this.fPrependPackageAction.isChecked();
        }
        return PrefConst.getUVMSTViewPrependPackage();
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return this.fLazyContentProvider;
    }

    @Override
    public Control getControlToColorBg() {
        return this.fInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.fInfo;
    }

    class PrependPackageAction
    extends BooleanPropertyAction {
        public PrependPackageAction() {
            super("Prepend Package Name", DVTPlugin.getDefault().getPreferenceStore(), "sequencetreeview.prependPackage");
            this.setDescription("Prepend Package Name");
            this.setToolTipText("Prepend Package Name");
            this.setImageDescriptor(DVTImages.PREPEND_PACKAGE);
            this.setChecked(PrefConst.getUVMSTViewPrependPackage());
        }

        public void run() {
            PrefConst.setUVMSTViewPrependPackage(this.isChecked());
            UVMSequenceTreeView.this.update(null);
        }
    }

    class UVMSequenceTreeHistoryAction
    extends HistoryAction {
        UVMSequenceTreeHistoryAction() {
        }

        @Override
        public void openHistoryItem(HistoryItem item) {
            IProject newProject = Utils.getProject(((UpdateViewEvent)item).getProjectName());
            UVMSequenceTreeView.this.setInput(new ViewDataContainer(newProject, item));
            UVMSequenceTreeView.this.update(null);
        }

        @Override
        public boolean checkHistoryItem(HistoryItem item) {
            return true;
        }
    }
}

