/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.uvmsequencetree;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.uvmsequencetree.IUVMSequenceTreeViewContributor;

public class UVMSequenceTreeViewHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        new Job("Opening UVM Sequence Tree View"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HistoryItem hItem = ViewsUtils.getHistoryItemAtCurrentOffset(IUVMSequenceTreeViewContributor.class, false);
                    if (hItem == null) {
                        return Status.CANCEL_STATUS;
                    }
                    String sourceId = hItem.getLanguage().equals((Object)LanguageKind.VLOG) ? "ro.amiq.vlogdt.ui.editor.VlogEditor" : (hItem.getLanguage().equals((Object)LanguageKind.E) ? "ro.amiq.edt.ui.editor.EEditor" : (hItem.getLanguage().equals((Object)LanguageKind.VHDL) ? "ro.amiq.vhdldt.ui.editor.VhdlEditor" : ""));
                    IProject project = ro.amiq.dvt.utils.Utils.getProject(((UpdateViewEvent)hItem).getProjectName());
                    ViewDataContainer dataContainer = new ViewDataContainer(project, hItem);
                    Utils.safeRunAsynchInUIThread(() -> ViewsUtils.notifyViewById("ro.amiq.dvt.ui.views.UVMSequenceTreeView", new DVTViewEvent(DVTViewEvent.EventKind.TRIGGER, sourceId, dataContainer), true));
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return null;
    }
}

