/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;

public abstract class AbstractDVTWaveViewEditorActionHandler
extends TextEditorAction {
    private String dialogTitle;

    protected AbstractDVTWaveViewEditorActionHandler(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public boolean isEnabled() {
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        return DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project);
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (!(textEditor instanceof IDVTBreadcrumbHost)) {
            return;
        }
        super.run();
        int offset = ((DVTEditor)this.getTextEditor()).getCursor();
        if (offset < 0) {
            return;
        }
        IRfNamedElementAndScope elementScope = this.getElementAndScopeAtCursor(offset);
        this.doAction(elementScope, textEditor, offset);
    }

    protected void popUnsupportedElement(IRfNamedElement elementAtCursor) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.dialogTitle, null, "The operation is unavailable on the current element " + (elementAtCursor == null ? "." : ": '" + elementAtCursor.getName() + "'.") + "\nPlease select another Verilog Language element.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    protected IFile getFile() {
        ITextEditor textEditor = this.getTextEditor();
        if (!(textEditor instanceof DVTEditor)) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    protected IDocument getDocument() {
        ITextEditor textEditor = this.getTextEditor();
        if (!(textEditor instanceof DVTEditor)) {
            return null;
        }
        return ((DVTEditor)textEditor).getDocument();
    }

    protected IProject getProject() {
        ITextEditor textEditor = this.getTextEditor();
        if (!(textEditor instanceof DVTEditor)) {
            return null;
        }
        return ((DVTEditor)textEditor).getProject();
    }

    protected abstract IRfNamedElementAndScope getElementAndScopeAtCursor(int var1);

    protected abstract void doAction(IRfNamedElementAndScope var1, ITextEditor var2, int var3);
}

