/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IResourceSelectionChangeListener;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditorInput;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.ui.waveviewer.ICurrentWaveListener;

public enum CurrentWaveStatusBarIndicator implements ICurrentWaveListener,
IResourceChangeListener,
IResourceSelectionChangeListener
{
    INSTANCE;

    private static final String N_A = "N/A";
    private Label label;
    private Button button;
    private Composite trimToolbar;
    private Composite waveStatusComposite;

    public void init() {
        this.trimToolbar = DVTUiUtils.getTrimToolbarParent((Composite)DVTUiUtils.getActiveWorkbenchShell());
        if (this.trimToolbar == null) {
            DVTLogger.INSTANCE.logError("Current wave status bar not initialized. Trim toolbar could not be found.");
            return;
        }
        this.waveStatusComposite = new Composite(this.trimToolbar, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 0).margins(2, 0).applyTo(this.waveStatusComposite);
        this.button = new Button(this.waveStatusComposite, 0);
        this.button.setImage(DVTImages.imageCache.getImage(DVTImages.WAVE_FILE_PIN));
        this.button.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.button);
        this.label = new Label(this.waveStatusComposite, 0);
        this.label.setToolTipText("No current waveform viewer");
        this.label.setText(N_A);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.label);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject lastSelectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
                if (lastSelectedProject == null) {
                    return;
                }
                WaveDiagramEditor editor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(lastSelectedProject);
                if (editor == null) {
                    return;
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) {
                    return;
                }
                page.activate((IWorkbenchPart)editor);
            }
        });
        DVTWaveViewIDEFactory.getInstance().addCurrentWaveListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        DVTPlugin.getSelectionManager().addResourceSelectionChangeListener(Utils.getActiveWorkbenchWindow(), this);
        this.trimToolbar.addDisposeListener(e -> this.dispose());
        this.trimToolbar.layout();
    }

    private void dispose() {
        DVTWaveViewIDEFactory.getInstance().removeCurrentWaveListener(this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        DVTPlugin.getSelectionManager().removeResourceSelectionChangeListener(Utils.getActiveWorkbenchWindow(), this);
    }

    @Override
    public void notifyCurrentWaveChanged(WaveDiagramEditor editor) {
        IPath location;
        WaveDiagramEditorInput editorInput = this.computeEditorInput(editor);
        String toolTipText = editorInput == null ? null : "Current waveform viewer: " + editorInput.getToolTipText();
        IFile file = editorInput == null ? null : editorInput.getFile();
        IPath iPath = location = file == null ? null : file.getLocation();
        if (toolTipText == null || location == null) {
            this.label.setToolTipText("No current waveform viewer");
            this.label.setText(N_A);
            this.button.setToolTipText("No current waveform viewer");
            this.button.setEnabled(false);
        } else {
            this.label.setToolTipText(toolTipText);
            this.label.setText(location.lastSegment());
            this.button.setToolTipText(String.valueOf(toolTipText) + " (click to reveal)");
            this.button.setEnabled(true);
        }
        if (this.trimToolbar != null) {
            this.trimToolbar.layout();
        }
    }

    private WaveDiagramEditorInput computeEditorInput(WaveDiagramEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof WaveDiagramEditorInput)) {
            return null;
        }
        return (WaveDiagramEditorInput)editorInput;
    }

    private void asyncRefresh(IProject project) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.notifyCurrentWaveChanged(DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(project)));
    }

    @Override
    public void resourceSelectionChanged(IResource resource) {
        if (resource != null && !(resource instanceof IProject)) {
            resource = resource.getProject();
        }
        if (!(resource instanceof IProject)) {
            return;
        }
        this.asyncRefresh((IProject)resource);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta == null) {
                            return false;
                        }
                        if (delta.getResource() instanceof IProject && delta.getFlags() == 16384) {
                            CurrentWaveStatusBarIndicator.this.asyncRefresh((IProject)delta.getResource());
                            return false;
                        }
                        return delta.getResource() instanceof IWorkspaceRoot;
                    }
                });
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Composite getWaveStatusComposite() {
        return this.waveStatusComposite;
    }
}

