/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ro.amiq.dvt.diagrams.wave.WSignalsTableElementsFactory;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditorCommon;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCursor;
import ro.amiq.dvt.diagrams.wave.draw.WMarker;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum DVTVCDConfigFilesEngine {
    INSTANCE;

    private static final String EXPORT_CURRENT_CONFIG_ERROR = "Export Current Config Error";
    private static final String NO_CONFIG_TO_EXPORT = "No valid configuration found!\nCurrent waveform viewer configuration is empty!";
    private static final String IMPORT_CONFIG_ERROR = "Import Config Error";
    private static final String CONFIG_NOT_FOUND = "Selected config file not found!";
    private static final String UNKOWN_SIGNALS_TABLE_ELEMENT_TYPE = "Unkown signals table element type ";

    public void exportCurrentConfig(WViewport viewport) {
        TreeSet<WSignalsTableElement> signalsTableElements = viewport.getSignalsTableElements();
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (signalsTableElements == null || signalsTableElements.isEmpty()) {
            MessageDialog.openError((Shell)activeShell, (String)EXPORT_CURRENT_CONFIG_ERROR, (String)NO_CONFIG_TO_EXPORT);
            return;
        }
        FileDialog cfgFileDialog = new FileDialog(activeShell, 8192);
        cfgFileDialog.setText("Export Current Config");
        cfgFileDialog.setFilterExtensions(new String[]{"*.wcfg"});
        cfgFileDialog.setFilterIndex(0);
        cfgFileDialog.setFilterPath(DVTVCDUtils.getWaveFileDirectory(viewport));
        String cfgFilePath = cfgFileDialog.open();
        if (cfgFilePath == null || cfgFilePath.isEmpty()) {
            return;
        }
        String vcdFilePath = DVTVCDUtils.getVcdFilePath(viewport);
        String dstFilePath = DVTVCDUtils.getDstFilePath(viewport);
        this.serializeDiagramState(viewport, cfgFilePath, vcdFilePath, dstFilePath);
    }

    public void exportDefaultConfig(WViewport viewport) {
        String vcdFilePath = DVTVCDUtils.getVcdFilePath(viewport);
        String dstFilePath = DVTVCDUtils.getDstFilePath(viewport);
        String validFilePath = vcdFilePath;
        if (validFilePath == null || validFilePath.isEmpty() || "missing source".equals(validFilePath)) {
            validFilePath = dstFilePath;
        }
        if (validFilePath == null || validFilePath.isEmpty()) {
            return;
        }
        String defaultConfigFilePath = this.getDefaultConfigFilePath(validFilePath);
        DVTVCDParser parser = viewport.getCanvas().getProvider();
        if (defaultConfigFilePath == null || defaultConfigFilePath.isEmpty()) {
            return;
        }
        parser.setConfigFilePath(defaultConfigFilePath);
        this.serializeDiagramState(viewport, defaultConfigFilePath, vcdFilePath, dstFilePath);
    }

    public void serializeDiagramState(WViewport viewport, final String cfgFilePath, final String vcdFilePath, final String dstFilePath) {
        final long lowestVisibleTime = viewport.getLowestVisibleTime();
        final long highestVisibleTime = viewport.getHighestVisibleTime();
        final WCursor primaryCursorCopy = new WCursor(viewport.getPrimaryCursor());
        final WCursor secondaryCursorCopy = new WCursor(viewport.getSecondaryCursor());
        final List<WMarker> markers = viewport.getMarkers();
        ArrayList<WMarker> markersCopy = new ArrayList<WMarker>();
        for (WMarker marker : markers) {
            markersCopy.add(new WMarker(marker));
        }
        TreeSet<WSignalsTableElement> signalsTableElements = viewport.getSignalsTableElements();
        final TreeSet<WSignalsTableElement> signalsTableElementsCopy = new TreeSet<WSignalsTableElement>(WSignalsTableElement.ELEMENTS_COMPARATOR);
        for (WSignalsTableElement element : signalsTableElements) {
            signalsTableElementsCopy.add(WSignalsTableElementsFactory.INSTANCE.createCopyOf(element));
        }
        new Job("Exporting current configuration"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    JSONObject root = new JSONObject();
                    if (vcdFilePath != null) {
                        root.put("vcdPath", vcdFilePath);
                    }
                    if (dstFilePath != null) {
                        root.put("dstPath", dstFilePath);
                    }
                    root.put("lowestVisibleTime", lowestVisibleTime);
                    root.put("highestVisibleTime", highestVisibleTime);
                    root.put("primaryCursorTime", primaryCursorCopy.getTime());
                    root.put("secondaryCursorTime", secondaryCursorCopy.getTime());
                    ArrayList<JSONObject> markersJson = new ArrayList<JSONObject>();
                    for (WMarker marker : markers) {
                        JSONObject markerJson = new JSONObject();
                        markerJson.put("markerLabel", marker.getLabel());
                        markerJson.put("markerTime", marker.getTime());
                        markersJson.add(markerJson);
                    }
                    root.put("markers", markersJson);
                    root.put("elements", DVTVCDConfigFilesEngine.this.signalsTableElementsToJSONArray(signalsTableElementsCopy));
                    File file = new File(cfgFilePath);
                    DVTFileUtils.getInstance().writeStringToFile(file, root.toString(2), false);
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    if (workspaceRoot == null) {
                        return Status.OK_STATUS;
                    }
                    IFile configFile = workspaceRoot.getFileForLocation((IPath)new Path(cfgFilePath));
                    try {
                        if (configFile != null) {
                            configFile.refreshLocal(0, null);
                        }
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private JSONArray signalsTableElementsToJSONArray(TreeSet<WSignalsTableElement> signalsTableElements) throws JSONException {
        JSONArray elementsJsonArray = new JSONArray();
        for (WSignalsTableElement element : signalsTableElements) {
            JSONObject elementJson = this.signalsTableElementToJSONObject(element);
            if (elementJson == null) {
                DVTLogger.INSTANCE.logError(UNKOWN_SIGNALS_TABLE_ELEMENT_TYPE + element.getName());
                continue;
            }
            elementsJsonArray.put(elementJson);
        }
        return elementsJsonArray;
    }

    private JSONObject signalsTableElementToJSONObject(WSignalsTableElement element) throws JSONException {
        if (element instanceof WSignalsTableGroup) {
            return this.groupToJSONObject((WSignalsTableGroup)element);
        }
        if (element instanceof WSignalsTableSeparator) {
            return this.separatorToJSONObject((WSignalsTableSeparator)element);
        }
        if (element instanceof WSignalsTableSignal) {
            return this.signalToJSONObject((WSignalsTableSignal)element);
        }
        return null;
    }

    private JSONObject groupToJSONObject(WSignalsTableGroup group) throws JSONException {
        JSONObject groupJson = new JSONObject();
        groupJson.put("elementName", group.getName());
        groupJson.put("elementType", "group");
        groupJson.put("backgroundColor", this.rgbToString(group.getBackgroundColor()));
        TreeSet<WSignalsTableElement> childElements = group.getChildElements();
        groupJson.put("children", this.childElementsToJSONArray(childElements));
        return groupJson;
    }

    private JSONArray childElementsToJSONArray(TreeSet<WSignalsTableElement> childElements) throws JSONException {
        JSONArray childElementsJsonArray = new JSONArray();
        for (WSignalsTableElement childElement : childElements) {
            childElementsJsonArray.put(this.signalsTableElementToJSONObject(childElement));
        }
        return childElementsJsonArray;
    }

    private JSONObject separatorToJSONObject(WSignalsTableSeparator separator) throws JSONException {
        JSONObject separatorJson = new JSONObject();
        separatorJson.put("elementName", separator.getName());
        separatorJson.put("elementType", "separator");
        separatorJson.put("backgroundColor", this.rgbToString(separator.getBackgroundColor()));
        return separatorJson;
    }

    private JSONObject signalToJSONObject(WSignalsTableSignal signal) throws JSONException {
        if (signal instanceof WSignalsTableSingleBitSignal) {
            return this.singleBitSignalToJSONObject((WSignalsTableSingleBitSignal)signal);
        }
        if (signal instanceof WSignalsTableMultiBitSignal) {
            return this.multiBitSignalToJSONObject((WSignalsTableMultiBitSignal)signal);
        }
        return null;
    }

    private JSONObject singleBitSignalToJSONObject(WSignalsTableSingleBitSignal signal) throws JSONException {
        JSONObject signalJson = new JSONObject();
        signalJson.put("elementName", signal.getName());
        signalJson.put("elementDesignPath", signal.getVcdPath().toString("/"));
        signalJson.put("signalRadix", "2");
        signalJson.put("waveColor", this.rgbToString(signal.getWaveColor()));
        signalJson.put("textColor", this.rgbToString(DVTVCDUtils.WHITE));
        signalJson.put("backgroundColor", this.rgbToString(signal.getBackgroundColor()));
        signalJson.put("type", signal.getType());
        signalJson.put("bitwidth", 1);
        if (signal instanceof WSignalsTableSingleBitChildSignal) {
            signalJson.put("elementType", "sbc");
            signalJson.put("index", ((WSignalsTableSingleBitChildSignal)signal).getIndex());
        } else {
            signalJson.put("elementType", "sb");
        }
        return signalJson;
    }

    private JSONObject multiBitSignalToJSONObject(WSignalsTableMultiBitSignal signal) throws JSONException {
        JSONObject signalJson = new JSONObject();
        signalJson.put("elementName", signal.getName());
        signalJson.put("elementDesignPath", signal.getVcdPath().toString("/"));
        signalJson.put("signalRadix", signal.getBase());
        signalJson.put("waveColor", this.rgbToString(signal.getWaveColor()));
        signalJson.put("textColor", this.rgbToString(signal.getTextColor()));
        signalJson.put("backgroundColor", this.rgbToString(signal.getBackgroundColor()));
        signalJson.put("type", signal.getType());
        signalJson.put("bitwidth", signal.getBitWidth());
        signalJson.put("isBigEndian", signal.isBigEndian());
        if (signal instanceof WSignalsTableMultiBitChildSignal) {
            signalJson.put("elementType", "mbc");
            signalJson.put("startIndex", signal.getStartIndex());
            signalJson.put("endIndex", signal.getEndIndex());
        } else if (signal instanceof WSignalsTableStructSignal) {
            signalJson.put("elementType", "str");
        } else {
            signalJson.put("elementType", "mb");
        }
        TreeSet<WSignalsTableElement> childElements = signal.getChildElements();
        signalJson.put("children", this.childElementsToJSONArray(childElements));
        return signalJson;
    }

    private String rgbToString(RGB rgb) {
        if (rgb == null) {
            return "";
        }
        return String.valueOf(rgb.red) + "," + " " + rgb.green + "," + " " + rgb.blue;
    }

    public void importConfig(WaveViewerSignalTableView signalsView, WCanvas canvas) {
        Shell activeShell = Display.getCurrent().getActiveShell();
        FileDialog cfgFileDialog = new FileDialog(activeShell);
        WViewport viewport = canvas.getViewport();
        cfgFileDialog.setText("Import Config");
        cfgFileDialog.setFilterExtensions(new String[]{"*.wcfg"});
        cfgFileDialog.setFilterPath(DVTVCDUtils.getWaveFileDirectory(viewport));
        String cfgFilePath = cfgFileDialog.open();
        if (cfgFilePath == null || cfgFilePath.isEmpty()) {
            return;
        }
        String cfgJsonString = DVTFileUtils.getInstance().readFileContent(new File(cfgFilePath));
        if (cfgJsonString.isEmpty()) {
            MessageDialog.openError((Shell)activeShell, (String)IMPORT_CONFIG_ERROR, (String)CONFIG_NOT_FOUND);
            return;
        }
        WaveDiagramEditor waveEditor = signalsView.getWaveEditor();
        if (waveEditor == null) {
            return;
        }
        this.deserializeSignalsTableElements(waveEditor, canvas, cfgJsonString);
    }

    public void deserializeSignalsTableElements(final WaveDiagramEditorCommon waveEditor, final WCanvas canvas, final String configJsonString) {
        new Job("Importing configuration"){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static /* synthetic */ void lambda$0() {
                Shell activeShell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)activeShell, (String)"Import Config", (String)"Import failed due to poorly formated config file!");
            }
        }.schedule();
    }

    List<WMarker> deserializeMarkers(JSONObject rootJson) throws JSONException {
        Object object = rootJson.get("markers");
        if (!(object instanceof JSONArray)) {
            return Collections.emptyList();
        }
        JSONArray markersJson = (JSONArray)object;
        if (markersJson.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<WMarker> markers = new ArrayList<WMarker>();
        int i = 0;
        while (i < markersJson.length()) {
            JSONObject markerJson = markersJson.getJSONObject(i);
            String markerLabel = markerJson.getString("markerLabel");
            long markerTime = markerJson.getLong("markerTime");
            markers.add(new WMarker(markerLabel, markerTime));
            ++i;
        }
        return markers;
    }

    private TreeSet<WSignalsTableElement> deserializeSignalsTableElements(JSONObject rootJson, DVTVCDModel vcdModel) throws JSONException {
        Object object = rootJson.get("elements");
        if (!(object instanceof JSONArray)) {
            return null;
        }
        JSONArray elementsJson = (JSONArray)object;
        if (elementsJson.length() == 0) {
            return null;
        }
        HashMap<String, DVTVCDSignalWrapper> signalsByDesignPath = new HashMap<String, DVTVCDSignalWrapper>();
        LinkedHashMap<String, DVTVCDSignalWrapper> signalsById = vcdModel.getSignalsByModelId();
        for (Map.Entry<String, DVTVCDSignalWrapper> signalById : signalsById.entrySet()) {
            signalsByDesignPath.put(signalById.getValue().getPath().toString("/"), signalById.getValue());
        }
        TreeSet<WSignalsTableElement> signalsTableElements = new TreeSet<WSignalsTableElement>(WSignalsTableElement.ELEMENTS_COMPARATOR);
        int i = 0;
        while (i < elementsJson.length()) {
            WSignalsTableElement element;
            Object elementJson = elementsJson.get(i);
            if (elementJson instanceof JSONObject && (element = this.jsonObjectToSignalsTableElement((JSONObject)elementJson, signalsByDesignPath, i)) != null) {
                signalsTableElements.add(element);
            }
            ++i;
        }
        return signalsTableElements;
    }

    private WSignalsTableElement jsonObjectToSignalsTableElement(JSONObject nodeJson, Map<String, DVTVCDSignalWrapper> signalsByDesignPath, int elementId) throws JSONException {
        String elementType = this.deserializeType(nodeJson.get("elementType"), String.class);
        if ("group".equals(elementType)) {
            return this.jsonObjectToGroup(nodeJson, signalsByDesignPath, elementId);
        }
        if ("separator".equals(elementType)) {
            return this.jsonObjectToSeparator(nodeJson, elementId);
        }
        String signalDesignPath = this.deserializeType(nodeJson.get("elementDesignPath"), String.class);
        if (signalDesignPath == null) {
            return null;
        }
        DVTVCDSignalWrapper vcdSignalWrapper = signalsByDesignPath.get(signalDesignPath);
        if (vcdSignalWrapper == null) {
            return null;
        }
        return this.jsonObjectToSignal(nodeJson, vcdSignalWrapper, elementId, vcdSignalWrapper.getStructMetadata());
    }

    private WSignalsTableGroup jsonObjectToGroup(JSONObject groupJson, Map<String, DVTVCDSignalWrapper> signalsByDesignPath, int nodeId) throws JSONException {
        String name = this.deserializeType(groupJson.get("elementName"), String.class);
        if (name == null) {
            return null;
        }
        String backgroundColor = this.deserializeType(groupJson.get("backgroundColor"), String.class);
        if (backgroundColor == null) {
            return null;
        }
        TreeSet<WSignalsTableElement> childElements = new TreeSet<WSignalsTableElement>(WSignalsTableElement.ELEMENTS_COMPARATOR);
        JSONArray childElementsJson = this.deserializeType(groupJson.get("children"), JSONArray.class);
        if (childElementsJson == null || childElementsJson.length() == 0) {
            WSignalsTableGroup group = new WSignalsTableGroup(nodeId, name, null, childElements);
            group.setBackgroundColor(this.stringToRgb(backgroundColor));
            return group;
        }
        Object object = null;
        int nodeOrderId = 0;
        int i = 0;
        while (i < childElementsJson.length()) {
            WSignalsTableElement childElement;
            object = childElementsJson.get(i);
            if (object instanceof JSONObject && (childElement = this.jsonObjectToSignalsTableElement((JSONObject)object, signalsByDesignPath, nodeOrderId)) != null) {
                childElements.add(childElement);
                ++nodeOrderId;
            }
            ++i;
        }
        WSignalsTableGroup group = new WSignalsTableGroup(nodeId, name, null, childElements);
        group.setBackgroundColor(this.stringToRgb(backgroundColor));
        return group;
    }

    private WSignalsTableSeparator jsonObjectToSeparator(JSONObject separatorJson, int elementId) throws JSONException {
        String name = this.deserializeType(separatorJson.get("elementName"), String.class);
        if (name == null) {
            return null;
        }
        String backgroundColor = this.deserializeType(separatorJson.get("backgroundColor"), String.class);
        if (backgroundColor == null) {
            return null;
        }
        WSignalsTableSeparator separator = new WSignalsTableSeparator(elementId, name, null);
        separator.setBackgroundColor(this.stringToRgb(backgroundColor));
        return separator;
    }

    private WSignalsTableSignal jsonObjectToSignal(JSONObject signalJson, DVTVCDSignalWrapper vcdSignalWrapper, int elementId, WStructMetadata structMetadata) throws JSONException {
        String elementType = this.deserializeType(signalJson.get("elementType"), String.class);
        if (elementType == null) {
            return null;
        }
        if ("sb".equals(elementType)) {
            return this.jsonObjectToSingleBitSignal(signalJson, vcdSignalWrapper, elementId);
        }
        if ("sbc".equals(elementType)) {
            return this.jsonObjectToSingleBitChildSignal(signalJson, vcdSignalWrapper, structMetadata, elementId);
        }
        if ("mbc".equals(elementType)) {
            return this.jsonObjectToMultiBitChildSignal(signalJson, vcdSignalWrapper, structMetadata, elementId);
        }
        if ("mb".equals(elementType)) {
            return this.jsonObjectToMultiBitSignal(signalJson, vcdSignalWrapper, elementId);
        }
        return this.jsonObjectToStructSignal(signalJson, vcdSignalWrapper, structMetadata, elementId);
    }

    private void restoreAttributes(JSONObject signalJson, WSignalsTableSignal signalWrapper) throws JSONException {
        String base = this.deserializeType(signalJson.get("signalRadix"), String.class);
        if (base == null) {
            return;
        }
        String waveColor = this.deserializeType(signalJson.get("waveColor"), String.class);
        if (waveColor == null) {
            return;
        }
        String textColor = this.deserializeType(signalJson.get("textColor"), String.class);
        if (textColor == null) {
            return;
        }
        String backgroundColor = this.deserializeType(signalJson.get("backgroundColor"), String.class);
        if (backgroundColor == null) {
            return;
        }
        signalWrapper.setWaveColor(this.stringToRgb(waveColor));
        signalWrapper.setBackgroundColor(this.stringToRgb(backgroundColor));
        if (!(signalWrapper instanceof WSignalsTableMultiBitSignal)) {
            return;
        }
        WSignalsTableMultiBitSignal multiBitWrapper = (WSignalsTableMultiBitSignal)signalWrapper;
        multiBitWrapper.setBase(base);
        multiBitWrapper.setTextColor(this.stringToRgb(textColor));
    }

    private void restoreAttributesRecursive(JSONObject signalJson, WSignalsTableSignal signalWrapper) throws JSONException {
        String base = this.deserializeType(signalJson.get("signalRadix"), String.class);
        if (base == null) {
            return;
        }
        String waveColor = this.deserializeType(signalJson.get("waveColor"), String.class);
        if (waveColor == null) {
            return;
        }
        String textColor = this.deserializeType(signalJson.get("textColor"), String.class);
        if (textColor == null) {
            return;
        }
        String backgroundColor = this.deserializeType(signalJson.get("backgroundColor"), String.class);
        if (backgroundColor == null) {
            return;
        }
        signalWrapper.setWaveColor(this.stringToRgb(waveColor));
        signalWrapper.setBackgroundColor(this.stringToRgb(backgroundColor));
        if (!(signalWrapper instanceof WSignalsTableMultiBitSignal var7_8)) {
            return;
        }
        multiBitWrapper.setBase(base);
        multiBitWrapper.setTextColor(this.stringToRgb(textColor));
        JSONArray childElementsJson = this.deserializeType(signalJson.get("children"), JSONArray.class);
        if (childElementsJson == null) {
            return;
        }
        int childAttributesIndex = 0;
        for (WSignalsTableElement childElement : multiBitWrapper.getChildElements()) {
            if (!(childElement instanceof WSignalsTableSignal var13_13)) continue;
            if (childAttributesIndex > childElementsJson.length()) break;
            Object childAttributes = childElementsJson.opt(childAttributesIndex);
            if (!(childAttributes instanceof JSONObject var16_16)) {
                return;
            }
            String elementName = this.deserializeType(jsonChildAttributes.get("elementName"), String.class);
            if (elementName == null) {
                return;
            }
            if (!elementName.equals(childElement.getName())) continue;
            this.restoreAttributesRecursive((JSONObject)jsonChildAttributes, (WSignalsTableSignal)childSignal);
            ++childAttributesIndex;
        }
    }

    private WSignalsTableSingleBitSignal jsonObjectToSingleBitSignal(JSONObject signalJson, DVTVCDSignalWrapper vcdSignalWrapper, int elementId) throws JSONException {
        String name = this.deserializeType(signalJson.get("elementName"), String.class);
        if (name == null) {
            return null;
        }
        String type = this.deserializeType(signalJson.get("type"), String.class);
        if (type == null) {
            return null;
        }
        String vcdId = vcdSignalWrapper.getVarID();
        WSignalElementPath vcdPath = vcdSignalWrapper.getPath();
        WSignalsTableSingleBitSignal signal = new WSignalsTableSingleBitSignal(elementId, name, null, vcdId, vcdPath, type);
        this.restoreAttributes(signalJson, signal);
        return signal;
    }

    private WSignalsTableSingleBitChildSignal jsonObjectToSingleBitChildSignal(JSONObject signalJson, DVTVCDSignalWrapper vcdSignalWrapper, WStructMetadata structMetadata, int elementId) throws JSONException {
        String name = this.deserializeType(signalJson.get("elementName"), String.class);
        if (name == null) {
            return null;
        }
        String type = this.deserializeType(signalJson.get("type"), String.class);
        if (type == null) {
            return null;
        }
        Integer index = this.deserializeType(signalJson.get("index"), Integer.class);
        if (index == null) {
            return null;
        }
        String vcdId = vcdSignalWrapper.getVarID();
        WSignalElementPath vcdPath = vcdSignalWrapper.getPath();
        if (structMetadata != null && structMetadata.getBitWidth() == 1) {
            name = structMetadata.getName();
        }
        WSignalsTableSingleBitChildSignal signal = new WSignalsTableSingleBitChildSignal(elementId, name, null, vcdId, vcdPath, type, index, null);
        this.restoreAttributes(signalJson, signal);
        return signal;
    }

    private WSignalsTableMultiBitSignal jsonObjectToStructSignal(JSONObject signalJson, DVTVCDSignalWrapper vcdSignalWrapper, WStructMetadata structMetadata, int elementId) throws JSONException {
        if (structMetadata == null) {
            WSignalsTableMultiBitSignal signal = (WSignalsTableMultiBitSignal)WSignalsTableElementsFactory.INSTANCE.createSignal(elementId, vcdSignalWrapper);
            this.restoreAttributesRecursive(signalJson, signal);
            return signal;
        }
        String name = this.deserializeType(signalJson.get("elementName"), String.class);
        if (name == null) {
            return null;
        }
        String type = this.deserializeType(signalJson.get("type"), String.class);
        if (type == null) {
            return null;
        }
        Integer bitWidth = this.deserializeType(signalJson.get("bitwidth"), Integer.class);
        if (bitWidth == null) {
            return null;
        }
        String vcdId = vcdSignalWrapper.getVarID();
        WSignalElementPath vcdPath = vcdSignalWrapper.getPath();
        TreeSet<WSignalsTableElement> childElements = this.createStructChildren(signalJson, vcdSignalWrapper, structMetadata);
        WSignalsTableStructSignal signal = new WSignalsTableStructSignal(elementId, name, null, vcdId, vcdPath, bitWidth, type, structMetadata, null);
        signal.setChildElements(childElements);
        this.restoreAttributes(signalJson, signal);
        return signal;
    }

    private WSignalsTableMultiBitSignal jsonObjectToMultiBitSignal(JSONObject signalJson, DVTVCDSignalWrapper vcdSignalWrapper, int elementId) throws JSONException {
        Integer bitWidth = this.deserializeType(signalJson.get("bitwidth"), Integer.class);
        if (bitWidth == null) {
            return null;
        }
        WStructMetadata structMetadata = vcdSignalWrapper.getStructMetadata();
        if (structMetadata != null) {
            WSignalsTableMultiBitSignal signal = (WSignalsTableMultiBitSignal)WSignalsTableElementsFactory.INSTANCE.createSignal(elementId, vcdSignalWrapper);
            this.restoreAttributesRecursive(signalJson, signal);
            return signal;
        }
        String name = this.deserializeType(signalJson.get("elementName"), String.class);
        if (name == null) {
            return null;
        }
        String type = this.deserializeType(signalJson.get("type"), String.class);
        if (type == null) {
            return null;
        }
        Boolean isBigEndian = this.deserializeType(signalJson.get("isBigEndian"), Boolean.class);
        if (isBigEndian == null) {
            return null;
        }
        int[] indexBounds = DVTVCDUtils.getPackedArrayIndexBounds(vcdSignalWrapper.getPath().getDimension(), isBigEndian, bitWidth);
        int startIndex = indexBounds[0];
        int endIndex = indexBounds[1];
        String vcdId = vcdSignalWrapper.getVarID();
        WSignalElementPath vcdPath = vcdSignalWrapper.getPath();
        TreeSet<WSignalsTableElement> childElements = this.createMultiBitChildren(signalJson, vcdSignalWrapper, structMetadata);
        if (childElements == null) {
            WSignalsTableMultiBitSignal signal = (WSignalsTableMultiBitSignal)WSignalsTableElementsFactory.INSTANCE.createSignal(elementId, vcdSignalWrapper);
            this.restoreAttributesRecursive(signalJson, signal);
            return signal;
        }
        WSignalsTableMultiBitSignal signal = new WSignalsTableMultiBitSignal(elementId, name, null, vcdId, vcdPath, bitWidth, type, isBigEndian, startIndex, endIndex);
        signal.setChildElements(childElements);
        this.restoreAttributes(signalJson, signal);
        return signal;
    }

    private WSignalsTableMultiBitSignal jsonObjectToMultiBitChildSignal(JSONObject signalJson, DVTVCDSignalWrapper vcdSignalWrapper, WStructMetadata structMetadata, int elementId) throws JSONException {
        Integer bitwidth = this.deserializeType(signalJson.get("bitwidth"), Integer.class);
        if (bitwidth == null) {
            return null;
        }
        if (structMetadata != null && !structMetadata.getMembers().isEmpty() && structMetadata.getBitWidth() == bitwidth.intValue()) {
            return null;
        }
        String name = this.deserializeType(signalJson.get("elementName"), String.class);
        if (name == null) {
            return null;
        }
        String type = this.deserializeType(signalJson.get("type"), String.class);
        if (type == null) {
            return null;
        }
        Integer startIndex = this.deserializeType(signalJson.get("startIndex"), Integer.class);
        if (startIndex == null) {
            return null;
        }
        Integer endIndex = this.deserializeType(signalJson.get("endIndex"), Integer.class);
        if (endIndex == null) {
            return null;
        }
        Boolean isBigEndian = this.deserializeType(signalJson.get("isBigEndian"), Boolean.class);
        if (isBigEndian == null) {
            return null;
        }
        String vcdId = vcdSignalWrapper.getVarID();
        WSignalElementPath vcdPath = vcdSignalWrapper.getPath();
        TreeSet<WSignalsTableElement> childElements = this.createMultiBitChildren(signalJson, vcdSignalWrapper, structMetadata);
        if (childElements == null) {
            return null;
        }
        WSignalsTableMultiBitChildSignal signal = new WSignalsTableMultiBitChildSignal(elementId, name, null, vcdId, vcdPath, bitwidth, type, isBigEndian, startIndex, endIndex, null);
        signal.setChildElements(childElements);
        this.restoreAttributes(signalJson, signal);
        return signal;
    }

    private TreeSet<WSignalsTableElement> createMultiBitChildren(JSONObject signalJson, DVTVCDSignalWrapper vcdSignalWrapper, WStructMetadata structMetadata) throws JSONException {
        TreeSet<WSignalsTableElement> childElements = new TreeSet<WSignalsTableElement>(WSignalsTableElement.ELEMENTS_COMPARATOR);
        JSONArray childElementsJson = this.deserializeType(signalJson.get("children"), JSONArray.class);
        if (childElementsJson == null) {
            return null;
        }
        Object object = null;
        int nodeOrderId = 0;
        int i = 0;
        while (i < childElementsJson.length()) {
            object = childElementsJson.get(i);
            if (object instanceof JSONObject) {
                String elementType = this.deserializeType(((JSONObject)object).get("elementType"), String.class);
                if (elementType == null) {
                    return null;
                }
                if ("str".equals(elementType) && structMetadata == null) {
                    return null;
                }
                WSignalsTableSignal childElement = this.jsonObjectToSignal((JSONObject)object, vcdSignalWrapper, nodeOrderId, structMetadata);
                if (childElement != null) {
                    childElements.add(childElement);
                    ++nodeOrderId;
                }
            }
            ++i;
        }
        return childElements;
    }

    private TreeSet<WSignalsTableElement> createStructChildren(JSONObject signalJson, DVTVCDSignalWrapper vcdSignalWrapper, WStructMetadata structMetadata) throws JSONException {
        TreeSet<WSignalsTableElement> childElements = new TreeSet<WSignalsTableElement>(WSignalsTableElement.ELEMENTS_COMPARATOR);
        JSONArray childElementsJson = this.deserializeType(signalJson.get("children"), JSONArray.class);
        if (childElementsJson == null) {
            return null;
        }
        Object object = null;
        int nodeOrderId = 0;
        List<WStructMetadata> structActualChildren = structMetadata.getMembers();
        if (structActualChildren == null) {
            return null;
        }
        int i = 0;
        while (i < childElementsJson.length() && i < structActualChildren.size()) {
            object = childElementsJson.get(i);
            if (object instanceof JSONObject var10_10) {
                String structChildName = this.deserializeType(signalJson.get("elementName"), String.class);
                WStructMetadata childMetadata = structMetadata.getMember(structChildName);
                if (childMetadata == null) {
                    childMetadata = structActualChildren.get(i);
                }
                if ((childElement = this.jsonObjectToSignal((JSONObject)jsonObject, vcdSignalWrapper, nodeOrderId, childMetadata)) != null) {
                    childElements.add(childElement);
                    ++nodeOrderId;
                }
            }
            ++i;
        }
        return childElements;
    }

    public String extractFilePathFromConfig(String configFilePath, DVTVCDUtilsCommon.WaveFileFormat fileFormat) {
        String filePath;
        block10: {
            block9: {
                try {
                    if (configFilePath != null) break block9;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            String cfgJsonString = DVTFileUtils.getInstance().readFileContent(new File(configFilePath));
            filePath = null;
            switch (fileFormat) {
                case VCD: {
                    filePath = INSTANCE.deserializeFilePath("vcdPath", cfgJsonString);
                    break;
                }
                case DST: {
                    filePath = INSTANCE.deserializeFilePath("dstPath", cfgJsonString);
                    break;
                }
                case ALL_TYPES: {
                    filePath = INSTANCE.deserializeFilePath("dstPath", cfgJsonString);
                    if (!"missing source".equals(filePath) && DVTVCDUtils.checkFileExists(filePath)) break;
                    filePath = INSTANCE.deserializeFilePath("vcdPath", cfgJsonString);
                    break;
                }
            }
            if (!"missing source".equals(filePath) && DVTVCDUtils.checkFileExists(filePath)) break block10;
            return null;
        }
        return filePath;
    }

    public String deserializeFilePath(String fileFormat, String configJsonString) throws JSONException {
        JSONObject rootJson = new JSONObject(configJsonString);
        Object filePath = rootJson.opt(fileFormat);
        if (filePath == null) {
            return null;
        }
        return this.deserializeType(filePath, String.class);
    }

    private RGB stringToRgb(String rgbString) {
        if (rgbString.isEmpty()) {
            return null;
        }
        String[] rgbSplitString = rgbString.split(",");
        int r = Integer.parseInt(rgbSplitString[0].trim());
        int g = Integer.parseInt(rgbSplitString[1].trim());
        int b = Integer.parseInt(rgbSplitString[2].trim());
        return ColorFactory.getInstance().getRGB(r, g, b);
    }

    private <T> T deserializeType(Object object, Class<T> type) {
        return type == object.getClass() ? (T)type.cast(object) : null;
    }

    public String getDefaultConfigFilePath(String vcdFilePath) {
        StringBuilder cfgFilePathBuilder = new StringBuilder().append(BaseUtils.getFileDirectoryPath(vcdFilePath)).append('/').append(DVTFileUtils.getInstance().getBaseFileName(vcdFilePath)).append("_default").append(".").append("wcfg");
        return cfgFilePathBuilder.toString();
    }
}

