/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTWaveHierarchicalScopeInfo;
import ro.amiq.dvt.ui.waveviewer.TimeChangeWrapper;

public class DVTVCDModel {
    private LinkedHashMap<String, DVTVCDSignalWrapper> signalsByModelId = new LinkedHashMap();
    private HashMap<ElementPath, DVTWaveHierarchicalScopeInfo> scopeInfos = new HashMap();
    private TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo> orderedScopeInfos = new TreeMap((e1, e2) -> {
        DVTWaveHierarchicalScopeInfo scopeInfo1 = this.scopeInfos.get(e1);
        DVTWaveHierarchicalScopeInfo scopeInfo2 = this.scopeInfos.get(e2);
        int treeMapId1 = scopeInfo1.getParseOrderId();
        int treeMapId2 = scopeInfo2.getParseOrderId();
        return treeMapId1 - treeMapId2;
    });

    public void addVarWrapperToModel(String id, DVTVCDSignalWrapper wrapper) {
        this.signalsByModelId.put(id, wrapper);
    }

    public void addVarValueChangeToModel(TimeChangeWrapper timeChange, String id, String newValue, boolean addFirst) {
        DVTVCDSignalWrapper dvtvcdVarWrapper = this.signalsByModelId.get(id);
        if (dvtvcdVarWrapper == null) {
            return;
        }
        dvtvcdVarWrapper.addNewValueAtTime(timeChange, newValue, addFirst);
    }

    public ElementPath getExistingScopePath(ElementPath scopePath) {
        if (!this.scopeInfos.containsKey(scopePath)) {
            return null;
        }
        for (ElementPath existingScopePath : this.scopeInfos.keySet()) {
            if (!scopePath.equals(existingScopePath)) continue;
            return existingScopePath;
        }
        return null;
    }

    public void addScopeInfo(ElementPath scopePath, String scopeType) {
        this.scopeInfos.put(scopePath, new DVTWaveHierarchicalScopeInfo(this.scopeInfos.size(), scopeType));
    }

    public DVTWaveHierarchicalScopeInfo getScopeInfo(ElementPath scopePath) {
        return this.scopeInfos.get(scopePath);
    }

    public void computeOrderedScopeInfos() {
        this.orderedScopeInfos.putAll(this.scopeInfos);
    }

    public TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo> getOrderedScopeInfos() {
        return this.orderedScopeInfos;
    }

    public DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType getScopeType(ElementPath scopePath) {
        DVTWaveHierarchicalScopeInfo scopeInfo = this.scopeInfos.get(scopePath);
        if (scopeInfo == null) {
            return DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType.NONE;
        }
        return scopeInfo.getScopeType();
    }

    public LinkedHashMap<String, DVTVCDSignalWrapper> getSignalsByModelId() {
        return this.signalsByModelId;
    }

    public int getNofVariables() {
        return this.signalsByModelId.size();
    }

    public void deepClean() {
        this.cleanCaches();
        this.signalsByModelId = null;
        if (this.scopeInfos != null) {
            this.scopeInfos.clear();
        }
        this.scopeInfos = null;
        if (this.orderedScopeInfos != null) {
            this.orderedScopeInfos.clear();
        }
        this.orderedScopeInfos = null;
    }

    public void cleanCaches() {
        for (Map.Entry<String, DVTVCDSignalWrapper> varWrapper : this.signalsByModelId.entrySet()) {
            DVTVCDSignalWrapper varValue;
            if (varWrapper == null || (varValue = varWrapper.getValue()) == null) continue;
            varValue.deepClean();
            Object var3_3 = null;
        }
        this.signalsByModelId.clear();
        this.scopeInfos.clear();
        this.orderedScopeInfos.clear();
    }
}

