/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTVarModifQueue;
import ro.amiq.dvt.ui.waveviewer.TimeChangeWrapper;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;

public class DVTVCDNetArrayWrapper
extends DVTVCDSignalWrapper {
    private Map<Integer, DVTVCDSignalWrapper> childSignals = new LinkedHashMap<Integer, DVTVCDSignalWrapper>();
    TreeSet<Long> lastTimeStamps;
    private int startIndex = -1;
    private int endIndex = -1;

    public DVTVCDNetArrayWrapper(String id, int hierarchyId, String type, String bitwidth, WSignalElementPath path) {
        super(id, hierarchyId, type, bitwidth, path);
    }

    public void addChildSignal(DVTVCDSignalWrapper childSignal, int index) {
        this.childSignals.put(index, childSignal);
        if (this.startIndex == -1) {
            this.startIndex = index;
        }
        this.endIndex = index;
        this.bitwidth = Integer.toString(Integer.parseInt(this.bitwidth) + 1);
    }

    @Override
    public ConcurrentLinkedDeque<DVTVCDVarModificationByTime> getVarModificationByTime() {
        ArrayList childrenVarModifsIterators = new ArrayList();
        for (DVTVCDSignalWrapper childSignal : this.childSignals.values()) {
            ConcurrentLinkedDeque<DVTVCDVarModificationByTime> childVarModificationsByTime = childSignal.getVarModificationByTime();
            if (childVarModificationsByTime == null) {
                return this.varModificationByTime;
            }
            childrenVarModifsIterators.add(childVarModificationsByTime.iterator());
        }
        TreeSet<Long> timeStamps = new TreeSet<Long>();
        for (Iterator iterator : childrenVarModifsIterators) {
            while (iterator.hasNext()) {
                timeStamps.add(((DVTVCDVarModificationByTime)iterator.next()).getTime());
            }
        }
        if (timeStamps.equals(this.lastTimeStamps)) {
            return this.varModificationByTime;
        }
        this.lastTimeStamps = timeStamps;
        childrenVarModifsIterators.clear();
        for (DVTVCDSignalWrapper dVTVCDSignalWrapper : this.childSignals.values()) {
            ConcurrentLinkedDeque<DVTVCDVarModificationByTime> childVarModificationsByTime = dVTVCDSignalWrapper.getVarModificationByTime();
            if (childVarModificationsByTime == null) {
                return this.varModificationByTime;
            }
            childrenVarModifsIterators.add(childVarModificationsByTime.iterator());
        }
        int n = Integer.parseInt(this.bitwidth);
        ArrayList<DVTVCDVarModificationByTime> cachedValues = new ArrayList<DVTVCDVarModificationByTime>(this.childSignals.size());
        int i = 0;
        while (i < this.childSignals.size()) {
            cachedValues.add(null);
            ++i;
        }
        for (Long timeStamp : timeStamps) {
            int index = -1;
            DVTVCDVarModificationByTime currentVarModif = new DVTVCDVarModificationByTime(new TimeChangeWrapper(timeStamp, -1L), "0".repeat(n));
            if (!this.varModificationByTime.isEmpty() && this.varModificationByTime.getLast() != null) {
                currentVarModif.setValue(((DVTVCDVarModificationByTime)this.varModificationByTime.getLast()).getValue());
            } else {
                currentVarModif.setValue("0".repeat(n));
            }
            for (Iterator iterator : childrenVarModifsIterators) {
                this.varModificationByTime.addLast(currentVarModif);
                DVTVCDVarModificationByTime cachedValue = (DVTVCDVarModificationByTime)cachedValues.get(++index);
                if (cachedValue != null) {
                    if (cachedValue.getTime() != timeStamp.longValue()) continue;
                    String currentValueAtIndex = cachedValue.getValue();
                    String currentVarModifValue = currentVarModif.getValue();
                    currentVarModif.setValue(String.valueOf(currentVarModifValue.substring(0, index)) + currentValueAtIndex + currentVarModifValue.substring(index + 1));
                    cachedValues.set(index, null);
                    continue;
                }
                if (!iterator.hasNext()) continue;
                DVTVCDVarModificationByTime nextVarModifAtIndex = (DVTVCDVarModificationByTime)iterator.next();
                long timeOfNextChange = nextVarModifAtIndex.getTime();
                if (timeOfNextChange != timeStamp) {
                    cachedValues.set(index, nextVarModifAtIndex);
                    continue;
                }
                String currentValueAtIndex = nextVarModifAtIndex.getValue();
                String currentVarModifValue = currentVarModif.getValue();
                currentVarModif.setValue(String.valueOf(currentVarModifValue.substring(0, index)) + currentValueAtIndex + currentVarModifValue.substring(index + 1));
            }
            this.varModificationByTime.addLast(currentVarModif);
        }
        return this.varModificationByTime;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        for (DVTVCDSignalWrapper childSignal : this.childSignals.values()) {
            childSignal.deepClean();
        }
        this.childSignals.clear();
        this.childSignals = null;
    }

    @Override
    public DVTVarModifQueue<DVTVCDVarModificationByTime> getVarModifsFromFST() {
        if (this.varModifsFromFST != null && !this.varModifsFromFST.isEmpty()) {
            return this.varModifsFromFST;
        }
        this.varModifsFromFST = new DVTVarModifQueue();
        ArrayList childrenVarModifsIterators = new ArrayList();
        for (DVTVCDSignalWrapper childSignal : this.childSignals.values()) {
            DVTVarModifQueue<DVTVCDVarModificationByTime> childVarModifsFromFST = childSignal.getVarModifsFromFST();
            if (childVarModifsFromFST == null || !childSignal.isFullyRead()) {
                return this.varModifsFromFST;
            }
            childrenVarModifsIterators.add(childVarModifsFromFST.iterator());
        }
        TreeSet<Long> timeStamps = new TreeSet<Long>();
        for (Iterator iterator : childrenVarModifsIterators) {
            while (iterator.hasNext()) {
                timeStamps.add(((DVTVCDVarModificationByTime)iterator.next()).getTime());
            }
        }
        childrenVarModifsIterators.clear();
        for (DVTVCDSignalWrapper dVTVCDSignalWrapper : this.childSignals.values()) {
            DVTVarModifQueue<DVTVCDVarModificationByTime> childVarModifsFromFST = dVTVCDSignalWrapper.getVarModifsFromFST();
            if (childVarModifsFromFST == null) {
                return this.varModifsFromFST;
            }
            childrenVarModifsIterators.add(childVarModifsFromFST.iterator());
        }
        int n = Integer.parseInt(this.bitwidth);
        ArrayList<DVTVCDVarModificationByTime> cachedValues = new ArrayList<DVTVCDVarModificationByTime>(this.childSignals.size());
        int i = 0;
        while (i < this.childSignals.size()) {
            cachedValues.add(null);
            ++i;
        }
        for (Long timeStamp : timeStamps) {
            int index = -1;
            DVTVCDVarModificationByTime currentVarModif = new DVTVCDVarModificationByTime(new TimeChangeWrapper(timeStamp, -1L), "0".repeat(n));
            DVTVCDVarModificationByTime prevVarModif = (DVTVCDVarModificationByTime)this.varModifsFromFST.getLastValue();
            if (prevVarModif != null) {
                currentVarModif.setValue(prevVarModif.getValue());
            } else {
                currentVarModif.setValue("0".repeat(n));
            }
            for (Iterator iterator : childrenVarModifsIterators) {
                this.varModifsFromFST.addLast(currentVarModif);
                DVTVCDVarModificationByTime cachedValue = (DVTVCDVarModificationByTime)cachedValues.get(++index);
                if (cachedValue != null) {
                    if (cachedValue.getTime() != timeStamp.longValue()) continue;
                    String currentValueAtIndex = cachedValue.getValue();
                    String currentVarModifValue = currentVarModif.getValue();
                    currentVarModif.setValue(String.valueOf(currentVarModifValue.substring(0, index)) + currentValueAtIndex + currentVarModifValue.substring(index + 1));
                    cachedValues.set(index, null);
                    continue;
                }
                if (!iterator.hasNext()) continue;
                DVTVCDVarModificationByTime nextVarModifAtIndex = (DVTVCDVarModificationByTime)iterator.next();
                long timeOfNextChange = nextVarModifAtIndex.getTime();
                if (timeOfNextChange != timeStamp) {
                    cachedValues.set(index, nextVarModifAtIndex);
                    continue;
                }
                String currentValueAtIndex = nextVarModifAtIndex.getValue();
                String currentVarModifValue = currentVarModif.getValue();
                currentVarModif.setValue(String.valueOf(currentVarModifValue.substring(0, index)) + currentValueAtIndex + currentVarModifValue.substring(index + 1));
            }
            this.varModifsFromFST.addLast(currentVarModif);
        }
        return this.varModifsFromFST;
    }

    @Override
    public WSignalElementPath getPath() {
        this.path.setDimension("[" + this.startIndex + ":" + this.endIndex + "]");
        return this.path;
    }

    public List<String> getAllVarIds() {
        return this.childSignals.values().stream().map(DVTVCDSignalWrapper::getVarID).collect(Collectors.toList());
    }

    public DVTVCDSignalWrapper getSignalAtIndex(int index) {
        return this.childSignals.get(index);
    }
}

