/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldUtils;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDNetArrayWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarClockInfo;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTWaveHierarchicalScopeInfo;
import ro.amiq.dvt.ui.waveviewer.IWaveViwerComputedStruct;
import ro.amiq.dvt.ui.waveviewer.TimeChangeWrapper;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;
import ro.amiq.dvt.ui.waveviewer.WaveViewerGenerationError;

public class DVTVCDParser {
    private IProject project;
    private String vcdFilePath;
    private String configFilePath;
    private RandomAccessFile vcdFile;
    private BufferedInputStream bufferedInputStream;
    private BufferedReader bufferedReader;
    private DVTVCDModel vcdModel;
    private DVTVCDUtilsCommon.UserActions currentAction;
    protected WViewport viewport;
    private long currPositionInFile;
    protected DVTVCDUtilsCommon.TimeScales vcdFileTimescale;
    private LinkedHashMap<Long, TimeChangeWrapper> timeChangesWrapperByTime;
    private Map<String, String> modelIdByVcdId = new HashMap<String, String>();
    private int signalsNo;
    private long firstTimeToGetParsedNext;
    private long firstTimeParsedOnAllVariables;
    private long lastTimeFromVcd;
    private long firstTimeFromVcd;
    private long diagramLowerTimeLimit;
    protected long diagramUpperTimeLimit;
    protected Set<WaveViewerGenerationError> generationErrors;

    public DVTVCDParser(IProject project, String vcdFilePath, String configFilePath, DVTVCDModel vcdModel) {
        this.project = project;
        this.vcdFilePath = vcdFilePath;
        this.vcdModel = vcdModel;
        this.setConfigFilePath(configFilePath);
        this.timeChangesWrapperByTime = new LinkedHashMap();
        this.firstTimeParsedOnAllVariables = -1L;
        this.lastTimeFromVcd = -1L;
        this.firstTimeToGetParsedNext = Long.MAX_VALUE;
        this.diagramLowerTimeLimit = 0L;
        this.diagramUpperTimeLimit = 100L;
        this.firstTimeFromVcd = 0L;
        this.generationErrors = new HashSet<WaveViewerGenerationError>();
    }

    public void setViewport(WViewport viewport) {
        this.viewport = viewport;
    }

    public WViewport getViewport() {
        return this.viewport;
    }

    public void parseInitial() {
        try {
            this.vcdFile = new RandomAccessFile(new File(this.vcdFilePath), "r");
            this.createBufferedLayer();
            this.parseAndCollectVarDefAndDumpvarsSections();
            if (this.getNofVariablesInModel() == 0) {
                this.generationErrors.add(WaveViewerGenerationError.NO_SIGNALS_FOUND_IN_VCD_FILE);
                return;
            }
            this.collectLastTimeFromVcd();
            this.parseAndCollectNextLinesInFile(true);
            this.diagramUpperTimeLimit = this.firstTimeToGetParsedNext;
            this.vcdModel.computeOrderedScopeInfos();
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException && e.getMessage().endsWith("(Permission denied)")) {
                this.generationErrors.add(WaveViewerGenerationError.VCD_FILE_MISSING_READ_PERMISSION);
            } else if (e instanceof FileNotFoundException) {
                this.generationErrors.add(WaveViewerGenerationError.VCD_FILE_NOT_FOUND);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (Exception e) {
            this.generationErrors.add(WaveViewerGenerationError.VCD_FILE_PARSING_ERROR);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void collectLastTimeFromVcd() {
        try {
            long avgLineLength = 7L;
            long sectionSize = avgLineLength * (long)this.getNofVariablesInModel();
            long sectionEndOffset = this.vcdFile.length() - 1L;
            long sectionStartOffset = sectionEndOffset - sectionSize;
            long varModificationsStartOffset = this.currPositionInFile;
            long currentPos = sectionStartOffset >= varModificationsStartOffset ? sectionStartOffset : varModificationsStartOffset;
            while (currentPos >= varModificationsStartOffset) {
                String currentLine;
                this.vcdFile.seek(currentPos);
                this.createBufferedLayer();
                while ((currentLine = this.bufferedReader.readLine()) != null) {
                    StringTokenizer currentLineTokenizer = new StringTokenizer(currentLine);
                    if (!currentLineTokenizer.hasMoreElements()) continue;
                    String token = currentLineTokenizer.nextToken();
                    if (!currentLineTokenizer.hasMoreElements() && token.charAt(0) == '#' && token.length() > 1) {
                        String currentTimeString = token.substring(1);
                        BigInteger value = new BigInteger(currentTimeString);
                        this.lastTimeFromVcd = value.longValue();
                    }
                    if ((currentPos += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH)) > sectionEndOffset) break;
                }
                if (this.lastTimeFromVcd != -1L) {
                    return;
                }
                sectionEndOffset = sectionStartOffset;
                if (sectionEndOffset > varModificationsStartOffset && (sectionStartOffset -= sectionSize) < varModificationsStartOffset) {
                    sectionStartOffset = varModificationsStartOffset;
                }
                currentPos = sectionStartOffset;
            }
            if (this.lastTimeFromVcd == -1L) {
                this.lastTimeFromVcd = 0L;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void createBufferedLayer() throws IOException {
        this.bufferedInputStream = new BufferedInputStream(new FileInputStream(this.vcdFile.getFD()));
        this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.bufferedInputStream, StandardCharsets.UTF_8));
    }

    public boolean addVariableValueChangeToModel(String token, StringTokenizer currentLineTokenizer, TimeChangeWrapper currentTimeChange, Set<String> variablesToUpdate) {
        String varId;
        String valueString;
        char variableType = Character.toLowerCase(token.charAt(0));
        if (variableType == 'b' || variableType == 'r') {
            if (!currentLineTokenizer.hasMoreTokens()) {
                return false;
            }
            valueString = token.substring(1);
            varId = currentLineTokenizer.nextToken();
        } else {
            valueString = "" + token.charAt(0);
            varId = token.substring(1);
        }
        LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID = this.vcdModel.getSignalsByModelId();
        String id = this.modelIdByVcdId.get(varId);
        DVTVCDSignalWrapper variable = variablesByID.get(id);
        if (variable == null) {
            return true;
        }
        if (currentTimeChange.getTime() == 0L) {
            variable.setValueAtTimeZero(valueString);
            this.vcdModel.addVarValueChangeToModel(new TimeChangeWrapper(this.firstTimeFromVcd, this.currPositionInFile), id, valueString, false);
            return false;
        }
        if (DVTVCDUtils.isCurrentVarModifInClock(variable, currentTimeChange.getTime(), valueString)) {
            return false;
        }
        ConcurrentLinkedDeque<DVTVCDVarModificationByTime> varModificationsByTime = variable.getVarModificationByTime();
        if (variablesToUpdate == null) {
            if (varModificationsByTime.isEmpty() || varModificationsByTime.getLast().getTime() <= currentTimeChange.getTime()) {
                if (currentTimeChange.getTime() < this.diagramLowerTimeLimit && !varModificationsByTime.isEmpty()) {
                    varModificationsByTime.pollLast();
                    if (varModificationsByTime.isEmpty() && currentTimeChange.getTime() > this.firstTimeParsedOnAllVariables) {
                        this.firstTimeParsedOnAllVariables = currentTimeChange.getTime();
                    }
                }
                this.vcdModel.addVarValueChangeToModel(currentTimeChange, id, valueString, false);
            }
            return true;
        }
        if (variablesToUpdate.contains(id) && (varModificationsByTime.isEmpty() || varModificationsByTime.getFirst().getTime() >= currentTimeChange.getTime())) {
            if (currentTimeChange.getTime() <= this.diagramUpperTimeLimit) {
                this.vcdModel.addVarValueChangeToModel(currentTimeChange, id, valueString, true);
            }
            if (currentTimeChange.getTime() <= this.diagramLowerTimeLimit) {
                variablesToUpdate.remove(id);
            }
            return true;
        }
        return true;
    }

    private void parseAndCollectNextLinesInFile(boolean isInitialParse) throws IOException {
        String currentLine;
        long currentTime = this.firstTimeToGetParsedNext;
        TimeChangeWrapper currentTimeChangeWrapper = null;
        Set<Long> timeChanges = this.timeChangesWrapperByTime.keySet();
        List timeChangesSortedList = timeChanges.stream().collect(Collectors.toList());
        boolean shouldParseTime = true;
        this.vcdFile.seek(this.currPositionInFile);
        this.createBufferedLayer();
        while ((currentLine = this.bufferedReader.readLine()) != null) {
            StringTokenizer currentLineTokenizer = new StringTokenizer(currentLine);
            if (!currentLineTokenizer.hasMoreElements()) {
                this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                continue;
            }
            String token = currentLineTokenizer.nextToken();
            if (!currentLineTokenizer.hasMoreElements() && token.charAt(0) == '#' && token.length() > 1) {
                String currentTimeString = token.substring(1);
                BigInteger value = new BigInteger(currentTimeString);
                currentTime = value.longValue();
                if (currentTime == this.firstTimeToGetParsedNext) {
                    if (currentTimeChangeWrapper == null) {
                        currentTimeChangeWrapper = this.timeChangesWrapperByTime.get(currentTime);
                    }
                    this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                    continue;
                }
                if (currentTime == this.firstTimeFromVcd) {
                    if (isInitialParse) {
                        currentTimeChangeWrapper = new TimeChangeWrapper(currentTime, this.currPositionInFile);
                    } else if (!timeChangesSortedList.isEmpty()) {
                        currentTime = (Long)timeChangesSortedList.get(0);
                        currentTimeChangeWrapper = this.timeChangesWrapperByTime.get(currentTime);
                        this.currPositionInFile = currentTimeChangeWrapper.getOffset();
                        this.vcdFile.seek(this.currPositionInFile);
                        this.createBufferedLayer();
                        currentLine = this.bufferedReader.readLine();
                    }
                    this.firstTimeToGetParsedNext = currentTime;
                    if (!isInitialParse && currentTime > this.diagramUpperTimeLimit || isInitialParse && timeChanges.size() >= 100) break;
                    if (currentTime >= this.diagramLowerTimeLimit && currentTimeChangeWrapper != null) {
                        currentTimeChangeWrapper.setParsedBefore(true);
                    }
                    if (currentTime != 0L && !this.timeChangesWrapperByTime.containsKey(currentTime)) {
                        this.timeChangesWrapperByTime.put(currentTime, new TimeChangeWrapper(currentTime, this.currPositionInFile));
                    }
                    this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                    continue;
                }
                if (!isInitialParse && currentTime > this.diagramUpperTimeLimit || isInitialParse && timeChanges.size() >= 100) break;
                if (!this.timeChangesWrapperByTime.containsKey(currentTime)) {
                    this.timeChangesWrapperByTime.put(currentTime, new TimeChangeWrapper(currentTime, this.currPositionInFile));
                }
                currentTimeChangeWrapper = this.timeChangesWrapperByTime.get(currentTime);
                this.firstTimeToGetParsedNext = currentTime;
                shouldParseTime = currentTimeChangeWrapper.shouldGetParsed();
            } else if (shouldParseTime) {
                if (currentTimeChangeWrapper == null) {
                    DVTLogger.INSTANCE.logError("Unrecognized file format! - " + this.vcdFilePath);
                    return;
                }
                currentTimeChangeWrapper.setParsedBefore(true);
                if (this.addVariableValueChangeToModel(token, currentLineTokenizer, currentTimeChangeWrapper, null)) {
                    this.timeChangesWrapperByTime.get(currentTime).incrementSignalCnt();
                }
            }
            this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
        }
    }

    private void parseAndCollectPreviousLinesInFile(Set<String> variablesToUpdate) throws IOException {
        Set<Long> timeChanges = this.timeChangesWrapperByTime.keySet();
        List timeChangesSortedList = timeChanges.stream().collect(Collectors.toList());
        if (timeChangesSortedList.isEmpty()) {
            return;
        }
        int firstParsedTimeChangeIndex = Collections.binarySearch(timeChangesSortedList, this.firstTimeParsedOnAllVariables);
        if (firstParsedTimeChangeIndex < 0) {
            firstParsedTimeChangeIndex = -firstParsedTimeChangeIndex - 1;
        }
        if (firstParsedTimeChangeIndex == timeChangesSortedList.size()) {
            --firstParsedTimeChangeIndex;
        }
        ListIterator timeChangesIterator = timeChangesSortedList.listIterator(firstParsedTimeChangeIndex);
        long currentTime = (Long)timeChangesIterator.next();
        long firstTime = (Long)timeChangesSortedList.get(0);
        while (currentTime > this.firstTimeParsedOnAllVariables) {
            if (!timeChangesIterator.hasPrevious()) {
                variablesToUpdate.clear();
                return;
            }
            currentTime = (Long)timeChangesIterator.previous();
        }
        TimeChangeWrapper currentTimeChange = this.timeChangesWrapperByTime.get(currentTime);
        while (!variablesToUpdate.isEmpty()) {
            this.currPositionInFile = currentTimeChange.getOffset();
            if (this.firstTimeToGetParsedNext < currentTimeChange.getTime()) {
                this.firstTimeToGetParsedNext = currentTimeChange.getTime();
            }
            if (this.firstTimeParsedOnAllVariables > this.diagramLowerTimeLimit || this.firstTimeParsedOnAllVariables < currentTime && currentTime <= this.diagramLowerTimeLimit) {
                this.firstTimeParsedOnAllVariables = currentTime;
            }
            if (currentTimeChange.shouldGetParsed()) {
                this.vcdFile.seek(this.currPositionInFile);
                this.createBufferedLayer();
                String currentLine = this.bufferedReader.readLine();
                while ((currentLine = this.bufferedReader.readLine()) != null) {
                    StringTokenizer currentLineTokenizer = new StringTokenizer(currentLine);
                    if (!currentLineTokenizer.hasMoreElements()) {
                        return;
                    }
                    String token = currentLineTokenizer.nextToken();
                    if (!currentLineTokenizer.hasMoreElements() && token.charAt(0) == '#' && token.length() > 1) {
                        String currentTimeString = token.substring(1);
                        BigInteger value = new BigInteger(currentTimeString);
                        long nextTimeChange = value.longValue();
                        if (currentTime == nextTimeChange) continue;
                        break;
                    }
                    this.addVariableValueChangeToModel(token, currentLineTokenizer, currentTimeChange, variablesToUpdate);
                }
            }
            if (currentTime == firstTime) break;
            currentTime = (Long)timeChangesIterator.previous();
            currentTimeChange = this.timeChangesWrapperByTime.get(currentTime);
            while (!currentTimeChange.shouldGetParsed() && timeChangesIterator.hasPrevious()) {
                currentTime = (Long)timeChangesIterator.previous();
                currentTimeChange = this.timeChangesWrapperByTime.get(currentTime);
            }
        }
    }

    public void updateModel() {
        try {
            if (this.vcdModel == null) {
                return;
            }
            Set<String> variablesToUpdateLeft = null;
            variablesToUpdateLeft = this.currentAction != DVTVCDUtilsCommon.UserActions.ZOOM_OUT ? this.clearUnusedTimeChanges() : new HashSet<String>(this.vcdModel.getSignalsByModelId().keySet());
            if (this.currentAction == DVTVCDUtilsCommon.UserActions.ZOOM_IN) {
                return;
            }
            if (!(this.currentAction != DVTVCDUtilsCommon.UserActions.PAN_LEFT && this.currentAction != DVTVCDUtilsCommon.UserActions.ZOOM_OUT || variablesToUpdateLeft == null || variablesToUpdateLeft.isEmpty())) {
                try {
                    this.parseAndCollectPreviousLinesInFile(variablesToUpdateLeft);
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            if ((this.currentAction == DVTVCDUtilsCommon.UserActions.PAN_RIGHT || this.currentAction == DVTVCDUtilsCommon.UserActions.ZOOM_OUT) && this.firstTimeToGetParsedNext <= this.diagramUpperTimeLimit) {
                try {
                    this.currPositionInFile = this.timeChangesWrapperByTime.get(this.firstTimeToGetParsedNext).getOffset();
                    this.parseAndCollectNextLinesInFile(false);
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        catch (NullPointerException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Set<String> clearUnusedTimeChanges() {
        LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID = this.vcdModel.getSignalsByModelId();
        HashSet<String> variablesToUpdateLeft = new HashSet<String>(variablesByID.keySet());
        for (Map.Entry<String, DVTVCDSignalWrapper> entry : variablesByID.entrySet()) {
            DVTVCDSignalWrapper variableWrapper = (DVTVCDSignalWrapper)entry.getValue();
            if (variableWrapper == null) continue;
            ConcurrentLinkedDeque<DVTVCDVarModificationByTime> varModificationByTime = variableWrapper.getVarModificationByTime();
            switch (this.currentAction) {
                case PAN_LEFT: {
                    this.clearUpperUnusedTimeChanges(varModificationByTime);
                    break;
                }
                case PAN_RIGHT: {
                    this.clearLowerUnusedTimeChanges(variablesToUpdateLeft, entry, varModificationByTime);
                    break;
                }
                case ZOOM_IN: {
                    this.clearUpperUnusedTimeChanges(varModificationByTime);
                    this.clearLowerUnusedTimeChanges(variablesToUpdateLeft, entry, varModificationByTime);
                    break;
                }
            }
        }
        return variablesToUpdateLeft;
    }

    private void clearUpperUnusedTimeChanges(ConcurrentLinkedDeque<DVTVCDVarModificationByTime> varModificationByTime) {
        while (!varModificationByTime.isEmpty() && varModificationByTime.getLast().getTime() > this.diagramUpperTimeLimit) {
            DVTVCDVarModificationByTime removedVarModification = varModificationByTime.pollLast();
            if (removedVarModification.getTime() >= this.firstTimeToGetParsedNext) continue;
            this.firstTimeToGetParsedNext = removedVarModification.getTime();
        }
    }

    protected void clearLowerUnusedTimeChanges(Set<String> variablesToUpdate, Map.Entry<String, DVTVCDSignalWrapper> variable, ConcurrentLinkedDeque<DVTVCDVarModificationByTime> varModificationByTime) {
        DVTVCDVarClockInfo clock = DVTVCDUtils.getClockAt(variable.getValue(), this.diagramLowerTimeLimit);
        if (varModificationByTime.isEmpty() && clock == null) {
            return;
        }
        DVTVCDVarModificationByTime firstVarModificationByTime = null;
        while (!varModificationByTime.isEmpty() && varModificationByTime.getFirst().getTime() <= this.diagramLowerTimeLimit) {
            firstVarModificationByTime = varModificationByTime.pollFirst();
        }
        if (firstVarModificationByTime != null && clock == null) {
            varModificationByTime.addFirst(firstVarModificationByTime);
        }
        if (!varModificationByTime.isEmpty() && (firstVarModificationByTime = varModificationByTime.getFirst()).getTime() > this.firstTimeParsedOnAllVariables) {
            this.firstTimeParsedOnAllVariables = firstVarModificationByTime.getTime();
        }
        if (firstVarModificationByTime != null || clock != null) {
            variablesToUpdate.remove(variable.getKey());
        }
    }

    private void ignoreComment(String currentLine) throws IOException {
        while (!currentLine.contains("$end")) {
            currentLine = this.bufferedReader.readLine();
            if (currentLine == null) {
                return;
            }
            this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
        }
    }

    private void parseAndCollectVarDefAndDumpvarsSections() throws IOException {
        String currentLine;
        ElementPath designHierarchyPath = ElementPath.EMPTY_PATH;
        boolean reachedEndDefinitions = false;
        String scope = "";
        long firstVarModifPositionInFile = 0L;
        while ((currentLine = this.bufferedReader.readLine()) != null) {
            StringTokenizer currentLineTokenizer = new StringTokenizer(currentLine);
            if (!currentLineTokenizer.hasMoreTokens()) {
                this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                continue;
            }
            String firstToken = currentLineTokenizer.nextToken();
            if ("$comment".equals(firstToken)) {
                this.ignoreComment(currentLine);
            }
            if ("$timescale".equals(firstToken)) {
                this.vcdFileTimescale = this.parseTimescale(currentLineTokenizer);
            }
            if ("$scope".equals(firstToken)) {
                ElementPath existingScopePath;
                String scopeType = "";
                if (currentLineTokenizer.hasMoreTokens()) {
                    scopeType = currentLineTokenizer.nextToken();
                }
                if (currentLineTokenizer.hasMoreTokens()) {
                    scope = currentLineTokenizer.nextToken();
                }
                if ((existingScopePath = this.vcdModel.getExistingScopePath(designHierarchyPath = ELUtils.appendToPath(designHierarchyPath, scope))) != null) {
                    designHierarchyPath = existingScopePath;
                } else {
                    this.vcdModel.addScopeInfo(designHierarchyPath, scopeType);
                }
            }
            if ("$var".equals(firstToken)) {
                this.addVarToModel(currentLineTokenizer, designHierarchyPath);
            }
            if ("$upscope".equals(firstToken)) {
                designHierarchyPath = ELUtils.upperPathOf(designHierarchyPath);
            }
            if ("$enddefinitions".equals(firstToken)) {
                reachedEndDefinitions = true;
            }
            if (reachedEndDefinitions && firstToken != null && firstToken.length() > 1 && firstToken.charAt(0) == '#') {
                String currentTimeString = firstToken.substring(1);
                if (firstVarModifPositionInFile != 0L) {
                    this.currPositionInFile = firstVarModifPositionInFile;
                    return;
                }
                firstVarModifPositionInFile = this.currPositionInFile;
                if (!StringUtils.isNumeric((String)currentTimeString)) {
                    this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                    continue;
                }
                BigInteger value = new BigInteger(currentTimeString);
                this.firstTimeFromVcd = value.longValue();
                if (this.diagramLowerTimeLimit < this.firstTimeFromVcd) {
                    long delta = this.firstTimeFromVcd - this.diagramLowerTimeLimit;
                    this.diagramLowerTimeLimit = this.firstTimeFromVcd;
                    this.diagramUpperTimeLimit += delta;
                }
            }
            if ("$dumpvars".equals(firstToken)) {
                this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                this.createDumpvarsInfo();
                return;
            }
            this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
        }
    }

    private DVTVCDUtilsCommon.TimeScales parseTimescale(StringTokenizer lineTokenizer) throws IOException {
        String timescale = null;
        String timescaleName = null;
        while (timescaleName == null || timescaleName.isEmpty()) {
            String token;
            if (!lineTokenizer.hasMoreTokens()) {
                String currentLine = this.bufferedReader.readLine();
                if (currentLine == null) {
                    return null;
                }
                this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                lineTokenizer = new StringTokenizer(currentLine);
            }
            if ((token = lineTokenizer.nextToken()).equals("$end")) break;
            if (timescale == null) {
                timescale = token;
                Matcher matcher = DVTVCDUtils.TIMESCALE_DIGITS_PATTERN.matcher(timescale);
                if (!matcher.find()) {
                    return null;
                }
                timescaleName = timescale.substring(matcher.end());
                continue;
            }
            timescaleName = token;
        }
        return timescaleName != null ? DVTVCDUtilsCommon.TimeScales.getTimeUnit(timescaleName) : null;
    }

    private void createDumpvarsInfo() throws IOException {
        String currentLine;
        while ((currentLine = this.bufferedReader.readLine()) != null) {
            this.currPositionInFile += (long)(currentLine.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
            StringTokenizer currentLineTokenizer = new StringTokenizer(currentLine);
            if (!currentLineTokenizer.hasMoreTokens()) continue;
            String token = currentLineTokenizer.nextToken();
            if ("$end".equals(token)) {
                return;
            }
            this.addVariableValueChangeToModel(token, currentLineTokenizer, new TimeChangeWrapper(0L, 0L), null);
        }
    }

    private void addVarToModel(StringTokenizer tokenizer, ElementPath designPath) {
        String type = tokenizer.nextToken();
        String bitwidth = tokenizer.nextToken();
        String vcdId = tokenizer.nextToken();
        String name = tokenizer.nextToken();
        String dimension = tokenizer.nextToken();
        boolean isBigEndian = DVTVCDUtils.isBigEndian(dimension);
        if (dimension.equals("$end")) {
            dimension = "";
        }
        WSignalElementPath path = new WSignalElementPath(name, dimension, designPath);
        WStructMetadata structMetadata = this.getStructMetadata(path, name, dimension);
        String signalModelId = Integer.toString(this.signalsNo);
        DVTVCDSignalWrapper signalWrapper = new DVTVCDSignalWrapper(signalModelId, this.vcdModel.getNofVariables() + 1, type, bitwidth, path);
        signalWrapper.setBigEndian(isBigEndian);
        if (structMetadata != null) {
            signalWrapper.setStructMetadata(structMetadata);
        }
        LinkedHashMap<String, DVTVCDSignalWrapper> signalsByModelId = this.vcdModel.getSignalsByModelId();
        String aliasModelId = this.modelIdByVcdId.get(vcdId);
        if (aliasModelId == null) {
            this.modelIdByVcdId.put(vcdId, signalModelId);
        } else {
            signalWrapper.setAlias(signalsByModelId.get(aliasModelId));
        }
        DVTWaveHierarchicalScopeInfo scopeInfo = this.vcdModel.getScopeInfo(designPath);
        if (!dimension.isEmpty() && !dimension.contains(":")) {
            String netArrayModelId = String.valueOf(designPath.toString()) + "." + name;
            DVTVCDSignalWrapper netArrayWrapper = signalsByModelId.get(netArrayModelId);
            if (netArrayWrapper == null) {
                netArrayWrapper = new DVTVCDNetArrayWrapper(netArrayModelId, this.vcdModel.getNofVariables() + 1, scopeInfo.getScopeType().name(), "0", path);
                this.vcdModel.addVarWrapperToModel(netArrayModelId, netArrayWrapper);
                scopeInfo.addSignalWrapper(name, netArrayWrapper);
            }
            netArrayWrapper.setStructMetadata(structMetadata);
            netArrayWrapper.setBigEndian(isBigEndian);
            ((DVTVCDNetArrayWrapper)netArrayWrapper).addChildSignal(signalWrapper, DVTVCDUtils.getIndex(dimension));
            signalWrapper.setChildOfNetArray(true);
        }
        this.vcdModel.addVarWrapperToModel(signalModelId, signalWrapper);
        scopeInfo.addSignalWrapper(String.valueOf(name) + dimension, signalWrapper);
        ++this.signalsNo;
    }

    protected WStructMetadata getStructMetadata(WSignalElementPath designPath, String name, String dimension) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            if (this.project != null) break block7;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError("Failed to get info for struct: " + designPath + "/" + name, (Throwable)e);
                            return null;
                        }
                    }
                    namedElement = DVTVCDUtils.getSignalNamedElementFromPath(designPath, this.project);
                    if (namedElement != null) break block8;
                    return null;
                }
                register = BitFieldUtils.getBitFieldRegisterElement(namedElement);
                if (register instanceof IWaveViwerComputedStruct) break block9;
                return null;
            }
            int nofBits = register.getBitFieldDiagramSize(designPath.getParentInstancePath());
            isBigEndian = DVTVCDUtils.isBigEndian(dimension);
            if (register instanceof IRfCompositeTypeElement var8_10 && compositeTypeElement.isEnum()) {
                return ((IWaveViwerComputedStruct)((Object)register)).getStructMetadata(name, isBigEndian);
            }
            if (nofBits >= 1) break block10;
            return null;
        }
        return ((IWaveViwerComputedStruct)((Object)register)).getStructMetadata(name, isBigEndian);
    }

    public IProject getProject() {
        return this.project;
    }

    public String getVcdFilePath() {
        return this.vcdFilePath;
    }

    public DVTVCDUtilsCommon.TimeScales getVcdFileTimeUnit() {
        return this.vcdFileTimescale;
    }

    public DVTVCDModel getVcdModel() {
        return this.vcdModel;
    }

    public long getDiagramLowerTimeLimit() {
        return this.diagramLowerTimeLimit;
    }

    public void setDiagramTimeLimits(long diagramLowerTimeLimit, long diagramUpperTimeLimit) {
        if (diagramLowerTimeLimit >= this.diagramLowerTimeLimit && diagramUpperTimeLimit <= this.diagramUpperTimeLimit) {
            this.currentAction = DVTVCDUtilsCommon.UserActions.ZOOM_IN;
        }
        if (diagramLowerTimeLimit < this.diagramLowerTimeLimit && diagramUpperTimeLimit > this.diagramUpperTimeLimit) {
            this.currentAction = DVTVCDUtilsCommon.UserActions.ZOOM_OUT;
        }
        if (diagramLowerTimeLimit >= this.diagramLowerTimeLimit && diagramUpperTimeLimit > this.diagramUpperTimeLimit) {
            this.currentAction = DVTVCDUtilsCommon.UserActions.PAN_RIGHT;
        }
        if (diagramLowerTimeLimit < this.diagramLowerTimeLimit && diagramUpperTimeLimit <= this.diagramUpperTimeLimit) {
            this.currentAction = DVTVCDUtilsCommon.UserActions.PAN_LEFT;
        }
        this.diagramLowerTimeLimit = diagramLowerTimeLimit;
        this.diagramUpperTimeLimit = diagramUpperTimeLimit;
    }

    public long getDiagramUpperTimeLimit() {
        return this.diagramUpperTimeLimit;
    }

    public int getNofVariablesInModel() {
        return this.vcdModel.getNofVariables();
    }

    public boolean reachedFileMaxTime() {
        try {
            this.vcdFile.seek(this.currPositionInFile);
            this.createBufferedLayer();
            String line = this.bufferedReader.readLine();
            if (line == null && this.diagramUpperTimeLimit > this.firstTimeToGetParsedNext) {
                return true;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public void deepClean() {
        try {
            if (this.vcdModel != null) {
                this.vcdModel.deepClean();
                this.vcdModel = null;
            }
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
            this.project = null;
            this.vcdFilePath = null;
            this.vcdFile = null;
            this.bufferedInputStream = null;
            this.bufferedReader = null;
            if (this.generationErrors != null) {
                this.generationErrors.clear();
            }
            this.generationErrors = null;
            this.timeChangesClean();
            this.timeChangesWrapperByTime = null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String testGetVcdFilePath() {
        return this.vcdFilePath;
    }

    public String getSignalValueAtTime(DVTVCDSignalWrapper signalWrapper, Map<Long, String> timesValuesMap, long time, long lowestModelTime, long highestModelTime, RandomAccessFile localVcdFile) {
        String signalId = signalWrapper.getVarID();
        String signalValueAtTime = timesValuesMap.get(time);
        if (signalValueAtTime != null) {
            return signalValueAtTime;
        }
        if (time >= lowestModelTime && time <= highestModelTime) {
            DVTVCDVarClockInfo clock = DVTVCDUtils.getClockAt(signalWrapper, time);
            if (clock != null) {
                return String.valueOf(clock.getValueAtTime(time));
            }
            return null;
        }
        return this.getSignalValueAtTimeFromFile(signalId, time, localVcdFile);
    }

    public String getSignalValueAtTimeFromFile(String signalId, long time, RandomAccessFile localVcdFile) {
        if (localVcdFile == null) {
            return null;
        }
        Long currentTimeOffset = this.timeChangesWrapperByTime.get(time).getTime();
        try {
            localVcdFile.seek(currentTimeOffset);
            BufferedInputStream localBufferedInputStream = new BufferedInputStream(new FileInputStream(localVcdFile.getFD()));
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)localBufferedInputStream, StandardCharsets.UTF_8));
            String line = this.bufferedReader.readLine();
            line = this.bufferedReader.readLine();
            while (line != null && !line.startsWith("#")) {
                String lineSignalId;
                StringTokenizer stringTokenizer = new StringTokenizer(line);
                if (!stringTokenizer.hasMoreTokens()) {
                    line = this.bufferedReader.readLine();
                    continue;
                }
                String token = stringTokenizer.nextToken();
                char firstChar = Character.toLowerCase(token.charAt(0));
                if (firstChar == 'b' || firstChar == 'r') {
                    if (!stringTokenizer.hasMoreTokens()) {
                        line = this.bufferedReader.readLine();
                        continue;
                    }
                    lineSignalId = stringTokenizer.nextToken();
                    if (!signalId.equals(lineSignalId)) {
                        line = this.bufferedReader.readLine();
                        continue;
                    }
                    return token.substring(1);
                }
                lineSignalId = token.substring(1);
                if (!signalId.equals(lineSignalId)) {
                    line = this.bufferedReader.readLine();
                    continue;
                }
                return String.valueOf(firstChar);
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public long getLastTimeFromVcd() {
        return this.lastTimeFromVcd;
    }

    public void refreshClean() {
        try {
            if (this.vcdModel != null) {
                this.vcdModel.cleanCaches();
            }
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
            this.vcdFile = null;
            this.bufferedInputStream = null;
            this.bufferedReader = null;
            this.currPositionInFile = 0L;
            if (this.generationErrors != null) {
                this.generationErrors.clear();
            }
            this.firstTimeToGetParsedNext = Long.MAX_VALUE;
            this.signalsNo = 0;
            if (this.timeChangesWrapperByTime == null) {
                return;
            }
            this.timeChangesClean();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void timeChangesClean() {
        if (this.timeChangesWrapperByTime == null) {
            return;
        }
        for (Map.Entry<Long, TimeChangeWrapper> timeChange : this.timeChangesWrapperByTime.entrySet()) {
            TimeChangeWrapper timeChangeWrapper;
            if (timeChange == null || (timeChangeWrapper = timeChange.getValue()) == null) continue;
            timeChangeWrapper.deepClean();
        }
        this.timeChangesWrapperByTime.clear();
    }

    public long getFirstTimeFromVcd() {
        return this.firstTimeFromVcd;
    }

    public Set<WaveViewerGenerationError> getGenerationErrors() {
        return this.generationErrors;
    }

    public void setGenerationErrors(Set<WaveViewerGenerationError> generationErrors) {
        this.generationErrors.addAll(generationErrors);
    }

    public String getConfigFilePath() {
        return this.configFilePath != null && !this.configFilePath.isEmpty() ? this.configFilePath : this.getDefaultConfigFilePath();
    }

    protected String getDefaultConfigFilePath() {
        return String.valueOf(FilenameUtils.removeExtension((String)this.vcdFilePath)) + "_default" + "." + "wcfg";
    }

    public void addSignalToModel(String signalId) {
    }

    public void addSignalsToModel(Set<String> signalIds) {
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }
}

