/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarClockInfo;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTVarModifQueue;
import ro.amiq.dvt.ui.waveviewer.TimeChangeWrapper;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;

public class DVTVCDSignalWrapper {
    private String valueAtTimeZero;
    ConcurrentLinkedDeque<DVTVCDVarModificationByTime> varModificationByTime;
    protected DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST;
    private String id;
    private int hierarchyId;
    private String type;
    private DVTVCDSignalWrapper alias;
    private WStructMetadata structMetadata;
    protected boolean isFullyRead;
    private boolean isBigEndian;
    protected String bitwidth;
    private TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes;
    private boolean isChildOfNetArray;
    protected WSignalElementPath path;

    public DVTVCDSignalWrapper(String id, int hierarchyId, String type, String bitwidth, WSignalElementPath path) {
        this.id = id;
        this.hierarchyId = hierarchyId;
        this.type = type;
        this.bitwidth = bitwidth;
        this.varModificationByTime = new ConcurrentLinkedDeque();
        this.clockInfoByStartTimes = new TreeMap();
        this.alias = null;
        this.path = path;
    }

    public void setChildOfNetArray(boolean isChildOfNetArray) {
        this.isChildOfNetArray = isChildOfNetArray;
    }

    public boolean isChildOfNetArray() {
        return this.isChildOfNetArray;
    }

    public void setHierarchyId(int hierarchyID) {
        this.hierarchyId = hierarchyID;
    }

    public void setAlias(DVTVCDSignalWrapper alias) {
        this.alias = alias;
    }

    public String getAliasId() {
        return this.alias != null ? this.alias.getVarID() : null;
    }

    public void clearVarModifsFromFST() {
        if (this.varModifsFromFST == null) {
            return;
        }
        this.varModifsFromFST.clear();
        this.varModifsFromFST = null;
    }

    public DVTVarModifQueue<DVTVCDVarModificationByTime> getVarModifsFromFST() {
        if (this.alias == null) {
            return this.varModifsFromFST;
        }
        return this.alias.getVarModifsFromFST();
    }

    public void setVarModifsFromFST(DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST) {
        this.varModifsFromFST = varModifsFromFST;
    }

    public void resetClocks() {
        this.clockInfoByStartTimes = new TreeMap();
    }

    public void addNewValueAtTime(TimeChangeWrapper timeChange, String newValue, boolean addFirst) {
        if (addFirst) {
            DVTVCDVarModificationByTime firstVarModif = this.varModificationByTime.peekFirst();
            if (firstVarModif != null && firstVarModif.getTime() == timeChange.getTime()) {
                firstVarModif.setValue(newValue);
            } else {
                this.varModificationByTime.addFirst(new DVTVCDVarModificationByTime(timeChange, newValue));
            }
        } else {
            DVTVCDVarModificationByTime lastVarModif = this.varModificationByTime.peekLast();
            if (lastVarModif != null && lastVarModif.getTime() == timeChange.getTime()) {
                lastVarModif.setValue(newValue);
            } else {
                this.varModificationByTime.add(new DVTVCDVarModificationByTime(timeChange, newValue));
            }
        }
    }

    public void restoreValueAtTime(TimeChangeWrapper timeChange, String newValue) {
        this.varModificationByTime.push(new DVTVCDVarModificationByTime(timeChange, newValue));
    }

    public void clearValues() {
        this.varModificationByTime.clear();
    }

    public String getLatestValueAtTime(int time) {
        String latestValue = null;
        for (DVTVCDVarModificationByTime modifTimeEntry : this.varModificationByTime) {
            Long modifTime = modifTimeEntry.getTime();
            if ((long)time >= modifTime) {
                return latestValue;
            }
            latestValue = modifTimeEntry.getValue();
        }
        return latestValue;
    }

    public String getVarID() {
        return this.id;
    }

    public int getHierarchyId() {
        return this.hierarchyId;
    }

    public WSignalElementPath getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public String getBitWidth() {
        return this.bitwidth;
    }

    public ConcurrentLinkedDeque<DVTVCDVarModificationByTime> getVarModificationByTime() {
        if (this.alias == null) {
            return this.varModificationByTime;
        }
        return this.alias.getVarModificationByTime();
    }

    public long getLatestTimeValueChange() {
        if (this.varModificationByTime.isEmpty()) {
            return -1L;
        }
        DVTVCDVarModificationByTime lastVarModification = this.varModificationByTime.peekLast();
        if (lastVarModification == null) {
            return -1L;
        }
        return lastVarModification.getTime();
    }

    public TreeMap<Long, DVTVCDVarClockInfo> getClockInfoByStartTimes() {
        if (this.alias == null) {
            return this.clockInfoByStartTimes;
        }
        return this.alias.getClockInfoByStartTimes();
    }

    public String getValueAtTimeZero() {
        if (this.alias == null) {
            return this.valueAtTimeZero;
        }
        return this.alias.getValueAtTimeZero();
    }

    public void setValueAtTimeZero(String valueAtTimeZero) {
        if (this.alias != null) {
            return;
        }
        this.valueAtTimeZero = valueAtTimeZero;
    }

    public void createClock(long interval, long firstTime, int firstValue, ConcurrentLinkedDeque<DVTVCDVarModificationByTime> auxVarModificationByTime) {
        DVTVCDVarClockInfo lastClock;
        if (!this.clockInfoByStartTimes.isEmpty() && (lastClock = this.clockInfoByStartTimes.lastEntry().getValue()).getEndTime() > firstTime) {
            return;
        }
        this.clockInfoByStartTimes.put(firstTime, new DVTVCDVarClockInfo(interval, firstTime, firstValue));
        for (DVTVCDVarModificationByTime varModif : auxVarModificationByTime) {
            TimeChangeWrapper timeChange = varModif.getTimeChange();
            timeChange.decrementSignalCnt();
        }
    }

    public void addClock(DVTVCDVarClockInfo clockInfo) {
        this.clockInfoByStartTimes.put(clockInfo.getStartTime(), clockInfo);
    }

    public void closeClock(long time) {
        if (this.clockInfoByStartTimes.isEmpty()) {
            return;
        }
        DVTVCDVarClockInfo lastClock = this.clockInfoByStartTimes.lastEntry().getValue();
        if (lastClock.getEndTime() < time) {
            lastClock.close();
        }
    }

    public void deepClean() {
        if (this.varModifsFromFST != null) {
            this.varModifsFromFST.setStartTime(0);
            for (DVTVCDVarModificationByTime dVTVCDVarModificationByTime : this.varModifsFromFST) {
                if (dVTVCDVarModificationByTime == null) continue;
                dVTVCDVarModificationByTime.deepClean();
            }
            this.varModifsFromFST.clear();
            this.varModifsFromFST = null;
        }
        if (this.varModificationByTime != null) {
            for (DVTVCDVarModificationByTime dVTVCDVarModificationByTime : this.varModificationByTime) {
                if (dVTVCDVarModificationByTime == null) continue;
                dVTVCDVarModificationByTime.deepClean();
            }
            this.varModificationByTime.clear();
            this.varModificationByTime = null;
        }
        if (this.clockInfoByStartTimes != null) {
            for (Map.Entry entry : this.clockInfoByStartTimes.entrySet()) {
                DVTVCDVarClockInfo clock = (DVTVCDVarClockInfo)entry.getValue();
                if (clock == null) continue;
                clock.deepClean();
            }
            this.clockInfoByStartTimes.clear();
            this.clockInfoByStartTimes = null;
        }
        this.valueAtTimeZero = null;
        this.id = null;
        this.type = null;
        this.bitwidth = null;
        this.alias = null;
        this.path = null;
    }

    public void setStructMetadata(WStructMetadata structMetadata) {
        this.structMetadata = structMetadata;
    }

    public WStructMetadata getStructMetadata() {
        return this.structMetadata;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public void setBigEndian(boolean isBigEndian) {
        this.isBigEndian = isBigEndian;
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean isFullyRead() {
        return this.isFullyRead;
    }

    public void setFullyRead(boolean isFullyRead) {
        this.isFullyRead = isFullyRead;
    }
}

