/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.wave.DVTOpenMode;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.WaveformViewerLogViewerAction;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.logviewer.ILogViewerContributor;
import ro.amiq.dvt.logviewer.LogViewerContributorUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.MultipleSelectionTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetMultipleSelectionActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.utils.LazyTreeUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;

public class DVTVCDUtils
extends DVTVCDUtilsCommon {
    private static DVTVCDUtils fInstance;

    public static DVTVCDUtils getInstance() {
        if (fInstance == null) {
            fInstance = new DVTVCDUtils();
        }
        return fInstance;
    }

    public static WSignalsTableGroup addSignalsAction(WCanvas canvas, WSignalsTableGroup group, WaveViewerSignalTableView signalsView, Set<String> signalsToAddVCDIds) {
        return DVTVCDUtils.addSignalsAction(canvas, group == null ? "default" : group.getName(), signalsView, signalsToAddVCDIds);
    }

    public static WSignalsTableGroup addSignalsAction(WaveDiagramEditor editor, String groupName, Set<String> signalsToAddVCDIds) {
        Canvas canvas = editor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return null;
        }
        return DVTVCDUtils.addSignalsAction((WCanvas)canvas, groupName, editor.getSignalsTable(), signalsToAddVCDIds);
    }

    public static WSignalsTableGroup addSignalsAction(WCanvas canvas, String groupName, WaveViewerSignalTableView signalsTable, Set<String> signalsToAddVCDIds) {
        WSignalsTableGroup existingGroup;
        WSignalsTableGroup[] selectedGroupInTable = new WSignalsTableGroup[1];
        DVTVCDParser vcdParser = canvas.getProvider();
        DVTVCDModel vcdModel = vcdParser.getVcdModel();
        LinkedHashMap<String, DVTVCDSignalWrapper> signalsById = vcdModel.getSignalsByModelId();
        WViewport viewport = canvas.getViewport();
        TreeSet<WSignalsTableElement> signalsTableNodes = viewport.getSignalsTableElements();
        selectedGroupInTable[0] = existingGroup = DVTVCDUtils.getExistingGroup(groupName, signalsTableNodes);
        if ("default".equals(groupName) && existingGroup == null) {
            selectedGroupInTable[0] = DVTVCDUtils.createNewDefaultGroup(signalsTableNodes, canvas);
            if (selectedGroupInTable[0].getTreePath() == null) {
                TreePath child = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, selectedGroupInTable[0].getName(), selectedGroupInTable[0].getId(), CHILDREN_COMPARATOR);
                selectedGroupInTable[0].setTreePath(child);
                child.setElement(selectedGroupInTable[0]);
            }
            Display.getDefault().asyncExec(() -> {
                TreePath groupTreePath = selectedGroupInTable[0].getTreePath();
                MultipleSelectionTreeIterator treeIterator = (MultipleSelectionTreeIterator)signalsTable.getLazyTree().getTreeIterator();
                ArrayList<TreePath> selection = new ArrayList<TreePath>();
                selection.add(groupTreePath);
                treeIterator.setStartTreePath(groupTreePath);
                treeIterator.setSelections(selection);
                treeIterator.setLastSelection(groupTreePath);
                signalsTable.getLazyTree().doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(selection, null));
            });
        }
        if (selectedGroupInTable[0] == null) {
            return selectedGroupInTable[0];
        }
        DVTVCDUtils.addAllSignals(selectedGroupInTable[0], signalsById, signalsToAddVCDIds);
        viewport.addSignalsTableNode(selectedGroupInTable[0]);
        if (viewport.getPrimaryCursor() != null) {
            viewport.renderAndUpdateTableValues();
        }
        DVTVCDUtils.refreshWaveViewer(signalsTable, canvas);
        return selectedGroupInTable[0];
    }

    public static void updateBreadcrumbForEditor(WSignalElementPath path, DVTOpenMode mode) {
        ElementPath breadcrumbPath = path.getParentInstancePath();
        if (mode == DVTOpenMode.CONNECTION) {
            breadcrumbPath = ELUtils.upperPathOf(breadcrumbPath);
        }
        IDesignPathProvider.updatePathManagerForActiveEditor(breadcrumbPath);
    }

    @Override
    public IProject getLastSelectedProject() {
        return DVTPlugin.getSelectionManager().getLastSelectedProject();
    }

    @Override
    public void restoreTimeOnImportConfig(long lowestVisibleTime, long highestVisibleTime, WCanvas canvas) {
        WViewport viewport = canvas.getViewport();
        if (viewport == null) {
            return;
        }
        WaveViewerSignalTableView signalsTableView = canvas.getSignalsTableView();
        if (signalsTableView == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            viewport.zoomToFitTimes(lowestVisibleTime, highestVisibleTime);
            signalsTableView.update();
        });
    }

    @Override
    public void displayWarning(String title, String message) {
        Display.getDefault().asyncExec(() -> {
            Shell activeShell = Display.getDefault().getActiveShell();
            MessageDialog.openWarning((Shell)activeShell, (String)title, (String)message);
        });
    }

    @Override
    public void displayInfo(String title, String message) {
        Display.getDefault().asyncExec(() -> {
            Shell activeShell = Display.getDefault().getActiveShell();
            MessageDialog.openInformation((Shell)activeShell, (String)title, (String)message);
        });
    }

    @Override
    public boolean hasLicense(Canvas canvas) {
        if (DVTPlugin.getDefault().collect().c()) {
            return true;
        }
        if (canvas instanceof WCanvas) {
            DVTVCDUtils.refreshWaveDiagram((WCanvas)canvas);
        }
        return false;
    }

    @Override
    public int getTreeItemHeight(LazyTree lazyTree) {
        if (LazyTreeUtils.treeItemHeight != 0) {
            return LazyTreeUtils.treeItemHeight;
        }
        Tree tree = lazyTree.getTree();
        if (tree == null) {
            return 18;
        }
        int itemHeight = tree.getItemHeight();
        if (itemHeight != 0) {
            return itemHeight;
        }
        return 18;
    }

    public void updateLogViewerActionButton(WCanvas canvas) {
        WViewport viewport = canvas.getViewport();
        if (viewport == null) {
            return;
        }
        WaveDiagramEditor inputWaveEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(this.getLastSelectedProject());
        if (inputWaveEditor == null || !inputWaveEditor.getCanvas().equals((Object)canvas)) {
            viewport.setToolBarActionEnabled(WaveformViewerLogViewerAction.class, false);
            viewport.setToolBarActionTooltip(WaveformViewerLogViewerAction.class, "Jump To Time in Log Viewer");
            return;
        }
        ILogViewerContributor logViewerContributor = LogViewerContributorUtils.get();
        if (logViewerContributor == null || !logViewerContributor.isLogViewerSet()) {
            viewport.setToolBarActionEnabled(WaveformViewerLogViewerAction.class, false);
            viewport.setToolBarActionTooltip(WaveformViewerLogViewerAction.class, "Jump To Time in Log Viewer (No current log file)");
            return;
        }
        if (!this.isCursorPlaced(canvas)) {
            viewport.setToolBarActionEnabled(WaveformViewerLogViewerAction.class, false);
            viewport.setToolBarActionTooltip(WaveformViewerLogViewerAction.class, "Jump To Time in Log Viewer (No cursor placed)");
            return;
        }
        viewport.setToolBarActionEnabled(WaveformViewerLogViewerAction.class, true);
        viewport.setToolBarActionTooltip(WaveformViewerLogViewerAction.class, "Jump To Time in Log Viewer");
    }
}

