/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.diagrams.wave.DVTOpenMode;
import ro.amiq.dvt.diagrams.wave.RefreshAction;
import ro.amiq.dvt.diagrams.wave.WSignalsTableElementsFactory;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCursor;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.diagrams.wave.draw.obj.IWDModel;
import ro.amiq.dvt.diagrams.wave.draw.obj.IWDModelFactory;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDModel;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.LatestTaskOnlyScheduler;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.WSWTRenderer;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDHierarchicalScope;
import ro.amiq.dvt.ui.waveviewer.DVTVCDHierarchicalVar;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarClockInfo;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTVarModifQueue;
import ro.amiq.dvt.ui.waveviewer.DVTWaveHierarchicalScopeInfo;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.ui.waveviewer.FSTReader;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableExpandableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;
import ro.amiq.dvt.ui.waveviewer.WaveViewerSignalType;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.VlogBitVector;

public abstract class DVTVCDUtilsCommon {
    public static final boolean DVT_DISABLE_DST_CONVERSION = Boolean.parseBoolean(System.getenv("DVT_DISABLE_DST_CONVERSION"));
    public static final int COMPRESSION_LEVEL = 5;
    public static final String VCD_EXTENSION = "vcd";
    public static final String DST_EXTENSION = "dst";
    public static final String COULD_NOT_GENERATE_DIAGRAM = "Could not generate diagram!";
    public static final String LICENSE_NOT_AVAILABLE_JOB_NAME = "License not available";
    public static final String CURRENT_WAVE_NOT_SET = "No current waveform viewer";
    public static final String INFO_BAR_SOURCE_FILE_NAME_NOT_AVAILABLE = "[file name N/A]";
    public static final int DEFAULT_DIAGRAM_LOWER_TIME_LIMIT = 0;
    public static final int DEFAULT_DIAGRAM_UPPER_TIME_LIMIT = 100;
    public static final int DEFAULT_NOF_TIME_CHANGES_TO_PARSE = 100;
    public static final String $TIMESCALE = "$timescale";
    public static final String $SCOPE = "$scope";
    public static final String $UPSCOPE = "$upscope";
    public static final String $DUMPVARS = "$dumpvars";
    public static final String $DUMPON = "$dumpon";
    public static final String $DUMPOFF = "$dumpoff";
    public static final String $DUMPALL = "$dumpall";
    public static final String $VAR = "$var";
    public static final String $END = "$end";
    public static final String $ENDDEFINITIONS = "$enddefinitions";
    public static final String $ENDDEFINITIONS_$END = "$enddefinitions $end";
    public static final String $COMMENT = "$comment";
    public static final String EMPTY_STRING = "";
    public static final String SPACE = " ";
    public static final String PERCENT = "%";
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public static final String DOT_DOT_DOT = "...";
    public static final String OPENING_SQUARE_BRACKET = "[";
    public static final String CLOSING_SQUARE_BRACKET = "]";
    public static final String SLASH = "/";
    public static final String SPACED_DASH = " - ";
    public static final String COLON = ":";
    public static final String VCD_DH_PATH_SEGMENT_SEPARATOR = "/";
    public static final int DATE_TIME_DIMENSION = 100;
    public static final int SYSTEM_LINE_SEPARATOR_LENGTH = System.lineSeparator().length();
    public static final Pattern TIMESCALE_DIGITS_PATTERN = Pattern.compile("[0-9]+");
    public static final Pattern DIGITS_PATTERN = Pattern.compile(".*[0-9]+.*");
    public static final Pattern DIGITS_CAPTURE_GROUP_PATTERN = Pattern.compile("(\\d+)");
    public static final Pattern HIGH_IMPEDANCE_PATTERN = Pattern.compile(".*[zZ]+.*");
    public static final Pattern SHORT_CIRCUIT_PATTERN = Pattern.compile(".*[xX]+.*");
    public static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");
    public static final int CACHE_MAX_TIME_CHANGES = 1000;
    public static final int CLOCK_MIN_TIME_CHANGES = 5;
    public static final int AVG_LINE_LENGTH = 7;
    public static final int UPDATE_PROVIDER_MODEL_JOB_SCHEDULE_TIME = 200;
    public static final String UPDATE_SIGNALS_TABLE_VALUES_JOB_NAME = "Update Signals Table Job";
    public static final String UPDATE_WAVE_VIEWER_MODEL_JOB = "Update Waveform Viewer Model";
    public static final String NO_WRITING_PERMISSIONS_TITLE = "No writing permissions";
    public static final String CANNOT_CREATE_DST_MESSAGE = "Cannot create .dst file in current directory.";
    public static final String GROUP_NAME_EMPTY_ERROR = "Group name can not be empty!";
    public static final String NO_EXISTING_FILE_ERROR_TITLE = "No existing file";
    public static final String NO_VALID_VCD_OR_DST_ERROR = "Could not find any specified Waveform Viewer source files (vcd/dst)!";
    public static final TimeScales DEFAULT_TIME_UNIT = TimeScales.PICO_SECOND;
    public static final int DEFAULT_ZOOM_SCALE = 80;
    public static final long DEFAULT_TIME_LABEL_INTERVAL = 1L;
    public static final int DEFAULT_CURSORS_TIME = -100;
    public static final long ACTION_TIMEOUT_THRESHOLD = 10000L;
    public static final int ACTION_TIMEOUT_RETURN_CODE = -2;
    public static final int FONT_SIZE = 7;
    public static final String BASE_2_PREFIX = "'b";
    public static final String REAL_TYPE = "real";
    public static final int TIME_AXIS_LABEL_TEXT_MARGIN_BOTTOM = 10;
    public static final int TIME_AXIS_HIGHEST_TIME_LABEL_OFFSET = 2;
    public static final int WAVE_HEIGHT = 19;
    public static final int LOGIC_WAVE_OPTIMIZATION_THRESHOLD = 3;
    public static final int MULTIBIT_WAVE_OPTIMIZATION_THRESHOLD = 5;
    public static final int NO_WAVE_OPTIMIZATION_X = -100;
    public static final String WAVE_OPTIMIZATION_START = "DVT_WAVE_OPTIM_START";
    public static final String WAVE_OPTIMIZATION_END = "DVT_WAVE_OPTIM_END";
    public static final int MULTIBIT_WAVE_VALUE_CHANGE_X_OFFSET = 2;
    public static final int MULTIBIT_WAVE_VALUE_TEXT_MARGIN_LEFT = 4;
    public static final int MULTIBIT_WAVE_VALUE_TEXT_MARGIN_RIGHT = 6;
    public static final int UPPER_WAVE_LINE_PADDING = 5;
    public static final int LOWER_WAVE_LINE_PADDING = 2;
    public static final RGB RED = ColorFactory.getInstance().getRGB(255, 0, 0);
    public static final RGB GREEN = ColorFactory.getInstance().getRGB(0, 255, 0);
    public static final RGB BLUE = ColorFactory.getInstance().getRGB(127, 127, 255);
    public static final RGB GRAY = ColorFactory.getInstance().getRGB(110, 110, 110);
    public static final RGB BLACK = ColorFactory.getInstance().getRGB(0, 0, 0);
    public static final RGB WHITE = ColorFactory.getInstance().getRGB(255, 255, 255);
    public static final RGB MARKER_COLOR = ColorFactory.getInstance().getRGB(116, 255, 255);
    public static final float MIN_SELECTION_COLOR_BRIGHTNESS = 0.5f;
    public static final int CURSOR_Y = 1;
    public static final int CURSOR_LABEL_TEXT_MARGIN_LEFT = 3;
    public static final int CURSOR_TEXT_Y = 3;
    public static final int CURSOR_LABEL_OUTLINE_HEIGHT = 14;
    public static final String TIME_LABEL = " T=";
    private static final long STICKY_THRESHOLD = 50L;
    public static final int LEFT_CLICK = 1;
    public static final int RIGHT_CLICK = 3;
    public static final int MOUSE_MOVE_THRESHOLD = 10;
    public static final int CURSORS_ZOOM_TO_FIT_PADDING_RIGHT = 10;
    public static final int CURSORS_DELTA_TIME_TEXT_MARGIN_BOTTOM = 12;
    public static final int CURSORS_DELTA_TIME_TEXT_PADDING = 4;
    public static final int CURSORS_DELTA_TIME_LINE_ARROW_SIZE = 8;
    public static final int CURSORS_DELTA_TIME_LINE_ARROW_Y_OFFSET = 5;
    public static final int CURSORS_DELTA_TIME_LINE_ARROW_TEXT_LOWER_TIME_LEFT_MARGIN = 4;
    public static final int CURSORS_DELTA_TIME_LINE_ARROW_TEXT_HIGHER_TIME_RIGHT_MARGIN = 16;
    public static final int CURSORS_DELTA_TIME_LINE_ARROW_TEXT_BOTTOM_MARGIN = 15;
    public static final int MARKER_Y = 1;
    public static final int MARKER_LABEL_TEXT_HORIZONTAL_PADDING = 3;
    public static final int MARKER_LABEL_TEXT_Y = 3;
    public static final int MARKER_LABEL_OUTLINE_HEIGHT = 14;
    public static final int MIDDLE_CLICK = 2;
    public static final String MARKER_NAME = "T=";
    public static final String PAN_ACTION_DEBUG_PATH = "viewport/action/pan";
    public static final String ZOOM_ACTION_DEBUG_PATH = "viewport/action/zoom";
    public static final String RESIZE_ACTION_DEBUG_PATH = "viewport/action/resize";
    public static final String CURSORS_DEBUG_PATH = "viewport/cursors";
    public static final String FILTER_BY_NAME = "Filter by: name";
    public static final String FILTER_BY_HIERARCHICAL_NAME_SIGNAL = "Filter by: hierarchical name .signal";
    public static final String SELECT_AN_ELEMENT_TO_SEE_ITS_SIGNALS = "Select an element to see its signals.";
    public static final String NO_SIGNALS = "No signals.";
    public static final String NO_MATCHES_FOUND = "No matches found.";
    public static final String ADD_SIGNALS_PANEL_TITLE = "Design Panel";
    public static final String DEFAULT_GROUP_NAME = "default";
    public static final String ADD_GROUP_SIGNAL_LABEL = "Add Group/Signal";
    public static final String ADD_GROUP_LABEL = "Add New Group";
    public static final String OPEN_DH_VIEW_LABEL = "Open Design Panel";
    public static final String CLOSE_DH_VIEW_LABEL = "Close Design Panel";
    public static final String OPEN_DECLARATION = "Open Declaration";
    public static final String OPEN_CONNECTION = "Open Connection";
    public static final String COPY_PATH = "Copy Hierarchy Path";
    public static final String ADD_NEW_GROUP = "Add new group";
    public static final String GROUP_SELECTION_AREA_TEXT = "Select Group ...";
    public static final String AVAILABLE_SIGNALS = "Available Signals";
    public static final String SELECTED_SIGNALS = "Signals";
    public static final String SIGNALS_VALUE = "Value";
    public static final String WAVE_VIEW_SIGNAL_DIALOG_SHELL_TEXT = "Waveform Viewer Signal Dialog";
    public static final String CANCEL_BUTTON_LABEL = "Cancel";
    public static final String ADD_TO_DIAGRAM = "Add to Diagram";
    public static final String REMOVE_FROM_DIAGRAM = "Remove from Diagram";
    public static final String ADD_BUTTON_LABEL = "Add";
    public static final String ADD_ALL_BUTTON_LABEL = "Add All";
    public static final String ADD_GROUP_BUTTON_LABEL = "Add Group";
    public static final int DEFAULT_DH_SIGNALS_VIEW_WIDTH = 210;
    public static final String SET_WAVE_AS_INPUT = "Set current waveform viewer";
    public static final String SET_WAVE_AS_INPUT_DESCRIPTION = "Set current wave as input for selected project";
    public static final String UNSET_WAVE_AS_INPUT = "Unset current waveform viewer";
    public static final String UNSET_WAVE_AS_INPUT_DESCRIPTION = "Unset current waveform viewer as input for selected project";
    public static final String REFRESH_WAVE_VIEWER_LABEL = "Refresh Waveform Viewer";
    public static final String ZOOM_TO_FIT_CURSORS_LABEL = "Zoom To Fit Cursors";
    public static final String ZOOM_TO_FIT_CANVAS_LABEL = "Zoom To Fit Canvas";
    public static final String WAVEFORM_VIEWER_CONTEXT_MENU_LABEL = "Waveform Viewer";
    public static final String ADD_ALL_SIGNALS_LABEL = "Add All Signals";
    public static final String ADD_SIGNAL_LABEL = "Add Signal";
    public static final String ADD_PORTS_LABEL = "Add Ports";
    public static final String ADD_WITH_DRIVERS_LABEL = "Add With Drivers";
    public static final String SIGNAL_NOT_FOUND_WARNING = "Could not find the selected signal in the VCD file.";
    public static final String DRIVERS_NOT_FOUND_WARNING = "Could not find drivers for the selected signal.";
    public static final String NO_SIGNAL_UNDER_CURSOR_INFO = "Please place the cursor on the signal/instance/design you want to add to the Waveform Viewer.";
    public static final String ADD_WITH_LOADS_LABEL = "Add With Loads";
    public static final String LOADS_NOT_FOUND_WARNING = "Could not find loads for the selected signal.";
    public static final String REVEAL_IN_DVT_WAVE_VIEW_LABEL = "Reveal";
    public static final String DETACH_LABEL = "Detach";
    public static final String REATTACH_LABEL = "Reattach";
    public static final String LOG_VIEWER_ACTION_LABEL = "Jump To Time in Log Viewer";
    public static final String TIME_NOT_VALID = "Simulation time is not valid in ";
    public static final String CURRENT_LOG_FILE_NOT_SET = "No current log file";
    public static final String NO_CURSOR_PLACED_LABEL = "No cursor placed";
    public static final String NEW_GROUP_AFTER_LABEL = "After";
    public static final String NEW_GROUP_BEFORE_LABEL = "Before";
    public static final String NEW_GROUP_TOP_LABEL = "To top";
    public static final String NEW_GROUP_BOTTOM_LABEL = "To bottom";
    public static final String RENAME_GROUP_ACTION_LABEL = "Rename Group";
    public static final String REMOVE_ACTION_LABEL = "Remove";
    public static final String ADD_SEPARATOR_ACTION_LABEL = "Add Separator";
    public static final String EMPTY_SEPARATOR_NAME = "__dvt_empty_separator";
    public static final String CHANGE_SIGNAL_RADIX_ACTION_LABEL = "Change Signal Radix";
    public static final String BASE_2_LABEL = "Base 2";
    public static final String BASE_8_LABEL = "Base 8";
    public static final String BASE_10_LABEL = "Base 10";
    public static final String BASE_16_LABEL = "Base 16";
    public static final String ASCII_LABEL = "ASCII";
    public static final String ENUM_ITEM_LABEL = "Enum Item";
    public static final String BASE_2_VALUE = "2";
    public static final String BASE_8_VALUE = "8";
    public static final String BASE_10_VALUE = "10";
    public static final String BASE_16_VALUE = "16";
    public static final String ASCII_VALUE = "ASCII";
    public static final String ENUM_ITEM_VALUE = "ENUM";
    public static final String ENUM_UNDEFINDED_ITEM = "[undefined enum item]";
    public static final String BASE_16_PREFIX = "'h";
    public static final String NOT_PRINTABLE_ASCII = "[not printable ascii]";
    public static final String SHORT_CIRCUIT = "X";
    public static final String HIGH_IMPEDANCE = "Z";
    public static final String CHANGE_COLOR_ACTION_LABEL = "Change Color";
    public static final String CHANGE_TEXT_COLOR_ACTION_LABEL = "Text Color";
    public static final String CHANGE_WAVES_COLOR_ACTION_LABEL = "Waves Color";
    public static final String CHANGE_BACKGROUND_COLOR_ACTION_LABEL = "Background Color";
    public static final String JUMP_TO_EDGE_LABEL = "Jump To Change";
    public static final String NEXT_EDGE_LABEL = "Next Change";
    public static final String NEXT_EDGE_TOOLTIP = "Next Change\t( Ctrl+] )";
    public static final String PREV_EDGE_LABEL = "Prev Change";
    public static final String PREV_EDGE_TOOLTIP = "Prev Change\t( Ctrl+[ )";
    public static final String JUMP_TO_EDGE_TIMEOUT_MESSAGE = "Jump To Change canceled due to time out!";
    public static final String MOVE_TO_GROUP = "Move To Group";
    public static final String CURSORS_OPERATIONS_LABEL = "Cursors Operations";
    public static final String COUNT_EDGES_RESULTS_LABEL = "Count Edges Results";
    public static final String ZOOM_TO_FIT_CURSORS_BUTTON_LABEL = "Fit Cursors";
    public static final String COUNT_EDGES_BUTTON_LABEL = "Count Edges";
    public static final String COUNT_EDGES_TIME_LABEL = "Time: ";
    public static final String NOF_EDGES_LABEL = "Edges: ";
    public static final String NOF_POSEDGES_LABEL = "Posedges: ";
    public static final String NOF_NEGEDGES_LABEL = "Negedges: ";
    public static final String TIME_HIGH_LABEL = "Time High: ";
    public static final String TIME_LOW_LABEL = "Time Low: ";
    public static final String DUTY_CYCLE_LABEL = "Duty Cycle: ";
    public static final String METRIC_NOT_APPLICABLE = "Metric not applicable";
    public static final String COUNT_EDGES_JOB_LABEL = "Counting Edges";
    public static final String LOGIC_SIGNAL_LOW = "0";
    public static final String LOGIC_SIGNAL_HIGH = "1";
    public static final String JUMP_TO_LABEL = "Jump To Time";
    public static final String JUMP_BUTTON_LABEL = "Jump";
    public static final String CFG_EXPORT_CONFIG_DIALOG_TITLE = "Export Current Config";
    public static final String CFG_IMPORT_CONFIG_DIALOG_TITLE = "Import Config";
    public static final String CFG_EXPORT_CONFIG_JOB_NAME = "Exporting current configuration";
    public static final String CFG_IMPORT_CONFIG_JOB_NAME = "Importing configuration";
    public static final String CFG_IMPORT_POORLY_FORMATED_CONFIG = "Import failed due to poorly formated config file!";
    public static final String CFG_FILE_EXTENSION = "wcfg";
    public static final String CFG_FILE_EXTENSION_FILTER = "*.wcfg";
    public static final String CFG_DEFAULT_FILE_SUFFIX = "_default";
    public static final String CFG_VCD_PATH = "vcdPath";
    public static final String CFG_DST_PATH = "dstPath";
    public static final String CFG_MISSING_SOURCE = "missing source";
    public static final String CFG_LOWEST_VISIBLE_TIME = "lowestVisibleTime";
    public static final String CFG_HIGHEST_VISIBLE_TIME = "highestVisibleTime";
    public static final String CFG_PRIMARY_CURSOR_TIME = "primaryCursorTime";
    public static final String CFG_SECONDARY_CURSOR_TIME = "secondaryCursorTime";
    public static final String CFG_MARKERS = "markers";
    public static final String CFG_MARKER_LABEL = "markerLabel";
    public static final String CFG_MARKER_TIME = "markerTime";
    public static final String CFG_ELEMENTS = "elements";
    public static final String CFG_ELEMENT_NAME = "elementName";
    public static final String CFG_ELEMENT_DESIGN_PATH = "elementDesignPath";
    public static final String CFG_SIGNAL_RADIX = "signalRadix";
    public static final String CFG_WAVE_COLOR = "waveColor";
    public static final String CFG_TEXT_COLOR = "textColor";
    public static final String CFG_BACKGROUND_COLOR = "backgroundColor";
    public static final String CFG_CHILDREN_ELEMENTS = "children";
    public static final String CFG_NODE_ORDER_ID = "nodeOrderId";
    public static final String CFG_START_INDEX = "startIndex";
    public static final String CFG_END_INDEX = "endIndex";
    public static final String CFG_INDEX = "index";
    public static final String CFG_BITWIDTH = "bitwidth";
    public static final String CFG_IS_BIG_ENDIAN = "isBigEndian";
    public static final String CFG_TYPE = "type";
    public static final String CFG_ELEMENT_TYPE = "elementType";
    public static final String CFG_GROUP_TYPE = "group";
    public static final String CFG_SEPARATOR_TYPE = "separator";
    public static final String CFG_SIGNAL_TYPE = "signal";
    public static final String CFG_SINGLE_BIT_SIGNAL_TYPE = "sb";
    public static final String CFG_SINGLE_BIT_CHILD_SIGNAL_TYPE = "sbc";
    public static final String CFG_MULTI_BIT_SIGNAL_TYPE = "mb";
    public static final String CFG_MULTI_BIT_CHILD_SIGNAL_TYPE = "mbc";
    public static final String CFG_STRUCT_SIGNAL_TYPE = "str";
    public static final int CFG_JSON_INDENT_FACTOR = 2;
    public static final int CTRL_A_TIMEOUT_MILISECONDS = 500;
    public static final byte FST_BL_VCDATA = 1;
    public static final byte FST_BL_GEOM = 3;
    public static final byte FST_ST_GEN_ATTRBEGIN = -4;
    public static final byte FST_ST_GEN_ATTREND = -3;
    public static final byte FST_ST_VCD_SCOPE = -2;
    public static final byte FST_ST_VCD_UPSCOPE = -1;
    public static final byte FST_ST_END_HIERARCHY = -5;
    public static final int PREVIOUS_SIGNALS_BUFFER_SIZE = 10000;
    public static final int FORWARD_SIGNALS_BUFFER_SIZE = 10000;
    public static final Pattern TIMESCALE_PATTERN = Pattern.compile("\\$timescale\\s+([0-9]+)\\s*([a-z]+)\\s*\\$end");
    public static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    public static final byte FST_VT_VCD_EVENT = 0;
    public static final byte FST_VT_VCD_INTEGER = 1;
    public static final byte FST_VT_VCD_PARAMETER = 2;
    public static final byte FST_VT_VCD_REAL = 3;
    public static final byte FST_VT_VCD_REG = 4;
    public static final byte FST_VT_VCD_SUPPLY0 = 5;
    public static final byte FST_VT_VCD_SUPPLY1 = 6;
    public static final byte FST_VT_VCD_TIME = 7;
    public static final byte FST_VT_VCD_TRI = 8;
    public static final byte FST_VT_VCD_TRIAND = 9;
    public static final byte FST_VT_VCD_TRIOR = 10;
    public static final byte FST_VT_VCD_TRIREG = 11;
    public static final byte FST_VT_VCD_TRI0 = 12;
    public static final byte FST_VT_VCD_TRI1 = 13;
    public static final byte FST_VT_VCD_WAnd = 14;
    public static final byte FST_VT_VCD_WIRE = 15;
    public static final byte FST_VT_VCD_WOR = 16;
    public static final byte FST_VT_VCD_PORT = 17;
    public static final byte FST_VT_VCD_REALTIME = 19;
    public static final String ACTUAL_VALUE = "Actual value : ";
    public static final String TREE_SPACES = "   ";
    public static final String NEW_LINE = "\n";
    public static final String WAVE_VALUE_LABEL = "// Waveform value: ";
    public static final String NEXT_EDGE_VALUE_LABEL = "Next Change Value: ";
    public static final String PREV_EDGE_VALUE_LABEL = "Prev Change Value: ";
    public static final String NO_CHANGE_FOUND_LABEL = "No change found";
    public static final String VALUE_NOT_AVAILABLE = "N/A";
    public static final Map<String, String> BASES = new LinkedHashMap<String, String>();
    public static final int MAX_CHANGES_PER_BLOCK = 1000000;
    public static final int MAX_TIME_POINTS_PER_BLOCK = 100000;
    public static final int BUFFER_SIZE = 0x2000000;
    public static final long BLOCK_LENGTH_VALUE_SIZE = 8L;
    public static final String CONVERT_VCD_TO_DST_JOB_TITLE = "Convert VCD to DST";
    public static final String REFRESH_DST_FILE = "Refresh DST file";
    public static final String DH_DIFFER_WARNING = "The following VCD signal paths from {0} have not been found in the design hierarchy elaborated by DVT for project {1}:\n\n{2}\n\nSome functionalities might not work as intended.";
    public static final String WAVE_VIEWER_DESIGN_HIERARCHY_MISMATCH_TITLE = "Design Hierarchy Mismatch";
    public static final String UNABLE_TO_VERIFY_IF_VCD_IS_VALID_IN_DH = "Could not verify if the VCD signal paths from {0} can be found in the design hierarchy elaborated by DVT for project {1}.\n\nReason: build is not finished or project not restored.";
    public static final String WAVEFORM_VIEWER_DIALOG_TITLE = "Waveform Viewer";
    public static final String UNABLE_TO_FIND_ENCLOSING_PROJECT_MESSAGE = "Could not set current waveform viewer as input!\nSelected project is null or doesn't exist!";
    public static final String MENU_SEPARATOR = "Separator";
    public static final String ABOVE_BUTTON_LABEL = "Above";
    public static final String BELOW_BUTTON_LABEL = "Below";
    public static final String NAME_GROUP_LABEL = "Name";
    public static final String NAME_TEXT_MESSAGE = "Choose a name";
    public static final String POSITION_GROUP_LABEL = "Position";
    public static final String WAVE_VIEWER_CREATE_SEPARATOR_DIALOG_ID = "ro.amiq.dvt.ui.waveviewer.WaveViewerCreateSeparatorDialog";
    public static final String WAVE_VIEWER_CREATE_SEPARATOR_DIALOG_TITLE = "Waveform Viewer Create Separator Dialog";
    public static final ConcurrentHashMap<String, Object> DST_FILE_LOCKS;
    public static final int TIMESTAMPS_UNTIL_REFRESH = 500;
    public static final Comparator<TreePath> CHILDREN_COMPARATOR;

    static {
        BASES.put(BASE_2_VALUE, "Base  2: ");
        BASES.put(BASE_8_VALUE, "Base  8: ");
        BASES.put(BASE_10_VALUE, "Base 10: ");
        BASES.put(BASE_16_VALUE, "Base 16: ");
        BASES.put("ASCII", "Ascii: ");
        DST_FILE_LOCKS = new ConcurrentHashMap();
        CHILDREN_COMPARATOR = (t1, t2) -> {
            int t2Length;
            int[] t1Indices = t1.getIndices();
            int[] t2Indices = t2.getIndices();
            int maxCommonLength = Math.min(t1Indices.length, t2Indices.length);
            int i = 0;
            while (i < maxCommonLength) {
                int deltaIndex = t1Indices[i] - t2Indices[i];
                if (deltaIndex != 0) {
                    return deltaIndex;
                }
                ++i;
            }
            int t1Length = t1.getSegments().length;
            int deltaLength = t1Length - (t2Length = t2.getSegments().length);
            if (deltaLength != 0) {
                return deltaLength;
            }
            String t1LastSegment = t1.getLastSegment();
            String t2LastSegment = t2.getLastSegment();
            return t1LastSegment.compareTo(t2LastSegment);
        };
    }

    public static FontData getFontData() {
        return FontFactory.getInstance().getFontData("Sans", 7, 0);
    }

    public static boolean isValidFileExtension(String fileName) {
        String fileExtension = BaseUtils.getFileExtension(fileName);
        return fileExtension != null && (VCD_EXTENSION.equals(fileExtension) || DST_EXTENSION.equals(fileExtension) || CFG_FILE_EXTENSION.equals(fileExtension));
    }

    public static String getConvertedSignalValue(String signalValue, String signalBitwidth, String signalType, String signalBase) {
        if (signalValue.startsWith(WAVE_OPTIMIZATION_END)) {
            signalValue = signalValue.substring(WAVE_OPTIMIZATION_END.length());
        }
        if (signalValue == null || signalValue.isEmpty()) {
            return signalValue;
        }
        if (REAL_TYPE.equals(signalType)) {
            return signalValue;
        }
        VlogBitVector convertedNumber = ELUtils.parseIntegerNumberVLOG(String.valueOf(signalBitwidth) + BASE_2_PREFIX + signalValue, null, null);
        if (DVTNumber.isUndefined(convertedNumber)) {
            return signalValue;
        }
        try {
            switch (signalBase) {
                case "2": {
                    return ((DVTNumber)convertedNumber).toNiceString(null, 2, false, false);
                }
                case "8": {
                    return ((DVTNumber)convertedNumber).toNiceString(null, 8, false, false);
                }
                case "10": {
                    return ((DVTNumber)convertedNumber).toNiceString(null, 10, false, false);
                }
                case "16": {
                    return ((DVTNumber)convertedNumber).toNiceString(null, 16, false, false);
                }
                case "ASCII": {
                    if (signalValue.toUpperCase().contains(SHORT_CIRCUIT) || signalValue.toUpperCase().contains(HIGH_IMPEDANCE)) {
                        return signalValue;
                    }
                    String base10SignalValue = ((DVTNumber)convertedNumber).print(10, true, -1, false, false);
                    byte[] charsByteArray = new BigInteger(base10SignalValue).toByteArray();
                    if (!DVTVCDUtilsCommon.isPrintableAsciiString(charsByteArray)) {
                        return String.valueOf(signalValue) + SPACE + NOT_PRINTABLE_ASCII;
                    }
                    return new String(charsByteArray, IDVTConstants.ASCII);
                }
            }
            return signalValue;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return EMPTY_STRING;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getEnumItem(String signalValue, WSignalsTableMultiBitSignal signal) {
        void structSignal;
        void var3_2;
        WSignalsTableStructSignal wSignalsTableStructSignal;
        if (signalValue.startsWith(WAVE_OPTIMIZATION_END)) {
            signalValue = signalValue.substring(WAVE_OPTIMIZATION_END.length());
        }
        if (signalValue == null || signalValue.isEmpty()) {
            return signalValue;
        }
        WSignalsTableMultiBitSignal wSignalsTableMultiBitSignal = signal;
        if (!(wSignalsTableMultiBitSignal instanceof WSignalsTableStructSignal) || (wSignalsTableStructSignal = (WSignalsTableStructSignal)wSignalsTableMultiBitSignal) != (WSignalsTableStructSignal)var3_2) {
            return signalValue;
        }
        if (!structSignal.isEnum()) {
            return signalValue;
        }
        return structSignal.getEnumItemForValue(signalValue);
    }

    public static boolean isPrintableAsciiString(byte[] charsByteArray) {
        byte[] byArray = charsByteArray;
        int n = charsByteArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte charByte = byArray[n2];
            if (charByte < 32 || charByte > 127) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String getSignalValueAtTime(DVTVCDSignalWrapper signal, long time) {
        if (signal == null) {
            return EMPTY_STRING;
        }
        Iterable<DVTVCDVarModificationByTime> varModificationsByTime = signal.getVarModificationByTime();
        DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = signal.getVarModifsFromFST();
        if (varModifsFromFST != null) {
            varModificationsByTime = varModifsFromFST;
            ((DVTVarModifQueue)varModificationsByTime).setStartTime((int)time);
        }
        String signalValue = null;
        long lastChange = -1L;
        DVTVCDVarClockInfo currentClock = DVTVCDUtilsCommon.getClosestClock(signal, time);
        if (currentClock != null && currentClock.containsTime(time)) {
            signalValue = String.valueOf(currentClock.getValueAtTime(time));
        }
        if (signalValue == null) {
            if (varModificationsByTime == null) {
                return EMPTY_STRING;
            }
            if (varModifsFromFST != null) {
                for (DVTVCDVarModificationByTime varModif : varModificationsByTime) {
                    long lastTime = varModif.getTime();
                    if (lastTime <= time) {
                        signalValue = varModif.getValue();
                        lastChange = lastTime;
                        continue;
                    }
                    break;
                }
            } else {
                for (DVTVCDVarModificationByTime varModif : varModificationsByTime) {
                    if (varModif.getTime() <= time) {
                        signalValue = varModif.getValue();
                        lastChange = varModif.getTime();
                        continue;
                    }
                    break;
                }
            }
            if (currentClock != null && currentClock.getEndTime() > lastChange) {
                signalValue = Long.toString(currentClock.getValueAtTime(currentClock.getEndTime()));
            }
            if (currentClock != null && currentClock.getEndTime() > lastChange) {
                signalValue = Long.toString(currentClock.getValueAtTime(currentClock.getEndTime()));
            }
        }
        if (signalValue == null) {
            signalValue = signal.getValueAtTimeZero();
        }
        if (signalValue == null) {
            return EMPTY_STRING;
        }
        return signalValue;
    }

    public static long getNextEdge(TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes, Iterable<DVTVCDVarModificationByTime> varModificationByTime, long cursorTime, DVTVCDParser vcdParser, WViewport viewport, DVTVCDSignalWrapper selectedSignal, WSignalsTableElement selectedTableSignal) {
        long firstTimeFromVcd = vcdParser.getFirstTimeFromVcd();
        long lastTimeFromVcd = vcdParser.getLastTimeFromVcd();
        long clockInfoNextEdge = DVTVCDUtilsCommon.getNextEdgeFromClockInfoContainingCursorTime(cursorTime, clockInfoByStartTimes);
        if (clockInfoNextEdge >= firstTimeFromVcd) {
            return clockInfoNextEdge;
        }
        clockInfoNextEdge = DVTVCDUtilsCommon.getNextEdgeFromClockInfos(cursorTime, clockInfoByStartTimes);
        DVTVCDVarModificationByTime varModifNextEdge = null;
        if (cursorTime <= viewport.getHighestVisibleTime() && cursorTime >= viewport.getLowestVisibleTime()) {
            varModifNextEdge = DVTVCDUtilsCommon.getNextEdgeFromVarModifications(cursorTime, varModificationByTime, selectedSignal, selectedTableSignal);
        }
        if (varModifNextEdge != null) {
            if (clockInfoNextEdge < firstTimeFromVcd || varModifNextEdge.getTime() < clockInfoNextEdge) {
                return varModifNextEdge.getTime();
            }
            return clockInfoNextEdge;
        }
        long diagramTimeUnitsOnScreen = vcdParser.getDiagramUpperTimeLimit() - vcdParser.getDiagramLowerTimeLimit();
        long searchLimit = clockInfoNextEdge >= firstTimeFromVcd ? clockInfoNextEdge : lastTimeFromVcd;
        long currentdiagramLowerTimeLimit = cursorTime + 1L;
        long currentdiagramUpperTimeLimit = cursorTime + diagramTimeUnitsOnScreen + 1L;
        if (currentdiagramUpperTimeLimit > searchLimit && searchLimit - diagramTimeUnitsOnScreen < firstTimeFromVcd) {
            currentdiagramLowerTimeLimit = firstTimeFromVcd;
            currentdiagramUpperTimeLimit = firstTimeFromVcd + diagramTimeUnitsOnScreen;
        } else if (currentdiagramUpperTimeLimit > searchLimit) {
            currentdiagramLowerTimeLimit = searchLimit - diagramTimeUnitsOnScreen;
            currentdiagramUpperTimeLimit = searchLimit;
        }
        long previousDiagramLowerTimeLimit = vcdParser.getDiagramLowerTimeLimit();
        long previousDiagramUpperTimeLimit = vcdParser.getDiagramUpperTimeLimit();
        vcdParser.setDiagramTimeLimits(currentdiagramLowerTimeLimit, currentdiagramUpperTimeLimit);
        vcdParser.updateModel();
        try {
            long startTime = System.currentTimeMillis();
            boolean isNextEdgeFound = DVTVCDUtilsCommon.isEdgeInVarModifFound(cursorTime, varModificationByTime, true);
            while (!isNextEdgeFound && currentdiagramUpperTimeLimit < searchLimit) {
                if (System.currentTimeMillis() - startTime > 10000L) {
                    return -2L;
                }
                currentdiagramLowerTimeLimit += diagramTimeUnitsOnScreen > 0L ? diagramTimeUnitsOnScreen : 1L;
                if ((currentdiagramUpperTimeLimit += diagramTimeUnitsOnScreen > 0L ? diagramTimeUnitsOnScreen : 1L) > searchLimit) {
                    currentdiagramUpperTimeLimit = searchLimit;
                    currentdiagramLowerTimeLimit = searchLimit - diagramTimeUnitsOnScreen;
                }
                vcdParser.setDiagramTimeLimits(currentdiagramLowerTimeLimit, currentdiagramUpperTimeLimit);
                vcdParser.updateModel();
                isNextEdgeFound = DVTVCDUtilsCommon.isEdgeInVarModifFound(cursorTime, varModificationByTime, true);
            }
            if (!isNextEdgeFound) {
                long l = clockInfoNextEdge;
                return l;
            }
            varModifNextEdge = DVTVCDUtilsCommon.getNextEdgeFromVarModifications(cursorTime, varModificationByTime, selectedSignal, selectedTableSignal);
            if (varModifNextEdge == null) {
                long l = clockInfoNextEdge;
                return l;
            }
            if (clockInfoNextEdge < firstTimeFromVcd || clockInfoNextEdge > varModifNextEdge.getTime()) {
                long l = varModifNextEdge.getTime();
                return l;
            }
            long l = clockInfoNextEdge;
            return l;
        }
        finally {
            vcdParser.setDiagramTimeLimits(previousDiagramLowerTimeLimit, previousDiagramUpperTimeLimit);
            vcdParser.updateModel();
        }
    }

    private static DVTVCDVarModificationByTime getNextEdgeFromVarModifications(long cursorTime, Iterable<DVTVCDVarModificationByTime> varModificationByTime, DVTVCDSignalWrapper selectedSignal, WSignalsTableElement selectedTableSignal) {
        DVTVCDVarModificationByTime lastVarModif = null;
        String lastValue = null;
        String currentValue = null;
        for (DVTVCDVarModificationByTime varModif : varModificationByTime) {
            if (cursorTime < varModif.getTime()) {
                if (lastVarModif == null) {
                    return varModif;
                }
                if (selectedTableSignal instanceof WSignalsTableSingleBitChildSignal && !selectedSignal.isChildOfNetArray()) {
                    if (lastValue == null) {
                        lastValue = DVTVCDUtils.getValueAtIndex(((WSignalsTableSingleBitChildSignal)selectedTableSignal).getIndex(), lastVarModif.getValue(), Integer.parseInt(selectedSignal.getBitWidth()), selectedSignal.isBigEndian());
                    }
                    if ((currentValue = DVTVCDUtils.getValueAtIndex(((WSignalsTableSingleBitChildSignal)selectedTableSignal).getIndex(), varModif.getValue(), Integer.parseInt(selectedSignal.getBitWidth()), selectedSignal.isBigEndian())).equals(lastValue)) {
                        continue;
                    }
                } else if (selectedTableSignal instanceof WSignalsTableMultiBitChildSignal) {
                    if (lastValue == null) {
                        lastValue = DVTVCDUtils.getMultibitValueAtIndex(((WSignalsTableMultiBitChildSignal)selectedTableSignal).getStartIndex(), ((WSignalsTableMultiBitChildSignal)selectedTableSignal).getEndIndex(), lastVarModif.getValue(), Integer.parseInt(selectedSignal.getBitWidth()));
                    }
                    if ((currentValue = DVTVCDUtils.getMultibitValueAtIndex(((WSignalsTableMultiBitChildSignal)selectedTableSignal).getStartIndex(), ((WSignalsTableMultiBitChildSignal)selectedTableSignal).getEndIndex(), varModif.getValue(), Integer.parseInt(selectedSignal.getBitWidth()))).equals(lastValue)) {
                        continue;
                    }
                } else {
                    if (lastValue == null) {
                        lastValue = DVTVCDUtils.getSignalValueAtTime(selectedSignal, cursorTime);
                    }
                    if (varModif.getValue().equals(lastValue)) continue;
                }
                return varModif;
            }
            lastVarModif = varModif;
        }
        return null;
    }

    private static long getNextEdgeFromClockInfoContainingCursorTime(long cursorTime, TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes) {
        if (clockInfoByStartTimes == null || clockInfoByStartTimes.isEmpty()) {
            return -1L;
        }
        for (DVTVCDVarClockInfo clockInfo : clockInfoByStartTimes.values()) {
            if (clockInfo.getStartTime() > cursorTime) {
                return -1L;
            }
            if (clockInfo.getStartTime() > cursorTime || clockInfo.getEndTime() <= cursorTime) continue;
            return clockInfo.getNextTimeChange(cursorTime);
        }
        return -1L;
    }

    private static long getNextEdgeFromClockInfos(long cursorTime, TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes) {
        if (clockInfoByStartTimes == null || clockInfoByStartTimes.isEmpty()) {
            return -1L;
        }
        for (DVTVCDVarClockInfo clockInfo : clockInfoByStartTimes.values()) {
            if (clockInfo.getStartTime() <= cursorTime) continue;
            return clockInfo.getStartTime();
        }
        return -1L;
    }

    private static boolean isEdgeInVarModifFound(long cursorTime, Iterable<DVTVCDVarModificationByTime> varModificationByTimeIterable, boolean isNext) {
        if (!(varModificationByTimeIterable instanceof ConcurrentLinkedDeque)) {
            return true;
        }
        ConcurrentLinkedDeque varModificationByTime = (ConcurrentLinkedDeque)varModificationByTimeIterable;
        if (varModificationByTime.isEmpty()) {
            return false;
        }
        if (isNext) {
            return ((DVTVCDVarModificationByTime)varModificationByTime.getLast()).getTime() > cursorTime;
        }
        return ((DVTVCDVarModificationByTime)varModificationByTime.getFirst()).getTime() < cursorTime;
    }

    public static long getPrevEdge(TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes, Iterable<DVTVCDVarModificationByTime> varModificationByTime, long cursorTime, DVTVCDParser vcdParser, WViewport viewport, DVTVCDSignalWrapper selectedSignal, WSignalsTableElement selectedTableSignal) {
        long firstTimeFromVcd = vcdParser.getFirstTimeFromVcd();
        long clockInfoPrevEdge = DVTVCDUtilsCommon.getPrevEdgeFromClockInfoContainingCursorTime(cursorTime, clockInfoByStartTimes);
        if (clockInfoPrevEdge >= firstTimeFromVcd) {
            return clockInfoPrevEdge;
        }
        clockInfoPrevEdge = DVTVCDUtilsCommon.getPrevEdgeFromClockInfos(cursorTime, clockInfoByStartTimes);
        DVTVCDVarModificationByTime varModifPrevEdge = null;
        if (cursorTime <= viewport.getHighestVisibleTime() && cursorTime >= viewport.getLowestVisibleTime()) {
            varModifPrevEdge = DVTVCDUtilsCommon.getPrevEdgeFromVarModifications(cursorTime, varModificationByTime, selectedSignal, selectedTableSignal);
        }
        if (varModifPrevEdge != null) {
            if (clockInfoPrevEdge < firstTimeFromVcd || varModifPrevEdge.getTime() > clockInfoPrevEdge) {
                return varModifPrevEdge.getTime();
            }
            return clockInfoPrevEdge;
        }
        long diagramTimeUnitsOnScreen = vcdParser.getDiagramUpperTimeLimit() - vcdParser.getDiagramLowerTimeLimit();
        long searchLimit = clockInfoPrevEdge >= firstTimeFromVcd ? clockInfoPrevEdge : firstTimeFromVcd;
        long currentdiagramLowerTimeLimit = cursorTime - diagramTimeUnitsOnScreen - 1L;
        long currentdiagramUpperTimeLimit = cursorTime - 1L;
        if (currentdiagramLowerTimeLimit < searchLimit) {
            currentdiagramLowerTimeLimit = searchLimit;
            currentdiagramUpperTimeLimit = searchLimit + diagramTimeUnitsOnScreen;
        }
        vcdParser.setDiagramTimeLimits(currentdiagramLowerTimeLimit, currentdiagramUpperTimeLimit);
        vcdParser.updateModel();
        long startTime = System.currentTimeMillis();
        boolean isPrevEdgeFound = DVTVCDUtilsCommon.isEdgeInVarModifFound(cursorTime, varModificationByTime, false);
        while (!isPrevEdgeFound && currentdiagramLowerTimeLimit > searchLimit) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                return -2L;
            }
            currentdiagramUpperTimeLimit -= diagramTimeUnitsOnScreen;
            if ((currentdiagramLowerTimeLimit -= diagramTimeUnitsOnScreen) < searchLimit) {
                currentdiagramLowerTimeLimit = searchLimit;
                currentdiagramUpperTimeLimit = searchLimit + diagramTimeUnitsOnScreen;
            }
            vcdParser.setDiagramTimeLimits(currentdiagramLowerTimeLimit, currentdiagramUpperTimeLimit);
            vcdParser.updateModel();
            isPrevEdgeFound = DVTVCDUtilsCommon.isEdgeInVarModifFound(cursorTime, varModificationByTime, false);
        }
        if (!isPrevEdgeFound && clockInfoPrevEdge < firstTimeFromVcd) {
            return firstTimeFromVcd;
        }
        varModifPrevEdge = DVTVCDUtilsCommon.getPrevEdgeFromVarModifications(cursorTime, varModificationByTime, selectedSignal, selectedTableSignal);
        if (varModifPrevEdge == null) {
            return clockInfoPrevEdge;
        }
        if (clockInfoPrevEdge < firstTimeFromVcd || clockInfoPrevEdge < varModifPrevEdge.getTime()) {
            return varModifPrevEdge.getTime();
        }
        return clockInfoPrevEdge;
    }

    private static long getPrevEdgeFromClockInfoContainingCursorTime(long cursorTime, TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes) {
        if (clockInfoByStartTimes == null || clockInfoByStartTimes.isEmpty()) {
            return -1L;
        }
        for (DVTVCDVarClockInfo clockInfo : clockInfoByStartTimes.values()) {
            if (clockInfo.getStartTime() >= cursorTime) {
                return -1L;
            }
            if (clockInfo.getStartTime() >= cursorTime || clockInfo.getEndTime() < cursorTime) continue;
            return clockInfo.getPrevTimeChange(cursorTime);
        }
        return -1L;
    }

    private static long getPrevEdgeFromClockInfos(long cursorTime, TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes) {
        if (clockInfoByStartTimes == null || clockInfoByStartTimes.isEmpty()) {
            return -1L;
        }
        long prevEdgeTime = -1L;
        for (DVTVCDVarClockInfo clockInfo : clockInfoByStartTimes.values()) {
            if (clockInfo.getEndTime() > cursorTime) {
                return prevEdgeTime;
            }
            prevEdgeTime = clockInfo.getEndTime();
        }
        return prevEdgeTime;
    }

    private static DVTVCDVarModificationByTime getPrevEdgeFromVarModifications(long cursorTime, Iterable<DVTVCDVarModificationByTime> varModificationByTime, DVTVCDSignalWrapper selectedSignal, WSignalsTableElement selectedTableSignal) {
        DVTVCDVarModificationByTime lastVarModif = null;
        String lastValue = null;
        String currentValue = null;
        for (DVTVCDVarModificationByTime varModif : varModificationByTime) {
            if (varModif.getTime() >= cursorTime) {
                return lastVarModif;
            }
            if (lastVarModif != null) {
                if (selectedTableSignal instanceof WSignalsTableSingleBitChildSignal && !selectedSignal.isChildOfNetArray()) {
                    lastValue = DVTVCDUtils.getValueAtIndex(((WSignalsTableSingleBitChildSignal)selectedTableSignal).getIndex(), lastVarModif.getValue(), Integer.parseInt(selectedSignal.getBitWidth()), selectedSignal.isBigEndian());
                    currentValue = DVTVCDUtils.getValueAtIndex(((WSignalsTableSingleBitChildSignal)selectedTableSignal).getIndex(), varModif.getValue(), Integer.parseInt(selectedSignal.getBitWidth()), selectedSignal.isBigEndian());
                    if (currentValue.equals(lastValue)) {
                        continue;
                    }
                } else if (selectedTableSignal instanceof WSignalsTableMultiBitChildSignal) {
                    lastValue = DVTVCDUtils.getMultibitValueAtIndex(((WSignalsTableMultiBitChildSignal)selectedTableSignal).getStartIndex(), ((WSignalsTableMultiBitChildSignal)selectedTableSignal).getEndIndex(), lastVarModif.getValue(), Integer.parseInt(selectedSignal.getBitWidth()));
                    currentValue = DVTVCDUtils.getMultibitValueAtIndex(((WSignalsTableMultiBitChildSignal)selectedTableSignal).getStartIndex(), ((WSignalsTableMultiBitChildSignal)selectedTableSignal).getEndIndex(), varModif.getValue(), Integer.parseInt(selectedSignal.getBitWidth()));
                    if (currentValue.equals(lastValue)) {
                        continue;
                    }
                } else {
                    lastValue = lastVarModif.getValue();
                    if (varModif.getValue().equals(lastValue)) continue;
                }
            }
            lastVarModif = varModif;
        }
        return lastVarModif;
    }

    public static String getStructChildValue(DVTVCDSignalWrapper structWrapper, String structValue, WStructMetadata structChildMetadata) {
        int structChildBithWidth = structChildMetadata.getBitWidth();
        if (structChildBithWidth > 1) {
            return DVTVCDUtilsCommon.getMultibitValueAtIndex(structChildMetadata.getStartIndex(), structChildMetadata.getEndIndex(), structValue, structChildBithWidth);
        }
        return DVTVCDUtilsCommon.getValueAtIndex(structChildMetadata.getStartIndex(), structValue, structChildBithWidth, structWrapper.isBigEndian());
    }

    public static String getValueAtIndex(int index, String value, int bitwidth, boolean isBigEndian) {
        if (isBigEndian) {
            index = bitwidth - index - 1;
        }
        if (!DVTVCDUtilsCommon.isIndexInBounds(index, value)) {
            if (value.isEmpty()) {
                return LOGIC_SIGNAL_LOW;
            }
            char fillChar = value.charAt(0);
            if (fillChar == '1') {
                fillChar = '0';
            }
            return String.valueOf(fillChar);
        }
        return String.valueOf(value.charAt(value.length() - 1 - index));
    }

    public static String getMultibitValueAtIndex(int startIndex, int endIndex, String value, int bitWidth) {
        if (startIndex < endIndex) {
            startIndex = bitWidth - startIndex - 1;
            endIndex = bitWidth - endIndex - 1;
        }
        if (!DVTVCDUtilsCommon.isMultibitIndexInBounds(endIndex, value)) {
            if (value.isEmpty()) {
                return LOGIC_SIGNAL_LOW;
            }
            char fillChar = value.charAt(0);
            if (fillChar == '1') {
                fillChar = '0';
            }
            return String.valueOf(fillChar);
        }
        startIndex = value.length() - 1 - startIndex >= 0 ? value.length() - 1 - startIndex : 0;
        return value.substring(startIndex, value.length() - endIndex);
    }

    private static boolean isMultibitIndexInBounds(int endIndex, String value) {
        return value.length() - 1 - endIndex >= 0;
    }

    private static boolean isIndexInBounds(int index, String value) {
        return value.length() - 1 - index >= 0;
    }

    public static WSignalsTableElement getSignalsTableElement(TreePath selection) {
        if (selection == null) {
            return null;
        }
        Object selectedElement = selection.getElement();
        if (selectedElement == null) {
            return null;
        }
        if (selectedElement instanceof TreePath) {
            selectedElement = ((TreePath)selectedElement).getElement();
        }
        if (!(selectedElement instanceof WSignalsTableElement)) {
            return null;
        }
        return (WSignalsTableElement)selectedElement;
    }

    public static void removeSignalsTableElement(TreeSet<WSignalsTableElement> elementSiblings, int elementId) {
        WSignalsTableElement element = null;
        Iterator<WSignalsTableElement> iterator = elementSiblings.iterator();
        while (iterator.hasNext()) {
            element = iterator.next();
            if (elementId != element.getId()) continue;
            iterator.remove();
            break;
        }
        while (iterator.hasNext()) {
            element = iterator.next();
            element.setId(element.getId() - 1);
        }
    }

    public static byte mapVCDTypeToFST(String vcdType) {
        switch (vcdType) {
            case "event": {
                return 0;
            }
            case "integer": {
                return 1;
            }
            case "parameter": {
                return 2;
            }
            case "port": {
                return 17;
            }
            case "realtime": {
                return 19;
            }
            case "real": {
                return 3;
            }
            case "reg": {
                return 4;
            }
            case "supply0": {
                return 5;
            }
            case "supply1": {
                return 6;
            }
            case "time": {
                return 7;
            }
            case "tri": {
                return 8;
            }
            case "triand": {
                return 9;
            }
            case "trior": {
                return 10;
            }
            case "trireg": {
                return 11;
            }
            case "tri0": {
                return 12;
            }
            case "tri1": {
                return 13;
            }
            case "wand": {
                return 14;
            }
            case "wire": {
                return 15;
            }
            case "wor": {
                return 16;
            }
        }
        return 15;
    }

    public static String mapFSTtoVCDType(byte fstType) {
        switch (fstType) {
            case 0: {
                return "event";
            }
            case 1: {
                return "integer";
            }
            case 2: {
                return "parameter";
            }
            case 17: {
                return "port";
            }
            case 19: {
                return "realtime";
            }
            case 3: {
                return REAL_TYPE;
            }
            case 4: {
                return "reg";
            }
            case 5: {
                return "supply0";
            }
            case 6: {
                return "supply1";
            }
            case 7: {
                return "time";
            }
            case 8: {
                return "tri";
            }
            case 9: {
                return "triand";
            }
            case 10: {
                return "trior";
            }
            case 11: {
                return "trireg";
            }
            case 12: {
                return "tri0";
            }
            case 13: {
                return "tri1";
            }
            case 14: {
                return "wand";
            }
            case 15: {
                return "wire";
            }
            case 16: {
                return "wor";
            }
        }
        return "wire";
    }

    public static byte getTimescaleExponent(String timeUnit) {
        switch (timeUnit) {
            case "fs": {
                return 15;
            }
            case "ps": {
                return 12;
            }
            case "ns": {
                return 9;
            }
            case "us": {
                return 6;
            }
            case "ms": {
                return 3;
            }
            case "s": {
                return 0;
            }
        }
        return 9;
    }

    public static void addSignalsTableElement(TreeSet<WSignalsTableElement> elementSiblings, WSignalsTableElement element) {
        int elementId = element.getId();
        WSignalsTableElement sibling2 = null;
        for (WSignalsTableElement sibling2 : elementSiblings) {
            int siblingId = sibling2.getId();
            if (siblingId < elementId) continue;
            sibling2.setId(siblingId + 1);
        }
        elementSiblings.add(element);
    }

    public static boolean isCurrentVarModifInClock(DVTVCDSignalWrapper signal, long currentTime, String currentValue) {
        int actualValue;
        TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes = signal.getClockInfoByStartTimes();
        ConcurrentLinkedDeque<DVTVCDVarModificationByTime> varModificationByTime = signal.getVarModificationByTime();
        if (!currentValue.equals(LOGIC_SIGNAL_LOW) && !currentValue.equals(LOGIC_SIGNAL_HIGH)) {
            signal.closeClock(currentTime);
            return false;
        }
        DVTVCDVarClockInfo lastClock = null;
        if (clockInfoByStartTimes != null && !clockInfoByStartTimes.isEmpty()) {
            lastClock = clockInfoByStartTimes.lastEntry().getValue();
        }
        if (lastClock == null || lastClock.isClosed() && lastClock.getEndTime() < currentTime) {
            if (varModificationByTime.isEmpty()) {
                return false;
            }
            int clockChangesNeededCnt = 4;
            long clockInterval = -1L;
            long lastKnownVarModifTime = 0L;
            int lastChangedValue = 0;
            ConcurrentLinkedDeque<DVTVCDVarModificationByTime> auxVarModificationByTime = new ConcurrentLinkedDeque<DVTVCDVarModificationByTime>();
            while (clockChangesNeededCnt > 0) {
                int currentChangeValue;
                String lastKnownVarModifValue;
                if (varModificationByTime.isEmpty()) break;
                DVTVCDVarModificationByTime lastVarModification = varModificationByTime.pollLast();
                auxVarModificationByTime.addFirst(lastVarModification);
                lastKnownVarModifTime = lastVarModification.getTime();
                if (lastKnownVarModifTime > currentTime || !(lastKnownVarModifValue = lastVarModification.getValue()).equals(LOGIC_SIGNAL_LOW) && !lastKnownVarModifValue.equals(LOGIC_SIGNAL_HIGH) || (currentChangeValue = Integer.parseInt(currentValue)) == (lastChangedValue = Integer.parseInt(lastKnownVarModifValue))) break;
                if (clockInterval == -1L) {
                    clockInterval = currentTime - lastKnownVarModifTime;
                } else if (currentTime - lastKnownVarModifTime != clockInterval) break;
                currentTime = lastKnownVarModifTime;
                currentValue = lastKnownVarModifValue;
                --clockChangesNeededCnt;
            }
            if (clockChangesNeededCnt > 0) {
                for (DVTVCDVarModificationByTime varModif : auxVarModificationByTime) {
                    varModificationByTime.addLast(varModif);
                }
                return false;
            }
            signal.createClock(clockInterval, lastKnownVarModifTime, lastChangedValue, auxVarModificationByTime);
            return true;
        }
        if (DVTVCDUtilsCommon.isContainedInAClock(signal, currentTime)) {
            return true;
        }
        if (currentTime < lastClock.getStartTime()) {
            return false;
        }
        if (lastClock.isClosed()) {
            return false;
        }
        if (currentTime != lastClock.getEndTime() + lastClock.getChangeInterval()) {
            signal.closeClock(currentTime);
            return false;
        }
        long noOfIntervalsInBetween = (currentTime - lastClock.getStartTime()) / lastClock.getChangeInterval();
        long expectedValue = lastClock.getStartingValue();
        if (noOfIntervalsInBetween % 2L == 1L) {
            expectedValue = 1L - expectedValue;
        }
        if ((long)(actualValue = Integer.parseInt(currentValue)) != expectedValue) {
            signal.closeClock(currentTime);
            return false;
        }
        lastClock.setEndTime(currentTime);
        return true;
    }

    public static boolean isContainedInAClock(DVTVCDSignalWrapper signal, long currentTime) {
        return DVTVCDUtilsCommon.getClockAt(signal, currentTime) != null;
    }

    public static boolean isClock(DVTVCDSignalWrapper signal, long intervalStart, long intervalEnd) {
        DVTVCDVarClockInfo clockAtIntervalStart = DVTVCDUtilsCommon.getClockAt(signal, intervalStart);
        return clockAtIntervalStart != null && clockAtIntervalStart.containsTime(intervalEnd);
    }

    public static DVTVCDVarClockInfo getClosestClock(DVTVCDSignalWrapper signal, long time) {
        TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes = signal.getClockInfoByStartTimes();
        if (clockInfoByStartTimes == null || clockInfoByStartTimes.isEmpty()) {
            return null;
        }
        DVTVCDVarClockInfo clock = clockInfoByStartTimes.get(time);
        if (clock != null) {
            return clock;
        }
        Map.Entry<Long, DVTVCDVarClockInfo> closestClockEntryToTime = clockInfoByStartTimes.lowerEntry(time);
        if (closestClockEntryToTime == null) {
            return null;
        }
        return closestClockEntryToTime.getValue();
    }

    public static DVTVCDVarClockInfo getClockAt(DVTVCDSignalWrapper signal, long time) {
        DVTVCDVarClockInfo closestClockToTime = DVTVCDUtilsCommon.getClosestClock(signal, time);
        if (closestClockToTime == null || !closestClockToTime.containsTime(time)) {
            return null;
        }
        return closestClockToTime;
    }

    public static void refreshWaveViewer(WaveViewerSignalTableView signalsView, WCanvas canvas) {
        signalsView.update();
        DVTVCDUtilsCommon.refreshWaveDiagram(canvas);
    }

    public static void refreshWaveDiagram(WCanvas canvas) {
        WSWTRenderer renderer = canvas.getRenderer();
        Display.getDefault().asyncExec(() -> renderer.render());
    }

    public static WSignalsTableGroup getParentGroup(WSignalsTableElement element) {
        TreePath parentTreePath = DVTVCDUtilsCommon.getParentTreePath(element);
        if (parentTreePath == null) {
            return null;
        }
        Object parentElement = parentTreePath.getElement();
        if (!(parentElement instanceof WSignalsTableElement)) {
            return null;
        }
        if (!(parentElement instanceof WSignalsTableGroup)) {
            return DVTVCDUtilsCommon.getParentGroup((WSignalsTableElement)parentElement);
        }
        return (WSignalsTableGroup)parentElement;
    }

    public static TreePath getParentTreePath(WSignalsTableElement signal) {
        if (signal == null) {
            return null;
        }
        TreePath treePath = signal.getTreePath();
        if (treePath == null) {
            return null;
        }
        return treePath.getParent();
    }

    public static List<DVTVCDSignalWrapper> getSignalsWrappers(WaveDiagramEditor editor) {
        if (editor == null) {
            return Collections.emptyList();
        }
        Canvas canvas = editor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return Collections.emptyList();
        }
        DVTVCDParser provider = ((WCanvas)canvas).getProvider();
        DVTVCDModel vcdModel = provider.getVcdModel();
        LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID = vcdModel.getSignalsByModelId();
        ArrayList<DVTVCDSignalWrapper> result = new ArrayList<DVTVCDSignalWrapper>();
        for (Map.Entry<String, DVTVCDSignalWrapper> signalById : variablesByID.entrySet()) {
            result.add(signalById.getValue());
        }
        return result;
    }

    protected static List<DVTVCDSignalWrapper> getSignalsWrappers(TreePath scopeTreePath, WaveDiagramEditor editor) {
        Object element = scopeTreePath.getElement();
        if (!(element instanceof DVTVCDHierarchicalScope)) {
            return Collections.emptyList();
        }
        ElementPath scopePath = ((DVTVCDHierarchicalScope)element).getPath();
        if (scopePath == null || scopePath.isEmpty()) {
            return Collections.emptyList();
        }
        DVTVCDParser parser = editor.getParser();
        if (parser == null) {
            return Collections.emptyList();
        }
        DVTVCDModel model = parser.getVcdModel();
        if (model == null) {
            return Collections.emptyList();
        }
        DVTWaveHierarchicalScopeInfo scopeInfo = model.getScopeInfo(scopePath);
        if (scopeInfo == null) {
            return Collections.emptyList();
        }
        TreeMap<String, DVTVCDSignalWrapper> signalWrappersByName = scopeInfo.getSignalWrappersByName();
        if (signalWrappersByName == null || signalWrappersByName.isEmpty()) {
            return Collections.emptyList();
        }
        List<DVTVCDSignalWrapper> signalsWrappers = signalWrappersByName.values().stream().collect(Collectors.toList());
        return signalsWrappers;
    }

    public static TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo> getOrderedScopeInfos(WaveDiagramEditor editor) {
        if (editor == null) {
            return new TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo>();
        }
        Canvas canvas = editor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return new TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo>();
        }
        DVTVCDParser provider = ((WCanvas)canvas).getProvider();
        if (provider == null) {
            return new TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo>();
        }
        DVTVCDModel vcdModel = provider.getVcdModel();
        if (vcdModel == null) {
            return new TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo>();
        }
        return vcdModel.getOrderedScopeInfos();
    }

    public static void setChildrenSignalsInTreePath(TreePath scopeTreePath, WaveDiagramEditor diagramEditor) {
        Object element = scopeTreePath.getElement();
        if (!(element instanceof DVTVCDHierarchicalScope)) {
            return;
        }
        DVTVCDHierarchicalScope scope = (DVTVCDHierarchicalScope)element;
        List<DVTVCDSignalWrapper> signalsWrappers = DVTVCDUtilsCommon.getSignalsWrappers(scopeTreePath, diagramEditor);
        for (DVTVCDSignalWrapper signalWrapper : signalsWrappers) {
            String signalName;
            WSignalElementPath signalPath;
            if (signalWrapper.isChildOfNetArray() || (signalPath = signalWrapper.getPath()) == null || (signalName = signalPath.getNameWithDimension()) == null || signalName.isEmpty()) continue;
            scope.addChildSignal(new DVTVCDHierarchicalVar(signalName, signalPath, signalWrapper.getType(), signalWrapper.getVarID()));
        }
    }

    public static Image getSignalImage(String type, WSignalElementPath signalPath) {
        Image imageFromVCDVarType = WaveViewerSignalType.getSignalTypeFromString(type).getImage();
        if (signalPath == null) {
            return imageFromVCDVarType;
        }
        IProject lastSelectedProject = DVTVCDUtils.getInstance().getLastSelectedProject();
        if (lastSelectedProject == null || !lastSelectedProject.exists()) {
            return imageFromVCDVarType;
        }
        if (!DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(lastSelectedProject)) {
            return imageFromVCDVarType;
        }
        IRfNamedElement namedElement = DVTVCDUtilsCommon.getSignalNamedElementFromPath(signalPath, lastSelectedProject);
        if (namedElement == null) {
            return imageFromVCDVarType;
        }
        return namedElement.getImage();
    }

    public abstract IProject getLastSelectedProject();

    public static Map<DSTMetadataItem, Object> readDSTMetadataItems(ByteBuffer buffer) {
        EnumMap<DSTMetadataItem, Object> metadatas = new EnumMap<DSTMetadataItem, Object>(DSTMetadataItem.class);
        int metadataSize = buffer.getInt();
        DSTMetadataItem[] dSTMetadataItemArray = DSTMetadataItem.values();
        int n = dSTMetadataItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            DSTMetadataItem metadataItem = dSTMetadataItemArray[n2];
            if (metadataSize <= 0) break;
            metadataSize -= metadataItem.dimension;
            switch (metadataItem.dimension) {
                case 1: {
                    metadatas.put(metadataItem, (Object)buffer.get());
                    break;
                }
                case 4: {
                    metadatas.put(metadataItem, (Object)buffer.getInt());
                    break;
                }
                case 8: {
                    metadatas.put(metadataItem, (Object)buffer.getLong());
                    break;
                }
            }
            ++n2;
        }
        while (metadataSize > 0) {
            buffer.get();
            --metadataSize;
        }
        return metadatas;
    }

    public static int readVarint(ByteBuffer buffer) {
        byte b;
        int value = 0;
        int shift = 0;
        do {
            b = buffer.get();
            value |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return value;
    }

    public static int readVarint(ByteArrayInputStream stream) throws IOException {
        int b;
        int value = 0;
        int shift = 0;
        do {
            if ((b = stream.read()) == -1) {
                throw new EOFException("Unexpected end of stream while reading varint");
            }
            value |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return value;
    }

    public static int readSvarint(ByteArrayInputStream stream) throws IOException {
        int b;
        int value = 0;
        int shift = 0;
        do {
            if ((b = stream.read()) == -1) {
                throw new EOFException("Unexpected end of stream while reading svarint");
            }
            value |= (b & 0x7F) << shift;
            if ((shift += 7) <= 32) continue;
            throw new IOException("Variable length quantity is too long");
        } while ((b & 0x80) != 0);
        return value >>> 1 ^ -(value & 1);
    }

    public static int readSvarint(ByteBuffer stream) throws IOException {
        byte b;
        int value = 0;
        int shift = 0;
        do {
            b = stream.get();
            value |= (b & 0x7F) << shift;
            if ((shift += 7) <= 32) continue;
            throw new IOException("Variable length quantity is too long");
        } while ((b & 0x80) != 0);
        return value >>> 1 ^ -(value & 1);
    }

    public static String readString(ByteBuffer buffer) {
        byte b;
        StringBuilder sb = new StringBuilder();
        while ((b = buffer.get()) != 0) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    public static byte[] decompress(byte[] compressedData, int uncompressedLength) throws IOException {
        int bytesRead;
        ByteArrayInputStream bis = new ByteArrayInputStream(compressedData);
        Inflater inflater = new Inflater(true);
        InflaterInputStream inflaterIn = new InflaterInputStream(bis, inflater);
        byte[] decompressed = new byte[uncompressedLength];
        int totalRead = 0;
        while (totalRead < uncompressedLength && (bytesRead = inflaterIn.read(decompressed, totalRead, uncompressedLength - totalRead)) != -1) {
            totalRead += bytesRead;
        }
        inflaterIn.close();
        return decompressed;
    }

    public static String[] readInitialValues(int nOfVars, byte[] compressedBits) {
        String[] initialValues = new String[nOfVars];
        ByteBuffer bitsInputBuffer = ByteBuffer.wrap(compressedBits);
        int i = 0;
        while (i < nOfVars) {
            initialValues[i] = DVTVCDUtilsCommon.readString(bitsInputBuffer);
            ++i;
        }
        return initialValues;
    }

    public static byte[] extractWaveData(ByteBuffer mappedBuffer) throws IOException {
        DVTVCDUtilsCommon.readVarint(mappedBuffer);
        mappedBuffer.get();
        long wavesUncompressedLength = mappedBuffer.getLong();
        long wavesCompressedLength = mappedBuffer.getLong();
        byte[] waveData = new byte[(int)wavesCompressedLength];
        mappedBuffer.get(waveData);
        if (wavesCompressedLength != wavesUncompressedLength) {
            return DVTVCDUtilsCommon.decompress(waveData, (int)wavesUncompressedLength);
        }
        return waveData;
    }

    public static boolean selectionContainsGroups(List<WSignalsTableElement> selectedElements) {
        for (WSignalsTableElement element : selectedElements) {
            if (!(element instanceof WSignalsTableGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean selectionContainsOnlyChildSignals(List<WSignalsTableElement> selectedElements) {
        for (WSignalsTableElement element : selectedElements) {
            if (element instanceof WSignalsTableMultiBitChildSignal || element instanceof WSignalsTableSingleBitChildSignal) continue;
            return false;
        }
        return true;
    }

    public static long computeTime(int relativeX, WSignalsTableSignal currentSignal, WViewport viewport, boolean isRound) {
        long prevX;
        if (relativeX <= 0) {
            return viewport.getLowestVisibleTime();
        }
        if (relativeX >= viewport.getMaxXToDrawAt()) {
            return viewport.getHighestVisibleTime();
        }
        long relativeDeltaTime = 0L;
        relativeDeltaTime = !isRound ? (long)((double)relativeX / viewport.getTimeUnitSizeOnScreen()) : Math.round((double)relativeX / viewport.getTimeUnitSizeOnScreen());
        long currentTime = viewport.getLowestVisibleTime() + relativeDeltaTime;
        if (currentSignal == null) {
            return currentTime;
        }
        DVTVCDParser vcdParser = viewport.getCanvas().getProvider();
        DVTVCDModel vcdModel = vcdParser.getVcdModel();
        DVTVCDSignalWrapper varWrapper = vcdModel.getSignalsByModelId().get(currentSignal.getVcdId());
        TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes = varWrapper.getClockInfoByStartTimes();
        Iterable<DVTVCDVarModificationByTime> varModificationByTime = varWrapper.getVarModificationByTime();
        DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = varWrapper.getVarModifsFromFST();
        if (varModifsFromFST != null) {
            varModifsFromFST.setStartTime((int)currentTime);
            varModificationByTime = varModifsFromFST;
        }
        long nextTime = DVTVCDUtilsCommon.getNextEdge(clockInfoByStartTimes, varModificationByTime, currentTime - 1L, vcdParser, viewport, varWrapper, currentSignal);
        long prevTime = DVTVCDUtilsCommon.getPrevEdge(clockInfoByStartTimes, varModificationByTime, currentTime + 1L, vcdParser, viewport, varWrapper, currentSignal);
        long nextX = nextTime != -1L ? (long)((double)(nextTime - viewport.getLowestVisibleTime()) * viewport.getTimeUnitSizeOnScreen()) : -1L;
        long l = prevX = prevTime != -1L ? (long)((double)(prevTime - viewport.getLowestVisibleTime()) * viewport.getTimeUnitSizeOnScreen()) : -1L;
        if (nextX - (long)relativeX < (long)relativeX - prevX && nextX <= (long)viewport.getMaxXToDrawAt() && nextX != -1L && nextX - (long)relativeX <= 50L) {
            return nextTime;
        }
        if (prevX >= 0L && (long)relativeX - prevX <= 50L) {
            return prevTime;
        }
        return currentTime;
    }

    public static int computeClosestTimeX(int relativeX, WViewport viewport) {
        if (relativeX <= 0) {
            return 0;
        }
        if (relativeX >= viewport.getMaxXToDrawAt()) {
            return viewport.getMaxXToDrawAt();
        }
        long relativeTime = Math.round((double)relativeX / viewport.getTimeUnitSizeOnScreen());
        return (int)((double)relativeTime * viewport.getTimeUnitSizeOnScreen());
    }

    public static String getVcdFilePath(WViewport viewport) {
        DVTVCDParser provider = viewport.getCanvas().getProvider();
        if (provider == null) {
            return CFG_MISSING_SOURCE;
        }
        String filePath = provider.getVcdFilePath();
        if (filePath == null) {
            return CFG_MISSING_SOURCE;
        }
        return filePath;
    }

    public static String getDstFilePath(WViewport viewport) {
        DVTVCDParser provider = viewport.getCanvas().getProvider();
        if (!(provider instanceof FSTReader)) {
            return CFG_MISSING_SOURCE;
        }
        String filePath = ((FSTReader)provider).getDstFilePath();
        if (filePath == null) {
            return CFG_MISSING_SOURCE;
        }
        return filePath;
    }

    public static String getFirstAvailableFilePath(WViewport viewport) {
        String dstFilePath = DVTVCDUtilsCommon.getDstFilePath(viewport);
        if (CFG_MISSING_SOURCE.equals(dstFilePath)) {
            return DVTVCDUtilsCommon.getVcdFilePath(viewport);
        }
        return dstFilePath;
    }

    public static boolean checkFileExists(String filePath) {
        if (filePath == null) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static String getWaveFileDirectory(WViewport viewport) {
        String vcdFilePath = DVTVCDUtilsCommon.getVcdFilePath(viewport);
        String dstFilePath = DVTVCDUtilsCommon.getDstFilePath(viewport);
        String directoryPath = null;
        if (vcdFilePath != null && !CFG_MISSING_SOURCE.equals(vcdFilePath)) {
            directoryPath = BaseUtils.getFileDirectoryPath(vcdFilePath);
        }
        if (directoryPath == null) {
            directoryPath = BaseUtils.getFileDirectoryPath(dstFilePath);
        }
        return directoryPath;
    }

    public static WSignalsTableGroup createNewDefaultGroup(TreeSet<WSignalsTableElement> signalsTableElements, WCanvas canvas) {
        if (canvas == null) {
            return null;
        }
        for (WSignalsTableElement node : signalsTableElements) {
            node.setId(node.getId() + 1);
        }
        WSignalsTableGroup defaultGroup = new WSignalsTableGroup(0, DEFAULT_GROUP_NAME, null, null);
        WViewport viewport = canvas.getViewport();
        viewport.addSignalsTableNode(defaultGroup);
        return defaultGroup;
    }

    public static void addAllSignals(WSignalsTableGroup selectedGroupInTable, LinkedHashMap<String, DVTVCDSignalWrapper> signalsById, Set<String> signalToAddVCDIds) {
        int nodeOrderId = selectedGroupInTable.getChildElements().size();
        for (String signalToAddVCDId : signalToAddVCDIds) {
            if (signalToAddVCDId == null || !DVTVCDUtilsCommon.addSignal(selectedGroupInTable, signalToAddVCDId, nodeOrderId, signalsById)) continue;
            ++nodeOrderId;
        }
    }

    public static boolean addSignal(WSignalsTableGroup selectedGroupInTable, String signalToAddVCDId, int nodeOrderId, LinkedHashMap<String, DVTVCDSignalWrapper> signalsById) {
        DVTVCDSignalWrapper signalWrapper = signalsById.get(signalToAddVCDId);
        if (signalWrapper == null || signalWrapper.isChildOfNetArray()) {
            return false;
        }
        selectedGroupInTable.getChildElements().add(WSignalsTableElementsFactory.INSTANCE.createSignal(nodeOrderId, signalWrapper));
        return true;
    }

    public static WSignalsTableGroup getExistingGroup(String selectedGroupName, TreeSet<WSignalsTableElement> signalsTableElements) {
        for (WSignalsTableElement signalsTableElement : signalsTableElements) {
            if (!(signalsTableElement instanceof WSignalsTableGroup) || !selectedGroupName.equals(signalsTableElement.getName())) continue;
            return (WSignalsTableGroup)signalsTableElement;
        }
        return null;
    }

    public static WSignalsTableElement nextInTable(TreeSet<WSignalsTableElement> signalsTableElements, WSignalsTableElement currentElement) {
        if (currentElement == null) {
            return null;
        }
        WSignalsTableElement parent = DVTVCDUtils.getParentElement(currentElement);
        if (!(parent instanceof ISignalsTableExpandableElement)) {
            return signalsTableElements.higher(currentElement);
        }
        WSignalsTableElement nextSibling = ((ISignalsTableExpandableElement)((Object)parent)).getChildElements().higher(currentElement);
        if (nextSibling != null) {
            return nextSibling;
        }
        return DVTVCDUtilsCommon.nextInTable(signalsTableElements, parent);
    }

    public static WSignalsTableElement getParentElement(WSignalsTableElement signal) {
        TreePath parentTreepath = DVTVCDUtilsCommon.getParentTreePath(signal);
        if (parentTreepath == null) {
            return null;
        }
        return (WSignalsTableElement)parentTreepath.getElement();
    }

    public static boolean isBigEndian(String dimension) {
        if (dimension == null || dimension.equals($END)) {
            return false;
        }
        Matcher matcher = DIGITS_CAPTURE_GROUP_PATTERN.matcher(dimension);
        if (!matcher.find()) {
            return false;
        }
        String msb = matcher.group();
        if (!matcher.find()) {
            return false;
        }
        String lsb = matcher.group();
        return Integer.valueOf(msb) < Integer.valueOf(lsb);
    }

    public static int getIndex(String dimension) {
        if (dimension == null) {
            return -1;
        }
        Matcher matcher = DIGITS_CAPTURE_GROUP_PATTERN.matcher(dimension);
        if (!matcher.find()) {
            return -1;
        }
        String msb = matcher.group();
        return Integer.parseInt(msb);
    }

    public static IRfNamedElement getSignalNamedElementFromPath(WSignalElementPath signalElementPath, IProject project) {
        IRfNamedElement instanceOrDesign = DVTVCDUtilsCommon.getDesignElementFromElementPath(signalElementPath, project);
        return DVTVCDUtilsCommon.getSignalNamedElementFromDesign(signalElementPath.getNameWithDimension(), instanceOrDesign);
    }

    public static int[] getPackedArrayIndexBounds(String dimension, boolean isBigEndian, int bitWidth) {
        int[] nArray;
        if (isBigEndian) {
            int[] nArray2 = new int[2];
            nArray = nArray2;
            nArray2[1] = bitWidth - 1;
        } else {
            int[] nArray3 = new int[2];
            nArray = nArray3;
            nArray3[0] = bitWidth - 1;
        }
        int[] defaultBounds = nArray;
        if (dimension == null) {
            return defaultBounds;
        }
        int[] bounds = new int[2];
        Matcher matcher = DIGITS_CAPTURE_GROUP_PATTERN.matcher(dimension);
        if (!matcher.find()) {
            return defaultBounds;
        }
        String msb = matcher.group();
        bounds[0] = Integer.parseInt(msb);
        if (!matcher.find()) {
            return defaultBounds;
        }
        String lsb = matcher.group();
        bounds[1] = Integer.parseInt(lsb);
        return bounds;
    }

    public static IRfNamedElement getDesignElementFromElementPath(WSignalElementPath signalElementPath, IProject project) {
        List<IRfNamedElement> designSegmentsFromElementPath = DesignPathManager.getInstance().getDesignSegmentsFromElementPath(project, signalElementPath.getParentInstancePath());
        if (designSegmentsFromElementPath == null || designSegmentsFromElementPath.isEmpty()) {
            return null;
        }
        return designSegmentsFromElementPath.get(designSegmentsFromElementPath.size() - 1);
    }

    public static IRfNamedElement getSignalNamedElementFromDesign(String signalName, IRfNamedElement designOrInstanceElement) {
        List<IRfPortElement> ports;
        List<? extends IRfNamedElement> parameters;
        if (signalName.contains(OPENING_SQUARE_BRACKET)) {
            signalName = signalName.substring(0, signalName.indexOf(91));
        }
        if (designOrInstanceElement == null) {
            return null;
        }
        ArrayList<? extends IRfNamedElement> dhPortsAndParamsDesignElement = new ArrayList<IRfNamedElement>();
        IRfNamedElement designElement = designOrInstanceElement instanceof IRfDesignElement ? designOrInstanceElement : DesignUtils.getDesign(DesignUtils.DesignRequest.of(designOrInstanceElement, designOrInstanceElement));
        List<? extends IRfNamedElement> list = parameters = designOrInstanceElement instanceof IRfDesignElement ? designOrInstanceElement.getLocalParameters() : designElement.getLocalParameters();
        if (parameters != null && !parameters.isEmpty()) {
            ArrayList<? extends IRfNamedElement> parametersCopy = new ArrayList<IRfNamedElement>(parameters);
            Collections.sort(parametersCopy, new DHViewUtilsCommon.SignalViewComparator(null, true));
            dhPortsAndParamsDesignElement.addAll(parametersCopy);
        }
        if (!(ports = DesignUtils.getPorts(DesignUtils.DesignRequest.of(designElement, designElement), false, null)).isEmpty()) {
            Collections.sort(ports, new DHViewUtilsCommon.SignalViewComparator(null, true));
            dhPortsAndParamsDesignElement.addAll(ports);
        }
        for (IRfNamedElement iRfNamedElement : dhPortsAndParamsDesignElement) {
            String name = iRfNamedElement.getName();
            if (!name.equals(signalName)) continue;
            return iRfNamedElement;
        }
        return DesignUtils.getFieldOrInstanceByName(signalName, DesignUtils.DesignRequest.of(designElement));
    }

    public static void openSelectedElement(IProject project, List<WSignalsTableElement> selectedElements, DVTOpenMode openMode) {
        if (project == null || !project.exists()) {
            return;
        }
        if (!DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project)) {
            return;
        }
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        WSignalsTableElement firstSelection = selectedElements.get(0);
        if (!(firstSelection instanceof WSignalsTableSignal)) {
            return;
        }
        WSignalElementPath signalElementPath = DVTVCDUtilsCommon.getSignalVCDPath(firstSelection);
        if (signalElementPath == null) {
            return;
        }
        ElementPath parentInstancePath = signalElementPath.getParentInstancePath();
        if (parentInstancePath == null) {
            return;
        }
        IRfNamedElement element = DVTVCDUtils.getSignalNamedElementFromPath(signalElementPath, project);
        if (element == null) {
            return;
        }
        IRfNamedElement instanceOrDesign = DVTVCDUtils.getDesignElementFromElementPath(signalElementPath, project);
        if (instanceOrDesign == null) {
            return;
        }
        DesignUtils.DesignRequest designRequest = DesignUtils.DesignRequest.of(instanceOrDesign, true);
        DVTVCDUtilsCommon.setBreadcrumbData(instanceOrDesign);
        if (openMode == DVTOpenMode.CONNECTION) {
            if (element instanceof IRfFieldElement && (((IRfFieldElement)element).isParameter() || ((IRfFieldElement)element).isTypeParameter()) && designRequest != null) {
                DVTRfUtils.goToGenericConnectionOrDeclarationFromWaveViewer((IRfFieldElement)element, instanceOrDesign.getRfProject(), signalElementPath, true);
            } else {
                DVTOpenMode newOpenMode = DVTRfUtils.goToPortConnectionOrDeclarationInternal(element, designRequest, new LinkedHashMap<IRfInstanceElement, Set<DummyPort>>(), true);
                DVTVCDUtils.updateBreadcrumbForEditor(signalElementPath, newOpenMode);
            }
        } else if (openMode == DVTOpenMode.DECLARATION) {
            DVTRfUtils.goToDeclaration(element, true);
            DVTVCDUtils.updateBreadcrumbForEditor(signalElementPath, DVTOpenMode.DECLARATION);
        }
    }

    public static void setBreadcrumbData(IRfNamedElement element) {
        try {
            if (element == null) {
                return;
            }
            IRfDefElement declaration = element.getDeclaration();
            if (declaration == null || declaration.getDefFile() == null) {
                return;
            }
            IResource file = (IResource)declaration.getDefFile().getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static WSignalElementPath getSignalVCDPath(Object treePath) {
        if (treePath instanceof TreePath) {
            treePath = ((TreePath)treePath).getElement();
        }
        if (!(treePath instanceof WSignalsTableSignal)) {
            return null;
        }
        return ((WSignalsTableSignal)treePath).getVcdPath();
    }

    public static boolean isSeparatorInRoot(WSignalsTableElement element) {
        if (!(element instanceof WSignalsTableSeparator)) {
            return false;
        }
        WSignalsTableElement parentElement = DVTVCDUtilsCommon.getParentElement(element);
        return parentElement == null;
    }

    public static boolean existsTimeInVcd(WCanvas canvas, String vcdFilePath, IProgressMonitor monitor) {
        Path filePath = Path.of(vcdFilePath, new String[0]);
        boolean foundTime = false;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ReversedLinesFileReader rev = new ReversedLinesFileReader(filePath.toFile(), 4096, StandardCharsets.UTF_8);){
                String line;
                while ((line = rev.readLine()) != null) {
                    if (!line.startsWith("#")) continue;
                    foundTime = true;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (!foundTime) {
            canvas.getViewport().setToolBarActionEnabled(RefreshAction.class, true);
            monitor.setCanceled(true);
        }
        return foundTime;
    }

    public abstract void restoreTimeOnImportConfig(long var1, long var3, WCanvas var5);

    public static String computeTimeLabel(long time, TimeScales timescale) {
        return String.valueOf(String.valueOf(time)) + SPACE + timescale.getName();
    }

    public static int getLabelWidth(long time, TimeScales timescale) {
        String label = DVTVCDUtilsCommon.computeTimeLabel(time, timescale);
        Point labelSize = FontFactory.getInstance().stringExtent(label, DVTVCDUtils.getFontData());
        return labelSize.x;
    }

    public static ElementPath getTopElementPath(ElementPath path) {
        if (path == null) {
            return null;
        }
        ElementPath upperPath = ElementPath.upperPathOf(path);
        if (upperPath == null) {
            return path;
        }
        ElementPath topElementPath = upperPath;
        while (upperPath != null && !upperPath.isEmpty()) {
            topElementPath = upperPath;
            upperPath = ElementPath.upperPathOf(upperPath);
        }
        return topElementPath;
    }

    public static List<String> getPortsName(IRfNamedElement instanceOrDesign) {
        if (instanceOrDesign == null) {
            return Collections.emptyList();
        }
        List<IRfPortElement> ports = DesignUtils.getPorts(DesignUtils.DesignRequest.of(instanceOrDesign), false, new HashMap<IRfInstanceElement, Set<DummyPort>>());
        if (ports == null || ports.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> portsNames = new ArrayList<String>();
        for (IRfPortElement port : ports) {
            String portName = port.getName();
            if (portName == null || portName.isEmpty()) continue;
            portsNames.add(portName);
        }
        return portsNames;
    }

    public static String getSignalPath(Object element, boolean isSignalDelim) {
        if (element instanceof TreePath) {
            element = ((TreePath)element).getElement();
        }
        if (!(element instanceof WSignalsTableElement)) {
            return EMPTY_STRING;
        }
        WSignalsTableElement signalTableElement = (WSignalsTableElement)element;
        if (element instanceof WSignalsTableGroup) {
            return "group '" + signalTableElement.getName() + "'";
        }
        if (element instanceof WSignalsTableSeparator) {
            if (signalTableElement.getName().equals(EMPTY_SEPARATOR_NAME)) {
                return CFG_SEPARATOR_TYPE;
            }
            return "separator '" + signalTableElement.getName() + "'";
        }
        if (!(element instanceof WSignalsTableSignal)) {
            return signalTableElement.getName();
        }
        WSignalsTableSignal signal = (WSignalsTableSignal)signalTableElement;
        return !isSignalDelim ? signal.getVcdPath().toString("/") : signal.getVcdPath().toStringWithSignalDelim("/", DOT);
    }

    public static TreeMap<Long, String> computeSignalValuesByTime(WCanvas canvas, DVTVCDSignalWrapper vcdSignalWrapper, WSignalsTableElement tableSignal, long lowTime, long highTime) {
        return DVTVCDUtilsCommon.computeSignalValuesByTime(canvas, vcdSignalWrapper, tableSignal, lowTime, highTime, -1.0);
    }

    public static TreeMap<Long, String> computeSignalValuesByTime(WCanvas canvas, DVTVCDSignalWrapper vcdSignalWrapper, WSignalsTableElement tableSignal, long lowTime, long highTime, double timeUnitsSizeOnScreen) {
        IWDModel drawModel = IWDModelFactory.INSTANCE.getModel(canvas, new HashSet<String>(), new LatestTaskOnlyScheduler());
        if (!(drawModel instanceof WDModel var10_8)) {
            return new TreeMap<Long, String>();
        }
        if (vcdSignalWrapper.getBitWidth().equals(LOGIC_SIGNAL_HIGH)) {
            return wdModel.computeSingleBitSignalValuesByTime(vcdSignalWrapper, lowTime, highTime, timeUnitsSizeOnScreen);
        }
        if (tableSignal instanceof WSignalsTableMultiBitChildSignal var12_10) {
            return wdModel.computeMultiBitChildSignal(vcdSignalWrapper, lowTime, highTime, timeUnitsSizeOnScreen, multiBitChildSignal.getStartIndex(), multiBitChildSignal.getEndIndex());
        }
        if (tableSignal instanceof WSignalsTableSingleBitChildSignal var14_12) {
            return wdModel.computeSingleBitChildSignal(vcdSignalWrapper, lowTime, highTime, timeUnitsSizeOnScreen, singleBitChildSignal.getIndex());
        }
        return wdModel.computeMultiBitSignalValuesByTime(vcdSignalWrapper, lowTime, highTime, timeUnitsSizeOnScreen);
    }

    public boolean isCursorPlaced(WCanvas canvas) {
        WViewport viewport = canvas.getViewport();
        if (viewport == null) {
            return false;
        }
        WCursor primaryCursor = viewport.getPrimaryCursor();
        WCursor secondaryCursor = viewport.getSecondaryCursor();
        return primaryCursor != null && primaryCursor.isInCanvas(canvas) || secondaryCursor != null && secondaryCursor.isInCanvas(canvas);
    }

    public String getLogViewerQueryFromCursors(WCanvas canvas) {
        WViewport viewport = canvas.getViewport();
        if (viewport == null) {
            return null;
        }
        WCursor primaryCursor = viewport.getPrimaryCursor();
        WCursor secondaryCursor = viewport.getSecondaryCursor();
        if (primaryCursor == null || secondaryCursor == null) {
            return null;
        }
        if (!primaryCursor.isInCanvas(canvas) && !secondaryCursor.isInCanvas(canvas)) {
            return null;
        }
        DVTStringBuilder queryStringBuilder = new DVTStringBuilder();
        if (primaryCursor.isInCanvas(canvas) && secondaryCursor.isInCanvas(canvas)) {
            long lowestTime = primaryCursor.getTime() < secondaryCursor.getTime() ? primaryCursor.getTime() : secondaryCursor.getTime();
            long highestTime = primaryCursor.getTime() > secondaryCursor.getTime() ? primaryCursor.getTime() : secondaryCursor.getTime();
            queryStringBuilder.append("timestamp >= ").append(lowestTime).append(" && ").append("timestamp <= ").append(highestTime);
        } else {
            long fixedTime = primaryCursor.isInCanvas(canvas) ? primaryCursor.getTime() : secondaryCursor.getTime();
            queryStringBuilder.append("timestamp >= ").append(fixedTime);
        }
        if (queryStringBuilder.length() == 0) {
            return null;
        }
        return queryStringBuilder.toString();
    }

    public static boolean isTimeValidInVcd(long time, WCanvas canvas) {
        DVTVCDParser provider = canvas.getProvider();
        if (provider == null) {
            return false;
        }
        long firstTimeFromVcd = provider.getFirstTimeFromVcd();
        long lastTimeFromVcd = provider.getLastTimeFromVcd();
        return time >= firstTimeFromVcd && time <= lastTimeFromVcd;
    }

    public WViewport getCurrentWaveformViewport() {
        WaveDiagramEditor inputWaveEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(this.getLastSelectedProject());
        if (inputWaveEditor == null) {
            return null;
        }
        Canvas canvas = inputWaveEditor.getCanvas();
        if (!(canvas instanceof WCanvas var3_4)) {
            return null;
        }
        return wCanvas.getViewport();
    }

    public static String getSourceFileName(WViewport viewport) {
        if (viewport == null) {
            return INFO_BAR_SOURCE_FILE_NAME_NOT_AVAILABLE;
        }
        String filePath = DVTVCDUtils.getVcdFilePath(viewport);
        if (filePath == null || filePath.isEmpty() || CFG_MISSING_SOURCE.equals(filePath)) {
            filePath = DVTVCDUtils.getDstFilePath(viewport);
        }
        if (filePath == null || filePath.isEmpty() || CFG_MISSING_SOURCE.equals(filePath)) {
            return INFO_BAR_SOURCE_FILE_NAME_NOT_AVAILABLE;
        }
        String fileName = BaseUtils.getFileName(filePath);
        if (fileName == null || fileName.isEmpty()) {
            return INFO_BAR_SOURCE_FILE_NAME_NOT_AVAILABLE;
        }
        return fileName;
    }

    public static String removeStartingZerosFromBinaryString(String binaryString) {
        if (binaryString == null || binaryString.isEmpty()) {
            return null;
        }
        int i = 0;
        int len = binaryString.length();
        while (i < len - 1 && binaryString.charAt(i) == '0') {
            ++i;
        }
        return binaryString.substring(i);
    }

    public abstract void displayWarning(String var1, String var2);

    public abstract void displayInfo(String var1, String var2);

    public abstract boolean hasLicense(Canvas var1);

    public abstract int getTreeItemHeight(LazyTree var1);

    public static enum Cursors {
        PRIMARY,
        SECONDARY;

    }

    static enum DSTMetadataItem {
        IncompleteHierarchy(1);

        int dimension;

        private DSTMetadataItem(int dimension) {
            this.dimension = dimension;
        }

        public int getDimension() {
            return this.dimension;
        }

        public static int getAllMetadataSize() {
            return Arrays.stream(DSTMetadataItem.values()).map(DSTMetadataItem::getDimension).reduce(0, Integer::sum);
        }
    }

    public static enum TimeScales {
        FEMTO_SECOND("fs", 0),
        PICO_SECOND("ps", 3),
        NANO_SECOND("ns", 6),
        MICRO_SECOND("us", 9),
        MILI_SECOND("ms", 12),
        SECOND("s", 15);

        private final String name;
        private final int exponentOf10;

        private TimeScales(String name, int exponentOf10) {
            this.name = name;
            this.exponentOf10 = exponentOf10;
        }

        public String getName() {
            return this.name;
        }

        public int getExponentOf10() {
            return this.exponentOf10;
        }

        public static TimeScales getTimeUnit(String name) {
            if (FEMTO_SECOND.getName().equals(name)) {
                return FEMTO_SECOND;
            }
            if (PICO_SECOND.getName().equals(name)) {
                return PICO_SECOND;
            }
            if (NANO_SECOND.getName().equals(name)) {
                return NANO_SECOND;
            }
            if (MICRO_SECOND.getName().equals(name)) {
                return MICRO_SECOND;
            }
            if (MILI_SECOND.getName().equals(name)) {
                return MILI_SECOND;
            }
            if (SECOND.getName().equals(name)) {
                return SECOND;
            }
            return null;
        }
    }

    public static enum UserActions {
        ZOOM_IN(0),
        PAN_LEFT(1),
        PAN_RIGHT(2),
        ZOOM_OUT(3);

        private final int id;

        private UserActions(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum WaveFileFormat {
        VCD,
        DST,
        ALL_TYPES;

    }
}

