/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

public class DVTVCDVarClockInfo {
    private long changeInterval;
    private long startTime;
    private long endTime;
    private long startingValue;
    private boolean isClosed;

    public DVTVCDVarClockInfo(long interval, long startTime, long startingValue) {
        this.changeInterval = interval;
        this.startTime = startTime;
        this.startingValue = startingValue;
        this.endTime = startTime + 4L * interval;
        this.isClosed = false;
    }

    public long getChangeInterval() {
        return this.changeInterval;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getStartingValue() {
        return this.startingValue;
    }

    public void close() {
        this.isClosed = true;
    }

    public long getValueAtTime(long time) {
        long result = (time - this.startTime) / this.changeInterval % 2L;
        result = result == 0L ? this.startingValue : 1L - this.startingValue;
        return result;
    }

    public long getNextTimeChange(long time) {
        long intervalsCnt = (time - this.startTime) / this.changeInterval + 1L;
        return this.startTime + intervalsCnt * this.changeInterval;
    }

    public long getPrevTimeChange(long time) {
        long intervalsCnt = (time - this.startTime - 1L) / this.changeInterval;
        return this.startTime + intervalsCnt * this.changeInterval;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean containsTime(long time) {
        return this.startTime <= time && time <= this.endTime;
    }

    public void deepClean() {
    }
}

