/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.Objects;
import java.util.regex.Matcher;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.TimeChangeWrapper;
import ro.amiq.dvt.ui.waveviewer.TimeEvent;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;

public class DVTVCDVarModificationByTime
implements TimeEvent {
    private TimeChangeWrapper timeChange;
    private String value;

    public DVTVCDVarModificationByTime(TimeChangeWrapper timeChange, String value) {
        this.timeChange = timeChange;
        this.value = value;
    }

    public TimeChangeWrapper getTimeChange() {
        return this.timeChange;
    }

    @Override
    public long getTime() {
        return this.timeChange.getTime();
    }

    public String getValue() {
        return this.value;
    }

    public String computeValueForTableSignal(WSignalsTableSignal signalsTableSignal, DVTVCDSignalWrapper signalWrapper) {
        if (signalsTableSignal instanceof WSignalsTableSingleBitChildSignal var3_4) {
            return DVTVCDUtils.getValueAtIndex(childSignal.getIndex(), this.value, Integer.parseInt(signalWrapper.getBitWidth()), signalWrapper.isBigEndian());
        }
        if (signalsTableSignal instanceof WSignalsTableMultiBitChildSignal var5_6) {
            return DVTVCDUtils.getMultibitValueAtIndex(childSignal.getStartIndex(), childSignal.getEndIndex(), this.value, Integer.parseInt(signalWrapper.getBitWidth()));
        }
        if (signalsTableSignal instanceof WSignalsTableStructSignal var7_8) {
            return DVTVCDUtils.getMultibitValueAtIndex(childSignal.getStartIndex(), childSignal.getEndIndex(), this.value, Integer.parseInt(signalWrapper.getBitWidth()));
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void deepClean() {
        this.value = null;
    }

    public boolean containsDigits() {
        Matcher matcher = DVTVCDUtils.DIGITS_PATTERN.matcher(this.value);
        return matcher.matches();
    }

    public boolean containsHighImpedance() {
        Matcher matcher = DVTVCDUtils.HIGH_IMPEDANCE_PATTERN.matcher(this.value);
        return matcher.matches();
    }

    public boolean containsShortCircuit() {
        Matcher matcher = DVTVCDUtils.SHORT_CIRCUIT_PATTERN.matcher(this.value);
        return matcher.matches();
    }

    public int hashCode() {
        return Objects.hash(this.timeChange);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DVTVCDVarModificationByTime other = (DVTVCDVarModificationByTime)obj;
        return Objects.equals(this.timeChange, other.timeChange);
    }
}

