/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import ro.amiq.dvt.ui.waveviewer.TimeEvent;

public class DVTVarModifQueue<E extends TimeEvent>
implements Iterable<E> {
    private Node<E> first;
    private Node<E> last;
    private int size;
    private TreeMap<Integer, Node<E>> anchors = new TreeMap();
    private int anchorsDistance = 10000;
    private int startTime;
    public E firstValue;

    public void setStartTime(int startTime) {
        this.startTime = startTime;
    }

    public DVTVarModifQueue() {
    }

    public DVTVarModifQueue(int anchorsDistance) {
        this.anchorsDistance = anchorsDistance;
    }

    public E getFirstValue() {
        if (this.firstValue != null) {
            return this.firstValue;
        }
        if (this.first == null) {
            return null;
        }
        TimeEvent value = (TimeEvent)this.first.item;
        return (E)value;
    }

    public E getLastValue() {
        if (this.last == null) {
            return null;
        }
        TimeEvent value = (TimeEvent)this.last.item;
        return (E)value;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void addLast(E element) {
        Node<E> newNode = new Node<E>(element);
        if (this.last != null && ((TimeEvent)this.last.item).equals(element)) {
            this.replaceLast(newNode);
            return;
        }
        if (this.size % this.anchorsDistance == 0) {
            this.anchors.put((int)element.getTime(), newNode);
        }
        if (this.last == null) {
            this.first = newNode;
            this.last = newNode;
        } else {
            this.last.next = newNode;
            newNode.prev = this.last;
            this.last = newNode;
        }
        ++this.size;
    }

    private void replaceLast(Node<E> newNode) {
        if ((this.size - 1) % this.anchorsDistance == 0) {
            this.anchors.put((int)((TimeEvent)newNode.item).getTime(), newNode);
        }
        this.last = this.last.prev;
        if (this.last == null) {
            this.first = newNode;
            this.last = newNode;
        } else {
            this.last.next = newNode;
            newNode.prev = this.last;
            this.last = newNode;
        }
    }

    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        TimeEvent item = (TimeEvent)this.last.item;
        int lastTime = (int)item.getTime();
        if (this.anchors.get(lastTime) != null) {
            this.anchors.remove(lastTime);
        }
        this.last = this.last.prev;
        if (this.last != null) {
            this.last.next = null;
        } else {
            this.first = null;
        }
        --this.size;
        return (E)item;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.startTime = 0;
        this.anchors.clear();
        this.anchors = null;
        this.first = null;
        this.last = null;
    }

    @Override
    public Iterator<E> iterator() {
        Map.Entry<Integer, Node<E>> startEntry = this.anchors.lowerEntry(this.startTime);
        Node<E> startNode = startEntry != null ? startEntry.getValue() : this.first;
        return new Iterator<E>(startNode){
            private Node<E> current;
            {
                this.current = node;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public E next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                TimeEvent item = (TimeEvent)this.current.item;
                this.current = this.current.next;
                return item;
            }
        };
    }

    private static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(E item) {
            this.item = item;
        }
    }
}

