/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.Map;
import java.util.TreeMap;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;

public class DVTWaveHierarchicalScopeInfo {
    private int parseOrderId;
    DVTWaveHierarchicalScopeType scopeType;
    private TreeMap<String, DVTVCDSignalWrapper> signalWrappersByName;

    public DVTWaveHierarchicalScopeInfo(int parseOrderId, String scopeType) {
        this.parseOrderId = parseOrderId;
        switch (scopeType) {
            case "module": {
                this.scopeType = DVTWaveHierarchicalScopeType.MODULE;
                break;
            }
            case "task": {
                this.scopeType = DVTWaveHierarchicalScopeType.TASK;
                break;
            }
            case "function": {
                this.scopeType = DVTWaveHierarchicalScopeType.FUNCTION;
                break;
            }
            case "begin": {
                this.scopeType = DVTWaveHierarchicalScopeType.BEGIN;
                break;
            }
            case "fork": {
                this.scopeType = DVTWaveHierarchicalScopeType.FORK;
                break;
            }
            case "interface": {
                this.scopeType = DVTWaveHierarchicalScopeType.INTERFACE;
                break;
            }
            case "clocking": {
                this.scopeType = DVTWaveHierarchicalScopeType.CLOCKING;
                break;
            }
            default: {
                this.scopeType = DVTWaveHierarchicalScopeType.NONE;
            }
        }
        this.signalWrappersByName = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    public int getParseOrderId() {
        return this.parseOrderId;
    }

    public DVTWaveHierarchicalScopeType getScopeType() {
        return this.scopeType;
    }

    public void addSignalWrapper(String signalName, DVTVCDSignalWrapper signalWrapper) {
        this.signalWrappersByName.put(signalName, signalWrapper);
    }

    public TreeMap<String, DVTVCDSignalWrapper> getSignalWrappersByName() {
        return this.signalWrappersByName;
    }

    public DVTVCDSignalWrapper getSignalWrapper(String signalName) {
        DVTVCDSignalWrapper signalWrapper = this.signalWrappersByName.get(signalName);
        if (signalWrapper != null) {
            return signalWrapper;
        }
        for (Map.Entry<String, DVTVCDSignalWrapper> entry : this.signalWrappersByName.entrySet()) {
            String entryDimensions;
            String entryName = entry.getKey();
            if (entryName == null || entryName.isEmpty() || (entryDimensions = entryName.replaceAll(signalName, "")) == null || !(entryDimensions = entryDimensions.strip()).startsWith("[") || !entryDimensions.endsWith("]")) continue;
            return entry.getValue();
        }
        return null;
    }

    public static enum DVTWaveHierarchicalScopeType {
        MODULE,
        TASK,
        FUNCTION,
        BEGIN,
        FORK,
        INTERFACE,
        CLOCKING,
        NONE;

    }
}

