/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable;
import ro.amiq.dvt.diagrams.netlist.model.NLBundleGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLBusUtils;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerFactoryInput;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCursor;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManagerUtils;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.SearchHitConnectedElementInfo;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.AddToWaveMode;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarClockInfo;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTVarModifQueue;
import ro.amiq.dvt.ui.waveviewer.DVTWaveHierarchicalScopeInfo;
import ro.amiq.dvt.ui.waveviewer.ICurrentWaveListener;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;
import ro.amiq.dvt.ui.waveviewer.WaveformViewerSchematicDiagramUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public class DVTWaveViewIDEFactory {
    private static final LinkedHashSet<DVTWaveHierarchicalScopeInfo> SCOPE_INFO_EMPTY_LINKED_HASH_SET = new LinkedHashSet();
    private static DVTWaveViewIDEFactory fInstance;
    private HashMap<IProject, WaveDiagramEditor> inputWaveEditorsMap = new HashMap();
    private List<ICurrentWaveListener> currentWaveListeners;

    public static DVTWaveViewIDEFactory getInstance() {
        if (fInstance == null) {
            fInstance = new DVTWaveViewIDEFactory();
        }
        return fInstance;
    }

    public void setInputWaveEditor(IProject project, WaveDiagramEditor inputWaveEditor) {
        WaveViewerFactoryInput waveViewerFactoryInputAction;
        this.notifyCurrentWaveListeners(inputWaveEditor);
        WaveDiagramEditor prevInputWaveEditor = null;
        if (this.inputWaveEditorsMap.containsKey(project) && (waveViewerFactoryInputAction = (prevInputWaveEditor = this.inputWaveEditorsMap.get(project)).getWaveViewerFactoryInputAction()) != null) {
            waveViewerFactoryInputAction.setChecked(false);
        }
        this.inputWaveEditorsMap.put(project, inputWaveEditor);
        DVTVCDUtils.getInstance().updateLogViewerActionButton((WCanvas)inputWaveEditor.getCanvas());
        if (prevInputWaveEditor != null) {
            DVTVCDUtils.getInstance().updateLogViewerActionButton((WCanvas)prevInputWaveEditor.getCanvas());
        }
    }

    public WaveDiagramEditor getInputWaveEditor(IProject project) {
        if (project == null) {
            return null;
        }
        return this.inputWaveEditorsMap.get(project);
    }

    private long getCursorTime(WaveDiagramEditor inputWaveEditor) {
        if (inputWaveEditor == null) {
            return 0L;
        }
        Canvas canvas = inputWaveEditor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return 0L;
        }
        WViewport viewPort = ((WCanvas)canvas).getViewport();
        if (viewPort == null) {
            return 0L;
        }
        WCursor primaryCursor = viewPort.getPrimaryCursor();
        if (primaryCursor == null || primaryCursor.getTime() < 0L) {
            return 0L;
        }
        return primaryCursor.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ElementPath> computeVCDDHValidInProject(IProject iproject, int limit) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(iproject);
        if (elManager == null) {
            return null;
        }
        WaveDiagramEditor waveEditor = this.inputWaveEditorsMap.get(iproject);
        if (waveEditor == null) {
            return null;
        }
        Object object = waveEditor.getParserSwapSyncObject();
        synchronized (object) {
            TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo> scopeInfos;
            block12: {
                DVTVCDParser parser;
                block11: {
                    block10: {
                        DVTLogger.INSTANCE.logDebug("Waveform Viewer Compare DH: Started");
                        scopeInfos = DVTVCDUtils.getOrderedScopeInfos(waveEditor);
                        if (!scopeInfos.isEmpty()) break block10;
                        return null;
                    }
                    parser = waveEditor.getParser();
                    if (parser != null) break block11;
                    return null;
                }
                DVTVCDModel vcdModel = parser.getVcdModel();
                if (vcdModel != null) break block12;
                return null;
            }
            HashSet<ElementPath> result = new HashSet<ElementPath>();
            for (Map.Entry scopeInfosEntry : scopeInfos.entrySet()) {
                ElementPath scopePath = (ElementPath)scopeInfosEntry.getKey();
                if (elManager.getMemory().instanceFor(scopePath) != null) continue;
                DVTWaveHierarchicalScopeInfo scopeInfo = (DVTWaveHierarchicalScopeInfo)scopeInfosEntry.getValue();
                if (scopeInfo == null) {
                    DVTLogger.INSTANCE.logDebug(String.format("Waveform Viewer Compare DH: Scope Info not found for path: {0}", scopePath));
                    continue;
                }
                DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType scopeType = scopeInfo.getScopeType();
                if (DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType.CLOCKING.equals((Object)scopeType) || DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType.BEGIN.equals((Object)scopeType) || DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType.TASK.equals((Object)scopeType) || DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType.FUNCTION.equals((Object)scopeType)) continue;
                result.add(scopePath);
                if (result.size() < limit) continue;
                return result;
            }
            DVTLogger.INSTANCE.logDebug("Waveform Viewer Compare DH: Finished");
            return result;
        }
    }

    private DVTVCDSignalWrapper findSignalWrapperFromEditor(IDVTBreadcrumbHost textEditor, IRfNamedElementAndScope elementAndScope, int offset) {
        IProject project = textEditor.getProject();
        if (project == null) {
            return null;
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return null;
        }
        List<DVTVCDSignalWrapper> signalsWrappers = DVTVCDUtils.getSignalsWrappers(inputWaveEditor);
        if (textEditor == null || signalsWrappers == null || signalsWrappers.isEmpty() || elementAndScope == null) {
            return null;
        }
        IRfNamedElement element = elementAndScope.getIRfNamedElement();
        if (element == null) {
            return null;
        }
        ElementPath signalElementPath = this.getSignalElementPathInEditor(elementAndScope, textEditor, offset);
        if (signalElementPath == null) {
            return null;
        }
        String elementInEditorName = element.getName();
        for (DVTVCDSignalWrapper signalWrapper : signalsWrappers) {
            WSignalElementPath signalPath = signalWrapper.getPath();
            ElementPath parentInstancePath = signalPath.getParentInstancePath();
            if (parentInstancePath == null) continue;
            String designPathString = parentInstancePath.toString("/").trim();
            String string = designPathString = !designPathString.isEmpty() && designPathString.startsWith("/") ? designPathString.substring(1) : designPathString;
            if (!designPathString.equals(signalElementPath.toString("/"))) continue;
            String signalName = signalPath.getNameWithDimension();
            int indexOf = signalName.indexOf(91);
            if (indexOf >= 0) {
                signalName = signalName.substring(0, indexOf);
            }
            if (!signalName.equals(elementInEditorName)) continue;
            return signalWrapper;
        }
        return null;
    }

    public String getTooltipForSignalValueInEditor(IDVTBreadcrumbHost textEditor, IRfNamedElementAndScope elementAndScope, String delim, int offset) {
        IProject project = textEditor.getProject();
        if (project == null) {
            return "";
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return "";
        }
        DVTVCDSignalWrapper signalWrapper = this.findSignalWrapperFromEditor(textEditor, elementAndScope, offset);
        if (signalWrapper == null) {
            return "";
        }
        DVTVCDParser parser = inputWaveEditor.getParser();
        parser.addSignalToModel(signalWrapper.getVarID());
        DVTVCDUtilsCommon.TimeScales vcdFileTimeUnit = parser.getVcdFileTimeUnit();
        String timeUnitName = vcdFileTimeUnit.getName();
        String signalValueAtTime = DVTVCDUtils.getSignalValueAtTime(signalWrapper, this.getCursorTime(inputWaveEditor));
        String convertedSignalValue = DVTVCDUtils.getConvertedSignalValue(signalValueAtTime, String.valueOf(signalWrapper.getBitWidth()), signalWrapper.getType(), "real".equals(signalWrapper.getType()) ? "10" : "16");
        String tooltipMessage = convertedSignalValue == null || convertedSignalValue.isEmpty() ? "0" : "Value: " + convertedSignalValue + " @ " + this.getCursorTime(inputWaveEditor) + timeUnitName;
        String vcdTitle = inputWaveEditor.getTitle();
        if (vcdTitle == null || vcdTitle.isEmpty()) {
            return tooltipMessage;
        }
        return String.valueOf(tooltipMessage) + " from " + inputWaveEditor.getTitle();
    }

    public String getInspectViewInputContent(IEditorPart textEditor, IRfNamedElementAndScope elementAndScope, int offset) {
        IProject project = DVTVCDUtils.getInstance().getLastSelectedProject();
        if (project == null) {
            return "";
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return "";
        }
        if (!(textEditor instanceof IDVTBreadcrumbHost)) {
            return "";
        }
        DVTVCDSignalWrapper signalWrapper = this.findSignalWrapperFromEditor((IDVTBreadcrumbHost)textEditor, elementAndScope, offset);
        if (signalWrapper == null) {
            return "";
        }
        return this.getInspectViewContent(inputWaveEditor, signalWrapper, null);
    }

    private String getInspectViewContent(WaveDiagramEditor inputWaveEditor, DVTVCDSignalWrapper signalWrapper, WStructMetadata structChildMedata) {
        String prevEdgeValue;
        DVTVCDParser parser = inputWaveEditor.getParser();
        parser.addSignalToModel(signalWrapper.getVarID());
        DVTVCDUtilsCommon.TimeScales vcdFileTimeUnit = parser.getVcdFileTimeUnit();
        String timeUnitName = vcdFileTimeUnit.getName();
        long primaryCursorTime = this.getCursorTime(inputWaveEditor);
        String signalValue = this.getSignalValue(signalWrapper, structChildMedata, primaryCursorTime);
        String convertedSignalValue = this.getConvertedSignalValue(signalValue, signalWrapper, structChildMedata, "16");
        String valueAtCursorTime = convertedSignalValue == null || convertedSignalValue.isEmpty() ? "N/A" : String.valueOf(convertedSignalValue) + " @ " + primaryCursorTime + timeUnitName;
        StringBuilder inspectViewContent = new StringBuilder("\n");
        inspectViewContent.append("// Waveform value: ").append(valueAtCursorTime).append("\n");
        for (Map.Entry base : DVTVCDUtils.BASES.entrySet()) {
            inspectViewContent.append("   ").append((String)base.getValue()).append(this.getConvertedSignalValue(signalValue, signalWrapper, structChildMedata, (String)base.getKey())).append("\n");
        }
        inspectViewContent.append("\n");
        String nextEdgeValue = this.computeEdgeContent(signalWrapper, structChildMedata, "Next Change", parser);
        if (nextEdgeValue != null) {
            inspectViewContent.append("Next Change Value: ").append(nextEdgeValue).append("\n");
        }
        if ((prevEdgeValue = this.computeEdgeContent(signalWrapper, structChildMedata, "Prev Change", parser)) != null) {
            inspectViewContent.append("Prev Change Value: ").append(prevEdgeValue).append("\n");
        }
        return inspectViewContent.toString();
    }

    private String getSignalValue(DVTVCDSignalWrapper signalWrapper, WStructMetadata structChildMetadata, long primaryCursorTime) {
        String signalValueAtTime = DVTVCDUtils.getSignalValueAtTime(signalWrapper, primaryCursorTime);
        if (structChildMetadata == null) {
            return signalValueAtTime;
        }
        return DVTVCDUtilsCommon.getStructChildValue(signalWrapper, signalValueAtTime, structChildMetadata);
    }

    private String getConvertedSignalValue(String signalValue, DVTVCDSignalWrapper signalWrapper, WStructMetadata structChildMedata, String newBase) {
        if ("real".equals(signalWrapper.getType())) {
            newBase = "10";
        }
        String bitWidth = structChildMedata == null ? signalWrapper.getBitWidth() : String.valueOf(structChildMedata.getBitWidth());
        return DVTVCDUtils.getConvertedSignalValue(signalValue, bitWidth, signalWrapper.getType(), newBase);
    }

    public InspectViewInput getInspectViewInput(IProject project, ElementPath scopePath, IRfBreadcrumbElement bcElement) {
        WaveDiagramEditor waveformEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(project);
        if (waveformEditor == null) {
            return null;
        }
        DVTVCDParser parser = waveformEditor.getParser();
        if (parser == null) {
            return null;
        }
        DVTVCDModel model = parser.getVcdModel();
        if (model == null) {
            return null;
        }
        if (scopePath == null || scopePath.isEmpty()) {
            return null;
        }
        IRfNamedElement element = null;
        if (bcElement instanceof HierarchicalElement) {
            element = ((HierarchicalElement)bcElement).getLastSegment();
        } else if (bcElement instanceof IRfNamedElement) {
            element = (IRfNamedElement)bcElement;
        }
        if (!(element instanceof IRfFieldElement)) {
            return null;
        }
        String projectLineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(project);
        StringBuilder inspectViewContent = new StringBuilder();
        if (bcElement instanceof HierarchicalElement) {
            inspectViewContent.append(((HierarchicalElement)bcElement).getFullName()).append(projectLineDelimiter).append(projectLineDelimiter);
        }
        String lastSegment = scopePath.lastSegment();
        while (this.isLogicGateSegment(lastSegment)) {
            if ((scopePath = ELUtils.upperPathOf(scopePath)) == null || scopePath.isEmpty()) {
                return null;
            }
            lastSegment = scopePath.lastSegment();
        }
        String signalFullName = null;
        signalFullName = bcElement instanceof HierarchicalElement ? ((HierarchicalElement)bcElement).getFullName() : element.getName();
        if (signalFullName == null || signalFullName.isEmpty()) {
            return null;
        }
        String signalHierarchicalAccess = null;
        int indexOfDot = signalFullName.indexOf(".");
        if (indexOfDot != -1) {
            signalHierarchicalAccess = signalFullName;
            signalFullName = signalFullName.substring(0, indexOfDot);
        }
        String prevLastSegment = null;
        DVTVCDSignalWrapper signalWrapper = null;
        while (scopePath != null && !scopePath.isEmpty()) {
            DVTWaveHierarchicalScopeInfo scopeInfo = model.getScopeInfo(scopePath);
            if (scopeInfo == null) {
                prevLastSegment = scopePath.lastSegment();
                scopePath = ELUtils.upperPathOf(scopePath);
                continue;
            }
            if (prevLastSegment != null) {
                signalWrapper = scopeInfo.getSignalWrapper(prevLastSegment);
                if (signalWrapper != null && prevLastSegment.equals(signalFullName)) break;
                if (signalWrapper != null) {
                    signalHierarchicalAccess = prevLastSegment + "." + (signalHierarchicalAccess != null ? signalHierarchicalAccess : signalFullName);
                    break;
                }
            }
            if ((signalWrapper = scopeInfo.getSignalWrapper(signalFullName)) != null) break;
            prevLastSegment = scopePath.lastSegment();
            scopePath = ELUtils.upperPathOf(scopePath);
        }
        if (signalWrapper == null) {
            return null;
        }
        String signalValueInspectViewContent = null;
        signalValueInspectViewContent = signalHierarchicalAccess != null ? this.getStructChildInspectViewContent(signalWrapper, signalHierarchicalAccess, waveformEditor) : this.getInspectViewContent(waveformEditor, signalWrapper, null);
        if (signalValueInspectViewContent == null || signalValueInspectViewContent.isEmpty()) {
            return null;
        }
        inspectViewContent.append(signalValueInspectViewContent.strip());
        return new InspectViewInput(inspectViewContent.toString(), projectLineDelimiter);
    }

    private boolean isLogicGateSegment(String segment) {
        if (segment.contains(TCStatement.TCStatementKind.SEQUENTIAL_ALWAYS_BLOCK.name())) {
            return true;
        }
        if (segment.contains(TCStatement.TCStatementKind.CONCURRENT_ALWAYS_BLOCK.name())) {
            return true;
        }
        if (segment.contains(TCStatement.TCStatementKind.ASSIGN.name())) {
            return true;
        }
        return segment.contains(TCStatement.TCStatementKind.ALIAS.name());
    }

    private String getStructChildInspectViewContent(DVTVCDSignalWrapper structWrapper, String signalHierarchicalAccess, WaveDiagramEditor waveformEditor) {
        WStructMetadata structChildMetadata = WaveformViewerSchematicDiagramUtils.getStructChildMetadata(structWrapper.getStructMetadata(), signalHierarchicalAccess);
        if (structChildMetadata == null) {
            return null;
        }
        return this.getInspectViewContent(waveformEditor, structWrapper, structChildMetadata);
    }

    public List<DMenuActionKind> getDiagramActions(Set<DSelectable> selection) {
        Iterator<DSelectable> selectionItr = selection.iterator();
        if (!selectionItr.hasNext()) {
            return Collections.emptyList();
        }
        if (selection.size() == 1) {
            INLViewSelectable selectable = KLayDrawUtils.getNLViewSelectable(selectionItr.next());
            if (selectable == null) {
                return Collections.emptyList();
            }
            if (selectable instanceof NLInstanceGate) {
                return WaveformViewerSchematicDiagramUtils.GATE_ACTIONS;
            }
            if (selectable instanceof NLPort) {
                return WaveformViewerSchematicDiagramUtils.PORT_ACTIONS;
            }
        }
        for (DSelectable selectionElem : selection) {
            INLViewSelectable selectableElem = KLayDrawUtils.getNLViewSelectable(selectionElem);
            if (selectableElem instanceof NLPort) continue;
            return Collections.emptyList();
        }
        return WaveformViewerSchematicDiagramUtils.PORTS_ACTIONS;
    }

    private WViewport getViewport(WaveDiagramEditor inputWaveEditor) {
        if (inputWaveEditor == null) {
            return null;
        }
        Canvas canvas = inputWaveEditor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return null;
        }
        return ((WCanvas)canvas).getViewport();
    }

    private String computeEdgeContent(DVTVCDSignalWrapper signalWrapper, WStructMetadata structChildMetadata, String type, DVTVCDParser parser) {
        if (signalWrapper == null || parser == null) {
            return null;
        }
        IProject project = parser.getProject();
        if (project == null) {
            return null;
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return null;
        }
        long cursorTime = this.getCursorTime(inputWaveEditor);
        TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes = signalWrapper.getClockInfoByStartTimes();
        Iterable<DVTVCDVarModificationByTime> varModificationByTime = signalWrapper.getVarModificationByTime();
        DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = signalWrapper.getVarModifsFromFST();
        if (varModifsFromFST != null) {
            varModifsFromFST.setStartTime((int)cursorTime);
            varModificationByTime = varModifsFromFST;
        }
        DVTVCDUtilsCommon.TimeScales vcdFileTimeUnit = parser.getVcdFileTimeUnit();
        String timeUnitName = vcdFileTimeUnit.getName();
        WViewport viewport = this.getViewport(inputWaveEditor);
        if (viewport == null) {
            return null;
        }
        if ("Next Change".equals(type)) {
            return this.findNextEdge(signalWrapper, structChildMetadata, cursorTime, clockInfoByStartTimes, parser, viewport, varModificationByTime, timeUnitName);
        }
        if ("Prev Change".equals(type)) {
            return this.findPrevEdge(signalWrapper, structChildMetadata, cursorTime, clockInfoByStartTimes, parser, viewport, varModificationByTime, timeUnitName);
        }
        return null;
    }

    private String findNextEdge(DVTVCDSignalWrapper signalWrapper, WStructMetadata structChildMetadata, long cursorTime, TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes, DVTVCDParser parser, WViewport viewport, Iterable<DVTVCDVarModificationByTime> varModificationByTime, String timeUnit) {
        long nextEdgeTime = DVTVCDUtils.getNextEdge(clockInfoByStartTimes, varModificationByTime, cursorTime, parser, viewport, signalWrapper, null);
        return this.computeEdgeInspectViewText(signalWrapper, structChildMetadata, this.getSignalValue(signalWrapper, structChildMetadata, nextEdgeTime), nextEdgeTime, timeUnit);
    }

    private String findPrevEdge(DVTVCDSignalWrapper signalWrapper, WStructMetadata structChildMetadata, long cursorTime, TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes, DVTVCDParser parser, WViewport viewport, Iterable<DVTVCDVarModificationByTime> varModificationByTime, String timeUnit) {
        long prevEdgeTime = DVTVCDUtils.getPrevEdge(clockInfoByStartTimes, varModificationByTime, cursorTime, parser, viewport, signalWrapper, null);
        return this.computeEdgeInspectViewText(signalWrapper, structChildMetadata, this.getSignalValue(signalWrapper, structChildMetadata, prevEdgeTime), prevEdgeTime, timeUnit);
    }

    private String computeEdgeInspectViewText(DVTVCDSignalWrapper signalWrapper, WStructMetadata structChildMetadata, String value, long time, String timeUnit) {
        if (time == -1L || value == null) {
            return "No change found";
        }
        String convertedSignalValue = this.getConvertedSignalValue(value, signalWrapper, structChildMetadata, "16");
        if (convertedSignalValue == null || convertedSignalValue.isEmpty()) {
            return "N/A";
        }
        return String.valueOf(convertedSignalValue) + " @ " + time + timeUnit;
    }

    public ElementPath getSignalElementPathInEditor(IRfNamedElementAndScope elementAndScope, IDVTBreadcrumbHost textEditor, int offset) {
        ElementPath signalElementPath;
        IRfNamedElement prevParent;
        IRfScopeElement initialScope = elementAndScope.getScope();
        Deque<? extends IRfNamedElementAndScope> elementAndScopeStack = elementAndScope.getElementAndScopeStack();
        IRfNamedElement element = elementAndScope.getIRfNamedElement();
        boolean shouldCorrectBreadcrumbPath = false;
        if (elementAndScopeStack != null && !elementAndScope.getElementAndScopeStack().isEmpty() && !initialScope.equals(prevParent = elementAndScopeStack.peek().getIRfNamedElement())) {
            shouldCorrectBreadcrumbPath = true;
        }
        if ((signalElementPath = DesignPathManager.getInstance().getPathFor((DVTEditor)textEditor, offset, element, initialScope, false, false)) == null) {
            return null;
        }
        if (shouldCorrectBreadcrumbPath && elementAndScopeStack != null) {
            for (IRfNamedElementAndScope iRfNamedElementAndScope : elementAndScopeStack) {
                IRfNamedElement iRfNamedElement = iRfNamedElementAndScope.getIRfNamedElement();
                signalElementPath = ElementPath.join(signalElementPath, iRfNamedElement.getName());
            }
        }
        return signalElementPath;
    }

    public void updateStatusBar(String Text2, boolean isError) {
        if (isError) {
            SmartCopyUtils.updateStatusBarWithError(Text2);
            return;
        }
        SmartCopyUtils.updateStatusBarWithInfo(Text2);
    }

    public boolean isVcdSetAsInput(WaveDiagramEditor inputWaveEditor) {
        if (inputWaveEditor == null) {
            return false;
        }
        return this.inputWaveEditorsMap.containsValue((Object)inputWaveEditor);
    }

    public boolean isVcdSetAsInput(IProject project) {
        if (project == null) {
            return false;
        }
        return this.inputWaveEditorsMap.containsKey(project);
    }

    public void addToWaveFromEditor(IDVTBreadcrumbHost textEditor, IRfNamedElementAndScope elementAndScope, int offset, AddToWaveMode mode) {
        IProject project = textEditor.getProject();
        if (project == null) {
            return;
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return;
        }
        List<DVTVCDSignalWrapper> signalsWrappers = DVTVCDUtils.getSignalsWrappers(inputWaveEditor);
        if (textEditor == null || signalsWrappers == null || signalsWrappers.isEmpty() || elementAndScope == null) {
            return;
        }
        IRfNamedElement element = elementAndScope.getIRfNamedElement();
        if (element == null) {
            DVTVCDUtils.getInstance().displayInfo("Waveform Viewer", "Please place the cursor on the signal/instance/design you want to add to the Waveform Viewer.");
            return;
        }
        ElementPath elementPath = this.getSignalElementPathInEditor(elementAndScope, textEditor, offset);
        if (elementPath == null) {
            DVTVCDUtils.getInstance().displayInfo("Waveform Viewer", "Please place the cursor on the signal/instance/design you want to add to the Waveform Viewer.");
            return;
        }
        ArrayList<String> signalsName = new ArrayList<String>();
        if (element instanceof IRfFieldElement && mode == AddToWaveMode.SELECTED_SIGNALS) {
            String elementInEditorName = element.getName();
            signalsName.add(elementInEditorName);
        } else if (element instanceof IRfInstanceElement || element instanceof IRfDesignElement) {
            if (mode == AddToWaveMode.PORTS) {
                signalsName.addAll(DVTVCDUtils.getPortsName(element));
            } else if (mode == AddToWaveMode.ALL_SIGNALS) {
                DVTWaveViewIDEFactory.getInstance().addAllSignalsInPathToWave(elementPath);
                return;
            }
        } else {
            DVTVCDUtils.getInstance().displayInfo("Waveform Viewer", "Please place the cursor on the signal/instance/design you want to add to the Waveform Viewer.");
            return;
        }
        this.addToWave(inputWaveEditor, elementPath, signalsName, signalsWrappers);
    }

    public void addToWave(WaveDiagramEditor inputWaveEditor, ElementPath moduleOrInterfacePath, List<String> portsName, List<DVTVCDSignalWrapper> signalWrappers) {
        if (moduleOrInterfacePath == null || portsName == null || portsName.isEmpty() || signalWrappers == null || signalWrappers.isEmpty()) {
            return;
        }
        Canvas canvas = inputWaveEditor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return;
        }
        Set<String> signalsToAdd = this.getVcdIds(moduleOrInterfacePath, portsName, signalWrappers);
        DVTVCDUtils.addSignalsAction(inputWaveEditor, "default", signalsToAdd);
    }

    public void addAllSignalsInPathToWave(ElementPath moduleOrInterfacePath) {
        if (moduleOrInterfacePath == null) {
            return;
        }
        IProject project = DVTVCDUtils.getInstance().getLastSelectedProject();
        if (project == null) {
            return;
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return;
        }
        Canvas canvas = inputWaveEditor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return;
        }
        Set<String> signalsToAdd = this.getAllSignalsForPath(moduleOrInterfacePath);
        DVTVCDUtils.addSignalsAction(inputWaveEditor, "default", signalsToAdd);
    }

    public void addToWave(Set<ElementPath> allSignalsToSendDifferentPaths, List<DVTVCDSignalWrapper> signalWrappers) {
        if (allSignalsToSendDifferentPaths == null || allSignalsToSendDifferentPaths.isEmpty()) {
            return;
        }
        IProject project = DVTVCDUtils.getInstance().getLastSelectedProject();
        if (project == null) {
            return;
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return;
        }
        Canvas canvas = inputWaveEditor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return;
        }
        Set<String> signalsToAdd = this.getVcdIds(allSignalsToSendDifferentPaths, signalWrappers);
        DVTVCDUtils.addSignalsAction(inputWaveEditor, "default", signalsToAdd);
    }

    private Set<String> getAllSignalsForPath(ElementPath moduleOrInterfacePath) {
        IProject project = DVTVCDUtils.getInstance().getLastSelectedProject();
        if (project == null) {
            return Collections.emptySet();
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return Collections.emptySet();
        }
        List<DVTVCDSignalWrapper> signalsWrappers = DVTVCDUtils.getSignalsWrappers(inputWaveEditor);
        String lookupSignalDesignPath = moduleOrInterfacePath.toString("/");
        LinkedHashSet<String> lookupSignalsVCDIds = new LinkedHashSet<String>();
        for (DVTVCDSignalWrapper signalWrapper : signalsWrappers) {
            ElementPath parentInstancePath;
            WSignalElementPath signalWrapperPath = signalWrapper.getPath();
            if (signalWrapperPath == null || (parentInstancePath = signalWrapperPath.getParentInstancePath()) == null || parentInstancePath.isEmpty()) continue;
            String signalWrapperDesignPathString = parentInstancePath.toString("/").trim();
            String string = signalWrapperDesignPathString = !signalWrapperDesignPathString.isEmpty() && signalWrapperDesignPathString.startsWith("/") ? signalWrapperDesignPathString.substring(1) : signalWrapperDesignPathString;
            if (!signalWrapperDesignPathString.equals(lookupSignalDesignPath)) continue;
            lookupSignalsVCDIds.add(signalWrapper.getVarID());
        }
        return lookupSignalsVCDIds;
    }

    private Set<String> getVcdIds(ElementPath moduleOrInterfacePath, List<String> lookupSignalNames, List<DVTVCDSignalWrapper> signalsWrappers) {
        String lookupSignalDesignPath = moduleOrInterfacePath.toString("/");
        LinkedHashSet<String> lookupSignalsVCDIds = new LinkedHashSet<String>();
        for (DVTVCDSignalWrapper signalWrapper : signalsWrappers) {
            ElementPath parentInstancePath;
            WSignalElementPath signalWrapperPath = signalWrapper.getPath();
            if (signalWrapperPath == null || (parentInstancePath = signalWrapperPath.getParentInstancePath()) == null || parentInstancePath.isEmpty()) continue;
            String signalWrapperDesignPathString = parentInstancePath.toString("/").trim();
            String string = signalWrapperDesignPathString = !signalWrapperDesignPathString.isEmpty() && signalWrapperDesignPathString.startsWith("/") ? signalWrapperDesignPathString.substring(1) : signalWrapperDesignPathString;
            if (!signalWrapperDesignPathString.equals(lookupSignalDesignPath)) continue;
            String signalNameInVCD = signalWrapperPath.getNameWithDimension();
            int bracketIndex = signalNameInVCD.indexOf(91);
            if (bracketIndex >= 0) {
                signalNameInVCD = signalNameInVCD.substring(0, bracketIndex);
            }
            for (String lookupSignalName : lookupSignalNames) {
                if (!signalNameInVCD.equals(lookupSignalName)) continue;
                lookupSignalsVCDIds.add(signalWrapper.getVarID());
            }
        }
        return lookupSignalsVCDIds;
    }

    private Set<String> getVcdIds(Set<ElementPath> allSignalsToSendDifferentPaths, List<DVTVCDSignalWrapper> signalsWrappers) {
        LinkedHashMap<ElementPath, String> orderedSignalsByPath = new LinkedHashMap<ElementPath, String>();
        for (ElementPath allSignalsToSendDifferentPath : allSignalsToSendDifferentPaths) {
            orderedSignalsByPath.put(allSignalsToSendDifferentPath, null);
        }
        for (DVTVCDSignalWrapper signalWrapper : signalsWrappers) {
            String currentSignalPathStripped;
            String signalNameInVCD;
            WSignalElementPath signalWrapperPath = signalWrapper.getPath();
            ElementPath parentInstancePath = signalWrapperPath.getParentInstancePath();
            if (parentInstancePath == null || (signalNameInVCD = signalWrapperPath.getNameWithDimension()) == null || signalNameInVCD.isEmpty()) continue;
            int bracketIndex = signalNameInVCD.indexOf(91);
            if (bracketIndex >= 0) {
                signalNameInVCD = signalNameInVCD.substring(0, bracketIndex);
            }
            currentSignalPathStripped = !(currentSignalPathStripped = parentInstancePath.toString("/").trim()).isEmpty() && currentSignalPathStripped.startsWith("/") ? currentSignalPathStripped.substring(1) : currentSignalPathStripped;
            for (ElementPath lookupSignalPath : allSignalsToSendDifferentPaths) {
                String lookupSignalName = lookupSignalPath.lastSegment();
                String lookupSignalPathPathStripped = ElementPath.upperPathOf(lookupSignalPath).toString("/").trim();
                String string = lookupSignalPathPathStripped = !lookupSignalPathPathStripped.isEmpty() && lookupSignalPathPathStripped.startsWith("/") ? lookupSignalPathPathStripped.substring(1) : lookupSignalPathPathStripped;
                if (!signalNameInVCD.equals(lookupSignalName) || !currentSignalPathStripped.equals(lookupSignalPathPathStripped)) continue;
                orderedSignalsByPath.put(lookupSignalPath, signalWrapper.getVarID());
            }
        }
        return new LinkedHashSet<String>(orderedSignalsByPath.values());
    }

    public void clearInput(WaveDiagramEditor inputWaveEditor) {
        IProject inputProject = null;
        for (Map.Entry<IProject, WaveDiagramEditor> entry : this.inputWaveEditorsMap.entrySet()) {
            if (!entry.getValue().equals((Object)inputWaveEditor)) continue;
            inputProject = entry.getKey();
        }
        if (inputProject == null) {
            return;
        }
        this.inputWaveEditorsMap.remove(inputProject);
        this.notifyCurrentWaveListeners(null);
        DVTVCDUtils.getInstance().updateLogViewerActionButton((WCanvas)inputWaveEditor.getCanvas());
    }

    public void addDriversLoadsToWaveFromEditor(IDVTBreadcrumbHost textEditor, IRfNamedElementAndScope elementAndScope, int offset, RWKind rwKind, IProject project) {
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return;
        }
        List<DVTVCDSignalWrapper> signalsWrappers = DVTVCDUtils.getSignalsWrappers(inputWaveEditor);
        if (textEditor == null || signalsWrappers == null || signalsWrappers.isEmpty() || elementAndScope == null) {
            return;
        }
        IRfNamedElement element = elementAndScope.getIRfNamedElement();
        if (element == null) {
            return;
        }
        ElementPath initialElementPath = this.getSignalElementPathInEditor(elementAndScope, textEditor, offset);
        if (initialElementPath == null) {
            return;
        }
        DVTWaveViewIDEFactory.getInstance().addToWaveDriverLoadsForSignals(initialElementPath, Collections.singletonList(element), project, rwKind);
    }

    public void addToWaveDriverLoadsForSignals(ElementPath selectedNamedElementInitialPath, List<IRfNamedElement> lookupSignalsNamedElements, final IProject project, final RWKind rwKind) {
        if (selectedNamedElementInitialPath == null || lookupSignalsNamedElements == null || lookupSignalsNamedElements.isEmpty() || project == null) {
            return;
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return;
        }
        LinkedHashSet<ElementPath> allSignalsReferencesElementPath = new LinkedHashSet<ElementPath>();
        TreeSet<ElementPath> signalConnectionsElementPath = new TreeSet<ElementPath>();
        final HashMap referencedElementsByScope = new HashMap();
        IReportHitsListener<SearchHit> rwKindHitListener = new IReportHitsListener<SearchHit>(){

            @Override
            public boolean shouldFilterIHidObject(IHidObject hidObject, IRfClassElement enclosingScope) {
                return IReportHitsListener.super.shouldFilterIHidObject(hidObject, enclosingScope);
            }

            @Override
            public void addMatch(SearchHit match) {
                if (match.getAccess() != rwKind) {
                    return;
                }
                if (match.getParserPath() == null) {
                    return;
                }
                Set<SearchHitConnectedElementInfo> connectedElements = match.getConnectedElements();
                if (connectedElements == null) {
                    return;
                }
                for (SearchHitConnectedElementInfo connectedElement : connectedElements) {
                    IRfNamedElement element = connectedElement.getElement();
                    int line = connectedElement.getLine();
                    int offset = connectedElement.getOffset();
                    ParserPath parserPath = connectedElement.getParserPath();
                    IRfDefElement realScope = RfSearchUtils.getScope(project, parserPath, line, offset);
                    referencedElementsByScope.put(element, realScope.getNamedElement());
                }
            }

            @Override
            public Set<SearchHit> getMatches() {
                return null;
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor();
        HashMap<IProject, Set<ParserPath>> hashMap = new HashMap<IProject, Set<ParserPath>>();
        FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles(hashMap), (IProgressMonitor)monitor);
        boolean hasDriversOrLoads = false;
        for (IRfNamedElement lookupSignalNamedElement : lookupSignalsNamedElements) {
            if (!RfSearchUtils.canBeReadOrWritten(lookupSignalNamedElement)) continue;
            String lookupSignalName = lookupSignalNamedElement.getName();
            RfSearchUtils.computeReferences(rwKindHitListener, project, lookupSignalNamedElement, null, lookupSignalName, (IProgressMonitor)monitor, hashMap, fileManager, false, false, false, false, false);
            allSignalsReferencesElementPath.add(ELUtils.appendToPath(selectedNamedElementInitialPath, lookupSignalName));
            for (Map.Entry referencedElementEntry : referencedElementsByScope.entrySet()) {
                IRfNamedElement refElement = (IRfNamedElement)referencedElementEntry.getKey();
                Map<IRfNamedElement, ElementPath> referencedElementPaths = DesignPathManagerUtils.getAllPathsWithPrefix(new HashSet<IRfNamedElement>(referencedElementsByScope.values()), selectedNamedElementInitialPath, project);
                for (ElementPath matchingPath : referencedElementPaths.values()) {
                    if (matchingPath == null) continue;
                    signalConnectionsElementPath.add(ELUtils.appendToPath(matchingPath, refElement.getName()));
                    hasDriversOrLoads = true;
                }
            }
            allSignalsReferencesElementPath.addAll(signalConnectionsElementPath);
            referencedElementsByScope.clear();
            signalConnectionsElementPath.clear();
        }
        if (allSignalsReferencesElementPath.isEmpty()) {
            DVTVCDUtils.getInstance().displayWarning("Waveform Viewer", "Could not find the selected signal in the VCD file.");
            return;
        }
        if (!hasDriversOrLoads && RWKind.READ.equals((Object)rwKind)) {
            DVTVCDUtils.getInstance().displayWarning("Waveform Viewer", "Could not find loads for the selected signal.");
            return;
        }
        if (!hasDriversOrLoads && RWKind.WRITE.equals((Object)rwKind)) {
            DVTVCDUtils.getInstance().displayWarning("Waveform Viewer", "Could not find drivers for the selected signal.");
            return;
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return;
        }
        List<DVTVCDSignalWrapper> signalsWrappers = DVTVCDUtils.getSignalsWrappers(inputWaveEditor);
        DVTWaveViewIDEFactory.getInstance().addToWave(allSignalsReferencesElementPath, signalsWrappers);
    }

    public void revealInDVTWaveViewInEditor(IDVTBreadcrumbHost textEditor, IRfNamedElementAndScope elementAndScope, int offset) {
        IProject project = textEditor.getProject();
        if (project == null) {
            return;
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return;
        }
        List<DVTVCDSignalWrapper> signalsWrappers = DVTVCDUtils.getSignalsWrappers(inputWaveEditor);
        if (textEditor == null || signalsWrappers == null || signalsWrappers.isEmpty() || elementAndScope == null) {
            return;
        }
        IRfNamedElement element = elementAndScope.getIRfNamedElement();
        if (element == null) {
            return;
        }
        ElementPath signalElementPath = this.getSignalElementPathInEditor(elementAndScope, textEditor, offset);
        if (signalElementPath == null) {
            return;
        }
        String signalPathString = ElementPath.join(signalElementPath, element.getName()).toString("/");
        this.revealInDVTWaveView(signalPathString);
    }

    public void revealInDVTWaveView(ElementPath dhSelectionElementPath, String signalsName) {
        if (signalsName == null) {
            return;
        }
        String signalPathString = ElementPath.join(dhSelectionElementPath, signalsName).toString("/");
        this.revealInDVTWaveView(signalPathString);
    }

    private void revealInDVTWaveView(String signalPathString) {
        IProject project = DVTVCDUtils.getInstance().getLastSelectedProject();
        if (project == null) {
            return;
        }
        WaveDiagramEditor inputWaveEditor = this.inputWaveEditorsMap.get(project);
        if (inputWaveEditor == null) {
            return;
        }
        WaveViewerSignalTableView signalsTable = inputWaveEditor.getSignalsTable();
        List<TreePath> allSignalsTableTreePaths = signalsTable.getAllSignalsTableTreePaths();
        if (allSignalsTableTreePaths == null || allSignalsTableTreePaths.isEmpty()) {
            return;
        }
        TreePath searchedTreePath = null;
        for (TreePath treePath : allSignalsTableTreePaths) {
            ElementPath signalTrimmedFullPath;
            Object element = treePath.getElement();
            if (!(element instanceof WSignalsTableSignal)) continue;
            WSignalElementPath signalFullPath = ((WSignalsTableSignal)element).getVcdPath();
            String signalName = signalFullPath.getNameWithDimension();
            ElementPath parentInstanceDesignPath = signalFullPath.getParentInstancePath();
            int bracketIndex = signalName.indexOf(91);
            if (bracketIndex >= 0) {
                signalName = signalName.substring(0, bracketIndex);
            }
            if (!signalPathString.equals((signalTrimmedFullPath = ElementPath.join(parentInstanceDesignPath, signalName)).toString("/"))) continue;
            searchedTreePath = treePath;
            break;
        }
        signalsTable.revealInDVTWaveView(searchedTreePath);
    }

    public void addCurrentWaveListener(ICurrentWaveListener cWaveStatusBarIndicator) {
        if (this.currentWaveListeners == null) {
            this.currentWaveListeners = new ArrayList<ICurrentWaveListener>();
        }
        this.currentWaveListeners.add(cWaveStatusBarIndicator);
    }

    public void removeCurrentWaveListener(ICurrentWaveListener cWaveStatusBarIndicator) {
        if (this.currentWaveListeners == null) {
            return;
        }
        this.currentWaveListeners.remove(cWaveStatusBarIndicator);
    }

    private void notifyCurrentWaveListeners(WaveDiagramEditor waveEditor) {
        if (this.currentWaveListeners == null) {
            return;
        }
        for (ICurrentWaveListener iCurrentWaveListener : this.currentWaveListeners) {
            iCurrentWaveListener.notifyCurrentWaveChanged(waveEditor);
        }
    }

    public DVTWaveHierarchicalScopeInfo getWaveformViewerScopeInfo(ElementPath elementPath, WaveDiagramEditor waveformViewerEditor) {
        if (waveformViewerEditor == null) {
            return null;
        }
        DVTVCDParser parser = waveformViewerEditor.getParser();
        if (parser == null) {
            return null;
        }
        DVTVCDModel vcdModel = parser.getVcdModel();
        if (vcdModel == null) {
            return null;
        }
        return vcdModel.getScopeInfo(elementPath);
    }

    public String getWaveformInfoBarString(IProject project) {
        if (project == null || !project.exists()) {
            return "Set a Waveform Viewer and place the Primary Cursor to see the signals value.";
        }
        WaveDiagramEditor waveformEditor = this.getInputWaveEditor(project);
        if (waveformEditor == null) {
            return "Set a Waveform Viewer and place the Primary Cursor to see the signals value.";
        }
        Canvas canvas = waveformEditor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return "Set a Waveform Viewer and place the Primary Cursor to see the signals value.";
        }
        WViewport viewport = ((WCanvas)canvas).getViewport();
        if (viewport == null) {
            return "Set a Waveform Viewer and place the Primary Cursor to see the signals value.";
        }
        WCursor primaryCursor = viewport.getPrimaryCursor();
        if (primaryCursor == null) {
            return "Set a Waveform Viewer and place the Primary Cursor to see the signals value.";
        }
        long cursorTime = primaryCursor.getTime();
        if (cursorTime == -100L || cursorTime < 0L) {
            return "Set a Waveform Viewer and place the Primary Cursor to see the signals value.";
        }
        DVTVCDParser parser = waveformEditor.getParser();
        if (parser == null) {
            return "Set a Waveform Viewer and place the Primary Cursor to see the signals value.";
        }
        DVTVCDUtilsCommon.TimeScales timescale = viewport.getTimescale();
        String timescaleName = timescale.getName();
        String sourceFileName = DVTVCDUtils.getSourceFileName(viewport);
        return MessageFormat.format("Signals value @ {0}{1} from {2}", cursorTime, timescaleName, sourceFileName);
    }

    public void addSchematicDiagramWaveformInfo(NLInstanceGate topGate) {
        IRfSingleLangProject rfProject = topGate.getRfProject();
        if (rfProject == null) {
            return;
        }
        IProject project = rfProject.getProject();
        if (project == null || !project.exists()) {
            return;
        }
        WaveDiagramEditor waveformViewerEditor = this.getInputWaveEditor(project);
        if (waveformViewerEditor == null) {
            return;
        }
        this.collectNLPortsToLoad(topGate, waveformViewerEditor);
        waveformViewerEditor.loadSchematicDiagramPorts();
    }

    private void collectNLPortsToLoad(NLGate gate, WaveDiagramEditor waveformViewerEditor) {
        this.collectNLPortsToLoadFromGate(gate, waveformViewerEditor);
        if (!(gate instanceof NLInstanceGate)) {
            return;
        }
        Collection<? extends NLGate> subGates = ((NLInstanceGate)gate).getSubGates();
        if (subGates == null || subGates.isEmpty()) {
            return;
        }
        for (NLGate nLGate : subGates) {
            this.collectNLPortsToLoad(nLGate, waveformViewerEditor);
        }
    }

    private void collectNLPortsToLoadFromGate(NLGate gate, WaveDiagramEditor waveformViewerEditor) {
        Collection<NLPort> ports = gate.getPorts();
        if (ports == null || ports.isEmpty()) {
            return;
        }
        LinkedHashSet<DVTWaveHierarchicalScopeInfo> potentialScopeInfos = this.getGateScopeInfo(gate, waveformViewerEditor);
        if (potentialScopeInfos == null || potentialScopeInfos.isEmpty()) {
            return;
        }
        for (NLPort port : ports) {
            String portName = this.getNLPortToLoadName(port);
            if (portName == null || portName.isEmpty()) continue;
            DVTVCDSignalWrapper signalWrapper = null;
            for (DVTWaveHierarchicalScopeInfo scopeInfo : potentialScopeInfos) {
                signalWrapper = scopeInfo.getSignalWrapper(portName);
                if (signalWrapper != null) break;
            }
            waveformViewerEditor.addSchematicDiagramPortToLoad(port, signalWrapper);
        }
    }

    private LinkedHashSet<DVTWaveHierarchicalScopeInfo> getGateScopeInfo(NLGate gate, WaveDiagramEditor waveformViewerEditor) {
        if (gate == null) {
            return SCOPE_INFO_EMPTY_LINKED_HASH_SET;
        }
        if (gate instanceof NLLogicGate) {
            return this.getNLLogicGateScopeInfo((NLLogicGate)gate, waveformViewerEditor);
        }
        if (gate instanceof NLBundleGate) {
            return this.getNLBundleGateScopeInfo((NLBundleGate)gate, waveformViewerEditor);
        }
        if (gate instanceof NLInstanceGate) {
            return this.getNLInstanceGateScopeInfo((NLInstanceGate)gate, waveformViewerEditor);
        }
        return SCOPE_INFO_EMPTY_LINKED_HASH_SET;
    }

    private LinkedHashSet<DVTWaveHierarchicalScopeInfo> getNLLogicGateScopeInfo(NLLogicGate logicGate, WaveDiagramEditor waveformViewerEditor) {
        if (logicGate == null) {
            return SCOPE_INFO_EMPTY_LINKED_HASH_SET;
        }
        LinkedHashSet<DVTWaveHierarchicalScopeInfo> enclosingGatesScopeInfo = new LinkedHashSet<DVTWaveHierarchicalScopeInfo>();
        NLInstanceGate enclosingGate = logicGate.getEnclosingGate();
        while (enclosingGate != null) {
            if (!(enclosingGate instanceof NLLogicGate)) {
                enclosingGatesScopeInfo.addAll(this.getGateScopeInfo(enclosingGate, waveformViewerEditor));
            }
            enclosingGate = enclosingGate.getEnclosingGate();
        }
        return enclosingGatesScopeInfo;
    }

    private LinkedHashSet<DVTWaveHierarchicalScopeInfo> getNLBundleGateScopeInfo(NLBundleGate bundleGate, WaveDiagramEditor waveformViewerEditor) {
        if (bundleGate == null) {
            return SCOPE_INFO_EMPTY_LINKED_HASH_SET;
        }
        return this.getGateScopeInfo(bundleGate.getEnclosingGate(), waveformViewerEditor);
    }

    private LinkedHashSet<DVTWaveHierarchicalScopeInfo> getNLInstanceGateScopeInfo(NLInstanceGate instanceGate, WaveDiagramEditor waveformViewerEditor) {
        if (instanceGate == null) {
            return SCOPE_INFO_EMPTY_LINKED_HASH_SET;
        }
        Object mapping = instanceGate.getMapping();
        if (!(mapping instanceof DiagramInstanceWrapper)) {
            return SCOPE_INFO_EMPTY_LINKED_HASH_SET;
        }
        ElementPath gatePath = ((DiagramInstanceWrapper)mapping).getHierarchyPath();
        if (gatePath == null || gatePath.isEmpty()) {
            return SCOPE_INFO_EMPTY_LINKED_HASH_SET;
        }
        DVTWaveHierarchicalScopeInfo scopeInfo = this.getWaveformViewerScopeInfo(gatePath, waveformViewerEditor);
        if (scopeInfo == null) {
            return SCOPE_INFO_EMPTY_LINKED_HASH_SET;
        }
        LinkedHashSet<DVTWaveHierarchicalScopeInfo> result = new LinkedHashSet<DVTWaveHierarchicalScopeInfo>();
        result.add(scopeInfo);
        return result;
    }

    private String getNLPortToLoadName(NLPort port) {
        int indexOfDot;
        if (port == null) {
            return null;
        }
        Collection<GoToInfo> goToSource = port.getGoToSource();
        if (goToSource == null) {
            return null;
        }
        boolean isNullGoToSource = true;
        for (GoToInfo goToInfo : goToSource) {
            if (goToInfo == null) continue;
            isNullGoToSource = false;
            break;
        }
        if (isNullGoToSource) {
            return null;
        }
        NLGate enclosingGate = port.getEnclosingGate();
        if (enclosingGate instanceof NLBundleGate) {
            return enclosingGate.getName();
        }
        String portName = port.getName();
        if (portName == null || portName.isEmpty()) {
            return null;
        }
        int indexOfSelfLoopPortSuffix = portName.indexOf("__dvt__internal__self__loop_ port");
        if (indexOfSelfLoopPortSuffix != -1) {
            portName = portName.substring(0, indexOfSelfLoopPortSuffix);
        }
        if ((indexOfDot = portName.indexOf(".")) > 0) {
            portName = portName.substring(0, indexOfDot);
        }
        return portName;
    }

    public String getNLPortNameWithHierarchicalAccess(NLPort port) {
        NLGate enclosingGate;
        if (port == null) {
            return null;
        }
        String name = NLBusUtils.getCleanPortName(port);
        if (name == null || name.isEmpty()) {
            return null;
        }
        int indexOfSelfLoopPortSuffix = name.indexOf("__dvt__internal__self__loop_ port");
        if (indexOfSelfLoopPortSuffix != -1) {
            name = name.substring(0, indexOfSelfLoopPortSuffix);
        }
        if (!((enclosingGate = port.getEnclosingGate()) instanceof NLBundleGate)) {
            return name;
        }
        String bundleGateName = enclosingGate.getName();
        if (bundleGateName == null || bundleGateName.isEmpty() || bundleGateName.equals(name)) {
            return name;
        }
        return String.valueOf(bundleGateName) + "." + name;
    }
}

