/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import com.google.common.collect.EvictingQueue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDNetArrayWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarClockInfo;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTVarModifQueue;
import ro.amiq.dvt.ui.waveviewer.DVTWaveHierarchicalScopeInfo;
import ro.amiq.dvt.ui.waveviewer.TimeChangeWrapper;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;
import ro.amiq.dvt.ui.waveviewer.WaveViewerGenerationError;

public class FSTReader
extends DVTVCDParser {
    private String dstFilePath;
    private long startTime;
    private long endTime;
    private List<String> signalNames;
    private List<Integer> signalWidths;
    private FileChannel channel;
    private ByteBuffer mappedBuffer;
    private int headerEnd;
    private DVTVCDModel model;
    private boolean cleaned;
    private boolean needsRefresh;
    private boolean incompleteHierarchy;
    private Map<DVTVCDUtilsCommon.DSTMetadataItem, Object> metadataItems;
    private String dateTimeString = "";
    Map<Integer, DVTVarModifQueue<DVTVCDVarModificationByTime>> visibleUniqueSignals = new HashMap<Integer, DVTVarModifQueue<DVTVCDVarModificationByTime>>();
    Set<String> visibleSignals = new HashSet<String>();
    long mappedBufferPosition = -1L;

    public FSTReader(IProject project, String dstFilePath, String vcdFilePath, String configFilePath, DVTVCDModel model) {
        super(project, vcdFilePath, configFilePath, model);
        this.dstFilePath = dstFilePath;
        this.signalNames = new ArrayList<String>();
        this.signalWidths = new ArrayList<Integer>();
        this.model = model;
    }

    @Override
    public void addSignalToModel(String signalId) {
        this.addVisibleSignal(signalId);
        this.addVarModifsToModel();
    }

    @Override
    public void addSignalsToModel(Set<String> signalIds) {
        for (String signalId : signalIds) {
            this.addVisibleSignal(signalId);
        }
        this.addVarModifsToModel();
    }

    private void addVisibleSignal(String signalId) {
        if (this.visibleSignals.contains(signalId)) {
            return;
        }
        this.visibleSignals.add(signalId);
        DVTVCDSignalWrapper signalWrapper = this.model.getSignalsByModelId().get(signalId);
        if (signalWrapper instanceof DVTVCDNetArrayWrapper) {
            this.visibleSignals.addAll(((DVTVCDNetArrayWrapper)signalWrapper).getAllVarIds());
        }
    }

    @Override
    public void deepClean() {
        if (this.cleaned) {
            return;
        }
        this.visibleUniqueSignals.clear();
        this.visibleUniqueSignals = null;
        this.visibleSignals.clear();
        this.visibleSignals = null;
        this.signalNames.clear();
        this.signalNames = null;
        this.signalWidths.clear();
        this.signalWidths = null;
        this.model.deepClean();
        this.model = null;
        if (this.generationErrors != null) {
            this.generationErrors.clear();
        }
        this.generationErrors = null;
        this.cleaned = true;
    }

    public String getDstFilePath() {
        return this.dstFilePath;
    }

    public boolean needsRefresh() {
        return this.needsRefresh;
    }

    public void setRefresh(boolean needsRefresh) {
        this.needsRefresh = needsRefresh;
    }

    @Override
    public void parseInitial() {
        try {
            this.channel = FileChannel.open(Paths.get(this.dstFilePath, new String[0]), StandardOpenOption.READ);
            long fileSize = this.channel.size();
            MappedByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
            byte[] magic = new byte[4];
            buffer.get(magic);
            if (!new String(magic).equals("DST\u0000")) {
                this.channel.close();
                throw new IOException("Not a valid DST file");
            }
            buffer.get();
            buffer.get();
            byte timeunit = buffer.get();
            buffer.getInt();
            int positionAfterDateTimeString = buffer.position() + 100;
            this.dateTimeString = DVTVCDUtils.readString(buffer);
            ((ByteBuffer)buffer).position(positionAfterDateTimeString);
            this.vcdFileTimescale = DVTVCDUtilsCommon.TimeScales.getTimeUnit(this.getTimeScale(timeunit));
            this.metadataItems = DVTVCDUtils.readDSTMetadataItems(buffer);
            boolean bl = this.incompleteHierarchy = (Byte)this.metadataItems.getOrDefault((Object)DVTVCDUtilsCommon.DSTMetadataItem.IncompleteHierarchy, (byte)0) == 1;
            if (this.incompleteHierarchy) {
                this.generationErrors.add(WaveViewerGenerationError.VCD_INCOMPLETE_HIERARCHY);
                return;
            }
            try {
                byte token;
                this.startTime = buffer.getLong();
                this.diagramUpperTimeLimit = buffer.getLong();
                this.endTime = buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                ElementPath designHierarchyPath = ElementPath.EMPTY_PATH;
                String scopeType = "";
                String scopeName = "";
                do {
                    token = buffer.get();
                    switch (token) {
                        case -2: {
                            scopeType = DVTVCDUtils.readString(buffer);
                            scopeName = DVTVCDUtils.readString(buffer);
                            designHierarchyPath = ELUtils.appendToPath(designHierarchyPath, scopeName);
                            ElementPath existingScopePath = this.model.getExistingScopePath(designHierarchyPath);
                            if (existingScopePath != null) {
                                designHierarchyPath = existingScopePath;
                                break;
                            }
                            this.model.addScopeInfo(designHierarchyPath, scopeType);
                            break;
                        }
                        case -1: {
                            designHierarchyPath = ELUtils.upperPathOf(designHierarchyPath);
                            break;
                        }
                        case -4: {
                            byte type = buffer.get();
                            DVTVCDUtils.readString(buffer);
                            int index = DVTVCDUtils.readVarint(buffer);
                            int width = DVTVCDUtils.readVarint(buffer);
                            String name = DVTVCDUtils.readString(buffer);
                            String dimension = DVTVCDUtils.readString(buffer);
                            int alias = DVTVCDUtils.readSvarint(buffer);
                            WSignalElementPath path = new WSignalElementPath(name, dimension, designHierarchyPath);
                            this.signalNames.add(name);
                            this.signalWidths.add(width);
                            String signalModelId = Integer.toString(index);
                            DVTVCDSignalWrapper signalWrapper = new DVTVCDSignalWrapper(signalModelId, this.model.getNofVariables() + 1, DVTVCDUtils.mapFSTtoVCDType(type), Integer.toString(width), path);
                            WStructMetadata structMetadata = this.getStructMetadata(path, name, dimension);
                            if (structMetadata != null) {
                                signalWrapper.setStructMetadata(structMetadata);
                            }
                            boolean isReversedDimensionedArray = DVTVCDUtils.isBigEndian(dimension);
                            signalWrapper.setBigEndian(isReversedDimensionedArray);
                            LinkedHashMap<String, DVTVCDSignalWrapper> signalsByModelId = this.model.getSignalsByModelId();
                            if (alias != -1) {
                                String aliasModelId = Integer.toString(alias);
                                signalWrapper.setAlias(signalsByModelId.get(aliasModelId));
                            }
                            DVTWaveHierarchicalScopeInfo scopeInfo = this.model.getScopeInfo(designHierarchyPath);
                            if (!dimension.isEmpty() && !dimension.contains(":")) {
                                String netArrayModelId = String.valueOf(designHierarchyPath.toString()) + "." + name;
                                DVTVCDSignalWrapper netArrayWrapper = signalsByModelId.get(netArrayModelId);
                                if (netArrayWrapper == null) {
                                    netArrayWrapper = new DVTVCDNetArrayWrapper(netArrayModelId, this.model.getNofVariables() + 1, scopeType, "0", path);
                                    this.model.addVarWrapperToModel(netArrayModelId, netArrayWrapper);
                                    scopeInfo.addSignalWrapper(name, netArrayWrapper);
                                }
                                netArrayWrapper.setStructMetadata(structMetadata);
                                netArrayWrapper.setBigEndian(isReversedDimensionedArray);
                                ((DVTVCDNetArrayWrapper)netArrayWrapper).addChildSignal(signalWrapper, DVTVCDUtils.getIndex(dimension));
                                signalWrapper.setChildOfNetArray(true);
                            }
                            this.model.addVarWrapperToModel(signalModelId, signalWrapper);
                            scopeInfo.addSignalWrapper(String.valueOf(name) + dimension, signalWrapper);
                            buffer.get();
                            break;
                        }
                    }
                } while (token != -5);
                this.model.computeOrderedScopeInfos();
                this.mappedBuffer = buffer;
                this.headerEnd = buffer.position();
            }
            catch (Exception e) {
                if (e instanceof AccessDeniedException) {
                    this.generationErrors.add(WaveViewerGenerationError.DST_FILE_MISSING_READ_PERMISSION);
                } else if (e instanceof NoSuchFileException) {
                    this.generationErrors.add(WaveViewerGenerationError.DST_FILE_NOT_FOUND);
                } else {
                    this.generationErrors.add(WaveViewerGenerationError.CORRUPTED_DST_FILE);
                }
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            if (this.model.getNofVariables() == 0 && this.generationErrors.isEmpty()) {
                this.generationErrors.add(WaveViewerGenerationError.NO_SIGNALS_FOUND_IN_DST_FILE);
            }
        }
    }

    @Override
    public long getFirstTimeFromVcd() {
        return this.startTime;
    }

    @Override
    public long getLastTimeFromVcd() {
        return this.endTime;
    }

    public void loadWaveDataSingleBit(int position, byte[] wavesData, List<Long> timePoints, DVTVarModifQueue<DVTVCDVarModificationByTime> results, DVTVCDSignalWrapper varWraper) throws IOException {
        ByteArrayInputStream waveStream = new ByteArrayInputStream(wavesData);
        long skipBytes = (long)position - 1L;
        if (waveStream.skip(skipBytes) < 0L) {
            return;
        }
        int waveLength = DVTVCDUtils.readVarint(waveStream);
        byte[] waveData = new byte[waveLength];
        if (waveStream.read(waveData) < 0) {
            return;
        }
        ByteBuffer changeStream = ByteBuffer.wrap(waveData);
        String lastValue = null;
        long lastInterval = -1L;
        long lastTime = 0L;
        LinkedList<DVTVCDVarModificationByTime> currentPatternPoints = new LinkedList<DVTVCDVarModificationByTime>();
        while (changeStream.hasRemaining()) {
            int timeIndex = DVTVCDUtils.readVarint(changeStream) - 1;
            String value = DVTVCDUtils.readString(changeStream);
            boolean patternBroken = false;
            long currentTime = timePoints.get(timeIndex);
            long currentInterval = currentTime - lastTime;
            DVTVCDVarModificationByTime varModif = new DVTVCDVarModificationByTime(new TimeChangeWrapper(currentTime, 0L), value);
            if (!value.equals("1") && !value.equals("0")) {
                lastValue = null;
                patternBroken = true;
            }
            if (currentInterval != lastInterval || value.equals(lastValue)) {
                patternBroken = true;
            }
            if (patternBroken) {
                if (currentPatternPoints.size() > 5) {
                    DVTVCDVarModificationByTime firstEntry = (DVTVCDVarModificationByTime)currentPatternPoints.getFirst();
                    DVTVCDVarModificationByTime lastEntry = (DVTVCDVarModificationByTime)currentPatternPoints.getLast();
                    if (firstEntry.getTime() == lastEntry.getTime()) {
                        results.getLastValue().setValue(lastEntry.getValue());
                    } else {
                        long realStartTime = firstEntry.getTime() - lastInterval;
                        int realStartValue = 1 - Integer.parseInt(firstEntry.getValue());
                        DVTVCDVarClockInfo clockInfo = new DVTVCDVarClockInfo(lastInterval, realStartTime, realStartValue);
                        clockInfo.setEndTime(lastEntry.getTime());
                        varWraper.addClock(clockInfo);
                        results.pollLast();
                    }
                } else {
                    for (DVTVCDVarModificationByTime entry : currentPatternPoints) {
                        results.addLast(entry);
                    }
                }
                currentPatternPoints.clear();
                if (!value.equals("1") && !value.equals("0")) {
                    results.addLast(varModif);
                } else {
                    currentPatternPoints.addLast(varModif);
                }
            } else {
                currentPatternPoints.addLast(varModif);
                lastValue = value;
            }
            lastInterval = currentInterval;
            lastTime = currentTime;
        }
        if (currentPatternPoints.size() > 5) {
            DVTVCDVarModificationByTime firstEntry = (DVTVCDVarModificationByTime)currentPatternPoints.getFirst();
            DVTVCDVarModificationByTime lastEntry = (DVTVCDVarModificationByTime)currentPatternPoints.getLast();
            if (firstEntry.getTime() == lastEntry.getTime()) {
                results.getLastValue().setValue(lastEntry.getValue());
            } else {
                long realStartTime = firstEntry.getTime() - lastInterval;
                int realStartValue = 1 - Integer.parseInt(firstEntry.getValue());
                DVTVCDVarClockInfo clockInfo = new DVTVCDVarClockInfo(lastInterval, realStartTime, realStartValue);
                clockInfo.setEndTime(lastEntry.getTime());
                varWraper.addClock(clockInfo);
                results.pollLast();
            }
        } else {
            for (DVTVCDVarModificationByTime entry : currentPatternPoints) {
                results.addLast(entry);
            }
        }
    }

    private void loadWaveData(int position, byte[] wavesData, List<Long> timePoints, DVTVarModifQueue<DVTVCDVarModificationByTime> results) throws IOException {
        ByteArrayInputStream waveStream = new ByteArrayInputStream(wavesData);
        long skipBytes = (long)position - 1L;
        if (waveStream.skip(skipBytes) < 0L) {
            return;
        }
        int waveLength = DVTVCDUtils.readVarint(waveStream);
        byte[] waveData = new byte[waveLength];
        if (waveStream.read(waveData) < 0) {
            return;
        }
        ByteBuffer changeStream = ByteBuffer.wrap(waveData);
        while (changeStream.hasRemaining()) {
            int timeIndex = DVTVCDUtils.readVarint(changeStream) - 1;
            String value = DVTVCDUtils.readString(changeStream);
            results.addLast(new DVTVCDVarModificationByTime(new TimeChangeWrapper(timePoints.get(timeIndex), 0L), value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, DVTVarModifQueue<DVTVCDVarModificationByTime>> readSignals(Set<Integer> signalIndicesToRead, Map<Integer, DVTVarModifQueue<DVTVCDVarModificationByTime>> results) throws IOException {
        Object mutex;
        Object object = mutex = DVTVCDUtils.DST_FILE_LOCKS.computeIfAbsent(this.dstFilePath, k -> new Object());
        synchronized (object) {
            this.mappedBuffer.position(this.headerEnd);
            boolean isFirstBlock = true;
            int highestSignalId = -1;
            for (Integer signal : signalIndicesToRead) {
                if (signal <= highestSignalId) continue;
                highestSignalId = signal;
            }
            while (this.mappedBuffer.hasRemaining()) {
                byte blockType = this.mappedBuffer.get();
                if (blockType == 3) {
                    this.mappedBuffer.getInt();
                    this.mappedBuffer.getLong();
                    long compressedLength = this.mappedBuffer.getLong();
                    int newPosition = this.mappedBuffer.position() + (int)compressedLength;
                    this.mappedBuffer.position(newPosition);
                    continue;
                }
                if (blockType != 1) continue;
                this.mappedBuffer.getLong();
                long blockStartTime = this.mappedBuffer.getLong();
                this.mappedBuffer.getLong();
                this.mappedBuffer.getLong();
                int bitsUncompressedLength = DVTVCDUtils.readVarint(this.mappedBuffer);
                int bitsCompressedLength = DVTVCDUtils.readVarint(this.mappedBuffer);
                int bitsCount = DVTVCDUtils.readVarint(this.mappedBuffer);
                byte[] initialValuesBytes = new byte[bitsCompressedLength];
                this.mappedBuffer.get(initialValuesBytes);
                String[] initialValues = null;
                if (bitsCompressedLength != bitsUncompressedLength) {
                    initialValuesBytes = DVTVCDUtils.decompress(initialValuesBytes, bitsUncompressedLength);
                }
                initialValues = DVTVCDUtils.readInitialValues(bitsCount, initialValuesBytes);
                if (isFirstBlock) {
                    int i = 0;
                    while (i < initialValues.length) {
                        if (signalIndicesToRead.contains(i)) {
                            results.get(i).addLast(new DVTVCDVarModificationByTime(new TimeChangeWrapper(blockStartTime, 0L), initialValues[i]));
                        }
                        ++i;
                    }
                    isFirstBlock = false;
                }
                byte[] wavesData = DVTVCDUtils.extractWaveData(this.mappedBuffer);
                long positionDataLength = this.mappedBuffer.getLong();
                byte[] positionData = new byte[(int)positionDataLength];
                this.mappedBuffer.get(positionData);
                List<Long> timePoints = this.extractTimeData(blockStartTime);
                this.extractVarModifs(signalIndicesToRead, highestSignalId, results, wavesData, timePoints, positionData);
            }
            return results;
        }
    }

    private void extractVarModifs(Set<Integer> signalIndicesToRead, int highestSignalId, Map<Integer, DVTVarModifQueue<DVTVCDVarModificationByTime>> results, byte[] wavesData, List<Long> timePoints, byte[] positionData) throws IOException {
        ByteArrayInputStream posStream = new ByteArrayInputStream(positionData);
        HashMap<Integer, Integer> indexToPosition = new HashMap<Integer, Integer>();
        int currentPositionInWaveData = 0;
        int lastNegativeValue = 0;
        int currentSignalIndex = -1;
        while (posStream.available() > 0) {
            int indexOfReference;
            ++currentSignalIndex;
            int position = DVTVCDUtils.readSvarint(posStream);
            if ((position & 1) == 0) {
                int runLength = position >> 1;
                if (highestSignalId >= (currentSignalIndex += runLength - 1)) continue;
                break;
            }
            if (position < 0) {
                indexOfReference = -(position >> 1) - 1;
                if (signalIndicesToRead.contains(currentSignalIndex)) {
                    position = (Integer)indexToPosition.get(indexOfReference);
                    if (this.signalWidths.get(currentSignalIndex) > 1) {
                        this.loadWaveData(position, wavesData, timePoints, results.get(currentSignalIndex));
                    } else {
                        this.loadWaveDataSingleBit(position, wavesData, timePoints, results.get(currentSignalIndex), this.model.getSignalsByModelId().get(Integer.toString(currentSignalIndex)));
                    }
                }
                lastNegativeValue = indexOfReference;
                continue;
            }
            if (position == 1) {
                indexOfReference = lastNegativeValue;
                if (!signalIndicesToRead.contains(currentSignalIndex)) continue;
                position = (Integer)indexToPosition.get(indexOfReference);
                if (this.signalWidths.get(currentSignalIndex) > 1) {
                    this.loadWaveData(position, wavesData, timePoints, results.get(currentSignalIndex));
                    continue;
                }
                this.loadWaveDataSingleBit(position, wavesData, timePoints, results.get(currentSignalIndex), this.model.getSignalsByModelId().get(Integer.toString(currentSignalIndex)));
                continue;
            }
            indexToPosition.put(currentSignalIndex, currentPositionInWaveData += position >> 1);
            if (!signalIndicesToRead.contains(currentSignalIndex)) continue;
            if (this.signalWidths.get(currentSignalIndex) > 1) {
                this.loadWaveData(currentPositionInWaveData, wavesData, timePoints, results.get(currentSignalIndex));
                continue;
            }
            this.loadWaveDataSingleBit(currentPositionInWaveData, wavesData, timePoints, results.get(currentSignalIndex), this.model.getSignalsByModelId().get(Integer.toString(currentSignalIndex)));
        }
    }

    @Override
    protected void clearLowerUnusedTimeChanges(Set<String> variablesToUpdate, Map.Entry<String, DVTVCDSignalWrapper> variable, ConcurrentLinkedDeque<DVTVCDVarModificationByTime> varModificationByTime) {
    }

    private List<Long> extractTimeData(long blockStartTime) throws IOException {
        long timeUncompressedLength = this.mappedBuffer.getLong();
        long timeCompressedLength = this.mappedBuffer.getLong();
        long timeCount = this.mappedBuffer.getLong();
        byte[] compressedTime = new byte[(int)timeCompressedLength];
        this.mappedBuffer.get(compressedTime);
        byte[] timeData = timeCompressedLength != timeUncompressedLength ? DVTVCDUtils.decompress(compressedTime, (int)timeUncompressedLength) : compressedTime;
        ArrayList<Long> timePoints = new ArrayList<Long>();
        ByteArrayInputStream timeStream = new ByteArrayInputStream(timeData);
        long currentTime = blockStartTime;
        int i = 0;
        while ((long)i < timeCount) {
            long timeDelta = DVTVCDUtils.readVarint(timeStream);
            timePoints.add(currentTime += timeDelta);
            ++i;
        }
        return timePoints;
    }

    public List<String> getSignalNames() {
        return this.signalNames;
    }

    public String getTimeScale(byte timeunit) {
        switch (timeunit) {
            case 0: {
                return "s";
            }
            case 3: {
                return "ms";
            }
            case 6: {
                return "us";
            }
            case 9: {
                return "ns";
            }
            case 12: {
                return "ps";
            }
            case 15: {
                return "fs";
            }
        }
        return "unknown";
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void updateModel() {
    }

    private List<String> getSignalIdFromTreePath(TreePath treePath) {
        LinkedList<String> signalIds = new LinkedList<String>();
        Object element = treePath.getElement();
        if (!(element instanceof WSignalsTableSignal)) {
            return null;
        }
        String vcdId = ((WSignalsTableSignal)element).getVcdId();
        DVTVCDSignalWrapper signalWrapper = this.model.getSignalsByModelId().get(vcdId);
        if (signalWrapper instanceof DVTVCDNetArrayWrapper) {
            signalIds.addAll(((DVTVCDNetArrayWrapper)signalWrapper).getAllVarIds());
        } else {
            signalIds.add(vcdId);
        }
        return signalIds;
    }

    public void setBounds(String firstVisibleId, String lastVisibleId, List<TreePath> allSignals) {
        List<String> ids;
        TreePath treePath;
        if (firstVisibleId == null || lastVisibleId == null) {
            return;
        }
        EvictingQueue previousSignals = EvictingQueue.create((int)10000);
        HashSet<String> signalIds = new HashSet<String>();
        signalIds.add(firstVisibleId);
        signalIds.add(lastVisibleId);
        Iterator<TreePath> it = allSignals.iterator();
        while (it.hasNext()) {
            treePath = it.next();
            ids = this.getSignalIdFromTreePath(treePath);
            if (ids == null || ids.isEmpty()) continue;
            if (ids.size() == 1 && ids.contains(firstVisibleId)) break;
            previousSignals.addAll(ids);
        }
        while (it.hasNext()) {
            treePath = it.next();
            ids = this.getSignalIdFromTreePath(treePath);
            if (ids == null || ids.isEmpty()) continue;
            if (ids.size() == 1 && ids.contains(lastVisibleId)) break;
            signalIds.addAll(ids);
        }
        signalIds.addAll((Collection<String>)previousSignals);
        int counter = 10000;
        while (it.hasNext() && counter > 0) {
            TreePath treePath2 = it.next();
            List<String> ids2 = this.getSignalIdFromTreePath(treePath2);
            if (ids2 == null || ids2.isEmpty()) continue;
            signalIds.addAll(ids2);
            --counter;
        }
        this.cleanVarModifsFromModel(signalIds);
        this.addVarModifsToModel();
    }

    public void cleanVarModifsFromModel(Set<String> signalsWindow) {
        LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID = this.model.getSignalsByModelId();
        if (this.visibleSignals != null) {
            for (String signal : this.visibleSignals) {
                if (signalsWindow.contains(signal)) continue;
                DVTVCDSignalWrapper varWrapper = variablesByID.get(signal);
                varWrapper.clearVarModifsFromFST();
                int signalAsInt = -1;
                try {
                    signalAsInt = Integer.parseInt(signal);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                this.visibleUniqueSignals.remove(signalAsInt);
                String alias = varWrapper.getAliasId();
                if (alias == null) continue;
                this.visibleUniqueSignals.remove(Integer.parseInt(alias));
                variablesByID.get(alias).clearVarModifsFromFST();
            }
        }
        this.visibleSignals = signalsWindow;
    }

    public void cleanOldModel() {
        LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID = this.model.getSignalsByModelId();
        for (DVTVCDSignalWrapper signalWrapper : variablesByID.values()) {
            signalWrapper.varModificationByTime = null;
            signalWrapper.resetClocks();
        }
    }

    public void addVarModifsToModel() {
        try {
            LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID = this.model.getSignalsByModelId();
            HashMap<Integer, DVTVarModifQueue<DVTVCDVarModificationByTime>> signalsToRead = new HashMap<Integer, DVTVarModifQueue<DVTVCDVarModificationByTime>>();
            LinkedList<DVTVCDSignalWrapper> varWrappers = new LinkedList<DVTVCDSignalWrapper>();
            for (String signalId : this.visibleSignals) {
                DVTVarModifQueue<DVTVCDVarModificationByTime> varModifs;
                DVTVCDSignalWrapper signalWrapper = variablesByID.get(signalId);
                String alias = signalWrapper.getAliasId();
                Integer singalAsInt = null;
                try {
                    singalAsInt = Integer.parseInt(signalId);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (alias == null && singalAsInt != null && !this.visibleUniqueSignals.containsKey(singalAsInt)) {
                    varModifs = new DVTVarModifQueue<DVTVCDVarModificationByTime>();
                    signalWrapper.setVarModifsFromFST(varModifs);
                    this.visibleUniqueSignals.put(singalAsInt, varModifs);
                    signalsToRead.put(singalAsInt, varModifs);
                    varWrappers.add(signalWrapper);
                    continue;
                }
                if (alias == null) {
                    alias = signalId;
                } else {
                    signalWrapper = variablesByID.get(alias);
                }
                varWrappers.add(signalWrapper);
                singalAsInt = Integer.parseInt(alias);
                if (this.visibleUniqueSignals.containsKey(singalAsInt)) continue;
                varModifs = new DVTVarModifQueue();
                signalWrapper.setVarModifsFromFST(varModifs);
                this.visibleUniqueSignals.put(singalAsInt, varModifs);
                signalsToRead.put(singalAsInt, varModifs);
            }
            if (signalsToRead.isEmpty()) {
                return;
            }
            Set<Integer> signalIds = signalsToRead.keySet();
            this.readSignals(signalIds, signalsToRead);
            for (DVTVCDSignalWrapper signalWrapper : varWrappers) {
                DVTVCDVarModificationByTime firstValue;
                DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST;
                signalWrapper.setFullyRead(true);
                if (signalWrapper.getValueAtTimeZero() != null && !signalWrapper.getValueAtTimeZero().isEmpty() || (varModifsFromFST = signalWrapper.getVarModifsFromFST()) == null || (firstValue = varModifsFromFST.getFirstValue()) == null) continue;
                signalWrapper.setValueAtTimeZero(firstValue.getValue());
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected String getDefaultConfigFilePath() {
        return String.valueOf(FilenameUtils.removeExtension((String)this.dstFilePath)) + "_default" + "." + "wcfg";
    }

    public String getDateTimeString() {
        return this.dateTimeString;
    }

    public boolean hasIncompleteHierarchy() {
        return this.incompleteHierarchy;
    }
}

