/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.Objects;

public class TimeChangeWrapper {
    private long time;
    private long fileOffset;
    private long changedSignalsNum;
    private boolean isParsedBefore;

    public TimeChangeWrapper(long time, long offset) {
        this.time = time;
        this.fileOffset = offset;
        this.changedSignalsNum = 0L;
        this.isParsedBefore = false;
    }

    public long getOffset() {
        return this.fileOffset;
    }

    public void incrementSignalCnt() {
        ++this.changedSignalsNum;
    }

    public void decrementSignalCnt() {
        if (this.changedSignalsNum > 0L) {
            --this.changedSignalsNum;
        }
    }

    public boolean shouldGetParsed() {
        return !this.isParsedBefore || this.changedSignalsNum > 0L;
    }

    public void deepClean() {
    }

    public long getTime() {
        return this.time;
    }

    public void setParsedBefore(boolean hasBeenParsedBefore) {
        this.isParsedBefore = hasBeenParsedBefore;
    }

    public int hashCode() {
        return Objects.hash(this.time);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeChangeWrapper other = (TimeChangeWrapper)obj;
        return this.time == other.time;
    }
}

