/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;

public class VCD2FST
extends Job {
    private Map<String, Integer> symbolToWidth = new HashMap<String, Integer>();
    private List<Integer> widths = new ArrayList<Integer>();
    private Map<String, Byte> symbolToType = new HashMap<String, Byte>();
    private Map<String, Integer> symbolToIndex = new HashMap<String, Integer>();
    private Map<Integer, List<Integer>> aliases = new HashMap<Integer, List<Integer>>();
    private List<String> signalNames = new ArrayList<String>();
    private Map<Integer, ByteArrayOutputStream> waveStreams = new HashMap<Integer, ByteArrayOutputStream>();
    private ByteArrayOutputStream timeStream = new ByteArrayOutputStream();
    private String[] initialValues;
    private String timeUnit;
    private int timeScale;
    private int timeIndex;
    private long lastTime;
    private long timeDelta;
    private long globalStartTime;
    private long globalEndTime;
    private long totalMemoryRequired;
    private long blockStartTime;
    private int totalChanges;
    private String vcdFile;
    private String fstFile;
    private CountDownLatch latch = new CountDownLatch(1);
    private Runnable callbackFunction;
    private long vcdLastPosition;
    private FileChannel vcdChannel;
    private ByteBuffer vcdMappedBuffer;
    private int endTimeFSTPosition;
    private long timescalePosition;
    private long initialDiagramUpperTimeLimit;
    private String dateTimeString = "";
    private Map<DVTVCDUtilsCommon.DSTMetadataItem, Object> metadataItems = new EnumMap<DVTVCDUtilsCommon.DSTMetadataItem, Object>(DVTVCDUtilsCommon.DSTMetadataItem.class);
    private boolean incompleteHierarchy = true;

    public VCD2FST(String name, String vcdFile, String fstFile, Runnable callbackFunction) {
        super(name);
        this.callbackFunction = callbackFunction;
        this.fstFile = fstFile;
        this.vcdFile = vcdFile;
    }

    private void writeTimescale(FileChannel outChannel) throws IOException {
        long savedPosition = outChannel.position();
        outChannel.position(this.timescalePosition);
        ByteBuffer buffer = ByteBuffer.allocate(108);
        buffer.put(DVTVCDUtils.getTimescaleExponent(this.timeUnit));
        buffer.putInt(this.timeScale);
        this.writeString(buffer, this.dateTimeString);
        buffer.flip();
        outChannel.write(buffer);
        buffer.clear();
        outChannel.position(savedPosition);
    }

    public String getVCDDateTimeString() {
        String dateTimeString = "";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(this.vcdFile), 0x2000000);){
                String line;
                while ((line = reader.readLine()) != null && !line.contains("$scope")) {
                    if (!line.startsWith("$date")) continue;
                    dateTimeString = this.getDateTimeString(reader, line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return dateTimeString;
    }

    private String getDateTimeString(BufferedReader reader, String line) throws IOException {
        StringBuilder sb = new StringBuilder("");
        do {
            sb.append(line);
        } while ((line = reader.readLine()) != null && !line.contains("$end"));
        if (line != null) {
            sb.append(line);
        }
        String dateTimeString = sb.toString();
        dateTimeString = DVTVCDUtils.WHITE_SPACE_PATTERN.matcher(dateTimeString).replaceAll("");
        return dateTimeString;
    }

    private void parseVCDHeader(String inputFile, FileChannel outChannel, IProgressMonitor monitor) throws IOException {
        ByteBuffer varBuffer = ByteBuffer.allocateDirect(0x2000000);
        this.metadataItems.put(DVTVCDUtilsCommon.DSTMetadataItem.IncompleteHierarchy, (byte)1);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile), 0x2000000);){
            String line;
            StringBuilder timescaleBuilder = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                if (varBuffer.remaining() < 100) {
                    varBuffer.flip();
                    outChannel.write(varBuffer);
                    varBuffer.clear();
                }
                if (line.startsWith("$date")) {
                    this.dateTimeString = this.getDateTimeString(reader, line);
                    continue;
                }
                if (line.startsWith("$timescale")) {
                    timescaleBuilder = new StringBuilder(line);
                    while (!line.contains("$end")) {
                        line = reader.readLine();
                        if (line == null) break;
                        timescaleBuilder.append(" ").append(line);
                    }
                    String timescale = timescaleBuilder.toString();
                    Matcher matcher = DVTVCDUtils.TIMESCALE_PATTERN.matcher(timescale);
                    if (!matcher.find()) continue;
                    this.timeScale = Integer.parseInt(matcher.group(1));
                    this.timeUnit = matcher.group(2);
                    this.writeTimescale(outChannel);
                    continue;
                }
                if (line.startsWith("$var")) {
                    this.addVarDefinition(varBuffer, DVTVCDUtils.WHITE_SPACE_PATTERN.split(line));
                    continue;
                }
                if (line.startsWith("$scope")) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.pushScope(varBuffer, line);
                    continue;
                }
                if (line.startsWith("$upscope")) {
                    varBuffer.put((byte)-1);
                    continue;
                }
                if (!line.equals("$enddefinitions $end")) continue;
                this.metadataItems.put(DVTVCDUtilsCommon.DSTMetadataItem.IncompleteHierarchy, (byte)0);
                this.incompleteHierarchy = false;
                break;
            }
            varBuffer.put((byte)-5);
            varBuffer.flip();
            outChannel.write(varBuffer);
            varBuffer.clear();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void pushScope(ByteBuffer varBuffer, String line) {
        String[] items = DVTVCDUtils.WHITE_SPACE_PATTERN.split(line);
        String scopeType = items[1];
        String scopeName = items[2];
        varBuffer.put((byte)-2);
        this.writeString(varBuffer, scopeType);
        this.writeString(varBuffer, scopeName);
    }

    private void addVarDefinition(ByteBuffer varBuffer, String[] tokens) {
        if (tokens.length < 6) {
            return;
        }
        String typeStr = tokens[1];
        int width = Integer.parseInt(tokens[2]);
        String id = tokens[3];
        String name = tokens[4];
        String dimension = "";
        if (tokens.length > 6) {
            dimension = tokens[5];
        }
        byte type = DVTVCDUtils.mapVCDTypeToFST(typeStr);
        Integer aliasIndex = this.symbolToIndex.get(id);
        int index = this.signalNames.size();
        if (aliasIndex != null) {
            this.aliases.get(aliasIndex).add(index);
            this.symbolToWidth.put(id, width);
            this.symbolToType.put(id, type);
        } else {
            this.symbolToIndex.put(id, index);
            LinkedList<Integer> identicalSignals = new LinkedList<Integer>();
            identicalSignals.add(index);
            this.aliases.put(index, identicalSignals);
        }
        this.widths.add(width);
        this.signalNames.add(name);
        varBuffer.put((byte)-4);
        varBuffer.put(type);
        this.writeString(varBuffer, id);
        this.writeVarint(varBuffer, (long)index);
        this.writeVarint(varBuffer, (long)width);
        this.writeString(varBuffer, name);
        this.writeString(varBuffer, dimension);
        this.writeSvarint(varBuffer, aliasIndex != null ? aliasIndex : -1);
        varBuffer.put((byte)-3);
    }

    private void createDumpVarsInfo(BufferedReader reader, IProgressMonitor monitor) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.vcdLastPosition += (long)(line.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
            if (line.isEmpty()) continue;
            if (line.equals("$end")) break;
            char variableType = Character.toLowerCase(line.charAt(0));
            if (monitor.isCanceled()) {
                return;
            }
            if (variableType != 'b' && variableType != 'r') {
                String value = "" + variableType;
                String symbol = line.substring(1);
                Integer indexObj = this.symbolToIndex.get(symbol);
                if (indexObj == null) continue;
                this.initialValues[indexObj.intValue()] = value;
                continue;
            }
            String[] tokens = line.split(" ");
            String value = tokens[0].substring(1);
            String symbol = tokens[1];
            Integer indexObj = this.symbolToIndex.get(symbol);
            if (indexObj == null) continue;
            this.initialValues[indexObj.intValue()] = value;
        }
    }

    private String[] getInitialValues() {
        int size = this.widths.size();
        String[] currentValues = new String[size];
        int i = 0;
        while (i < size) {
            Integer width = this.widths.get(i);
            if (width > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                int j = 0;
                while (j < width) {
                    stringBuilder.append("x");
                    ++j;
                }
                currentValues[i] = stringBuilder.toString();
            } else {
                currentValues[i] = "x";
            }
            ++i;
        }
        return currentValues;
    }

    public boolean parseInitialFST() {
        MappedByteBuffer buffer;
        block14: {
            block13: {
                block12: {
                    this.vcdChannel = FileChannel.open(Paths.get(this.fstFile, new String[0]), StandardOpenOption.READ);
                    long fileSize = this.vcdChannel.size();
                    buffer = this.vcdChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
                    byte[] magic = new byte[4];
                    buffer.get(magic);
                    if (!new String(magic).equals("DST\u0000")) {
                        throw new IOException("Not a valid DST file");
                    }
                    buffer.get();
                    buffer.get();
                    buffer.get();
                    buffer.getInt();
                    ((ByteBuffer)buffer).position(buffer.position() + 100);
                    this.metadataItems = DVTVCDUtils.readDSTMetadataItems(buffer);
                    boolean bl = this.incompleteHierarchy = (Byte)this.metadataItems.getOrDefault((Object)DVTVCDUtilsCommon.DSTMetadataItem.IncompleteHierarchy, (byte)0) == 1;
                    if (!this.incompleteHierarchy) break block12;
                    return false;
                }
                buffer.getLong();
                buffer.getLong();
                this.endTimeFSTPosition = buffer.position();
                this.blockStartTime = buffer.getLong();
                this.totalMemoryRequired = buffer.getLong();
                if (this.totalMemoryRequired != 0L) break block13;
                return true;
            }
            if (this.blockStartTime != 0L) break block14;
            return true;
        }
        try {
            byte token;
            this.vcdLastPosition = buffer.getLong();
            do {
                token = buffer.get();
                switch (token) {
                    case -2: {
                        DVTVCDUtils.readString(buffer);
                        DVTVCDUtils.readString(buffer);
                        break;
                    }
                    case -4: {
                        buffer.get();
                        String symbol = DVTVCDUtils.readString(buffer);
                        int index = DVTVCDUtils.readVarint(buffer);
                        DVTVCDUtils.readVarint(buffer);
                        String name = DVTVCDUtils.readString(buffer);
                        this.signalNames.add(name);
                        DVTVCDUtils.readString(buffer);
                        int alias = DVTVCDUtils.readSvarint(buffer);
                        if (alias == -1) {
                            this.symbolToIndex.put(symbol, index);
                        }
                        buffer.get();
                        break;
                    }
                }
            } while (token != -5);
            this.vcdMappedBuffer = buffer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    private long getLastBlockPositionInFST() {
        long lastPosition = 0L;
        while (this.vcdMappedBuffer.hasRemaining()) {
            byte blockType = this.vcdMappedBuffer.get();
            if (blockType == 3) {
                this.vcdMappedBuffer.getInt();
                this.vcdMappedBuffer.getLong();
                long compressedLength = this.vcdMappedBuffer.getLong();
                int newPosition = this.vcdMappedBuffer.position() + (int)compressedLength;
                this.vcdMappedBuffer.position(newPosition);
                continue;
            }
            if (blockType != 1) continue;
            lastPosition = this.vcdMappedBuffer.position();
            long blockLength = this.vcdMappedBuffer.getLong();
            this.vcdMappedBuffer.position((int)(lastPosition + blockLength + 8L));
        }
        return lastPosition;
    }

    private void computeLastValuesFromFST(byte[] wavesData, byte[] positionData, String[] currentValues) throws IOException {
        ByteArrayInputStream posStream = new ByteArrayInputStream(positionData);
        HashMap<Integer, Integer> indexToPosition = new HashMap<Integer, Integer>();
        int currentPositionInWaveData = 0;
        int lastNegativeValue = 0;
        int currentSignalIndex = -1;
        while (posStream.available() > 0) {
            int indexOfReference;
            ++currentSignalIndex;
            int position = DVTVCDUtils.readSvarint(posStream);
            if ((position & 1) == 0) {
                int runLength = position >> 1;
                currentSignalIndex += runLength - 1;
                continue;
            }
            if (position < 0) {
                indexOfReference = -(position >> 1) - 1;
                position = (Integer)indexToPosition.get(indexOfReference);
                currentValues[currentSignalIndex] = this.getLastValueOfSignal(position, wavesData);
                lastNegativeValue = indexOfReference;
                continue;
            }
            if (position == 1) {
                indexOfReference = lastNegativeValue;
                position = (Integer)indexToPosition.get(indexOfReference);
                currentValues[currentSignalIndex] = this.getLastValueOfSignal(position, wavesData);
                continue;
            }
            indexToPosition.put(currentSignalIndex, currentPositionInWaveData += position >> 1);
            currentValues[currentSignalIndex] = this.getLastValueOfSignal(currentPositionInWaveData, wavesData);
        }
    }

    private String getLastValueOfSignal(int position, byte[] wavesData) throws IOException {
        ByteArrayInputStream waveStream = new ByteArrayInputStream(wavesData);
        long skipBytes = (long)position - 1L;
        String lastValue = null;
        if (waveStream.skip(skipBytes) < 0L) {
            return lastValue;
        }
        int waveLength = DVTVCDUtils.readVarint(waveStream);
        byte[] waveData = new byte[waveLength];
        if (waveStream.read(waveData) < 0) {
            return lastValue;
        }
        ByteBuffer changeStream = ByteBuffer.wrap(waveData);
        while (changeStream.hasRemaining()) {
            DVTVCDUtils.readVarint(changeStream);
            lastValue = DVTVCDUtils.readString(changeStream);
        }
        return lastValue;
    }

    private String[] getLastValuesFromFST(int lastBlockPosition) throws IOException {
        this.vcdMappedBuffer.position(lastBlockPosition);
        this.vcdMappedBuffer.getLong();
        this.vcdMappedBuffer.getLong();
        this.vcdMappedBuffer.getLong();
        this.vcdMappedBuffer.getLong();
        int bitsUncompressedLength = DVTVCDUtils.readVarint(this.vcdMappedBuffer);
        int bitsCompressedLength = DVTVCDUtils.readVarint(this.vcdMappedBuffer);
        int bitsCount = DVTVCDUtils.readVarint(this.vcdMappedBuffer);
        byte[] initialValuesBytes = new byte[bitsCompressedLength];
        this.vcdMappedBuffer.get(initialValuesBytes);
        String[] initialValues = null;
        if (bitsCompressedLength != bitsUncompressedLength) {
            initialValuesBytes = DVTVCDUtils.decompress(initialValuesBytes, bitsUncompressedLength);
        }
        initialValues = DVTVCDUtils.readInitialValues(bitsCount, initialValuesBytes);
        byte[] wavesData = DVTVCDUtils.extractWaveData(this.vcdMappedBuffer);
        long positionDataLength = this.vcdMappedBuffer.getLong();
        byte[] positionData = new byte[(int)positionDataLength];
        this.vcdMappedBuffer.get(positionData);
        this.computeLastValuesFromFST(wavesData, positionData, initialValues);
        return initialValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(IProgressMonitor monitor) throws IOException {
        Object mutex;
        if (!this.parseInitialFST()) {
            this.convert(monitor);
            return;
        }
        Object object = mutex = DVTVCDUtils.DST_FILE_LOCKS.computeIfAbsent(this.fstFile, k -> new Object());
        synchronized (object) {
            this.initialValues = this.getLastValuesFromFST((int)this.getLastBlockPositionInFST());
            boolean hasChanges = false;
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileChannel outChannel = FileChannel.open(Paths.get(this.fstFile, new String[0]), StandardOpenOption.WRITE);){
                outChannel.position(outChannel.size());
                ByteBuffer blockBuffer = ByteBuffer.allocateDirect(0x2000000);
                int signalSize = this.signalNames.size();
                String[] currentValues = this.initialValues;
                int blocksCounter = 1;
                int i = 0;
                while (i < signalSize) {
                    this.waveStreams.put(i, new ByteArrayOutputStream());
                    ++i;
                }
                RandomAccessFile vcdRandomAccessFile = null;
                BufferedReader reader = null;
                this.lastTime = this.blockStartTime;
                boolean isFirstLine = true;
                try {
                    String line;
                    File vcd = new File(this.vcdFile);
                    vcdRandomAccessFile = new RandomAccessFile(vcd, "r");
                    vcdRandomAccessFile.seek(this.vcdLastPosition);
                    FileDescriptor fd = vcdRandomAccessFile.getFD();
                    reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(fd))));
                    int initialLineLength = 0;
                    while ((line = reader.readLine()) != null) {
                        initialLineLength = line.length();
                        this.vcdLastPosition += (long)(initialLineLength + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                        if ((line = line.trim()).isEmpty()) continue;
                        if (line.startsWith("#")) {
                            long time = Long.parseLong(line.length() > 1 ? line.substring(1) : "-1");
                            if (time < this.lastTime) break;
                            if (isFirstLine) {
                                this.globalStartTime = time;
                                this.blockStartTime = time;
                                this.lastTime = time;
                                isFirstLine = false;
                            }
                            this.timeDelta = time - this.lastTime;
                            this.writeVarint(this.timeStream, this.timeDelta);
                            this.lastTime = time;
                            ++this.timeIndex;
                            this.globalEndTime = time;
                            if (this.timeIndex < 100000 && this.totalChanges < 1000000) continue;
                            this.writeBlock(outChannel, blockBuffer);
                            DVTLogger.INSTANCE.logDebug("[VCD REFRESH] Wrote block " + blocksCounter++ + " ||  Start Time: " + this.blockStartTime + " End Time: " + this.globalEndTime);
                            this.initialValues = (String[])currentValues.clone();
                            this.resetBlock(signalSize, time);
                            continue;
                        }
                        if (isFirstLine) {
                            isFirstLine = false;
                            this.timeIndex = 1;
                            this.timeDelta = 0L;
                            this.globalEndTime = this.blockStartTime;
                            this.writeVarint(this.timeStream, this.timeDelta);
                        }
                        this.totalChanges = this.writeVarModif(currentValues, this.timeIndex, line, this.totalChanges);
                        if (!hasChanges && this.totalChanges > 0) {
                            hasChanges = true;
                        }
                        if (this.totalChanges == -1) break;
                    }
                    this.vcdLastPosition -= (long)(initialLineLength + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
                    if (this.timeIndex != 0 && !isFirstLine && hasChanges) {
                        this.writeBlock(outChannel, blockBuffer);
                        DVTLogger.INSTANCE.logDebug("[VCD CONVERSION] Wrote FINAL block " + blocksCounter++ + " ||  Start Time: " + this.blockStartTime + " End Time: " + this.globalEndTime);
                    }
                    if (!isFirstLine) {
                        this.updateHeaderPlaceHoldersRefresh(outChannel, this.endTimeFSTPosition);
                    }
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    finally {
                        if (vcdRandomAccessFile != null) {
                            vcdRandomAccessFile.close();
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void convert(IProgressMonitor monitor) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ignoreComment(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && !line.contains("$end")) {
        }
    }

    private String[] parseDumpVarsAndInitialTime(String[] currentValues, BufferedReader reader, IProgressMonitor monitor) throws IOException {
        String line;
        boolean dumpVarsFound = false;
        boolean firstTimeFound = false;
        while ((line = reader.readLine()) != null) {
            this.vcdLastPosition += (long)(line.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
            if (line.isEmpty()) continue;
            if ((line = line.trim()).startsWith("$comment") && !line.contains("$end")) {
                this.ignoreComment(reader);
                continue;
            }
            if (line.startsWith("$dumpvars")) {
                this.createDumpVarsInfo(reader, monitor);
                currentValues = (String[])this.initialValues.clone();
                this.setInitialTime("#0");
                dumpVarsFound = true;
                break;
            }
            if (!line.startsWith("#")) continue;
            this.setInitialTime(line);
            firstTimeFound = true;
            break;
        }
        while (!firstTimeFound && (line = reader.readLine()) != null) {
            this.vcdLastPosition += (long)(line.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
            if (line.isEmpty()) continue;
            if ((line = line.trim()).startsWith("$comment") && line.contains("$end")) {
                this.ignoreComment(reader);
                continue;
            }
            if (!line.startsWith("#")) continue;
            currentValues = this.setCurrentTimeStamp(line);
            break;
        }
        while (!dumpVarsFound && (line = reader.readLine()) != null) {
            this.vcdLastPosition += (long)(line.length() + DVTVCDUtils.SYSTEM_LINE_SEPARATOR_LENGTH);
            if (line.isEmpty()) continue;
            if ((line = line.trim()).startsWith("$comment") && line.contains("$end")) {
                this.ignoreComment(reader);
            } else if (line.startsWith("$dumpvars")) {
                this.createDumpVarsInfo(reader, monitor);
                currentValues = (String[])this.initialValues.clone();
                break;
            }
            if (line.startsWith("#")) {
                currentValues = this.setCurrentTimeStamp(line);
                break;
            }
            this.totalChanges = this.writeVarModif(currentValues, this.timeIndex, line, this.totalChanges);
            break;
        }
        return currentValues;
    }

    private String[] setCurrentTimeStamp(String line) throws IOException {
        String[] currentValues = (String[])this.initialValues.clone();
        long time = Long.parseLong(line.substring(1));
        this.timeDelta = time - this.lastTime;
        this.writeVarint(this.timeStream, this.timeDelta);
        this.lastTime = time;
        ++this.timeIndex;
        this.globalEndTime = time;
        return currentValues;
    }

    private void setInitialTime(String line) throws IOException {
        this.lastTime = this.blockStartTime = Long.parseLong(line.substring(1));
        this.timeDelta = 0L;
        this.writeVarint(this.timeStream, this.timeDelta);
        this.timeIndex = 1;
        this.globalStartTime = this.blockStartTime;
    }

    private void updateHeaderPlaceHolders(FileChannel outChannel, long timeInfoPos) throws IOException {
        ByteBuffer timeInfoBuffer = ByteBuffer.allocateDirect(DVTVCDUtilsCommon.DSTMetadataItem.getAllMetadataSize() + 40);
        this.writeMetadata(timeInfoBuffer);
        timeInfoBuffer.putLong(this.globalStartTime);
        timeInfoBuffer.putLong(this.initialDiagramUpperTimeLimit);
        timeInfoBuffer.putLong(this.globalEndTime);
        timeInfoBuffer.putLong(this.totalMemoryRequired);
        timeInfoBuffer.putLong(this.vcdLastPosition);
        timeInfoBuffer.flip();
        outChannel.position(timeInfoPos);
        outChannel.write(timeInfoBuffer);
    }

    private void updateHeaderPlaceHoldersRefresh(FileChannel outChannel, long timeInfoPos) throws IOException {
        ByteBuffer timeInfoBuffer = ByteBuffer.allocateDirect(24);
        timeInfoBuffer.putLong(this.globalEndTime);
        timeInfoBuffer.putLong(this.totalMemoryRequired);
        timeInfoBuffer.putLong(this.vcdLastPosition);
        timeInfoBuffer.flip();
        outChannel.position(timeInfoPos);
        outChannel.write(timeInfoBuffer);
    }

    private void writeBlock(FileChannel outChannel, ByteBuffer blockBuffer) throws IOException {
        blockBuffer.clear();
        long memoryUsed = this.writeVCDataBlock(blockBuffer, this.blockStartTime, this.globalEndTime, this.timeIndex, this.initialValues);
        this.totalMemoryRequired += memoryUsed;
        blockBuffer.flip();
        outChannel.write(blockBuffer);
    }

    private void resetBlock(int signalsSize, long time) throws IOException {
        this.blockStartTime = time;
        this.totalChanges = 0;
        int i = 0;
        while (i < signalsSize) {
            this.waveStreams.get(i).reset();
            ++i;
        }
        this.timeStream.reset();
        this.timeDelta = 0L;
        this.writeVarint(this.timeStream, this.timeDelta);
        this.timeIndex = 1;
    }

    private int writeVarModif(String[] currentValues, int timeIndex, String line, int totalChanges) {
        try {
            char variableType = Character.toLowerCase(line.charAt(0));
            if (variableType != 'b' && variableType != 'r') {
                String value = "" + variableType;
                String symbol = line.substring(1);
                Integer indexObj = this.symbolToIndex.get(symbol);
                if (indexObj != null) {
                    currentValues[indexObj.intValue()] = value;
                    OutputStream waveOut = this.waveStreams.get(indexObj);
                    this.writeVarint(waveOut, (long)timeIndex);
                    this.writeString(waveOut, value);
                    ++totalChanges;
                } else if (!("$dumpoff".equals(line) || "$dumpon".equals(line) || "$dumpvars".equals(line) || "$end".equals(line) || line.startsWith("$dumpall"))) {
                    DVTLogger.INSTANCE.logError("[VCD CONVERSION] : UNKNOWN SYMBOL FOUND: " + symbol);
                    throw new Exception("Symbol not found!");
                }
            } else {
                String[] tokens = line.split(" ");
                String value = tokens[0].substring(1);
                String symbol = tokens[1];
                Integer indexObj = this.symbolToIndex.get(symbol);
                if (indexObj != null) {
                    currentValues[indexObj.intValue()] = value;
                    OutputStream waveOut = this.waveStreams.get(indexObj);
                    this.writeVarint(waveOut, (long)timeIndex);
                    this.writeString(waveOut, value);
                    ++totalChanges;
                } else if (!("$dumpoff".equals(line) || "$dumpon".equals(line) || "$dumpvars".equals(line) || "$end".equals(line) || line.startsWith("$dumpall"))) {
                    DVTLogger.INSTANCE.logError("[VCD CONVERSION] : UNKNOWN SYMBOL FOUND: " + symbol);
                    throw new Exception("Symbol not found!");
                }
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return totalChanges;
    }

    private void writeMetadata(ByteBuffer headerBuffer) {
        DVTVCDUtilsCommon.DSTMetadataItem[] dSTMetadataItemArray = DVTVCDUtilsCommon.DSTMetadataItem.values();
        int n = dSTMetadataItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            DVTVCDUtilsCommon.DSTMetadataItem metadataItem = dSTMetadataItemArray[n2];
            Object metadataObjValue = this.metadataItems.getOrDefault((Object)metadataItem, null);
            switch (metadataItem.dimension) {
                case 1: {
                    if (!(metadataObjValue instanceof Byte var7_7)) {
                        headerBuffer.put((byte)0);
                        break;
                    }
                    headerBuffer.put(byteValue.byteValue());
                    break;
                }
                case 4: {
                    if (!(metadataObjValue instanceof Integer var9_9)) {
                        headerBuffer.putInt(0);
                        break;
                    }
                    headerBuffer.putInt(intValue.intValue());
                    break;
                }
                case 8: {
                    if (!(metadataObjValue instanceof Long var11_11)) {
                        headerBuffer.putLong(0L);
                        break;
                    }
                    headerBuffer.putLong(longValue.longValue());
                    break;
                }
            }
            ++n2;
        }
    }

    private long writeFSTHeader(FileChannel outChannel) throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocateDirect(1024);
        headerBuffer.put("DST\u0000".getBytes());
        headerBuffer.put((byte)0);
        headerBuffer.put((byte)0);
        this.timescalePosition = headerBuffer.position();
        headerBuffer.put((byte)0);
        headerBuffer.putInt(0);
        headerBuffer.put(new byte[100]);
        int metadataSize = DVTVCDUtilsCommon.DSTMetadataItem.getAllMetadataSize();
        headerBuffer.putInt(metadataSize);
        long timeInfoPos = headerBuffer.position();
        headerBuffer.put(new byte[metadataSize]);
        headerBuffer.putLong(0L);
        headerBuffer.putLong(0L);
        headerBuffer.putLong(0L);
        headerBuffer.putLong(0L);
        headerBuffer.putLong(0L);
        headerBuffer.flip();
        outChannel.write(headerBuffer);
        return timeInfoPos;
    }

    private long writeVCDGeometryBlock(FileChannel outChannel) {
        ByteBuffer buf = ByteBuffer.allocateDirect(0x2000000);
        int signalsNo = this.signalNames.size();
        buf.put((byte)3);
        buf.putInt(signalsNo);
        ByteArrayOutputStream bitsStream = new ByteArrayOutputStream(signalsNo);
        try {
            int i = 0;
            while (i < signalsNo) {
                bitsStream.write(ByteBuffer.allocate(4).putInt(this.widths.get(i)).array());
                ++i;
            }
            byte[] geometryData = bitsStream.toByteArray();
            byte[] geometryDataCompressed = this.compress(geometryData);
            buf.putLong(geometryData.length);
            buf.putLong(geometryDataCompressed.length);
            buf.put(geometryDataCompressed);
            buf.flip();
            outChannel.write(buf);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return 0L;
    }

    private long writeVCDataBlock(ByteBuffer buf, long startTime, long endTime, int timePointsSize, String[] currentValues) throws IOException {
        if (timePointsSize == 0) {
            return 0L;
        }
        buf.put((byte)1);
        int blockStartPos = buf.position();
        buf.putLong(0L);
        buf.putLong(startTime);
        buf.putLong(endTime);
        int memoryRequiredPos = buf.position();
        buf.putLong(0L);
        int signalSize = this.signalNames.size();
        ByteArrayOutputStream initialValuesStream = new ByteArrayOutputStream(signalSize);
        int i = 0;
        while (i < signalSize) {
            this.writeString(initialValuesStream, currentValues[i]);
            ++i;
        }
        byte[] initialValues = initialValuesStream.toByteArray();
        byte[] compressedBits = this.compress(initialValues);
        this.writeVarint(buf, (long)initialValues.length);
        this.writeVarint(buf, (long)compressedBits.length);
        this.writeVarint(buf, (long)signalSize);
        buf.put(compressedBits);
        ByteArrayOutputStream wavesStream = new ByteArrayOutputStream();
        ByteArrayOutputStream positionStream = new ByteArrayOutputStream();
        HashMap<String, Integer> uniqueWaves = new HashMap<String, Integer>();
        int[] positions = new int[signalSize];
        this.computeWaveData(signalSize, wavesStream, uniqueWaves, positions);
        this.computePositionData(positions, positionStream);
        byte[] wavesData = wavesStream.toByteArray();
        byte[] positionData = positionStream.toByteArray();
        byte[] timeData = this.timeStream.toByteArray();
        byte[] compressedTime = this.compress(timeData);
        byte[] compressedWaveData = this.compress(wavesData);
        this.writeVarint(buf, (long)uniqueWaves.size());
        buf.put((byte)0);
        buf.putLong(wavesData.length);
        buf.putLong(compressedWaveData.length);
        buf.put(compressedWaveData);
        buf.putLong(positionData.length);
        buf.put(positionData);
        buf.putLong(timeData.length);
        buf.putLong(compressedTime.length);
        buf.putLong(timePointsSize);
        buf.put(compressedTime);
        long memoryRequired = (long)initialValues.length + (long)wavesData.length + (long)positionData.length + (long)timeData.length;
        int currentPos = buf.position();
        long blockLength = (long)(currentPos - blockStartPos) - 8L;
        int savedPos = buf.position();
        buf.position(blockStartPos);
        buf.putLong(blockLength);
        buf.position(memoryRequiredPos);
        buf.putLong(memoryRequired);
        buf.position(savedPos);
        return memoryRequired;
    }

    private void computePositionData(int[] positions, OutputStream posOut) throws IOException {
        int runLength = 0;
        int lastPositiveValue = 0;
        int lastNegativeValue = 0;
        int i = 0;
        while (i < positions.length) {
            int position = positions[i];
            if (position == 0) {
                ++runLength;
                if (i == positions.length - 1 || positions[i + 1] != 0) {
                    this.writeSvarint(posOut, runLength << 1);
                    runLength = 0;
                }
            } else if (position > 0) {
                int delta = position - lastPositiveValue;
                this.writeSvarint(posOut, delta << 1 | 1);
                lastPositiveValue = position;
            } else if (position == lastNegativeValue) {
                this.writeSvarint(posOut, 1);
            } else {
                this.writeSvarint(posOut, position << 1 | 1);
                lastNegativeValue = position;
            }
            ++i;
        }
    }

    private void computeWaveData(int signalSize, ByteArrayOutputStream wavesStream, Map<String, Integer> uniqueWaves, int[] positions) throws IOException {
        int i = 0;
        while (i < signalSize) {
            ByteArrayOutputStream waveStream = this.waveStreams.get(i);
            byte[] waveData = waveStream.toByteArray();
            if (waveData.length <= 0) {
                positions[i] = 0;
            } else {
                String waveKey = Integer.toString(Arrays.hashCode(waveData));
                if (uniqueWaves.containsKey(waveKey)) {
                    int originalId = uniqueWaves.get(waveKey);
                    positions[i] = -originalId - 1;
                } else {
                    int position = wavesStream.size() + 1;
                    uniqueWaves.put(waveKey, i);
                    positions[i] = position;
                    this.writeVarint(wavesStream, (long)waveData.length);
                    wavesStream.write(waveData);
                }
            }
            ++i;
        }
    }

    private void writeSvarint(OutputStream buf, int value) throws IOException {
        int zigzag = value << 1 ^ value >> 31;
        while (zigzag >= 128) {
            buf.write((byte)(zigzag & 0x7F | 0x80));
            zigzag >>>= 7;
        }
        buf.write((byte)zigzag);
    }

    private void writeSvarint(ByteBuffer buf, int value) {
        int zigzag = value << 1 ^ value >> 31;
        while (zigzag >= 128) {
            buf.put((byte)(zigzag & 0x7F | 0x80));
            zigzag >>>= 7;
        }
        buf.put((byte)zigzag);
    }

    private void writeVarint(ByteBuffer buf, long value) {
        while (value >= 128L) {
            buf.put((byte)(value & 0x7FL | 0x80L));
            value >>= 7;
        }
        buf.put((byte)value);
    }

    private void writeVarint(OutputStream out, long value) throws IOException {
        while (value >= 128L) {
            out.write((byte)(value & 0x7FL | 0x80L));
            value >>= 7;
        }
        out.write((int)value);
    }

    private void writeString(ByteBuffer buf, String str) {
        buf.put(str.getBytes());
        buf.put((byte)0);
    }

    private void writeString(OutputStream out, String str) throws IOException {
        out.write(str.getBytes());
        out.write(0);
    }

    private byte[] compress(byte[] data) throws IOException {
        if (data.length < 100) {
            return data;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        Deflater deflater = new Deflater(1, true);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DeflaterOutputStream gzip = new DeflaterOutputStream((OutputStream)bos, deflater);){
            gzip.write(data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        byte[] compressed = bos.toByteArray();
        return compressed.length < data.length ? compressed : data;
    }

    public void deepClean() {
        this.timeStream = null;
        this.initialValues = null;
        if (this.waveStreams != null) {
            this.waveStreams.clear();
            this.waveStreams = null;
        }
        if (this.signalNames != null) {
            this.signalNames.clear();
            this.signalNames = null;
        }
        if (this.aliases != null) {
            this.aliases.clear();
            this.aliases = null;
        }
        if (this.symbolToIndex != null) {
            this.symbolToIndex.clear();
            this.symbolToIndex = null;
        }
        if (this.symbolToType != null) {
            this.symbolToType.clear();
            this.symbolToType = null;
        }
        if (this.widths != null) {
            this.widths.clear();
            this.widths = null;
        }
        if (this.symbolToWidth != null) {
            this.symbolToWidth.clear();
            this.symbolToWidth = null;
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.convert(monitor);
            if (monitor.isCanceled()) {
                Files.delete(Paths.get(this.fstFile, new String[0]));
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.callbackFunction.run();
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            if (e instanceof AccessDeniedException) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Utils.getActiveShell(), (String)"No writing permissions", (String)"Cannot create .dst file in current directory."));
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            this.latch.countDown();
            this.deepClean();
        }
    }

    private static /* synthetic */ Object lambda$1(String k) {
        return new Object();
    }
}

