/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.TreeSet;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableExpandableElement;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableHierarchialElement;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;

public class WSignalsTableMultiBitChildSignal
extends WSignalsTableMultiBitSignal
implements ISignalsTableExpandableElement,
ISignalsTableHierarchialElement {
    private WSignalsTableMultiBitSignal parentElement;

    public WSignalsTableMultiBitChildSignal(int id, String name, TreePath treePath, String vcdId, WSignalElementPath vcdPath, int bitWidth, String type, boolean isBigEndian, int startIndex, int endIndex, WSignalsTableMultiBitSignal parentElement) {
        super(id, name, treePath, vcdId, vcdPath, bitWidth, type, isBigEndian, startIndex, endIndex);
        this.parentElement = parentElement;
        if (parentElement != null) {
            this.inheritParentAttributes();
        }
    }

    public WSignalsTableMultiBitChildSignal(WSignalsTableMultiBitChildSignal signal) {
        super(signal);
        this.startIndex = signal.startIndex;
        this.endIndex = signal.endIndex;
    }

    @Override
    public TreeSet<WSignalsTableElement> getChildElements() {
        if (this.childSignals != null) {
            return this.childSignals;
        }
        this.childSignals = new TreeSet(ELEMENTS_COMPARATOR);
        if (this.isBigEndian) {
            int childId = 0;
            int index = this.startIndex;
            while (index <= this.endIndex) {
                this.childSignals.add(new WSignalsTableSingleBitChildSignal(childId, String.valueOf(this.name) + "[" + childId + "]", null, this.vcdId, this.vcdPath, this.type, index, this));
                ++childId;
                ++index;
            }
        } else {
            int childId = 0;
            int index = this.startIndex;
            while (index >= this.endIndex) {
                this.childSignals.add(new WSignalsTableSingleBitChildSignal(childId, String.valueOf(this.name) + "[" + (index - this.endIndex) + "]", null, this.vcdId, this.vcdPath, this.type, index, this));
                ++childId;
                --index;
            }
        }
        return this.childSignals;
    }

    @Override
    public WSignalsTableMultiBitSignal getParent() {
        return this.parentElement;
    }

    @Override
    public void removeFromParent() {
        this.parentElement.getChildElements().remove(this);
    }

    @Override
    public boolean isChildElement() {
        return true;
    }

    @Override
    public void setParent(ISignalsTableExpandableElement parent) {
        this.parentElement = (WSignalsTableMultiBitSignal)parent;
    }

    @Override
    public void inheritParentAttributes() {
        if (this.parentElement == null) {
            return;
        }
        this.setBackgroundColor(this.parentElement.getBackgroundColor());
        this.setTextColor(this.parentElement.getTextColor());
        this.setWaveColor(this.parentElement.getWaveColor());
        this.setBase(this.parentElement.getBase());
    }
}

