/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.TreeSet;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.wave.WSignalsTableElementsFactory;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableExpandableElement;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableHierarchialElement;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;

public class WSignalsTableMultiBitSignal
extends WSignalsTableSignal
implements ISignalsTableExpandableElement {
    protected int bitWidth;
    protected int startIndex;
    protected int endIndex;
    protected boolean isBigEndian;
    private String base;
    private RGB textColor;
    protected TreeSet<WSignalsTableElement> childSignals;

    public WSignalsTableMultiBitSignal(int id, String name, TreePath treePath, String vcdId, WSignalElementPath vcdPath, int bitWidth, String type, boolean isBigEndian, int startIndex, int endIndex) {
        super(id, name, treePath, vcdId, vcdPath, type);
        this.bitWidth = bitWidth;
        this.base = "real".equals(type) ? "10" : "16";
        this.textColor = DVTVCDUtils.WHITE;
        this.childSignals = null;
        this.isBigEndian = isBigEndian;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public WSignalsTableMultiBitSignal(WSignalsTableMultiBitSignal signal) {
        super(signal);
        this.bitWidth = signal.bitWidth;
        this.startIndex = signal.startIndex;
        this.endIndex = signal.endIndex;
        this.base = signal.base;
        this.textColor = signal.textColor;
        this.isBigEndian = signal.isBigEndian;
        if (signal.childSignals == null || signal.childSignals.isEmpty()) {
            return;
        }
        TreeSet<WSignalsTableElement> childSignalsCopy = new TreeSet<WSignalsTableElement>(ELEMENTS_COMPARATOR);
        for (WSignalsTableElement child : signal.childSignals) {
            WSignalsTableElement childCopy = WSignalsTableElementsFactory.INSTANCE.createCopyOf(child);
            childSignalsCopy.add(childCopy);
        }
        this.setChildElements(childSignalsCopy);
    }

    public static WSignalsTableMultiBitSignal of(int id, DVTVCDSignalWrapper signalWrapper) {
        String vcdId = signalWrapper.getVarID();
        WSignalElementPath signalPath = signalWrapper.getPath();
        String name = signalPath.getNameWithDimension();
        int bitWidth = Integer.parseInt(signalWrapper.getBitWidth());
        String type = signalWrapper.getType();
        boolean isBigEndian = signalWrapper.isBigEndian();
        int[] indexBounds = DVTVCDUtils.getPackedArrayIndexBounds(signalWrapper.getPath().getDimension(), isBigEndian, bitWidth);
        return new WSignalsTableMultiBitSignal(id, name, null, vcdId, signalPath, bitWidth, type, isBigEndian, indexBounds[0], indexBounds[1]);
    }

    public static WSignalsTableMultiBitSignal of(int id, DVTVCDSignalWrapper signalWrapper, TreeSet<WSignalsTableStructSignal> childSignals) {
        WSignalsTableMultiBitSignal newSignal = WSignalsTableMultiBitSignal.of(id, signalWrapper);
        newSignal.childSignals = new TreeSet<WSignalsTableElement>(WSignalsTableElement.ELEMENTS_COMPARATOR);
        for (WSignalsTableStructSignal childSignal : childSignals) {
            newSignal.childSignals.add(childSignal);
            childSignal.setParent(newSignal);
        }
        return newSignal;
    }

    public void setChildElements(TreeSet<WSignalsTableElement> childSignals) {
        this.childSignals = childSignals;
        for (WSignalsTableElement childSignal : childSignals) {
            if (!(childSignal instanceof ISignalsTableHierarchialElement)) continue;
            ((ISignalsTableHierarchialElement)((Object)childSignal)).setParent(this);
        }
    }

    @Override
    public TreeSet<WSignalsTableElement> getChildElements() {
        if (this.childSignals != null) {
            return this.childSignals;
        }
        this.childSignals = new TreeSet(ELEMENTS_COMPARATOR);
        if (this.type.equals("real")) {
            return this.childSignals;
        }
        int tableId = 0;
        if (this.isBigEndian) {
            int index = this.startIndex;
            while (index <= this.endIndex) {
                this.childSignals.add(new WSignalsTableSingleBitChildSignal(tableId, String.valueOf(this.name) + "[" + index + "]", null, this.vcdId, this.vcdPath, this.type, index, this));
                ++tableId;
                ++index;
            }
        } else {
            int index = this.startIndex;
            while (index >= this.endIndex) {
                this.childSignals.add(new WSignalsTableSingleBitChildSignal(tableId, String.valueOf(this.name) + "[" + index + "]", null, this.vcdId, this.vcdPath, this.type, index, this));
                ++tableId;
                --index;
            }
        }
        return this.childSignals;
    }

    public int getBitWidth() {
        return this.bitWidth;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public RGB getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGB textColor) {
        this.textColor = textColor;
    }

    @Override
    public String getValueAtCursor() {
        String convertedSignalValue = DVTVCDUtils.getConvertedSignalValue(this.valueAtCursor, String.valueOf(this.bitWidth), this.type, this.base);
        return convertedSignalValue;
    }

    public void removeChild(WSignalsTableElement child) {
        this.childSignals.remove(child);
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }
}

