/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.List;
import java.util.TreeSet;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableExpandableElement;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableHierarchialElement;
import ro.amiq.dvt.ui.waveviewer.WSignalElementPath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;

public class WSignalsTableStructSignal
extends WSignalsTableMultiBitSignal
implements ISignalsTableExpandableElement,
ISignalsTableHierarchialElement {
    private WStructMetadata structMetadata;
    private ISignalsTableExpandableElement parentSignal;

    public WSignalsTableStructSignal(int id, String name, TreePath treePath, String vcdId, WSignalElementPath vcdPath, int bitWidth, String type, WStructMetadata structMetadata, ISignalsTableExpandableElement parentSignal) {
        super(id, name, treePath, vcdId, vcdPath, bitWidth, type, structMetadata.getStartIndex() < structMetadata.getEndIndex(), structMetadata.getStartIndex(), structMetadata.getEndIndex());
        this.structMetadata = structMetadata;
        this.childSignals = this.getChildElements();
        this.parentSignal = parentSignal;
        if (parentSignal != null) {
            this.inheritParentAttributes();
        }
        if (this.isEnum()) {
            this.setBase("ENUM");
        }
    }

    public WSignalsTableStructSignal(WSignalsTableStructSignal signal) {
        super(signal);
        this.structMetadata = signal.structMetadata;
    }

    public static WSignalsTableStructSignal of(int id, DVTVCDSignalWrapper signalWrapper) {
        String vcdId = signalWrapper.getVarID();
        WSignalElementPath elementPath = signalWrapper.getPath();
        String name = elementPath.getNameWithDimension();
        WStructMetadata structMetadata = signalWrapper.getStructMetadata();
        int bitWidth = structMetadata.getBitWidth();
        String type = signalWrapper.getType();
        return new WSignalsTableStructSignal(id, name, null, vcdId, elementPath, bitWidth, type, structMetadata, null);
    }

    public static WSignalsTableStructSignal of(int id, DVTVCDSignalWrapper signalWrapper, int index) {
        int elementEndIndex;
        int elementStartIndex;
        String vcdId = signalWrapper.getVarID();
        WSignalElementPath vcdPath = signalWrapper.getPath();
        WStructMetadata structMetadata = signalWrapper.getStructMetadata();
        int structBitWidth = structMetadata.getBitWidth();
        String type = signalWrapper.getType();
        int signalBitWidth = Integer.parseInt(signalWrapper.getBitWidth());
        if (signalWrapper.isBigEndian()) {
            elementStartIndex = index * structMetadata.getBitWidth();
            elementEndIndex = (index + 1) * structMetadata.getBitWidth() - 1;
        } else {
            int actualIndex = signalBitWidth / structBitWidth - 1 - index;
            elementStartIndex = signalBitWidth - actualIndex * structBitWidth - 1;
            elementEndIndex = elementStartIndex - structBitWidth + 1;
        }
        WStructMetadata elementMetadata = new WStructMetadata(structMetadata.getName(), elementStartIndex, elementEndIndex, structMetadata.getMembers());
        elementMetadata.setEnumItems(structMetadata.getEnumItems());
        return new WSignalsTableStructSignal(id, "[" + index + "]", null, vcdId, vcdPath, structBitWidth, type, elementMetadata, null);
    }

    @Override
    public int getStartIndex() {
        return this.structMetadata.getStartIndex();
    }

    @Override
    public int getEndIndex() {
        return this.structMetadata.getEndIndex();
    }

    @Override
    public TreeSet<WSignalsTableElement> getChildElements() {
        if (this.childSignals != null) {
            return this.childSignals;
        }
        this.childSignals = new TreeSet(ELEMENTS_COMPARATOR);
        if (this.structMetadata == null) {
            return this.childSignals;
        }
        int id = -1;
        List<WStructMetadata> members = this.structMetadata.getMembers();
        int parentStartIndex = this.structMetadata.getStartIndex();
        int parentEndIndex = this.structMetadata.getEndIndex();
        for (WStructMetadata member : members) {
            ++id;
            int startIndex = member.getStartIndex();
            int endIndex = member.getEndIndex();
            int bitWidth = member.getBitWidth();
            if (parentStartIndex >= parentEndIndex && (parentStartIndex < startIndex || endIndex < parentEndIndex)) {
                int dif = parentStartIndex - parentEndIndex;
                startIndex = parentStartIndex - dif + startIndex;
                endIndex = parentStartIndex - dif + endIndex;
            } else if (parentStartIndex <= parentEndIndex && (parentStartIndex > startIndex || endIndex > parentEndIndex)) {
                startIndex = parentStartIndex + startIndex;
                endIndex = parentStartIndex + endIndex;
            }
            WStructMetadata childStructMetadata = new WStructMetadata(member.getName(), startIndex, endIndex, member.getMembers());
            if (member.isEnum()) {
                childStructMetadata.setEnumItems(member.getEnumItems());
                this.childSignals.add(new WSignalsTableStructSignal(id, member.getName(), null, this.vcdId, this.vcdPath, bitWidth, this.type, childStructMetadata, this));
                continue;
            }
            if (!member.isInnerStruct()) {
                if (bitWidth == 1) {
                    this.childSignals.add(new WSignalsTableSingleBitChildSignal(id, member.getName(), null, this.vcdId, this.vcdPath, this.type, startIndex, this));
                    continue;
                }
                this.childSignals.add(new WSignalsTableMultiBitChildSignal(id, member.getName(), null, this.vcdId, this.vcdPath, bitWidth, this.type, this.isBigEndian, startIndex, endIndex, this));
                continue;
            }
            this.childSignals.add(new WSignalsTableStructSignal(id, member.getName(), null, this.vcdId, this.vcdPath, bitWidth, this.type, childStructMetadata, this));
        }
        return this.childSignals;
    }

    public boolean isEnum() {
        return this.structMetadata.isEnum();
    }

    public String getEnumItemForValue(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (!this.isEnum()) {
            return null;
        }
        value = DVTVCDUtils.removeStartingZerosFromBinaryString(value);
        String enumItem = this.structMetadata.getEnumItems().get(value);
        return enumItem == null ? "[undefined enum item]" : enumItem;
    }

    @Override
    public void setParent(ISignalsTableExpandableElement parent) {
        this.parentSignal = parent;
    }

    @Override
    public ISignalsTableExpandableElement getParent() {
        return this.parentSignal;
    }

    @Override
    public void removeFromParent() {
        this.parentSignal.getChildElements().remove(this);
    }

    @Override
    public boolean isChildElement() {
        return this.parentSignal != null;
    }

    @Override
    public void inheritParentAttributes() {
        if (this.parentSignal == null || !(this.parentSignal instanceof WSignalsTableSignal)) {
            return;
        }
        WSignalsTableSignal parent = (WSignalsTableSignal)((Object)this.parentSignal);
        this.setBackgroundColor(parent.getBackgroundColor());
        this.setWaveColor(parent.getWaveColor());
        if (!(parent instanceof WSignalsTableMultiBitSignal)) {
            return;
        }
        this.setTextColor(((WSignalsTableMultiBitSignal)parent).getTextColor());
        this.setBase(((WSignalsTableMultiBitSignal)parent).getBase());
    }

    @Override
    public String getValueAtCursor() {
        if (this.isEnum() && "ENUM".equals(this.getBase())) {
            return DVTVCDUtils.getEnumItem(this.valueAtCursor, this);
        }
        return super.getValueAtCursor();
    }
}

