/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.List;
import java.util.Map;

public class WStructMetadata {
    private String name;
    private int startIndex;
    private int endIndex;
    private List<WStructMetadata> members;
    private Map<String, String> enumItems;

    public WStructMetadata(String name, int startIndex, int endIndex, List<WStructMetadata> members) {
        this.name = name;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.members = members;
    }

    public String getName() {
        return this.name;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getBitWidth() {
        if (this.endIndex > this.startIndex) {
            return this.endIndex - this.startIndex + 1;
        }
        return this.startIndex - this.endIndex + 1;
    }

    public List<WStructMetadata> getMembers() {
        return this.members;
    }

    public boolean isInnerStruct() {
        return !this.members.isEmpty();
    }

    public WStructMetadata getMember(String name) {
        if (name == null) {
            return null;
        }
        for (WStructMetadata member : this.members) {
            if (!name.equals(member.name)) continue;
            return member;
        }
        return null;
    }

    public String toString() {
        return "field_name: " + this.name + " | start_index: " + this.startIndex + " | end_index: " + this.endIndex + System.lineSeparator();
    }

    public boolean isEnum() {
        return this.enumItems != null && !this.enumItems.isEmpty();
    }

    public Map<String, String> getEnumItems() {
        return this.enumItems;
    }

    public void setEnumItems(Map<String, String> enumItems) {
        this.enumItems = enumItems;
    }
}

