/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.diagrams.wave.DWaveformEditorFactory;
import ro.amiq.dvt.ui.waveviewer.DVTVCDConfigFilesEngine;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.FSTReader;

public enum WaveViewerEclipseUtils {
    INSTANCE;


    public static void openWaveViewer(String filePath) {
        DVTVCDParser vcdParser;
        if (!DVTVCDUtils.isValidFileExtension(filePath)) {
            return;
        }
        DVTVCDModel vcdModel = new DVTVCDModel();
        String configFilePath = null;
        if (filePath.endsWith("wcfg") && (filePath = DVTVCDConfigFilesEngine.INSTANCE.extractFilePathFromConfig(configFilePath = filePath, DVTVCDUtilsCommon.WaveFileFormat.ALL_TYPES)) == null) {
            new MessageDialog(Display.getCurrent().getActiveShell(), "No existing file", null, "Could not find any specified Waveform Viewer source files (vcd/dst)!", 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
            return;
        }
        IProject project = DVTVCDUtils.getInstance().getLastSelectedProject();
        if (filePath.endsWith("dst")) {
            String vcdFilePath = DVTVCDConfigFilesEngine.INSTANCE.extractFilePathFromConfig(configFilePath, DVTVCDUtilsCommon.WaveFileFormat.VCD);
            vcdParser = new FSTReader(project, filePath, vcdFilePath, configFilePath, vcdModel);
        } else {
            vcdParser = new DVTVCDParser(project, filePath, configFilePath, vcdModel);
        }
        vcdParser.parseInitial();
        DWaveformEditorFactory.getInstance().newWaveformDiagram(vcdParser).openEditor();
    }
}

