/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.waveviewer;

import java.util.List;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;

public class WaveformViewerSchematicDiagramUtils {
    public static final String INFO_BAR_HELP_MESSAGE = "Set a Waveform Viewer and place the Primary Cursor to see the signals value.";
    public static final String INFO_BAR_MESSAGE_TEMPLATE = "Signals value @ {0}{1} from {2}";
    public static final String PORT_VALUE_NOT_AVAILABLE_TEXT = "[N/A]";
    public static final int PORT_VALUE_MAX_LENGTH = 30;
    public static final List<DMenuActionKind> GATE_ACTIONS = List.of(DMenuActionKind.ADD_PORTS, DMenuActionKind.ADD_ALL_SIGNALS);
    public static final List<DMenuActionKind> PORT_ACTIONS = List.of(DMenuActionKind.ADD, DMenuActionKind.ADD_WITH_DRIVERS, DMenuActionKind.ADD_WITH_LOADS, DMenuActionKind.SEPARATOR, DMenuActionKind.REVEAL);
    public static final List<DMenuActionKind> PORTS_ACTIONS = List.of(DMenuActionKind.ADD);

    private static String getFormatedSignalValue(String signalValue) {
        if (signalValue.length() > 30) {
            signalValue = String.valueOf(signalValue.substring(0, 30)) + "...";
        }
        return "[" + signalValue.toLowerCase() + "]";
    }

    public static String getSignalValueAtTime(DVTVCDSignalWrapper signalWrapper, long time) {
        String signalValueAtTime = DVTVCDUtilsCommon.getSignalValueAtTime(signalWrapper, time);
        if (signalValueAtTime == null || signalValueAtTime.isEmpty()) {
            return PORT_VALUE_NOT_AVAILABLE_TEXT;
        }
        String convertedSignalValue = DVTVCDUtilsCommon.getConvertedSignalValue(signalValueAtTime, signalWrapper.getBitWidth(), signalWrapper.getType(), "16");
        if (convertedSignalValue == null || convertedSignalValue.isEmpty()) {
            return PORT_VALUE_NOT_AVAILABLE_TEXT;
        }
        return WaveformViewerSchematicDiagramUtils.getFormatedSignalValue(convertedSignalValue);
    }

    public static String getStructChildSignalValueAtTime(String signalHierarchicalAccess, DVTVCDSignalWrapper structWrapper, long time) {
        if (structWrapper == null) {
            return PORT_VALUE_NOT_AVAILABLE_TEXT;
        }
        String signalValueAtTime = DVTVCDUtilsCommon.getSignalValueAtTime(structWrapper, time);
        if (signalValueAtTime == null || signalValueAtTime.isEmpty()) {
            return PORT_VALUE_NOT_AVAILABLE_TEXT;
        }
        WStructMetadata childSignalMetadata = WaveformViewerSchematicDiagramUtils.getStructChildMetadata(structWrapper.getStructMetadata(), signalHierarchicalAccess);
        if (childSignalMetadata == null) {
            return PORT_VALUE_NOT_AVAILABLE_TEXT;
        }
        String structChildValue = DVTVCDUtilsCommon.getStructChildValue(structWrapper, signalValueAtTime, childSignalMetadata);
        if (structChildValue == null || structChildValue.isEmpty()) {
            return PORT_VALUE_NOT_AVAILABLE_TEXT;
        }
        String convertedStructChildValue = DVTVCDUtilsCommon.getConvertedSignalValue(structChildValue, String.valueOf(childSignalMetadata.getBitWidth()), structWrapper.getType(), "16");
        if (convertedStructChildValue == null || convertedStructChildValue.isEmpty()) {
            return PORT_VALUE_NOT_AVAILABLE_TEXT;
        }
        return WaveformViewerSchematicDiagramUtils.getFormatedSignalValue(convertedStructChildValue);
    }

    public static WStructMetadata getStructChildMetadata(WStructMetadata structMetadata, String signalHierchicalAccess) {
        if (structMetadata == null) {
            return null;
        }
        if (signalHierchicalAccess == null || signalHierchicalAccess.isEmpty()) {
            return null;
        }
        String[] segments = DVTVCDUtilsCommon.DOT_SEPARATOR_PATTERN.split(signalHierchicalAccess);
        if (segments == null || segments.length < 2) {
            return null;
        }
        String signalName = segments[segments.length - 1];
        if (signalName == null || signalName.isEmpty()) {
            return null;
        }
        List<WStructMetadata> members = structMetadata.getMembers();
        int i = 1;
        while (i < segments.length - 1) {
            if (members == null || members.isEmpty()) {
                return null;
            }
            String segment = segments[i];
            if (segment.isEmpty()) {
                return null;
            }
            for (WStructMetadata member : members) {
                if (!segment.equals(member.getName())) continue;
                members = member.getMembers();
                break;
            }
            ++i;
        }
        if (members == null || members.isEmpty()) {
            return null;
        }
        for (WStructMetadata member : members) {
            String memberDimensions;
            String memberName = member.getName();
            if (memberName == null || memberName.isEmpty() || (memberName.contains("[") && memberName.contains(signalName) ? (memberDimensions = memberName.replaceAll(signalName, "")) == null || memberDimensions.isEmpty() || !memberDimensions.startsWith("[") || !memberDimensions.endsWith("]") : !signalName.equals(memberName))) continue;
            return member;
        }
        return null;
    }
}

