/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.widget.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class DVTWidgetContentAssistProposalProvider
implements IContentProposalProvider {
    protected String[] proposals = null;
    private boolean matchIgnoreCase;
    private static final Pattern LAST_WORD_PATTERN = Pattern.compile("\\b(\\w+)$");

    public DVTWidgetContentAssistProposalProvider(String[] proposals) {
        this(proposals, true);
    }

    public DVTWidgetContentAssistProposalProvider(String[] proposals, boolean matchIgnoreCase) {
        this.proposals = proposals;
        this.matchIgnoreCase = matchIgnoreCase;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        Matcher matcher;
        if (position < contents.length()) {
            contents = contents.substring(0, position);
        }
        contents = (matcher = LAST_WORD_PATTERN.matcher(contents)).find() ? matcher.group(1) : "";
        List<IContentProposal> contentProposals = this.getMatchingProposals(this.proposals, contents);
        return contentProposals.toArray(new IContentProposal[contentProposals.size()]);
    }

    public void setProposals(String[] items) {
        this.proposals = items;
    }

    protected List<IContentProposal> getMatchingProposals(String[] proposals, final String contents) {
        ArrayList<IContentProposal> contentProposals = new ArrayList<IContentProposal>();
        String[] matchingProposals = this.matches(proposals, contents);
        int i = 0;
        while (i < matchingProposals.length) {
            final String proposal = matchingProposals[i];
            contentProposals.add(new IContentProposal(){

                public String getContent() {
                    return proposal.substring(contents.length());
                }

                public String getDescription() {
                    return proposal;
                }

                public String getLabel() {
                    return proposal;
                }

                public int getCursorPosition() {
                    return proposal.length();
                }
            });
            ++i;
        }
        return contentProposals;
    }

    private String[] matches(String[] items, String prefix) {
        if (prefix.trim().isEmpty()) {
            return items;
        }
        ArrayList<String> matches = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            if (this.matchIgnoreCase && this.startsWithIgnoreCase(items[i], prefix) || !this.matchIgnoreCase && items[i].startsWith(prefix)) {
                matches.add(items[i]);
            }
            ++i;
        }
        return matches.toArray(new String[matches.size()]);
    }

    private boolean startsWithIgnoreCase(String string, String prefix) {
        return string.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public void dispose() {
        this.proposals = null;
    }
}

