/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.DummyTopSelectionHistoryItem;
import ro.amiq.dvt.utils.UVMTestSelectionFilteredList;

public abstract class AbstractElementUVMTestSelectionListSelectionDialog
extends SelectionStatusDialog {
    private ILabelProvider fRenderer;
    private boolean fIgnoreCase = true;
    private boolean fIsMultipleSelection;
    private boolean fMatchEmptyString = true;
    private boolean fAllowDuplicates = true;
    private Label fMessage;
    protected UVMTestSelectionFilteredList fFilteredList;
    private Text fFilterText;
    private ISelectionStatusValidator fValidator;
    private String fFilter;
    private String fEmptyListMessage = "";
    private String fEmptySelectionMessage = "";
    private int fWidth = 60;
    private int fHeight = 18;
    private Object[] fSelection = new Object[0];
    private boolean isAutoResizeable = true;
    private int maxWidth = 200;
    private int maxHeight = 22;
    private int minWidth = 60;
    private int minHeight = 18;
    private int[] size = new int[]{this.maxWidth, this.maxHeight};

    protected AbstractElementUVMTestSelectionListSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent);
        this.fRenderer = renderer;
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    public boolean isCaseIgnored() {
        return this.fIgnoreCase;
    }

    public void setMatchEmptyString(boolean matchEmptyString) {
        this.fMatchEmptyString = matchEmptyString;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this.fIsMultipleSelection = multipleSelection;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.fAllowDuplicates = allowDuplicates;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    public void setEmptySelectionMessage(String message) {
        this.fEmptySelectionMessage = message;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected void setListElements(Object[] elements) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        this.size = this.fFilteredList.setElements(elements);
        this.handleElementsChanged();
    }

    public void setAutoResizeable(boolean isAutoResizeable) {
        this.isAutoResizeable = isAutoResizeable;
    }

    public boolean isAutoResizeable() {
        return this.isAutoResizeable;
    }

    public void autoResize() {
        if (!this.isAutoResizeable) {
            return;
        }
        int dialogWidth = Math.max(this.minWidth, Math.min(this.maxWidth, this.size[0]));
        int dialogHeight = Math.max(this.minHeight, Math.min(this.maxHeight, this.size[1]));
        this.setSize(dialogWidth, dialogHeight);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(this.maxHeight);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fFilteredList.setLayoutData(data);
    }

    protected void handleElementsChanged() {
        boolean enabled = !this.fFilteredList.isEmpty();
        this.fMessage.setEnabled(enabled);
        this.fFilteredList.setEnabled(enabled);
        this.updateOkState();
    }

    public void setFilter(String filter) {
        if (this.fFilterText == null) {
            this.fFilter = filter;
        } else {
            this.fFilterText.setText(filter);
        }
    }

    public String getFilter() {
        if (this.fFilteredList == null) {
            return this.fFilter;
        }
        return this.fFilteredList.getFilter();
    }

    protected int[] getSelectionIndices() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelectionIndices();
    }

    protected int getSelectionIndex() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelectionIndex();
    }

    protected void setSelection(Object[] selection) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        this.fFilteredList.setSelection(selection);
    }

    public Object[] getSelectedElements() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelection();
    }

    public Object[] getFoldedElements(int index) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getFoldedElements(index);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = super.createMessageArea(composite);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        this.fMessage = label;
        return label;
    }

    protected void handleSelectionChanged() {
        this.validateCurrentSelection();
    }

    protected boolean validateCurrentSelection() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        Object[] elements = this.getSelectedElements();
        Object status = elements.length > 0 ? (this.fValidator != null ? this.fValidator.validate(elements) : new Status(0, "org.eclipse.ui", 0, "", null)) : (this.fFilteredList.isEmpty() ? new Status(4, "org.eclipse.ui", 4, this.fEmptyListMessage, null) : new Status(4, "org.eclipse.ui", 4, this.fEmptySelectionMessage, null));
        this.updateStatus((IStatus)status);
        return status.isOK();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected UVMTestSelectionFilteredList createFilteredList(Composite parent) {
        int flags = 0xB00 | (this.fIsMultipleSelection ? 2 : 4);
        UVMTestSelectionFilteredList list = new UVMTestSelectionFilteredList(parent, flags, this.fRenderer, this.fIgnoreCase, this.fAllowDuplicates, this.fMatchEmptyString);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData(data);
        list.setFont(parent.getFont());
        list.setFilter(this.fFilter == null ? "" : this.fFilter);
        list.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractElementUVMTestSelectionListSelectionDialog.this.handleDefaultSelected();
            }

            public void widgetSelected(SelectionEvent e) {
                if (!(AbstractElementUVMTestSelectionListSelectionDialog.this.fFilteredList.getObjects()[0] instanceof DummyTopSelectionHistoryItem)) {
                    AbstractElementUVMTestSelectionListSelectionDialog.this.handleWidgetSelected();
                }
            }
        });
        this.fFilteredList = list;
        return list;
    }

    private void handleWidgetSelected() {
        Object[] newSelection = this.fFilteredList.getSelection();
        if (newSelection.length != this.fSelection.length) {
            this.fSelection = newSelection;
            this.handleSelectionChanged();
        } else {
            int i = 0;
            while (i != newSelection.length) {
                if (!newSelection[i].equals(this.fSelection[i])) {
                    this.fSelection = newSelection;
                    this.handleSelectionChanged();
                    break;
                }
                ++i;
            }
        }
    }

    protected Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        text.setText(this.fFilter == null ? "" : this.fFilter);
        Listener listener = e -> this.fFilteredList.setFilter(this.fFilterText.getText());
        text.addListener(24, listener);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AbstractElementUVMTestSelectionListSelectionDialog.this.fFilteredList.setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fFilterText = text;
        return text;
    }

    public int open() {
        super.open();
        return this.getReturnCode();
    }

    private void access$superCreate() {
        super.create();
    }

    public void create() {
        BusyIndicator.showWhile(null, () -> {
            this.access$superCreate();
            Assert.isNotNull((Object)((Object)this.fFilteredList));
            if (this.fFilteredList.isEmpty()) {
                this.handleEmptyList();
            } else {
                this.validateCurrentSelection();
                this.fFilterText.selectAll();
                this.fFilterText.setFocus();
            }
        });
    }

    protected void handleEmptyList() {
        this.fMessage.setEnabled(false);
        this.fFilterText.setEnabled(false);
        this.fFilteredList.setEnabled(false);
        this.updateOkState();
    }

    protected void updateOkState() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        if (this.fFilteredList.getObjects()[0] instanceof DummyTopSelectionHistoryItem) {
            return;
        }
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(this.getSelectedElements().length != 0);
        }
    }

    protected ISelectionStatusValidator getValidator() {
        return this.fValidator;
    }
}

