/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.Objects;

public class ArrayLevenshteinDistance {
    public static <T> int of(T[] a, T[] b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        if (a.length == 0) {
            return b.length;
        }
        if (b.length == 0) {
            return a.length;
        }
        if (a.length > b.length) {
            T[] tmp = a;
            a = b;
            b = tmp;
        }
        int[] p = new int[a.length + 1];
        int i = 0;
        while (i <= a.length) {
            p[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= b.length) {
            int ul = p[0];
            T rj = b[j - 1];
            p[0] = j;
            int i2 = 1;
            while (i2 <= a.length) {
                int u = p[i2];
                p[i2] = Math.min(Math.min(p[i2 - 1] + 1, p[i2] + 1), ul + (a[i2 - 1].equals(rj) ? 0 : 1));
                ul = u;
                ++i2;
            }
            ++j;
        }
        return p[a.length];
    }
}

