/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;

public abstract class BaseBitVector<T extends BaseBitVector<?>> {
    public static final BigInteger BIG_INTEGER_TWO = BigInteger.valueOf(2L);
    protected boolean sign;
    protected int left;
    protected int right;
    protected BigInteger number;

    public abstract T setValue(String var1, int var2);

    public abstract T setValue(BigInteger var1);

    public abstract T not();

    public abstract T plus(T var1);

    public abstract T minus(T var1);

    public abstract T multiply(T var1);

    public abstract T divide(T var1);

    public abstract T mod(T var1);

    public abstract T pow(int var1);

    public abstract T and(T var1);

    public abstract T or(T var1);

    public abstract T xor(T var1);

    public abstract T shiftLeft(int var1);

    public abstract T shiftRight(int var1, boolean var2);

    public abstract T abs();

    public abstract T band();

    public abstract T nband();

    public abstract T bxor();

    public abstract T nbxor();

    public abstract T bor();

    public abstract T nbor();

    public abstract boolean gt(T var1);

    public abstract boolean lt(T var1);

    public abstract T getRange(int var1, int var2);

    public abstract void setRange(T var1, int var2, int var3);

    protected BaseBitVector(boolean signed, int left, int right, BigInteger number) {
        this(signed, left, right);
        this.number = number;
    }

    public BaseBitVector(boolean signed, int left, int right) {
        this.sign = signed;
        this.left = left;
        this.right = right;
        this.number = BigInteger.ZERO;
    }

    protected BaseBitVector(T bs) {
        this.sign = ((BaseBitVector)bs).sign;
        this.left = ((BaseBitVector)bs).left;
        this.right = ((BaseBitVector)bs).right;
        this.number = new BigInteger(((BaseBitVector)bs).number.toByteArray());
    }

    public int getSize() {
        return Math.abs(this.left - this.right) + 1;
    }

    public boolean gte(T bs) {
        return this.equals(bs) || this.gt(bs);
    }

    public boolean lte(T bs) {
        return this.equals(bs) || this.lt(bs);
    }

    public BigInteger bigIntegerValue() {
        return this.number;
    }

    public boolean hasSign() {
        return this.sign;
    }

    public int intValue() {
        return this.number.intValue();
    }

    public String toString() {
        return "" + this.intValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseBitVector other = (BaseBitVector)obj;
        if (this.left != other.left) {
            return false;
        }
        if (this.number == null && other.number != null || other.number == null && this.number != null) {
            return false;
        }
        if (this.number != null && !this.number.equals(other.number)) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        return this.sign == other.sign;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.left;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        result = 31 * result + this.right;
        result = 31 * result + Boolean.hashCode(this.sign);
        return result;
    }
}

