/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemKind;
import ro.amiq.dvt.model.problems.DVTProblemKinds;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.problems.EProblemKinds;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.model.problems.MSDLProblemKinds;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.model.problems.PSSProblemKinds;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.problems.VhdlProblemKinds;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.model.problems.VlogProblemKinds;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.nature.NatureContributors;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;

public class BaseUtils {
    protected static final Pattern COMMENT_FORMATTING_PATTERN = Pattern.compile("^[-]+|[-]+$|^/+[-]*|[-]*/+$|^[*]+\\\\*|\\\\*[*]+$");
    protected static final Pattern NEWLINE_PATTERN = Pattern.compile("(?:\\r\\n)|(?:[\\r\\n])");
    private static final Map<LanguageKind, List<DVTProblemCategory>> errorCategories = new EnumMap<LanguageKind, List<DVTProblemCategory>>(LanguageKind.class){
        private static final long serialVersionUID = 1L;
        {
            this.put(LanguageKind.E, new ArrayList<DVTProblemCategory>(6){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemCategories.EXTERNALTOOLS);
                    this.add(EProblemCategories.E_SYNTAX);
                    this.add(EProblemCategories.E_SEMANTIC);
                    this.add(EProblemCategories.E_NAME_CHECKING);
                    this.add(EProblemCategories.E_PROBLEM);
                }
            });
            this.put(LanguageKind.VLOG, new ArrayList<DVTProblemCategory>(6){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemCategories.EXTERNALTOOLS);
                    this.add(VlogProblemCategories.SVLOG_SYNTAX);
                    this.add(VlogProblemCategories.SVLOG_SEMANTIC);
                    this.add(VlogProblemCategories.SVLOG_PROBLEM);
                }
            });
            this.put(LanguageKind.VHDL, new ArrayList<DVTProblemCategory>(6){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemCategories.EXTERNALTOOLS);
                    this.add(VhdlProblemCategories.VHDL_SYNTAX);
                    this.add(VhdlProblemCategories.VHDL_SEMANTIC);
                    this.add(VhdlProblemCategories.VHDL_PROBLEM);
                    this.add(VhdlProblemCategories.VHDL_NAME_CHECKING);
                }
            });
            this.put(LanguageKind.SLN, new ArrayList<DVTProblemCategory>(6){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemCategories.EXTERNALTOOLS);
                    this.add(EProblemCategories.SLN_SYNTAX);
                    this.add(EProblemCategories.SLN_SEMANTIC);
                    this.add(EProblemCategories.SLN_PROBLEM);
                    this.add(EProblemCategories.SLN_NAME_CHECKING);
                }
            });
            this.put(LanguageKind.PSS, new ArrayList<DVTProblemCategory>(6){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemCategories.EXTERNALTOOLS);
                    this.add(PSSProblemCategories.PSS_SYNTAX);
                    this.add(PSSProblemCategories.PSS_SEMANTIC);
                    this.add(PSSProblemCategories.PSS_PROBLEM);
                }
            });
            this.put(LanguageKind.MSDL, new ArrayList<DVTProblemCategory>(6){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemCategories.EXTERNALTOOLS);
                    this.add(MSDLProblemCategories.MSDL_SYNTAX);
                    this.add(MSDLProblemCategories.MSDL_SEMANTIC);
                    this.add(MSDLProblemCategories.MSDL_PROBLEM);
                }
            });
        }
    };
    private static final Map<LanguageKind, Set<DVTProblemKind>> errorKinds = new EnumMap<LanguageKind, Set<DVTProblemKind>>(LanguageKind.class){
        private static final long serialVersionUID = 1L;
        {
            this.put(LanguageKind.E, new HashSet<DVTProblemKind>(4){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemKinds.EXTERNALTOOLS_ERROR);
                    this.add(EProblemKinds.E_SYNTAX_ERROR);
                    this.add(EProblemKinds.E_SEMANTIC_ERROR);
                }
            });
            this.put(LanguageKind.VLOG, new HashSet<DVTProblemKind>(4){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemKinds.EXTERNALTOOLS_ERROR);
                    this.add(VlogProblemKinds.SYNTAX_ERROR);
                    this.add(VlogProblemKinds.SEMANTIC_ERROR);
                }
            });
            this.put(LanguageKind.VHDL, new HashSet<DVTProblemKind>(4){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemKinds.EXTERNALTOOLS_ERROR);
                    this.add(VhdlProblemKinds.SYNTAX_ERROR);
                    this.add(VhdlProblemKinds.SEMANTIC_ERROR);
                }
            });
            this.put(LanguageKind.SLN, new HashSet<DVTProblemKind>(4){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemKinds.EXTERNALTOOLS_ERROR);
                    this.add(EProblemKinds.SLN_SYNTAX_ERROR);
                    this.add(EProblemKinds.SLN_SEMANTIC_ERROR);
                }
            });
            this.put(LanguageKind.PSS, new HashSet<DVTProblemKind>(4){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemKinds.EXTERNALTOOLS_ERROR);
                    this.add(PSSProblemKinds.SYNTAX_ERROR);
                    this.add(PSSProblemKinds.SEMANTIC_ERROR);
                }
            });
            this.put(LanguageKind.MSDL, new HashSet<DVTProblemKind>(4){
                private static final long serialVersionUID = 1L;
                {
                    this.add(DVTProblemKinds.EXTERNALTOOLS_ERROR);
                    this.add(MSDLProblemKinds.SYNTAX_ERROR);
                    this.add(MSDLProblemKinds.SEMANTIC_ERROR);
                }
            });
        }
    };

    public static String getFileExtension(File file) {
        return BaseUtils.getFileExtension(file.getName());
    }

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return null;
    }

    public static String getFileNameNoExtension(File file) {
        return BaseUtils.getFileNameNoExtension(file.getName());
    }

    public static String getFileNameNoExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static String physicalPath(String filename, boolean exists) {
        try {
            File file = new File(filename);
            return exists || file.exists() ? file.getCanonicalPath() : filename;
        }
        catch (Exception exception) {
            return filename;
        }
    }

    public static String physicalPath(IPath file) {
        File tmpFile = file.toFile();
        try {
            return tmpFile.exists() ? tmpFile.getCanonicalPath() : tmpFile.getAbsolutePath();
        }
        catch (Exception exception) {
            return tmpFile.getAbsolutePath();
        }
    }

    public static String physicalPath(File file) {
        try {
            return file.exists() ? file.getCanonicalPath() : file.getAbsolutePath();
        }
        catch (Exception exception) {
            return file.getAbsolutePath();
        }
    }

    public static String canonicPath(String pathString) {
        if (pathString == null) {
            return null;
        }
        return BaseUtils.canonicPath(DVTFileUtils.getInstance().pathOf(pathString));
    }

    public static String canonicPath(IPath path) {
        if (path == null) {
            return null;
        }
        String device = path.getDevice();
        if (device != null && !device.isEmpty()) {
            path = path.setDevice(device.toUpperCase());
        }
        return path.toOSString();
    }

    public static String canonicPath(File file) {
        return BaseUtils.canonicPath(file.getAbsolutePath());
    }

    public static String getFileName(File file) {
        return file.getName();
    }

    public static String getFileName(String pathString) {
        return BaseUtils.getFileName(new File(pathString));
    }

    public static String getFileDirectoryPath(String filePath) {
        return Path.fromOSString((String)filePath).removeLastSegments(1).toOSString();
    }

    public static String getProjectDirectoryPathFromBuildConfigPath(String filePath) {
        return Path.fromOSString((String)filePath).removeLastSegments(2).toOSString();
    }

    public static String formatComment(String comment) {
        if (comment == null || comment.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String[] split = null;
        split = !comment.contains("\n") && !comment.contains("\r") ? new String[]{comment} : comment.split("\r\n|\r|\n");
        int i = 0;
        while (i < split.length) {
            split[i] = COMMENT_FORMATTING_PATTERN.matcher(split[i].trim()).replaceAll("").trim();
            result.append(split[i]);
            if (i < split.length - 1) {
                result.append("\n");
            }
            ++i;
        }
        return result.toString().trim();
    }

    public static void deleteFileRecursively(File file) {
        try {
            String canPath = file.getCanonicalPath();
            String absPath = file.getAbsolutePath();
            if (!canPath.equals(absPath) && absPath.startsWith(canPath)) {
                return;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null) {
                return;
            }
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    BaseUtils.deleteFileRecursively(child);
                }
                child.delete();
                ++n2;
            }
        }
        file.delete();
    }

    public static String appendInlineAndAboveComments(String inlineComment, String aboveComment) {
        String result = "";
        if (aboveComment != null && !aboveComment.isEmpty()) {
            result = Utils.formatComment(aboveComment);
            if (inlineComment != null && !inlineComment.isEmpty()) {
                result = DVTStringUtil.appendString(result, result.endsWith(".") ? " " : "; ", Utils.formatComment(inlineComment));
            }
        } else if (inlineComment != null && !inlineComment.isEmpty()) {
            result = Utils.formatComment(inlineComment);
        }
        return result;
    }

    public static String readFileContentBetweenLines(String fullPath, IProject iProject, int startLine, int endLine) {
        String readFromDocument = BaseUtils.readFileContentBetweenLinesFromDocument(fullPath, iProject, startLine, endLine);
        if (readFromDocument != null) {
            return readFromDocument;
        }
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(fullPath, new String[0]));
            String fileContent = new String(encoded, StandardCharsets.US_ASCII);
            String[] lines = NEWLINE_PATTERN.split(fileContent);
            startLine = Math.max(startLine, 0);
            endLine = Math.min(endLine, lines.length - 1);
            StringBuilder res = new StringBuilder();
            int i = startLine;
            while (i <= endLine) {
                res.append(lines[i]);
                if (i != endLine) {
                    res.append(System.lineSeparator());
                }
                ++i;
            }
            return res.toString();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    private static String readFileContentBetweenLinesFromDocument(String fullPath, IProject iProject, int startLine, int endLine) {
        if (iProject == null) {
            return null;
        }
        IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(iProject, fullPath);
        if (file == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getOpenDocument(file);
        if (document == null) {
            return null;
        }
        if ((startLine = Math.max(startLine, 0)) > (endLine = Math.min(endLine, document.getNumberOfLines() - 1))) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        try {
            int i = startLine;
            while (i <= endLine) {
                if (i != endLine) {
                    content.append(document.get(document.getLineOffset(i), document.getLineLength(i)));
                } else {
                    String lastLine = document.get(document.getLineOffset(i), document.getLineLength(i));
                    String delimiter = document.getLineDelimiter(i);
                    if (delimiter != null && lastLine.endsWith(delimiter)) {
                        lastLine = lastLine.substring(0, lastLine.length() - delimiter.length());
                    }
                    content.append(lastLine);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return content.toString();
    }

    public static List<DVTProblemCategory> getErrorCategories(LanguageKind lang) {
        return errorCategories.get((Object)lang);
    }

    private static Set<DVTProblemKind> getErrorKinds(LanguageKind lang) {
        return errorKinds.get((Object)lang);
    }

    public static boolean hasErrors(IProject project, String path, LanguageKind lang) {
        if (project == null || path == null || lang == null) {
            return false;
        }
        List<DVTProblemCategory> categories = BaseUtils.getErrorCategories(lang);
        Set<DVTProblemKind> kinds = BaseUtils.getErrorKinds(lang);
        if (categories == null || kinds == null) {
            return false;
        }
        for (DVTProblemCategory cat : categories) {
            Collection<DVTProblem> problems = DVTProblemManager.getInstance().getProblemsWithCategoryAndPath(project, cat, path);
            if (problems == null || problems.isEmpty()) continue;
            for (DVTProblem prob : problems) {
                if (prob.isWaived() || !kinds.contains(prob.getKind())) continue;
                return true;
            }
        }
        return false;
    }

    public static int getOperatorFirstOffset(List<IHidOperator> operators, int index) {
        if (index < 0 || index >= operators.size()) {
            return -1;
        }
        IHidOperator operator = operators.get(index);
        if (operator == null) {
            return -1;
        }
        HidOperatorOccurrence occurrence = operator.getOccurrence();
        return occurrence.getOffset();
    }

    public static int getMarginOffsetOfElement(IDocument document, int initialOffset, boolean forward) {
        DVTCharacterScanner scanner = new DVTCharacterScanner(100, document, Math.max(0, initialOffset), forward);
        int c = scanner.read();
        while (c != -1) {
            if (!Character.isJavaIdentifierPart((char)c)) {
                return scanner.getOffset();
            }
            c = scanner.read();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasDvtNature(IProject project) {
        try {
            INatureContributor contributor;
            if (project == null) {
                return false;
            }
            Iterator<INatureContributor> iterator = NatureContributors.getContributors().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(contributor = iterator.next()).hasNature(project));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Template[] getProjectTemplates(IProject project, String templatesFileName) {
        File file = project.getLocation().append(".dvt").append(templatesFileName).toFile();
        if (file == null || !file.exists()) {
            return new Template[0];
        }
        String fileContent = DVTFileUtils.getInstance().readFileContent(file);
        if (fileContent.isEmpty()) {
            return new Template[0];
        }
        TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
        TemplatePersistenceData[] templatePersistenceData = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedReader fileReader = new BufferedReader(new FileReader(file));){
                templatePersistenceData = templateReaderWriter.read((Reader)fileReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new Template[0];
        }
        if (templatePersistenceData == null) {
            return new Template[0];
        }
        ArrayList<Template> result = new ArrayList<Template>();
        TemplatePersistenceData[] templatePersistenceDataArray = templatePersistenceData;
        int n = templatePersistenceData.length;
        int n2 = 0;
        while (n2 < n) {
            TemplatePersistenceData tpd = templatePersistenceDataArray[n2];
            if (tpd.isEnabled() && !tpd.isDeleted()) {
                result.add(tpd.getTemplate());
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return new Template[0];
        }
        return result.toArray(new Template[result.size()]);
    }

    public static void setProjectTemplates(IProject project, String templatesFileName, Template[] templates) {
        File dotDVT;
        BufferedWriter fileWriter;
        block6: {
            fileWriter = null;
            dotDVT = new File(project.getLocation().toFile(), ".dvt");
            if (dotDVT.exists()) break block6;
            DVTUtilsCommon.INSTANCE.closeClosable(fileWriter);
            return;
        }
        try {
            try {
                File file = new File(dotDVT, templatesFileName);
                TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
                fileWriter = new BufferedWriter(new FileWriter(file));
                LinkedList<TemplatePersistenceData> datas = new LinkedList<TemplatePersistenceData>();
                Template[] templateArray = templates;
                int n = templates.length;
                int n2 = 0;
                while (n2 < n) {
                    Template template = templateArray[n2];
                    datas.add(new TemplatePersistenceData(template, true));
                    ++n2;
                }
                templateReaderWriter.save(datas.toArray(new TemplatePersistenceData[0]), (Writer)fileWriter);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(fileWriter);
            }
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(fileWriter);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(fileWriter);
    }
}

